/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.draw;

import arc.Core;
import arc.graphics.g2d.TextureRegion;
import arc.math.Rand;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.blocks.production.GenericCrafter;

public abstract class DrawBlock {
    protected static final Rand rand = new Rand();
    @Nullable
    public String[] iconOverride = null;

    public void getRegionsToOutline(Block block, Seq<TextureRegion> out) {
    }

    public void draw(Building build) {
    }

    public void drawLight(Building build) {
    }

    public void drawPlan(Block block, BuildPlan plan, Eachable<BuildPlan> list) {
    }

    public void load(Block block) {
    }

    public TextureRegion[] icons(Block block) {
        return new TextureRegion[]{block.region};
    }

    public final TextureRegion[] finalIcons(Block block) {
        if (this.iconOverride != null) {
            TextureRegion[] out = new TextureRegion[this.iconOverride.length];
            for (int i = 0; i < out.length; ++i) {
                out[i] = Core.atlas.find(block.name + this.iconOverride[i]);
            }
            return out;
        }
        return this.icons(block);
    }

    public GenericCrafter expectCrafter(Block block) {
        if (!(block instanceof GenericCrafter)) {
            throw new ClassCastException("This drawer requires the block to be a GenericCrafter. Use a different drawer.");
        }
        GenericCrafter crafter = (GenericCrafter)block;
        return crafter;
    }
}

