/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.gen.Building;
import mindustry.type.PayloadSeq;
import mindustry.type.PayloadStack;
import mindustry.ui.ItemImage;
import mindustry.ui.ReqImage;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.Stats;

public class ConsumePayloads
extends Consume {
    public Seq<PayloadStack> payloads;

    public ConsumePayloads(Seq<PayloadStack> payloads) {
        this.payloads = payloads;
    }

    @Override
    public float efficiency(Building build) {
        float mult = this.multiplier.get(build);
        for (PayloadStack stack : this.payloads) {
            if (build.getPayloads().contains(stack.item, Math.round((float)stack.amount * mult))) continue;
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public void trigger(Building build) {
        float mult = this.multiplier.get(build);
        for (PayloadStack stack : this.payloads) {
            build.getPayloads().remove(stack.item, Math.round((float)stack.amount * mult));
        }
    }

    @Override
    public void display(Stats stats) {
        for (PayloadStack stack : this.payloads) {
            stats.add(Stat.input, t -> {
                t.add(new ItemImage(stack));
                t.add(stack.item.localizedName).padLeft(4.0f).padRight(4.0f);
            });
        }
    }

    @Override
    public void build(Building build, Table table) {
        PayloadSeq inv = build.getPayloads();
        table.table(c -> {
            int i = 0;
            for (PayloadStack stack : this.payloads) {
                c.add(new ReqImage((Element)new ItemImage(stack.item.uiIcon, Math.round((float)stack.amount * this.multiplier.get(build))), () -> inv.contains(stack.item, Math.round((float)stack.amount * this.multiplier.get(build))))).padRight(8.0f);
                if (++i % 4 != 0) continue;
                c.row();
            }
        }).left();
    }
}

