/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.func.Func;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import mindustry.gen.Building;
import mindustry.type.PayloadSeq;
import mindustry.type.PayloadStack;
import mindustry.ui.ItemImage;
import mindustry.ui.ReqImage;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stats;

public class ConsumePayloadDynamic
extends Consume {
    public final Func<Building, Seq<PayloadStack>> payloads;

    public <T extends Building> ConsumePayloadDynamic(Func<T, Seq<PayloadStack>> payloads) {
        this.payloads = payloads;
    }

    @Override
    public float efficiency(Building build) {
        float mult = this.multiplier.get(build);
        for (PayloadStack stack : this.payloads.get(build)) {
            if (build.getPayloads().contains(stack.item, Math.round((float)stack.amount * mult))) continue;
            return 0.0f;
        }
        return 1.0f;
    }

    @Override
    public void trigger(Building build) {
        float mult = this.multiplier.get(build);
        for (PayloadStack stack : this.payloads.get(build)) {
            build.getPayloads().remove(stack.item, Math.round((float)stack.amount * mult));
        }
    }

    @Override
    public void display(Stats stats) {
    }

    @Override
    public void build(Building build, Table table) {
        Seq[] current = new Seq[]{this.payloads.get(build)};
        table.table(cont -> {
            table.update(() -> {
                if (current[0] != this.payloads.get(build)) {
                    this.rebuild(build, (Table)cont);
                    current[0] = this.payloads.get(build);
                }
            });
            this.rebuild(build, (Table)cont);
        });
    }

    private void rebuild(Building build, Table table) {
        PayloadSeq inv = build.getPayloads();
        Seq<PayloadStack> pay = this.payloads.get(build);
        table.table(c -> {
            int i = 0;
            for (PayloadStack stack : pay) {
                c.add(new ReqImage((Element)new ItemImage(stack.item.uiIcon, Math.round((float)stack.amount * this.multiplier.get(build))), () -> inv.contains(stack.item, Math.round((float)stack.amount * this.multiplier.get(build))))).padRight(8.0f);
                if (++i % 4 != 0) continue;
                c.row();
            }
        }).left();
    }
}

