/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.scene.ui.layout.Table;
import mindustry.gen.Building;
import mindustry.type.LiquidStack;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ConsumeLiquids
extends Consume {
    public final LiquidStack[] liquids;

    public ConsumeLiquids(LiquidStack[] liquids) {
        this.liquids = liquids;
    }

    protected ConsumeLiquids() {
        this(LiquidStack.empty);
    }

    @Override
    public void apply(Block block) {
        block.hasLiquids = true;
        for (LiquidStack stack : this.liquids) {
            block.liquidFilter[stack.liquid.id] = true;
        }
    }

    @Override
    public void build(Building build, Table table) {
        table.table(c -> {
            int i = 0;
            for (LiquidStack stack : this.liquids) {
                c.add(new ReqImage(stack.liquid.uiIcon, () -> build.liquids.get(stack.liquid) > 0.0f)).size(32.0f).padRight(8.0f);
                if (++i % 4 != 0) continue;
                c.row();
            }
        }).left();
    }

    @Override
    public void update(Building build) {
        float mult = this.multiplier.get(build);
        for (LiquidStack stack : this.liquids) {
            build.liquids.remove(stack.liquid, stack.amount * build.edelta() * mult);
        }
    }

    @Override
    public float efficiency(Building build) {
        float mult = this.multiplier.get(build);
        float ed = build.edelta();
        if (ed <= 1.0E-8f) {
            return 0.0f;
        }
        float min = 1.0f;
        for (LiquidStack stack : this.liquids) {
            min = Math.min(build.liquids.get(stack.liquid) / (stack.amount * ed * mult), min);
        }
        return min;
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, StatValues.liquids(1.0f, true, this.liquids));
    }
}

