/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.consumers.ConsumeLiquidFilter;

public class ConsumeLiquidFlammable
extends ConsumeLiquidFilter {
    public float minFlammability;

    public ConsumeLiquidFlammable(float minFlammability, float amount) {
        this.amount = amount;
        this.minFlammability = minFlammability;
        this.filter = liquid -> liquid.flammability >= this.minFlammability;
    }

    public ConsumeLiquidFlammable(float amount) {
        this(0.2f, amount);
    }

    public ConsumeLiquidFlammable() {
        this(0.2f);
    }

    @Override
    public float efficiencyMultiplier(Building build) {
        Liquid liq = this.getConsumed(build);
        return liq == null ? 0.0f : liq.flammability;
    }
}

