/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.consumers;

import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.gen.Building;
import mindustry.type.ItemStack;
import mindustry.ui.ItemImage;
import mindustry.ui.ReqImage;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.meta.Stats;

public class ConsumeItems
extends Consume {
    public final ItemStack[] items;

    public ConsumeItems(ItemStack[] items) {
        this.items = items;
    }

    protected ConsumeItems() {
        this(ItemStack.empty);
    }

    @Override
    public void apply(Block block) {
        block.hasItems = true;
        block.acceptsItems = true;
        for (ItemStack stack : this.items) {
            block.itemFilter[stack.item.id] = true;
        }
    }

    @Override
    public void build(Building build, Table table) {
        table.table(c -> {
            int i = 0;
            for (ItemStack stack : this.items) {
                c.add(new ReqImage((Element)new ItemImage(stack.item.uiIcon, Math.round((float)stack.amount * this.multiplier.get(build))), () -> build.items.has(stack.item, Math.round((float)stack.amount * this.multiplier.get(build))))).padRight(8.0f);
                if (++i % 4 != 0) continue;
                c.row();
            }
        }).left();
    }

    @Override
    public void trigger(Building build) {
        for (ItemStack stack : this.items) {
            build.items.remove(stack.item, Math.round((float)stack.amount * this.multiplier.get(build)));
        }
    }

    @Override
    public float efficiency(Building build) {
        return build.consumeTriggerValid() || build.items.has(this.items, this.multiplier.get(build)) ? 1.0f : 0.0f;
    }

    @Override
    public void display(Stats stats) {
        stats.add(this.booster ? Stat.booster : Stat.input, stats.timePeriod < 0.0f ? StatValues.items(this.items) : StatValues.items(stats.timePeriod, this.items));
    }
}

