/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.units;

import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.Stat;

public class UnitAssemblerModule
extends PayloadBlock {
    public TextureRegion sideRegion1;
    public TextureRegion sideRegion2;
    public int tier = 1;

    public UnitAssemblerModule(String name) {
        super(name);
        this.rotate = true;
        this.rotateDraw = false;
        this.acceptsPayload = true;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.moduleTier, this.tier);
    }

    @Override
    public void drawPlace(int x, int y, int rotation, boolean valid) {
        super.drawPlace(x, y, rotation, valid);
        UnitAssembler.UnitAssemblerBuild link = this.getLink(Vars.player.team(), x, y, rotation);
        if (link != null) {
            link.block.drawPlace(link.tile.x, link.tile.y, link.rotation, true);
        }
    }

    @Override
    public boolean canPlaceOn(Tile tile, Team team, int rotation) {
        return this.getLink(team, tile.x, tile.y, rotation) != null;
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.region, plan.drawx(), plan.drawy());
        Draw.rect(plan.rotation >= 2 ? this.sideRegion2 : this.sideRegion1, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect(this.topRegion, plan.drawx(), plan.drawy());
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.sideRegion1, this.topRegion};
    }

    @Nullable
    public UnitAssembler.UnitAssemblerBuild getLink(Team team, int x, int y, int rotation) {
        Seq results = Vars.indexer.getFlagged(team, BlockFlag.unitAssembler).as();
        return results.find(b -> b.moduleFits(this, (float)(x * 8) + this.offset, (float)(y * 8) + this.offset, rotation));
    }

    public class UnitAssemblerModuleBuild
    extends PayloadBlock.PayloadBlockBuild<Payload> {
        public UnitAssembler.UnitAssemblerBuild link;
        public int lastChange = -2;

        public void findLink() {
            if (this.link != null) {
                this.link.removeModule(this);
            }
            this.link = UnitAssemblerModule.this.getLink(this.team, this.tile.x, this.tile.y, this.rotation);
            if (this.link != null) {
                this.link.updateModules(this);
            }
        }

        public int tier() {
            return UnitAssemblerModule.this.tier;
        }

        @Override
        public void draw() {
            Draw.rect(UnitAssemblerModule.this.region, this.x, this.y);
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.rect(UnitAssemblerModule.this.inRegion, this.x, this.y, (float)(i * 90 - 180));
            }
            Draw.rect(this.rotation >= 2 ? UnitAssemblerModule.this.sideRegion2 : UnitAssemblerModule.this.sideRegion1, this.x, this.y, this.rotdeg());
            Draw.z(35.0f);
            this.payRotation = this.rotdeg();
            this.drawPayload();
            Draw.z(35.1f);
            Draw.rect(UnitAssemblerModule.this.topRegion, this.x, this.y);
        }

        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            return this.link != null && this.payload == null && this.link.acceptPayload(this, payload);
        }

        @Override
        public void drawSelect() {
            if (this.link != null) {
                Drawf.selected(this.link, Pal.accent);
            }
        }

        @Override
        public void onRemoved() {
            super.onRemoved();
            if (this.link != null) {
                this.link.removeModule(this);
            }
        }

        @Override
        public void updateTile() {
            if (this.lastChange != Vars.world.tileChanges) {
                this.lastChange = Vars.world.tileChanges;
                this.findLink();
            }
            if (this.moveInPayload() && this.link != null && this.link.moduleFits(this.block, this.x, this.y, this.rotation) && !this.link.wasOccupied && this.link.acceptPayload(this, this.payload) && this.efficiency > 0.0f) {
                this.link.yeetPayload(this.payload);
                this.payload = null;
            }
        }
    }
}

