/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.storage;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import java.util.Comparator;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import mindustry.world.blocks.storage.StorageBlock;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;

public class Unloader
extends Block {
    public TextureRegion centerRegion;
    public float speed = 1.0f;

    public Unloader(String name) {
        super(name);
        this.update = true;
        this.solid = true;
        this.health = 70;
        this.hasItems = true;
        this.configurable = true;
        this.saveConfig = true;
        this.itemCapacity = 0;
        this.noUpdateDisabled = true;
        this.clearOnDoubleTap = true;
        this.unloadable = false;
        this.config(Item.class, (tile, item) -> {
            tile.sortItem = item;
        });
        this.configClear(tile -> {
            tile.sortItem = null;
        });
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.speed, 60.0f / this.speed, StatUnit.itemsSecond);
    }

    @Override
    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        this.drawPlanConfigCenter(plan, plan.config, "unloader-center");
    }

    @Override
    public void setBars() {
        super.setBars();
        this.removeBar("items");
    }

    public class UnloaderBuild
    extends Building {
        public float unloadTimer = 0.0f;
        public int rotations = 0;
        private final int itemsLength;
        public Item sortItem;
        public ContainerStat dumpingFrom;
        public ContainerStat dumpingTo;
        public final Seq<ContainerStat> possibleBlocks;
        protected final Comparator<ContainerStat> comparator;

        public UnloaderBuild() {
            this.itemsLength = Vars.content.items().size;
            this.sortItem = null;
            this.possibleBlocks = new Seq();
            this.comparator = (x, y) -> {
                int unloadPriority = Boolean.compare(x.canUnload && !x.canLoad, y.canUnload && !y.canLoad);
                if (unloadPriority != 0) {
                    return unloadPriority;
                }
                int loadPriority = Boolean.compare(x.canUnload || !x.canLoad, y.canUnload || !y.canLoad);
                if (loadPriority != 0) {
                    return loadPriority;
                }
                int loadFactor = Float.compare(x.loadFactor, y.loadFactor);
                if (loadFactor != 0) {
                    return loadFactor;
                }
                return Integer.compare(y.lastUsed, x.lastUsed);
            };
        }

        private boolean isPossibleItem(Item item) {
            boolean hasProvider = false;
            boolean hasReceiver = false;
            boolean isDistinct = false;
            for (int i = 0; i < this.possibleBlocks.size; ++i) {
                ContainerStat pb = this.possibleBlocks.get(i);
                Building other = pb.building;
                pb.canLoad = !(other.block instanceof StorageBlock) && other.acceptItem(this, item);
                boolean bl = pb.canUnload = other.canUnload() && other.items != null && other.items.has(item);
                if (hasProvider && pb.canLoad || hasReceiver && pb.canUnload) {
                    isDistinct = true;
                }
                hasProvider |= pb.canUnload;
                hasReceiver |= pb.canLoad;
            }
            return isDistinct;
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            Pools.freeAll(this.possibleBlocks, true);
            this.possibleBlocks.clear();
            for (int i = 0; i < this.proximity.size; ++i) {
                boolean canUnload;
                Building other = (Building)this.proximity.get(i);
                if (!other.interactable(this.team)) continue;
                ContainerStat pb = Pools.obtain(ContainerStat.class, ContainerStat::new);
                boolean canLoad = !(other.block instanceof StorageBlock);
                boolean bl = canUnload = other.canUnload() && other.items != null;
                if (!canLoad && !canUnload) continue;
                pb.building = other;
                this.possibleBlocks.add(pb);
            }
        }

        @Override
        public void updateTile() {
            int i;
            boolean any;
            Item item;
            block8: {
                block7: {
                    if ((this.unloadTimer += this.delta()) < Unloader.this.speed || this.possibleBlocks.size < 2) {
                        return;
                    }
                    item = null;
                    any = false;
                    if (this.sortItem == null) break block7;
                    if (!this.isPossibleItem(this.sortItem)) break block8;
                    item = this.sortItem;
                    break block8;
                }
                for (i = 0; i < this.itemsLength; ++i) {
                    int total = (this.rotations + i + 1) % this.itemsLength;
                    Item possibleItem = Vars.content.item(total);
                    if (!this.isPossibleItem(possibleItem)) continue;
                    item = possibleItem;
                    break;
                }
            }
            if (item != null) {
                this.rotations = item.id;
                for (i = 0; i < this.possibleBlocks.size; ++i) {
                    ContainerStat pb = this.possibleBlocks.get(i);
                    Building other = pb.building;
                    pb.loadFactor = other.getMaximumAccepted(item) == 0 || other.items == null ? 0.0f : (float)other.items.get(item) / (float)other.getMaximumAccepted(item);
                    pb.lastUsed = (pb.lastUsed + 1) % Integer.MAX_VALUE;
                }
                this.possibleBlocks.sort(this.comparator);
                this.dumpingTo = null;
                this.dumpingFrom = null;
                for (i = 0; i < this.possibleBlocks.size; ++i) {
                    if (!this.possibleBlocks.get((int)i).canLoad) continue;
                    this.dumpingTo = this.possibleBlocks.get(i);
                    break;
                }
                for (i = this.possibleBlocks.size - 1; i >= 0; --i) {
                    if (!this.possibleBlocks.get((int)i).canUnload) continue;
                    this.dumpingFrom = this.possibleBlocks.get(i);
                    break;
                }
                if (!(this.dumpingFrom == null || this.dumpingTo == null || this.dumpingFrom.loadFactor == this.dumpingTo.loadFactor && this.dumpingFrom.canLoad)) {
                    this.dumpingTo.building.handleItem(this, item);
                    this.dumpingFrom.building.removeStack(item, 1);
                    this.dumpingTo.lastUsed = 0;
                    this.dumpingFrom.lastUsed = 0;
                    any = true;
                }
            }
            this.unloadTimer = any ? (this.unloadTimer %= Unloader.this.speed) : Math.min(this.unloadTimer, Unloader.this.speed);
        }

        @Override
        public void draw() {
            super.draw();
            Draw.color(this.sortItem == null ? Color.clear : this.sortItem.color);
            Draw.rect(Unloader.this.centerRegion, this.x, this.y);
            Draw.color();
        }

        @Override
        public void buildConfiguration(Table table) {
            ItemSelection.buildTable(Unloader.this, table, Vars.content.items(), () -> this.sortItem, this::configure, Unloader.this.selectionRows, Unloader.this.selectionColumns);
        }

        @Override
        public Item config() {
            return this.sortItem;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.s(this.sortItem == null ? -1 : (int)this.sortItem.id);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            short id = revision == 1 ? read.s() : (short)read.b();
            this.sortItem = id == -1 ? null : Vars.content.item(id);
        }
    }

    public static class ContainerStat {
        Building building;
        float loadFactor;
        boolean canLoad;
        boolean canUnload;
        int lastUsed;

        public String toString() {
            return "ContainerStat{building=" + this.building.block + "#" + this.building.id + ", loadFactor=" + this.loadFactor + ", canLoad=" + this.canLoad + ", canUnload=" + this.canUnload + ", lastUsed=" + this.lastUsed + '}';
        }
    }
}

