/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.payloads;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Eachable;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.PayloadBlock;
import mindustry.world.blocks.payloads.PayloadUnloader;

public class PayloadLoader
extends PayloadBlock {
    public final int timerLoad;
    public float loadTime;
    public int itemsLoaded;
    public float liquidsLoaded;
    public int maxBlockSize;
    public float maxPowerConsumption;
    public boolean loadPowerDynamic;
    public TextureRegion overRegion;
    protected float basePowerUse;

    public PayloadLoader(String name) {
        super(name);
        this.timerLoad = this.timers++;
        this.loadTime = 2.0f;
        this.itemsLoaded = 8;
        this.liquidsLoaded = 40.0f;
        this.maxBlockSize = 3;
        this.maxPowerConsumption = 40.0f;
        this.loadPowerDynamic = true;
        this.basePowerUse = 0.0f;
        this.hasItems = true;
        this.hasLiquids = true;
        this.hasPower = true;
        this.itemCapacity = 100;
        this.liquidCapacity = 100.0f;
        this.update = true;
        this.outputsPayload = true;
        this.size = 3;
        this.rotate = true;
        this.canOverdrive = false;
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{this.region, this.inRegion, this.outRegion, this.topRegion};
    }

    @Override
    public boolean outputsItems() {
        return false;
    }

    @Override
    public void setBars() {
        super.setBars();
        this.addBar("progress", build -> new Bar(() -> Core.bundle.format(build.payload != null && ((BuildPayload)build.payload).block().hasItems ? "bar.items" : "bar.loadprogress", build.payload == null || !((BuildPayload)build.payload).block().hasItems ? 0 : ((BuildPayload)build.payload).build.items.total()), () -> Pal.items, build::fraction));
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        Draw.rect(this.region, plan.drawx(), plan.drawy());
        Draw.rect(this.inRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect(this.outRegion, plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.rect(this.topRegion, plan.drawx(), plan.drawy());
    }

    @Override
    public void init() {
        if (this.loadPowerDynamic) {
            this.basePowerUse = this.consPower != null ? this.consPower.usage : 0.0f;
            this.consumePowerDynamic(loader -> loader.hasBattery() && !loader.exporting ? this.maxPowerConsumption + this.basePowerUse : this.basePowerUse);
        }
        super.init();
    }

    public class PayloadLoaderBuild
    extends PayloadBlock.PayloadBlockBuild<BuildPayload> {
        public boolean exporting = false;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean acceptPayload(Building source, Payload payload) {
            if (!super.acceptPayload(source, payload)) return false;
            if (!payload.fits(PayloadLoader.this.maxBlockSize)) return false;
            if (!(payload instanceof BuildPayload)) return false;
            BuildPayload build = (BuildPayload)payload;
            if (build.build.block.hasItems && build.block().unloadable && build.block().itemCapacity >= 10) {
                if (build.block().size <= PayloadLoader.this.maxBlockSize) return true;
            }
            if (build.build.block().hasLiquids) {
                if (build.block().liquidCapacity >= 10.0f) return true;
            }
            if (build.build.block.consPower == null) return false;
            if (!build.build.block.consPower.buffered) return false;
            return true;
        }

        @Override
        public void handlePayload(Building source, Payload payload) {
            super.handlePayload(source, payload);
            this.exporting = false;
        }

        @Override
        public boolean acceptItem(Building source, Item item) {
            return this.items.total() < PayloadLoader.this.itemCapacity && !(source instanceof PayloadUnloader.PayloadUnloaderBuild);
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            return (this.liquids.current() == liquid || this.liquids.currentAmount() < 0.2f) && !(source instanceof PayloadUnloader.PayloadUnloaderBuild);
        }

        @Override
        public void draw() {
            Draw.rect(PayloadLoader.this.region, this.x, this.y);
            boolean fallback = true;
            for (int i = 0; i < 4; ++i) {
                if (!this.blends(i) || i == this.rotation) continue;
                Draw.rect(PayloadLoader.this.inRegion, this.x, this.y, (float)(i * 90 - 180));
                fallback = false;
            }
            if (fallback) {
                Draw.rect(PayloadLoader.this.inRegion, this.x, this.y, (float)(this.rotation * 90));
            }
            Draw.rect(PayloadLoader.this.outRegion, this.x, this.y, this.rotdeg());
            Draw.rect(PayloadLoader.this.topRegion, this.x, this.y);
            Draw.z(35.0f);
            this.drawPayload();
            if (PayloadLoader.this.overRegion.found()) {
                Draw.z(35.1f);
                Draw.rect(PayloadLoader.this.overRegion, this.x, this.y);
            }
        }

        @Override
        public void updateTile() {
            super.updateTile();
            if (this.shouldExport()) {
                this.moveOutPayload();
            } else if (this.moveInPayload()) {
                if (((BuildPayload)this.payload).block().hasItems && this.items.any() && this.efficiency > 0.01f && this.timer(PayloadLoader.this.timerLoad, PayloadLoader.this.loadTime / this.efficiency)) {
                    block0: for (int j = 0; j < PayloadLoader.this.itemsLoaded && this.items.any(); ++j) {
                        for (int i = 0; i < this.items.length(); ++i) {
                            if (this.items.get(i) <= 0) continue;
                            Item item = Vars.content.item(i);
                            if (((BuildPayload)this.payload).build.acceptItem(((BuildPayload)this.payload).build, item)) {
                                ((BuildPayload)this.payload).build.handleItem(((BuildPayload)this.payload).build, item);
                                this.items.remove(item, 1);
                                continue block0;
                            }
                            if (!((BuildPayload)this.payload).block().separateItemCapacity && !((BuildPayload)this.payload).block().consumesItem(item)) continue;
                            this.exporting = true;
                            continue block0;
                        }
                    }
                }
                if (((BuildPayload)this.payload).block().hasLiquids && this.liquids.currentAmount() >= 0.001f) {
                    Liquid liq = this.liquids.current();
                    float total = this.liquids.currentAmount();
                    float flow = Math.min(Math.min(PayloadLoader.this.liquidsLoaded * this.edelta(), ((BuildPayload)this.payload).block().liquidCapacity - ((BuildPayload)this.payload).build.liquids.get(liq)), total);
                    if (((BuildPayload)this.payload).build.acceptLiquid(((BuildPayload)this.payload).build, liq)) {
                        ((BuildPayload)this.payload).build.liquids.add(liq, flow);
                        this.liquids.remove(liq, flow);
                    }
                }
                if (this.hasBattery()) {
                    float powerInput = this.power.status * (PayloadLoader.this.basePowerUse + PayloadLoader.this.maxPowerConsumption);
                    float availableInput = Math.max(powerInput - PayloadLoader.this.basePowerUse, 0.0f);
                    float cap = ((BuildPayload)this.payload).block().consPower.capacity;
                    ((BuildPayload)this.payload).build.power.status += availableInput / cap * this.edelta();
                    if (((BuildPayload)this.payload).build.power.status >= 1.0f) {
                        this.exporting = true;
                        ((BuildPayload)this.payload).build.power.status = Mathf.clamp(((BuildPayload)this.payload).build.power.status);
                    }
                }
            }
        }

        public float fraction() {
            return this.payload == null ? 0.0f : (((BuildPayload)this.payload).build.items != null ? (float)((BuildPayload)this.payload).build.items.total() / (float)((BuildPayload)this.payload).build.block.itemCapacity : (((BuildPayload)this.payload).build.liquids != null ? ((BuildPayload)this.payload).build.liquids.currentAmount() / ((BuildPayload)this.payload).block().liquidCapacity : (this.hasBattery() ? ((BuildPayload)this.payload).build.power.status : 0.0f)));
        }

        public boolean shouldExport() {
            return this.payload != null && (this.exporting || ((BuildPayload)this.payload).block().hasLiquids && this.liquids.currentAmount() >= 0.1f && ((BuildPayload)this.payload).build.liquids.currentAmount() >= ((BuildPayload)this.payload).block().liquidCapacity - 0.001f || ((BuildPayload)this.payload).block().hasItems && this.items.any() && ((BuildPayload)this.payload).block().separateItemCapacity && Vars.content.items().contains((Item)((Object)((Boolf<Item>)i -> ((BuildPayload)this.payload).build.items.get((Item)i) >= ((BuildPayload)this.payload).block().itemCapacity))) || this.hasBattery() && ((BuildPayload)this.payload).build.power.status >= 1.0f);
        }

        public boolean hasBattery() {
            return this.payload != null && ((BuildPayload)this.payload).block().consPower != null && ((BuildPayload)this.payload).block().consPower.buffered;
        }

        @Override
        public boolean shouldConsume() {
            return this.payload != null;
        }

        @Override
        public byte version() {
            return 1;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.bool(this.exporting);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 1) {
                this.exporting = read.bool();
            }
        }
    }
}

