/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.liquid;

import arc.Core;
import arc.func.Boolf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Nullable;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.input.Placement;
import mindustry.type.Liquid;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.Autotiler;
import mindustry.world.blocks.distribution.ChainedBuilding;
import mindustry.world.blocks.distribution.DirectionBridge;
import mindustry.world.blocks.distribution.ItemBridge;
import mindustry.world.blocks.liquid.LiquidBlock;
import mindustry.world.blocks.liquid.LiquidJunction;

public class Conduit
extends LiquidBlock
implements Autotiler {
    static final float rotatePad = 6.0f;
    static final float hpad = 0.75f;
    static final float[][] rotateOffsets = new float[][]{{0.75f, 0.75f}, {-0.75f, 0.75f}, {-0.75f, -0.75f}, {0.75f, -0.75f}};
    public final int timerFlow;
    public Color botColor;
    public TextureRegion[] topRegions;
    public TextureRegion[] botRegions;
    public TextureRegion capRegion;
    public TextureRegion[][][] rotateRegions;
    public boolean padCorners;
    public boolean leaks;
    @Nullable
    public Block junctionReplacement;
    @Nullable
    public Block bridgeReplacement;
    @Nullable
    public Block rotBridgeReplacement;

    public Conduit(String name) {
        super(name);
        this.timerFlow = this.timers++;
        this.botColor = Color.valueOf("565656");
        this.padCorners = true;
        this.leaks = true;
        this.rotate = true;
        this.solid = false;
        this.floating = true;
        this.underBullets = true;
        this.conveyorPlacement = true;
        this.noUpdateDisabled = true;
        this.canOverdrive = false;
        this.priority = -1.0f;
    }

    @Override
    public void init() {
        super.init();
        if (this.junctionReplacement == null) {
            this.junctionReplacement = Blocks.liquidJunction;
        }
        if (this.bridgeReplacement == null || !(this.bridgeReplacement instanceof ItemBridge)) {
            this.bridgeReplacement = Blocks.bridgeConduit;
        }
    }

    @Override
    public void load() {
        super.load();
        this.rotateRegions = new TextureRegion[4][2][50];
        if (Vars.renderer != null) {
            float pad = 6.0f;
            TextureRegion[][] frames = Vars.renderer.getFluidFrames();
            for (int rot = 0; rot < 4; ++rot) {
                for (int fluid = 0; fluid < 2; ++fluid) {
                    for (int frame = 0; frame < 50; ++frame) {
                        TextureRegion base = frames[fluid][frame];
                        TextureRegion result = new TextureRegion();
                        result.set(base);
                        if (rot == 0) {
                            result.setX((float)result.getX() + pad);
                            result.setHeight((float)result.height - pad);
                        } else if (rot == 1) {
                            result.setWidth((float)result.width - pad);
                            result.setHeight((float)result.height - pad);
                        } else if (rot == 2) {
                            result.setWidth((float)result.width - pad);
                            result.setY((float)result.getY() + pad);
                        } else {
                            result.setX((float)result.getX() + pad);
                            result.setY((float)result.getY() + pad);
                        }
                        this.rotateRegions[rot][fluid][frame] = result;
                    }
                }
            }
        }
    }

    @Override
    public void drawPlanRegion(BuildPlan plan, Eachable<BuildPlan> list) {
        int[] bits = this.getTiling(plan, list);
        if (bits == null) {
            return;
        }
        Draw.scl(bits[1], bits[2]);
        Draw.color(this.botColor);
        Draw.alpha(0.5f);
        Draw.rect(this.botRegions[bits[0]], plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.color();
        Draw.rect(this.topRegions[bits[0]], plan.drawx(), plan.drawy(), (float)(plan.rotation * 90));
        Draw.scl();
    }

    @Override
    public Block getReplacement(BuildPlan req, Seq<BuildPlan> plans) {
        if (this.junctionReplacement == null) {
            return this;
        }
        Boolf<Point2> cont = p -> plans.contains(o -> o.x == req.x + p.x && o.y == req.y + p.y && (req.block instanceof Conduit || req.block instanceof LiquidJunction));
        return cont.get(Geometry.d4(req.rotation)) && cont.get(Geometry.d4(req.rotation - 2)) && req.tile() != null && req.tile().block() instanceof Conduit && Mathf.mod(req.build().rotation - req.rotation, 2) == 1 ? this.junctionReplacement : this;
    }

    @Override
    public boolean blends(Tile tile, int rotation, int otherx, int othery, int otherrot, Block otherblock) {
        return otherblock.hasLiquids && (otherblock.outputsLiquid || this.lookingAt(tile, rotation, otherx, othery, otherblock)) && this.lookingAtEither(tile, rotation, otherx, othery, otherrot, otherblock);
    }

    @Override
    public void handlePlacementLine(Seq<BuildPlan> plans) {
        if (this.bridgeReplacement == null) {
            return;
        }
        Block block = this.rotBridgeReplacement;
        if (block instanceof DirectionBridge) {
            DirectionBridge duct = (DirectionBridge)block;
            Placement.calculateBridges(plans, duct, true, b -> b instanceof Conduit);
        } else {
            Placement.calculateBridges(plans, (ItemBridge)this.bridgeReplacement);
        }
    }

    @Override
    public TextureRegion[] icons() {
        return new TextureRegion[]{Core.atlas.find("conduit-bottom"), this.topRegions[0]};
    }

    public class ConduitBuild
    extends LiquidBlock.LiquidBuild
    implements ChainedBuilding {
        public float smoothLiquid;
        public int blendbits;
        public int xscl;
        public int yscl;
        public int blending;
        public boolean capped;
        public boolean backCapped;

        public ConduitBuild() {
            super(Conduit.this);
            this.xscl = 1;
            this.yscl = 1;
            this.backCapped = false;
        }

        @Override
        public void draw() {
            int r = this.rotation;
            Draw.z(29.5f);
            for (int i = 0; i < 4; ++i) {
                if ((this.blending & 1 << i) == 0) continue;
                int dir = r - i;
                this.drawAt(this.x + (float)(Geometry.d4x(dir) * 8) * 0.75f, this.y + (float)(Geometry.d4y(dir) * 8) * 0.75f, 0, i == 0 ? r : dir, i != 0 ? Autotiler.SliceMode.bottom : Autotiler.SliceMode.top);
            }
            Draw.z(30.0f);
            Draw.scl(this.xscl, this.yscl);
            this.drawAt(this.x, this.y, this.blendbits, r, Autotiler.SliceMode.none);
            Draw.reset();
            if (this.capped && Conduit.this.capRegion.found()) {
                Draw.rect(Conduit.this.capRegion, this.x, this.y, this.rotdeg());
            }
            if (this.backCapped && Conduit.this.capRegion.found()) {
                Draw.rect(Conduit.this.capRegion, this.x, this.y, this.rotdeg() + 180.0f);
            }
        }

        protected void drawAt(float x, float y, int bits, int rotation, Autotiler.SliceMode slice) {
            TextureRegion liquidr;
            float angle = (float)rotation * 90.0f;
            Draw.color(Conduit.this.botColor);
            Draw.rect(Conduit.this.sliced(Conduit.this.botRegions[bits], slice), x, y, angle);
            int offset = this.yscl == -1 ? 3 : 0;
            int frame = this.liquids.current().getAnimationFrame();
            int gas = this.liquids.current().gas ? 1 : 0;
            float ox = 0.0f;
            float oy = 0.0f;
            int wrapRot = (rotation + offset) % 4;
            TextureRegion textureRegion = liquidr = bits == 1 && Conduit.this.padCorners ? Conduit.this.rotateRegions[wrapRot][gas][frame] : Vars.renderer.fluidFrames[gas][frame];
            if (bits == 1 && Conduit.this.padCorners) {
                ox = rotateOffsets[wrapRot][0];
                oy = rotateOffsets[wrapRot][1];
            }
            float xscl = Draw.xscl;
            float yscl = Draw.yscl;
            Draw.scl(1.0f, 1.0f);
            Drawf.liquid(Conduit.this.sliced(liquidr, slice), x + ox, y + oy, this.smoothLiquid, this.liquids.current().color.write(Tmp.c1).a(1.0f));
            Draw.scl(xscl, yscl);
            Draw.rect(Conduit.this.sliced(Conduit.this.topRegions[bits], slice), x, y, angle);
        }

        @Override
        public void onProximityUpdate() {
            super.onProximityUpdate();
            int[] bits = Conduit.this.buildBlending(this.tile, this.rotation, null, true);
            this.blendbits = bits[0];
            this.xscl = bits[1];
            this.yscl = bits[2];
            this.blending = bits[4];
            Building next = this.front();
            Building prev = this.back();
            this.capped = next == null || next.team != this.team || !next.block.hasLiquids;
            this.backCapped = this.blendbits == 0 && (prev == null || prev.team != this.team || !prev.block.hasLiquids);
        }

        @Override
        public boolean acceptLiquid(Building source, Liquid liquid) {
            this.noSleep();
            return !(this.liquids.current() != liquid && !(this.liquids.currentAmount() < 0.2f) || this.tile != null && source != this && (source.relativeTo(this.tile.x, this.tile.y) + 2) % 4 == this.rotation);
        }

        @Override
        public void updateTile() {
            this.smoothLiquid = Mathf.lerpDelta(this.smoothLiquid, this.liquids.currentAmount() / Conduit.this.liquidCapacity, 0.05f);
            if (this.liquids.currentAmount() > 1.0E-4f && this.timer(Conduit.this.timerFlow, 1.0f)) {
                this.moveLiquidForward(Conduit.this.leaks, this.liquids.current());
                this.noSleep();
            } else {
                this.sleep();
            }
        }

        @Override
        @Nullable
        public Building next() {
            Tile next = this.tile.nearby(this.rotation);
            if (next != null && next.build instanceof ConduitBuild) {
                return next.build;
            }
            return null;
        }
    }
}

