/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.math.Mathf;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.world.blocks.defense.turrets.BaseTurret;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.consumers.ConsumeLiquidFilter;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class ReloadTurret
extends BaseTurret {
    public float reload = 10.0f;

    public ReloadTurret(String name) {
        super(name);
    }

    @Override
    public void setStats() {
        super.setStats();
        if (this.coolant != null) {
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, StatValues.boosters(this.reload, this.coolant.amount, this.coolantMultiplier, true, l -> l.coolant && this.consumesLiquid((Liquid)l)));
        }
    }

    public class ReloadTurretBuild
    extends BaseTurret.BaseTurretBuild {
        public float reloadCounter;

        protected void updateCooling() {
            if (this.reloadCounter < ReloadTurret.this.reload && ReloadTurret.this.coolant != null && ReloadTurret.this.coolant.efficiency(this) > 0.0f && this.efficiency > 0.0f) {
                float f;
                ConsumeLiquidBase consumeLiquidBase = ReloadTurret.this.coolant;
                if (consumeLiquidBase instanceof ConsumeLiquidFilter) {
                    ConsumeLiquidFilter filter = (ConsumeLiquidFilter)consumeLiquidBase;
                    f = filter.getConsumed((Building)this).heatCapacity;
                } else {
                    f = 1.0f;
                }
                float capacity = f;
                float amount = ReloadTurret.this.coolant.amount * ReloadTurret.this.coolant.efficiency(this);
                ReloadTurret.this.coolant.update(this);
                this.reloadCounter += amount * this.edelta() * capacity * ReloadTurret.this.coolantMultiplier;
                if (Mathf.chance(0.06 * (double)amount)) {
                    ReloadTurret.this.coolEffect.at(this.x + Mathf.range((float)(ReloadTurret.this.size * 8) / 2.0f), this.y + Mathf.range((float)(ReloadTurret.this.size * 8) / 2.0f));
                }
            }
        }

        protected float baseReloadSpeed() {
            return this.efficiency;
        }
    }
}

