/*
 * Decompiled with CFR 0.152.
 */
package mindustry.world.blocks.defense.turrets;

import arc.math.Angles;
import arc.math.Mathf;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Bullets;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidBase;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;

public class ContinuousTurret
extends Turret {
    public BulletType shootType = Bullets.placeholder;
    public float aimChangeSpeed = Float.POSITIVE_INFINITY;

    public ContinuousTurret(String name) {
        super(name);
        this.coolantMultiplier = 1.0f;
        this.envEnabled |= 2;
        this.displayAmmoMultiplier = false;
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.ammo, StatValues.ammo(ObjectMap.of(this, this.shootType)));
        this.stats.remove(Stat.reload);
        this.stats.remove(Stat.inaccuracy);
    }

    public class ContinuousTurretBuild
    extends Turret.TurretBuild {
        public Seq<Turret.BulletEntry> bullets;
        public float lastLength;

        public ContinuousTurretBuild() {
            super(ContinuousTurret.this);
            this.bullets = new Seq();
            this.lastLength = (float)ContinuousTurret.this.size * 4.0f;
        }

        @Override
        protected void updateCooling() {
        }

        @Override
        public BulletType useAmmo() {
            return ContinuousTurret.this.shootType;
        }

        @Override
        public boolean hasAmmo() {
            return this.canConsume();
        }

        @Override
        public boolean shouldConsume() {
            return this.isShooting();
        }

        @Override
        public BulletType peekAmmo() {
            return ContinuousTurret.this.shootType;
        }

        @Override
        public void updateTile() {
            super.updateTile();
            float ammoFract = this.efficiency;
            Object t = ContinuousTurret.this.findConsumer(f -> f instanceof ConsumeLiquidBase);
            if (t instanceof ConsumeLiquid) {
                ConsumeLiquid cons = (ConsumeLiquid)t;
                ammoFract = Math.min(ammoFract, this.liquids.get(cons.liquid) / ContinuousTurret.this.liquidCapacity);
            }
            this.unit.ammo((float)this.unit.type().ammoCapacity * ammoFract);
            this.bullets.removeAll(b -> !b.bullet.isAdded() || b.bullet.type == null || b.bullet.owner != this);
            if (this.bullets.any()) {
                for (Turret.BulletEntry entry : this.bullets) {
                    this.updateBullet(entry);
                }
                this.wasShooting = true;
                this.heat = 1.0f;
                this.curRecoil = ContinuousTurret.this.recoil;
            }
        }

        protected void updateBullet(Turret.BulletEntry entry) {
            float resultLength;
            float bulletX = this.x + Angles.trnsx(this.rotation - 90.0f, ContinuousTurret.this.shootX + entry.x, ContinuousTurret.this.shootY + entry.y);
            float bulletY = this.y + Angles.trnsy(this.rotation - 90.0f, ContinuousTurret.this.shootX + entry.x, ContinuousTurret.this.shootY + entry.y);
            float angle = this.rotation + entry.rotation;
            entry.bullet.rotation(angle);
            entry.bullet.set(bulletX, bulletY);
            float shootLength = Math.min(this.dst(this.targetPos), ContinuousTurret.this.range);
            float curLength = this.dst(entry.bullet.aimX, entry.bullet.aimY);
            this.lastLength = resultLength = Mathf.approachDelta(curLength, shootLength, ContinuousTurret.this.aimChangeSpeed);
            Tmp.v1.trns(this.rotation, this.lastLength).add(this.x, this.y);
            entry.bullet.aimX = Tmp.v1.x;
            entry.bullet.aimY = Tmp.v1.y;
            if (this.isShooting() && this.hasAmmo()) {
                entry.bullet.time = entry.bullet.lifetime * entry.bullet.type.optimalLifeFract * this.shootWarmup;
                entry.bullet.keepAlive = true;
            }
        }

        @Override
        protected void updateReload() {
        }

        @Override
        protected void updateShooting() {
            if (this.bullets.any()) {
                return;
            }
            if (this.canConsume() && !this.charging() && this.shootWarmup >= ContinuousTurret.this.minWarmup) {
                this.shoot(this.peekAmmo());
            }
        }

        @Override
        protected void turnToTarget(float targetRot) {
            this.rotation = Angles.moveToward(this.rotation, targetRot, this.efficiency * ContinuousTurret.this.rotateSpeed * this.delta());
        }

        @Override
        protected void handleBullet(@Nullable Bullet bullet, float offsetX, float offsetY, float angleOffset) {
            if (bullet != null) {
                this.bullets.add(new Turret.BulletEntry(bullet, offsetX, offsetY, angleOffset, 0.0f));
                Tmp.v1.trns(this.rotation, ContinuousTurret.this.shootY + this.lastLength).add(this.x, this.y);
                bullet.aimX = Tmp.v1.x;
                bullet.aimY = Tmp.v1.y;
            }
        }

        @Override
        public boolean shouldActiveSound() {
            return this.bullets.any();
        }

        @Override
        public float activeSoundVolume() {
            return 1.0f;
        }

        @Override
        public byte version() {
            return 3;
        }

        @Override
        public void write(Writes write) {
            super.write(write);
            write.f(this.lastLength);
        }

        @Override
        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision >= 3) {
                this.lastLength = read.f();
            }
        }
    }
}

