/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.scene.ui.TextButton;
import arc.util.Time;
import mindustry.Vars;
import mindustry.game.Saves;
import mindustry.gen.Icon;
import mindustry.ui.dialogs.LoadDialog;

public class SaveDialog
extends LoadDialog {
    public SaveDialog() {
        super("@savegame");
        this.update(() -> {
            if (Vars.state.isMenu() && this.isShown()) {
                this.hide();
            }
        });
    }

    @Override
    public void addSetup() {
        this.buttons.button("@save.new", Icon.add, () -> Vars.ui.showTextInput("@save", "@save.newslot", 30, "", text -> Vars.ui.loadAnd("@saving", () -> {
            Vars.control.saves.addSave((String)text);
            Core.app.post(() -> Core.app.post(this::setup));
        }))).fillX().margin(10.0f);
    }

    @Override
    public void modifyButton(TextButton button, Saves.SaveSlot slot) {
        button.clicked(() -> {
            if (button.childrenPressed()) {
                return;
            }
            Vars.ui.showConfirm("@overwrite", "@save.overwrite", () -> this.save(slot));
        });
    }

    void save(Saves.SaveSlot slot) {
        Vars.ui.loadfrag.show("@saving");
        Time.runTask(5.0f, () -> {
            this.hide();
            Vars.ui.loadfrag.hide();
            try {
                slot.save();
            }
            catch (Throwable e) {
                e.printStackTrace();
                Vars.ui.showException("[accent]" + Core.bundle.get("savefail"), e);
            }
        });
    }
}

