/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ui.dialogs;

import arc.Core;
import arc.func.Boolc;
import arc.func.Boolf;
import arc.func.Boolp;
import arc.func.Cons;
import arc.func.Floatc;
import arc.func.Floatp;
import arc.func.Intc;
import arc.func.Intp;
import arc.func.Prov;
import arc.graphics.Color;
import arc.scene.style.Drawable;
import arc.scene.style.TextureRegionDrawable;
import arc.scene.ui.Button;
import arc.scene.ui.ButtonGroup;
import arc.scene.ui.Image;
import arc.scene.ui.ImageButton;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.TextButton;
import arc.scene.ui.TextField;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Items;
import mindustry.content.Planets;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Rules;
import mindustry.game.Team;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.type.ItemStack;
import mindustry.type.Planet;
import mindustry.type.Weather;
import mindustry.ui.Styles;
import mindustry.ui.dialogs.BaseDialog;
import mindustry.ui.dialogs.LoadoutDialog;
import mindustry.world.Block;

public class CustomRulesDialog
extends BaseDialog {
    Rules rules;
    private Table main;
    private Prov<Rules> resetter;
    private LoadoutDialog loadoutDialog = new LoadoutDialog();

    public CustomRulesDialog() {
        super("@mode.custom");
        this.setFillParent(true);
        this.shown(this::setup);
        this.addCloseButton();
    }

    private <T extends UnlockableContent> void showBanned(String title, ContentType type, ObjectSet<T> set, Boolf<T> pred) {
        BaseDialog bd = new BaseDialog(title);
        bd.addCloseButton();
        Runnable[] rebuild = new Runnable[]{null};
        rebuild[0] = () -> {
            float previousScroll = bd.cont.getChildren().isEmpty() ? 0.0f : ((ScrollPane)bd.cont.getChildren().first()).getScrollY();
            bd.cont.clear();
            bd.cont.pane((Table t) -> {
                t.margin(10.0f);
                if (set.isEmpty()) {
                    t.add("@empty");
                }
                Seq array = set.toSeq();
                array.sort();
                int cols = Vars.mobile && Core.graphics.isPortrait() ? 1 : (Vars.mobile ? 2 : 3);
                int i = 0;
                for (UnlockableContent con : array) {
                    t.table(Tex.underline, b -> {
                        b.left().margin(4.0f);
                        b.image(con.uiIcon).size(32.0f).padRight(3.0f);
                        b.add(con.localizedName).color(Color.lightGray).padLeft(3.0f).growX().left().wrap();
                        b.button((Drawable)Icon.cancel, Styles.emptyi, () -> {
                            set.remove(con);
                            rebuild[0].run();
                        }).size(70.0f).pad(-4.0f).padLeft(0.0f);
                    }).size(300.0f, 70.0f).padRight(5.0f);
                    if (++i % cols != 0) continue;
                    t.row();
                }
            }).get().setScrollYForce(previousScroll);
            bd.cont.row();
            bd.cont.button("@add", Icon.add, () -> {
                BaseDialog dialog = new BaseDialog("@add");
                dialog.cont.pane((Table t) -> {
                    t.left().margin(14.0f);
                    int[] i = new int[]{0};
                    Vars.content.getBy(type).each(b -> !set.contains(b) && pred.get(b), b -> {
                        int cols = Vars.mobile && Core.graphics.isPortrait() ? 4 : 12;
                        t.button(new TextureRegionDrawable(b.uiIcon), Styles.flati, 32.0f, () -> {
                            set.add(b);
                            rebuild[0].run();
                            dialog.hide();
                        }).size(60.0f).tooltip(b.localizedName);
                        i[0] = i[0] + 1;
                        if (i[0] % cols == 0) {
                            t.row();
                        }
                    });
                });
                dialog.addCloseButton();
                dialog.show();
            }).size(300.0f, 64.0f).disabled(b -> set.size == Vars.content.getBy(type).count(pred));
        };
        bd.shown(rebuild[0]);
        bd.buttons.button("@addall", Icon.add, () -> {
            set.addAll(Vars.content.getBy(type).select(pred));
            rebuild[0].run();
        }).size(180.0f, 64.0f);
        bd.buttons.button("@clear", Icon.trash, () -> {
            set.clear();
            rebuild[0].run();
        }).size(180.0f, 64.0f);
        bd.show();
    }

    public void show(Rules rules, Prov<Rules> resetter) {
        this.rules = rules;
        this.resetter = resetter;
        this.show();
    }

    void setup() {
        this.cont.clear();
        this.cont.pane((Table m) -> {
            this.main = m;
        }).scrollX(false);
        this.main.margin(10.0f);
        this.main.button("@settings.reset", () -> {
            this.rules = this.resetter.get();
            this.setup();
            this.requestKeyboard();
            this.requestScroll();
        }).size(300.0f, 50.0f);
        this.main.left().defaults().fillX().left().pad(5.0f);
        this.main.row();
        this.title("@rules.title.waves");
        this.check("@rules.waves", b -> {
            this.rules.waves = b;
        }, () -> this.rules.waves);
        this.check("@rules.wavesending", b -> {
            this.rules.waveSending = b;
        }, () -> this.rules.waveSending, () -> this.rules.waves);
        this.check("@rules.wavetimer", b -> {
            this.rules.waveTimer = b;
        }, () -> this.rules.waveTimer, () -> this.rules.waves);
        this.check("@rules.waitForWaveToEnd", b -> {
            this.rules.waitEnemies = b;
        }, () -> this.rules.waitEnemies, () -> this.rules.waves && this.rules.waveTimer);
        this.numberi("@rules.wavelimit", f -> {
            this.rules.winWave = f;
        }, () -> this.rules.winWave, () -> this.rules.waves, 0, Integer.MAX_VALUE);
        this.number("@rules.wavespacing", false, f -> {
            this.rules.waveSpacing = f * 60.0f;
        }, () -> this.rules.waveSpacing / 60.0f, () -> this.rules.waves && this.rules.waveTimer, 1.0f, Float.MAX_VALUE);
        if (Vars.experimental) {
            this.number("@rules.initialwavespacing", false, f -> {
                this.rules.initialWaveSpacing = f * 60.0f;
            }, () -> this.rules.initialWaveSpacing / 60.0f, () -> this.rules.waves && this.rules.waveTimer, 0.0f, Float.MAX_VALUE);
        }
        this.number("@rules.dropzoneradius", false, (float f) -> {
            this.rules.dropZoneRadius = f * 8.0f;
        }, () -> this.rules.dropZoneRadius / 8.0f, () -> this.rules.waves);
        this.title("@rules.title.resourcesbuilding");
        this.check("@rules.infiniteresources", b -> {
            this.rules.infiniteResources = b;
            if (!b && this.rules.hiddenBuildItems.isEmpty()) {
                this.rules.env = Planets.serpulo.defaultEnv;
                this.rules.hiddenBuildItems.clear();
                this.rules.hiddenBuildItems.addAll(Planets.serpulo.hiddenItems);
                this.setup();
            }
        }, () -> this.rules.infiniteResources);
        this.check("@rules.onlydepositcore", b -> {
            this.rules.onlyDepositCore = b;
        }, () -> this.rules.onlyDepositCore);
        this.check("@rules.reactorexplosions", b -> {
            this.rules.reactorExplosions = b;
        }, () -> this.rules.reactorExplosions);
        this.check("@rules.schematic", b -> {
            this.rules.schematicsAllowed = b;
        }, () -> this.rules.schematicsAllowed);
        this.check("@rules.coreincinerates", b -> {
            this.rules.coreIncinerates = b;
        }, () -> this.rules.coreIncinerates);
        this.check("@rules.cleanupdeadteams", b -> {
            this.rules.cleanupDeadTeams = b;
        }, () -> this.rules.cleanupDeadTeams, () -> this.rules.pvp);
        this.check("@rules.disableworldprocessors", b -> {
            this.rules.disableWorldProcessors = b;
        }, () -> this.rules.disableWorldProcessors);
        this.number("@rules.buildcostmultiplier", false, (float f) -> {
            this.rules.buildCostMultiplier = f;
        }, () -> this.rules.buildCostMultiplier, () -> !this.rules.infiniteResources);
        this.number("@rules.buildspeedmultiplier", f -> {
            this.rules.buildSpeedMultiplier = f;
        }, () -> this.rules.buildSpeedMultiplier, 0.001f, 50.0f);
        this.number("@rules.deconstructrefundmultiplier", false, (float f) -> {
            this.rules.deconstructRefundMultiplier = f;
        }, () -> this.rules.deconstructRefundMultiplier, () -> !this.rules.infiniteResources);
        this.number("@rules.blockhealthmultiplier", f -> {
            this.rules.blockHealthMultiplier = f;
        }, () -> this.rules.blockHealthMultiplier);
        this.number("@rules.blockdamagemultiplier", f -> {
            this.rules.blockDamageMultiplier = f;
        }, () -> this.rules.blockDamageMultiplier);
        this.main.button("@configure", () -> this.loadoutDialog.show(999999, this.rules.loadout, i -> true, () -> this.rules.loadout.clear().add(new ItemStack(Items.copper, 100)), () -> {}, () -> {})).left().width(300.0f).row();
        this.main.button("@bannedblocks", () -> this.showBanned("@bannedblocks", ContentType.block, this.rules.bannedBlocks, Block::canBeBuilt)).left().width(300.0f).row();
        this.check("@rules.hidebannedblocks", b -> {
            this.rules.hideBannedBlocks = b;
        }, () -> this.rules.hideBannedBlocks);
        this.check("@bannedblocks.whitelist", b -> {
            this.rules.blockWhitelist = b;
        }, () -> this.rules.blockWhitelist);
        this.title("@rules.title.unit");
        this.check("@rules.unitcapvariable", b -> {
            this.rules.unitCapVariable = b;
        }, () -> this.rules.unitCapVariable);
        this.numberi("@rules.unitcap", f -> {
            this.rules.unitCap = f;
        }, () -> this.rules.unitCap, -999, 999);
        this.number("@rules.unitdamagemultiplier", f -> {
            this.rules.unitDamageMultiplier = f;
        }, () -> this.rules.unitDamageMultiplier);
        this.number("@rules.unitcrashdamagemultiplier", f -> {
            this.rules.unitCrashDamageMultiplier = f;
        }, () -> this.rules.unitCrashDamageMultiplier);
        this.number("@rules.unitbuildspeedmultiplier", f -> {
            this.rules.unitBuildSpeedMultiplier = f;
        }, () -> this.rules.unitBuildSpeedMultiplier, 0.0f, 50.0f);
        this.number("@rules.unitcostmultiplier", f -> {
            this.rules.unitCostMultiplier = f;
        }, () -> this.rules.unitCostMultiplier);
        this.number("@rules.unithealthmultiplier", f -> {
            this.rules.unitHealthMultiplier = f;
        }, () -> this.rules.unitHealthMultiplier);
        this.main.button("@bannedunits", () -> this.showBanned("@bannedunits", ContentType.unit, this.rules.bannedUnits, u -> !u.isHidden())).left().width(300.0f).row();
        this.check("@bannedunits.whitelist", b -> {
            this.rules.unitWhitelist = b;
        }, () -> this.rules.unitWhitelist);
        this.title("@rules.title.enemy");
        this.check("@rules.attack", b -> {
            this.rules.attackMode = b;
        }, () -> this.rules.attackMode);
        this.check("@rules.corecapture", b -> {
            this.rules.coreCapture = b;
        }, () -> this.rules.coreCapture);
        this.check("@rules.placerangecheck", b -> {
            this.rules.placeRangeCheck = b;
        }, () -> this.rules.placeRangeCheck);
        this.check("@rules.polygoncoreprotection", b -> {
            this.rules.polygonCoreProtection = b;
        }, () -> this.rules.polygonCoreProtection);
        this.number("@rules.enemycorebuildradius", f -> {
            this.rules.enemyCoreBuildRadius = f * 8.0f;
        }, () -> Math.min(this.rules.enemyCoreBuildRadius / 8.0f, 200.0f), () -> !this.rules.polygonCoreProtection);
        this.title("@rules.title.environment");
        this.check("@rules.explosions", b -> {
            this.rules.damageExplosions = b;
        }, () -> this.rules.damageExplosions);
        this.check("@rules.fire", b -> {
            this.rules.fire = b;
        }, () -> this.rules.fire);
        this.check("@rules.fog", b -> {
            this.rules.fog = b;
        }, () -> this.rules.fog);
        this.check("@rules.lighting", b -> {
            this.rules.lighting = b;
        }, () -> this.rules.lighting);
        if (Vars.experimental) {
            this.check("@rules.limitarea", b -> {
                this.rules.limitMapArea = b;
            }, () -> this.rules.limitMapArea);
            this.numberi("x", x -> {
                this.rules.limitX = x;
            }, () -> this.rules.limitX, () -> this.rules.limitMapArea, 0, 10000);
            this.numberi("y", y -> {
                this.rules.limitY = y;
            }, () -> this.rules.limitY, () -> this.rules.limitMapArea, 0, 10000);
            this.numberi("w", w -> {
                this.rules.limitWidth = w;
            }, () -> this.rules.limitWidth, () -> this.rules.limitMapArea, 0, 10000);
            this.numberi("h", h -> {
                this.rules.limitHeight = h;
            }, () -> this.rules.limitHeight, () -> this.rules.limitMapArea, 0, 10000);
        }
        this.number("@rules.solarmultiplier", f -> {
            this.rules.solarMultiplier = f;
        }, () -> this.rules.solarMultiplier);
        this.main.button((Button b) -> {
            b.left();
            b.table(Tex.pane, in -> in.stack(new Image(Tex.alphaBg), new Image(Tex.whiteui){
                {
                    this.update(() -> this.setColor(CustomRulesDialog.this.rules.ambientLight));
                }
            }).grow()).margin(4.0f).size(50.0f).padRight(10.0f);
            b.add("@rules.ambientlight");
        }, () -> Vars.ui.picker.show(this.rules.ambientLight, this.rules.ambientLight::set)).left().width(250.0f).row();
        this.main.button("@rules.weather", this::weatherDialog).width(250.0f).left().row();
        this.title("@rules.title.planet");
        this.main.table(Tex.button, t -> {
            t.margin(10.0f);
            ButtonGroup group = new ButtonGroup();
            TextButton.TextButtonStyle style = Styles.flatTogglet;
            t.defaults().size(140.0f, 50.0f);
            for (Planet planet : Vars.content.planets().select(p -> p.accessible && p.visible && p.isLandable())) {
                t.button(planet.localizedName, style, () -> planet.applyRules(this.rules)).group(group).checked(b -> this.rules.planet == planet);
                if (t.getChildren().size % 3 != 0) continue;
                t.row();
            }
            t.button("@rules.anyenv", style, () -> {
                this.rules.env = 233;
                this.rules.hiddenBuildItems.clear();
                this.rules.planet = Planets.sun;
            }).group(group).checked(b -> this.rules.planet == Planets.sun);
        }).left().fill(false).expand(false, false).row();
        this.title("@rules.title.teams");
        this.team("@rules.playerteam", t -> {
            this.rules.defaultTeam = t;
        }, () -> this.rules.defaultTeam);
        this.team("@rules.enemyteam", t -> {
            this.rules.waveTeam = t;
        }, () -> this.rules.waveTeam);
        for (Team team : Team.baseTeams) {
            boolean[] shown = new boolean[]{false};
            Table wasMain = this.main;
            this.main.button(team.coloredName(), (Drawable)Icon.downOpen, Styles.togglet, () -> {
                shown[0] = !shown[0];
            }).marginLeft(14.0f).width(260.0f).height(55.0f).update((T t) -> {
                ((Image)t.getChildren().get(1)).setDrawable(shown[0] ? Icon.upOpen : Icon.downOpen);
                t.setChecked(shown[0]);
            }).row();
            this.main.collapser((Table t) -> {
                t.left().defaults().fillX().left().pad(5.0f);
                this.main = t;
                Rules.TeamRule teams = this.rules.teams.get(team);
                this.number("@rules.blockhealthmultiplier", f -> {
                    teams.blockHealthMultiplier = f;
                }, () -> teams.blockHealthMultiplier);
                this.number("@rules.blockdamagemultiplier", f -> {
                    teams.blockDamageMultiplier = f;
                }, () -> teams.blockDamageMultiplier);
                this.check("@rules.rtsai", b -> {
                    teams.rtsAi = b;
                }, () -> teams.rtsAi, () -> team != this.rules.defaultTeam);
                this.numberi("@rules.rtsminsquadsize", f -> {
                    teams.rtsMinSquad = f;
                }, () -> teams.rtsMinSquad, () -> teams.rtsAi, 0, 100);
                this.numberi("@rules.rtsmaxsquadsize", f -> {
                    teams.rtsMaxSquad = f;
                }, () -> teams.rtsMaxSquad, () -> teams.rtsAi, 1, 1000);
                this.number("@rules.rtsminattackweight", f -> {
                    teams.rtsMinWeight = f;
                }, () -> teams.rtsMinWeight, () -> teams.rtsAi);
                this.check("@rules.buildai", b -> {
                    teams.buildAi = b;
                }, () -> teams.buildAi, () -> team != this.rules.defaultTeam && this.rules.env != Planets.erekir.defaultEnv && !this.rules.pvp);
                this.number("@rules.buildaitier", false, f -> {
                    teams.buildAiTier = f;
                }, () -> teams.buildAiTier, () -> teams.buildAi && this.rules.env != Planets.erekir.defaultEnv && !this.rules.pvp, 0.0f, 1.0f);
                this.check("@rules.infiniteresources", b -> {
                    teams.infiniteResources = b;
                }, () -> teams.infiniteResources);
                this.number("@rules.buildspeedmultiplier", f -> {
                    teams.buildSpeedMultiplier = f;
                }, () -> teams.buildSpeedMultiplier, 0.001f, 50.0f);
                this.number("@rules.unitdamagemultiplier", f -> {
                    teams.unitDamageMultiplier = f;
                }, () -> teams.unitDamageMultiplier);
                this.number("@rules.unitcrashdamagemultiplier", f -> {
                    teams.unitCrashDamageMultiplier = f;
                }, () -> teams.unitCrashDamageMultiplier);
                this.number("@rules.unitbuildspeedmultiplier", f -> {
                    teams.unitBuildSpeedMultiplier = f;
                }, () -> teams.unitBuildSpeedMultiplier, 0.001f, 50.0f);
                this.number("@rules.unitcostmultiplier", f -> {
                    teams.unitCostMultiplier = f;
                }, () -> teams.unitCostMultiplier);
                this.number("@rules.unithealthmultiplier", f -> {
                    teams.unitHealthMultiplier = f;
                }, () -> teams.unitHealthMultiplier);
                this.main = wasMain;
            }, () -> shown[0]).growX().row();
        }
    }

    void team(String text, Cons<Team> cons, Prov<Team> prov) {
        this.main.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f);
            for (Team team : Team.baseTeams) {
                t.button(Tex.whiteui, Styles.squareTogglei, 38.0f, () -> cons.get(team)).pad(1.0f).checked(b -> prov.get() == team).size(60.0f).tooltip(team.coloredName()).with(i -> {
                    i.getStyle().imageUpColor = team.color;
                });
            }
        }).padTop(0.0f).row();
    }

    void number(String text, Floatc cons, Floatp prov) {
        this.number(text, false, cons, prov, () -> true, 0.0f, Float.MAX_VALUE);
    }

    void number(String text, Floatc cons, Floatp prov, float min, float max) {
        this.number(text, false, cons, prov, () -> true, min, max);
    }

    void number(String text, boolean integer, Floatc cons, Floatp prov, Boolp condition) {
        this.number(text, integer, cons, prov, condition, 0.0f, Float.MAX_VALUE);
    }

    void number(String text, Floatc cons, Floatp prov, Boolp condition) {
        this.number(text, false, cons, prov, condition, 0.0f, Float.MAX_VALUE);
    }

    void numberi(String text, Intc cons, Intp prov, int min, int max) {
        this.numberi(text, cons, prov, () -> true, min, max);
    }

    void numberi(String text, Intc cons, Intp prov, Boolp condition, int min, int max) {
        this.main.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f).update((T a) -> a.setColor(condition.get() ? Color.white : Color.gray));
            t.field(prov.get() + "", s -> cons.get(Strings.parseInt(s))).update((T a) -> a.setDisabled(!condition.get())).padRight(100.0f).valid(f -> Strings.parseInt(f) >= min && Strings.parseInt(f) <= max).width(120.0f).left();
        }).padTop(0.0f).row();
    }

    void number(String text, boolean integer, Floatc cons, Floatp prov, Boolp condition, float min, float max) {
        this.main.table((Table t) -> {
            t.left();
            t.add(text).left().padRight(5.0f).update((T a) -> a.setColor(condition.get() ? Color.white : Color.gray));
            t.field((integer ? (float)((int)prov.get()) : prov.get()) + "", s -> cons.get(Strings.parseFloat(s))).padRight(100.0f).update((T a) -> a.setDisabled(!condition.get())).valid(f -> Strings.canParsePositiveFloat(f) && Strings.parseFloat(f) >= min && Strings.parseFloat(f) <= max).width(120.0f).left();
        }).padTop(0.0f);
        this.main.row();
    }

    void check(String text, Boolc cons, Boolp prov) {
        this.check(text, cons, prov, () -> true);
    }

    void check(String text, Boolc cons, Boolp prov, Boolp condition) {
        this.main.check(text, cons).checked(prov.get()).update((T a) -> a.setDisabled(!condition.get())).padRight(100.0f).get().left();
        this.main.row();
    }

    void title(String text) {
        this.main.add(text).color(Pal.accent).padTop(20.0f).padRight(100.0f).padBottom(-3.0f);
        this.main.row();
        this.main.image().color(Pal.accent).height(3.0f).padRight(100.0f).padBottom(20.0f);
        this.main.row();
    }

    Cell<TextField> field(Table table, float value, Floatc setter) {
        return table.field(Strings.autoFixed(value, 2), v -> setter.get(Strings.parseFloat(v))).valid(Strings::canParsePositiveFloat).size(90.0f, 40.0f).pad(2.0f);
    }

    void weatherDialog() {
        BaseDialog dialog = new BaseDialog("@rules.weather");
        Runnable[] rebuild = new Runnable[]{null};
        dialog.cont.pane((Table base) -> {
            rebuild[0] = () -> {
                base.clearChildren();
                int cols = Math.max(1, (int)((float)Core.graphics.getWidth() / Scl.scl(450.0f)));
                int idx = 0;
                for (Weather.WeatherEntry entry : this.rules.weather) {
                    base.top();
                    base.table(Tex.pane, c -> {
                        c.margin(0.0f);
                        c.table(Tex.whiteui, t -> {
                            t.setColor(Pal.gray);
                            t.top().left();
                            t.add(entry.weather.localizedName).left().padLeft(6.0f);
                            t.add().growX();
                            ImageButton.ImageButtonStyle style = Styles.geni;
                            t.defaults().size(42.0f);
                            t.button((Drawable)Icon.cancel, style, () -> {
                                this.rules.weather.remove(entry);
                                rebuild[0].run();
                            });
                        }).growX();
                        c.row();
                        c.table((Table f) -> {
                            f.marginLeft(4.0f);
                            f.left().top();
                            f.defaults().padRight(4.0f).left();
                            f.add("@rules.weather.duration");
                            this.field((Table)f, entry.minDuration / 3600.0f, (float v) -> {
                                entry.minDuration = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@waves.to");
                            this.field((Table)f, entry.maxDuration / 3600.0f, (float v) -> {
                                entry.maxDuration = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@unit.minutes");
                            f.row();
                            f.add("@rules.weather.frequency");
                            this.field((Table)f, entry.minFrequency / 3600.0f, (float v) -> {
                                entry.minFrequency = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@waves.to");
                            this.field((Table)f, entry.maxFrequency / 3600.0f, (float v) -> {
                                entry.maxFrequency = v * 3600.0f;
                            }).disabled(v -> entry.always);
                            f.add("@unit.minutes");
                            f.row();
                            f.check("@rules.weather.always", val -> {
                                entry.always = val;
                            }).checked(cc -> entry.always).padBottom(4.0f);
                        }).grow().left().pad(6.0f).top();
                    }).width(410.0f).pad(3.0f).top().left().fillY();
                    if (++idx % cols != 0) continue;
                    base.row();
                }
            };
            rebuild[0].run();
        }).grow();
        dialog.addCloseButton();
        dialog.buttons.button("@add", Icon.add, () -> {
            BaseDialog add = new BaseDialog("@add");
            add.cont.pane((Table t) -> {
                t.background(Tex.button);
                int i = 0;
                for (Weather weather : Vars.content.getBy(ContentType.weather)) {
                    if (weather.hidden) continue;
                    t.button(weather.localizedName, Styles.flatt, () -> {
                        this.rules.weather.add(new Weather.WeatherEntry(weather));
                        rebuild[0].run();
                        add.hide();
                    }).size(140.0f, 50.0f);
                    if (++i % 2 != 0) continue;
                    t.row();
                }
            });
            add.addCloseButton();
            add.show();
        }).width(170.0f);
        dialog.show();
    }
}

