/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.func.Cons;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Rules;
import mindustry.gen.Icon;
import mindustry.maps.generators.FileMapGenerator;
import mindustry.mod.Mods;
import mindustry.type.Planet;
import mindustry.type.Sector;

public class SectorPreset
extends UnlockableContent {
    public FileMapGenerator generator;
    public Planet planet;
    public Sector sector;
    public int captureWave = 0;
    public Cons<Rules> rules = rules -> {
        rules.winWave = this.captureWave;
    };
    public float difficulty;
    public float startWaveTimeMultiplier = 2.0f;
    public boolean addStartingItems = false;
    public boolean noLighting = false;
    public boolean isLastSector;
    public boolean showSectorLandInfo = true;
    public boolean overrideLaunchDefaults = false;
    public boolean allowLaunchSchematics = false;
    public boolean allowLaunchLoadout = false;
    public boolean attackAfterWaves = false;

    public SectorPreset(String name, Planet planet, int sector) {
        this(name);
        this.initialize(planet, sector);
    }

    public SectorPreset(String name, Mods.LoadedMod mod) {
        super(name);
        this.minfo.mod = mod;
        this.generator = new FileMapGenerator(name, this);
    }

    public SectorPreset(String name) {
        this(name, null);
    }

    public void initialize(Planet planet, int sector) {
        this.planet = planet;
        this.sector = planet.sectors.get(sector %= planet.sectors.size);
        this.inlineDescription = false;
        planet.preset(sector, this);
    }

    @Override
    public void loadIcon() {
        if (Icon.terrain != null) {
            this.uiIcon = this.fullIcon = Icon.terrain.getRegion();
        }
    }

    @Override
    public boolean isHidden() {
        return this.description == null;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.sector;
    }
}

