/*
 * Decompiled with CFR 0.152.
 */
package mindustry.type;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.math.Rand;
import arc.struct.ObjectSet;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Effect;
import mindustry.gen.Puddle;
import mindustry.graphics.Drawf;
import mindustry.logic.LAccess;
import mindustry.logic.Senseable;
import mindustry.type.StatusEffect;
import mindustry.world.Tile;
import mindustry.world.meta.Attribute;
import mindustry.world.meta.Stat;

public class Liquid
extends UnlockableContent
implements Senseable {
    public static final int animationFrames = 50;
    public static float animationScaleGas = 190.0f;
    public static float animationScaleLiquid = 230.0f;
    protected static final Rand rand = new Rand();
    public boolean gas = false;
    public Color color;
    public Color gasColor = Color.lightGray.cpy();
    @Nullable
    public Color barColor;
    public Color lightColor = Color.clear.cpy();
    public float flammability;
    public float temperature = 0.5f;
    public float heatCapacity = 0.5f;
    public float viscosity = 0.5f;
    public float explosiveness;
    public boolean blockReactive = true;
    public boolean coolant = true;
    public boolean moveThroughBlocks = false;
    public boolean incinerable = true;
    public StatusEffect effect = StatusEffects.none;
    public Effect particleEffect = Fx.none;
    public float particleSpacing = 60.0f;
    public float boilPoint = 2.0f;
    public boolean capPuddles = true;
    public Effect vaporEffect = Fx.vapor;
    public boolean hidden;
    public ObjectSet<Liquid> canStayOn = new ObjectSet();

    public Liquid(String name, Color color) {
        super(name);
        this.color = new Color(color);
    }

    public Liquid(String name) {
        this(name, new Color(Color.black));
    }

    @Override
    public void init() {
        super.init();
        if (this.gas) {
            this.coolant = false;
            this.boilPoint = -1.0f;
            this.color = this.color.cpy();
            this.color.a = 0.6f;
            this.gasColor = this.color;
            if (this.barColor == null) {
                this.barColor = this.color.cpy().a(1.0f);
            }
        }
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public int getAnimationFrame() {
        return (int)(Time.time / (this.gas ? animationScaleGas : animationScaleLiquid) * 50.0f + (float)(this.id * 5)) % 50;
    }

    public boolean willBoil() {
        return Attribute.heat.env() >= this.boilPoint;
    }

    public boolean canExtinguish() {
        return this.flammability < 0.1f && this.temperature <= 0.5f;
    }

    public Color barColor() {
        return this.barColor == null ? this.color : this.barColor;
    }

    public void drawPuddle(Puddle puddle) {
        float amount = puddle.amount;
        float x = puddle.x;
        float y = puddle.y;
        float f = Mathf.clamp(amount / 46.666668f);
        float smag = puddle.tile.floor().isLiquid ? 0.8f : 0.0f;
        float sscl = 25.0f;
        Draw.color(Tmp.c1.set(this.color).shiftValue(-0.05f));
        Fill.circle(x + Mathf.sin(Time.time + (float)(this.id * 532), sscl, smag), y + Mathf.sin(Time.time + (float)(this.id * 53), sscl, smag), f * 8.0f);
        float length = f * 6.0f;
        rand.setSeed(this.id);
        for (int i = 0; i < 3; ++i) {
            Tmp.v1.trns(rand.random(360.0f), rand.random(length));
            float vx = x + Tmp.v1.x;
            float vy = y + Tmp.v1.y;
            Fill.circle(vx + Mathf.sin(Time.time + (float)(i * 532), sscl, smag), vy + Mathf.sin(Time.time + (float)(i * 53), sscl, smag), f * 5.0f);
        }
        Draw.color();
        if (this.lightColor.a > 0.001f && f > 0.0f) {
            Drawf.light(x, y, 30.0f * f, this.lightColor, this.color.a * f * 0.8f);
        }
    }

    public void update(Puddle puddle) {
    }

    public float react(Liquid other, float amount, Tile tile, float x, float y) {
        return 0.0f;
    }

    @Override
    public void setStats() {
        this.stats.addPercent(Stat.explosiveness, this.explosiveness);
        this.stats.addPercent(Stat.flammability, this.flammability);
        this.stats.addPercent(Stat.temperature, this.temperature);
        this.stats.addPercent(Stat.heatCapacity, this.heatCapacity);
        this.stats.addPercent(Stat.viscosity, this.viscosity);
    }

    @Override
    public double sense(LAccess sensor) {
        if (sensor == LAccess.color) {
            return this.color.toDoubleBits();
        }
        if (sensor == LAccess.id) {
            return this.getLogicId();
        }
        return Double.NaN;
    }

    @Override
    public Object senseObject(LAccess sensor) {
        if (sensor == LAccess.name) {
            return this.name;
        }
        return noSensed;
    }

    @Override
    public String toString() {
        return this.localizedName;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.liquid;
    }
}

