/*
 * Decompiled with CFR 0.152.
 */
package mindustry.net;

import arc.Core;
import arc.files.Fi;
import arc.func.Boolf;
import arc.func.Cons;
import arc.struct.ObjectMap;
import arc.util.Log;
import arc.util.OS;
import arc.util.Strings;
import arc.util.io.PropertiesUtils;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.mod.Mods;

public class CrashSender {
    public static String createReport(String error) {
        String report = "Mindustry has crashed. How unfortunate.\n";
        if (Vars.mods != null && Vars.mods.list().size == 0 && Version.build != -1) {
            report = report + "Report this at https://github.com/Anuken/Mindustry/issues/new?labels=bug&template=bug_report.md\n\n";
        }
        return report + "Version: " + Version.combined() + (Vars.headless ? " (Server)" : "") + "\nOS: " + OS.osName + " x" + OS.osArchBits + " (" + OS.osArch + ")\n" + ((OS.isAndroid || OS.isIos) && Core.app != null ? "Android API level: " + Core.app.getVersion() + "\n" : "") + "Java Version: " + OS.javaVersion + "\nRuntime Available Memory: " + Runtime.getRuntime().maxMemory() / 1024L / 1024L + "mb\nCores: " + Runtime.getRuntime().availableProcessors() + "\n" + (Vars.mods == null ? "<no mod init>" : "Mods: " + (!Vars.mods.list().contains((Mods.LoadedMod)((Object)((Boolf<Mods.LoadedMod>)Mods.LoadedMod::shouldBeEnabled))) ? "none (vanilla)" : Vars.mods.list().select(Mods.LoadedMod::shouldBeEnabled).toString(", ", mod -> mod.name + ":" + mod.meta.version))) + "\n\n" + error;
    }

    public static void log(Throwable exception) {
        try {
            Core.settings.getDataDirectory().child("crashes").child("crash_" + System.currentTimeMillis() + ".txt").writeString(CrashSender.createReport(Strings.neatError(exception)));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void send(Throwable exception, Cons<File> writeListener) {
        try {
            try {
                Log.err(exception);
            }
            catch (Throwable no) {
                exception.printStackTrace();
            }
            try {
                Core.settings.manualSave();
            }
            catch (Throwable no) {
                // empty catch block
            }
            if (OS.username.equals("anuke") && !"steam".equals(Version.modifier)) {
                CrashSender.ret();
            }
            if (Version.number == 0) {
                try {
                    ObjectMap<String, String> map = new ObjectMap<String, String>();
                    PropertiesUtils.load(map, new InputStreamReader(CrashSender.class.getResourceAsStream("/version.properties")));
                    Version.type = map.get("type");
                    Version.number = Integer.parseInt(map.get("number"));
                    Version.modifier = map.get("modifier");
                    if (map.get("build").contains(".")) {
                        String[] split = map.get("build").split("\\.");
                        Version.build = Integer.parseInt(split[0]);
                        Version.revision = Integer.parseInt(split[1]);
                    } else {
                        Version.build = Strings.canParseInt(map.get("build")) ? Integer.parseInt(map.get("build")) : -1;
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    Log.err("Failed to parse version.", new Object[0]);
                }
            }
            try {
                File file = new File(OS.getAppDataDirectoryString("Mindustry"), "crashes/crash-report-" + new SimpleDateFormat("MM_dd_yyyy_HH_mm_ss").format(new Date()) + ".txt");
                new Fi(OS.getAppDataDirectoryString("Mindustry")).child("crashes").mkdirs();
                new Fi(file).writeString(CrashSender.createReport(CrashSender.writeException(exception)));
                writeListener.get(file);
            }
            catch (Throwable e) {
                Log.err("Failed to save local crash report.", e);
            }
            try {
                Vars.net.dispose();
            }
            catch (Throwable e) {}
        }
        catch (Throwable death) {
            death.printStackTrace();
        }
        CrashSender.ret();
    }

    private static void ret() {
        System.exit(1);
    }

    private static String writeException(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }
}

