/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.planet;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.struct.FloatSeq;
import arc.struct.ObjectMap;
import arc.struct.ObjectSet;
import arc.struct.Seq;
import arc.util.Structs;
import arc.util.Tmp;
import arc.util.noise.Noise;
import arc.util.noise.Ridged;
import arc.util.noise.Simplex;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.ai.BaseRegistry;
import mindustry.content.Blocks;
import mindustry.content.Liquids;
import mindustry.game.Schematics;
import mindustry.game.Team;
import mindustry.game.Waves;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.maps.generators.BaseGenerator;
import mindustry.maps.generators.PlanetGenerator;
import mindustry.type.Sector;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.TileGen;
import mindustry.world.Tiles;
import mindustry.world.blocks.environment.Floor;

public class SerpuloPlanetGenerator
extends PlanetGenerator {
    public static boolean alt = false;
    BaseGenerator basegen = new BaseGenerator();
    float scl = 5.0f;
    float waterOffset = 0.07f;
    boolean genLakes = false;
    Block[][] arr = new Block[][]{{Blocks.water, Blocks.darksandWater, Blocks.darksand, Blocks.darksand, Blocks.darksand, Blocks.darksand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.darksandTaintedWater, Blocks.stone, Blocks.stone}, {Blocks.water, Blocks.darksandWater, Blocks.darksand, Blocks.darksand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.darksandTaintedWater, Blocks.stone, Blocks.stone, Blocks.stone}, {Blocks.water, Blocks.darksandWater, Blocks.darksand, Blocks.sand, Blocks.salt, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.darksandTaintedWater, Blocks.stone, Blocks.stone, Blocks.stone}, {Blocks.water, Blocks.sandWater, Blocks.sand, Blocks.salt, Blocks.salt, Blocks.salt, Blocks.sand, Blocks.stone, Blocks.stone, Blocks.stone, Blocks.snow, Blocks.iceSnow, Blocks.ice}, {Blocks.deepwater, Blocks.water, Blocks.sandWater, Blocks.sand, Blocks.salt, Blocks.sand, Blocks.sand, Blocks.basalt, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.ice}, {Blocks.deepwater, Blocks.water, Blocks.sandWater, Blocks.sand, Blocks.sand, Blocks.sand, Blocks.moss, Blocks.iceSnow, Blocks.snow, Blocks.snow, Blocks.ice, Blocks.snow, Blocks.ice}, {Blocks.deepwater, Blocks.sandWater, Blocks.sand, Blocks.sand, Blocks.moss, Blocks.moss, Blocks.snow, Blocks.basalt, Blocks.basalt, Blocks.basalt, Blocks.ice, Blocks.snow, Blocks.ice}, {Blocks.deepTaintedWater, Blocks.darksandTaintedWater, Blocks.darksand, Blocks.darksand, Blocks.basalt, Blocks.moss, Blocks.basalt, Blocks.hotrock, Blocks.basalt, Blocks.ice, Blocks.snow, Blocks.ice, Blocks.ice}, {Blocks.darksandWater, Blocks.darksand, Blocks.darksand, Blocks.darksand, Blocks.moss, Blocks.sporeMoss, Blocks.snow, Blocks.basalt, Blocks.basalt, Blocks.ice, Blocks.snow, Blocks.ice, Blocks.ice}, {Blocks.darksandWater, Blocks.darksand, Blocks.darksand, Blocks.sporeMoss, Blocks.ice, Blocks.ice, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.ice, Blocks.ice, Blocks.ice}, {Blocks.deepTaintedWater, Blocks.darksandTaintedWater, Blocks.darksand, Blocks.sporeMoss, Blocks.sporeMoss, Blocks.ice, Blocks.ice, Blocks.snow, Blocks.snow, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice}, {Blocks.taintedWater, Blocks.darksandTaintedWater, Blocks.darksand, Blocks.sporeMoss, Blocks.moss, Blocks.sporeMoss, Blocks.iceSnow, Blocks.snow, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice}, {Blocks.darksandWater, Blocks.darksand, Blocks.snow, Blocks.ice, Blocks.iceSnow, Blocks.snow, Blocks.snow, Blocks.snow, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice, Blocks.ice}};
    ObjectMap<Block, Block> dec = ObjectMap.of(Blocks.sporeMoss, Blocks.sporeCluster, Blocks.moss, Blocks.sporeCluster, Blocks.taintedWater, Blocks.water, Blocks.darksandTaintedWater, Blocks.darksandWater);
    ObjectMap<Block, Block> tars = ObjectMap.of(Blocks.sporeMoss, Blocks.shale, Blocks.moss, Blocks.shale);
    float water = 2.0f / (float)this.arr[0].length;

    float rawHeight(Vec3 position) {
        position = Tmp.v33.set(position).scl(this.scl);
        return (Mathf.pow(Simplex.noise3d(this.seed, 7.0, 0.5, 0.3333333432674408, position.x, position.y, position.z), 2.3f) + this.waterOffset) / (1.0f + this.waterOffset);
    }

    @Override
    public void generateSector(Sector sector) {
        if (sector.id == 154 || sector.id == 0) {
            sector.generateEnemyBase = true;
            return;
        }
        PlanetGrid.Ptile tile = sector.tile;
        boolean any = false;
        float poles = Math.abs(tile.v.y);
        float noise = Noise.snoise3(tile.v.x, tile.v.y, tile.v.z, 0.001f, 0.58f);
        if ((double)noise + (double)poles / 7.1 > 0.12 && (double)poles > 0.23) {
            any = true;
        }
        if ((double)noise < 0.16) {
            for (PlanetGrid.Ptile other : tile.tiles) {
                Sector osec = sector.planet.getSector(other);
                if (!(osec.id == sector.planet.startSector || osec.generateEnemyBase && (double)poles < 0.85) && (sector.preset == null || !((double)noise < 0.11))) continue;
                return;
            }
        }
        sector.generateEnemyBase = any;
    }

    @Override
    public float getHeight(Vec3 position) {
        float height = this.rawHeight(position);
        return Math.max(height, this.water);
    }

    @Override
    public Color getColor(Vec3 position) {
        Block block = this.getBlock(position);
        if (block == Blocks.salt) {
            return Blocks.sand.mapColor;
        }
        return Tmp.c1.set(block.mapColor).a(1.0f - block.albedo);
    }

    @Override
    public void genTile(Vec3 position, TileGen tile) {
        tile.floor = this.getBlock(position);
        tile.block = tile.floor.asFloor().wall;
        if ((double)Ridged.noise3d(this.seed + 1, position.x, position.y, position.z, 2, 22.0f) > 0.31) {
            tile.block = Blocks.air;
        }
    }

    Block getBlock(Vec3 position) {
        float height = this.rawHeight(position);
        Tmp.v31.set(position);
        position = Tmp.v33.set(position).scl(this.scl);
        float rad = this.scl;
        float temp = Mathf.clamp(Math.abs(position.y * 2.0f) / rad);
        float tnoise = Simplex.noise3d(this.seed, 7.0, 0.56, 0.3333333432674408, position.x, position.y + 999.0f, position.z);
        temp = Mathf.lerp(temp, tnoise, 0.5f);
        height *= 1.2f;
        height = Mathf.clamp(height);
        float tar = Simplex.noise3d(this.seed, 4.0, 0.55f, 0.5, position.x, position.y + 999.0f, position.z) * 0.3f + Tmp.v31.dst(0.0f, 0.0f, 1.0f) * 0.2f;
        Block res = this.arr[Mathf.clamp((int)(temp * (float)this.arr.length), 0, this.arr[0].length - 1)][Mathf.clamp((int)(height * (float)this.arr[0].length), 0, this.arr[0].length - 1)];
        if (tar > 0.5f) {
            return this.tars.get(res, res);
        }
        return res;
    }

    @Override
    protected float noise(float x, float y, double octaves, double falloff, double scl, double mag) {
        Vec3 v = this.sector.rect.project(x, y).scl(5.0f);
        return Simplex.noise3d(this.seed, octaves, falloff, 1.0 / scl, v.x, v.y, v.z) * (float)mag;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void generate() {
        class Room {
            int x;
            int y;
            int radius;
            ObjectSet<Room> connected = new ObjectSet();

            Room(int x, int y, int radius) {
                this.x = x;
                this.y = y;
                this.radius = radius;
                this.connected.add(this);
            }

            void join(int x1, int y1, int x2, int y2) {
                float nscl = SerpuloPlanetGenerator.this.rand.random(100.0f, 140.0f) * 6.0f;
                int stroke = SerpuloPlanetGenerator.this.rand.random(3, 9);
                SerpuloPlanetGenerator.this.brush(SerpuloPlanetGenerator.this.pathfind(x1, y1, x2, y2, tile -> (tile.solid() ? 50.0f : 0.0f) + SerpuloPlanetGenerator.this.noise(tile.x, tile.y, 2.0, 0.4f, 1.0f / nscl) * 500.0f, Astar.manhattan), stroke);
            }

            void connect(Room to) {
                if (!this.connected.add(to) || to == this) {
                    return;
                }
                Vec2 midpoint = Tmp.v1.set(to.x, to.y).add(this.x, (float)this.y).scl(0.5f);
                SerpuloPlanetGenerator.this.rand.nextFloat();
                if (alt) {
                    midpoint.add(Tmp.v2.set(1.0f, 0.0f).setAngle(Angles.angle(to.x, to.y, this.x, this.y) + 90.0f * (SerpuloPlanetGenerator.this.rand.chance(0.5) ? 1.0f : -1.0f)).scl(Tmp.v1.dst(this.x, this.y) * 2.0f));
                } else {
                    midpoint.add(Tmp.v2.setToRandomDirection(SerpuloPlanetGenerator.this.rand).scl(Tmp.v1.dst(this.x, this.y)));
                }
                midpoint.sub((float)SerpuloPlanetGenerator.this.width / 2.0f, (float)SerpuloPlanetGenerator.this.height / 2.0f).limit((float)SerpuloPlanetGenerator.this.width / 2.0f / Mathf.sqrt3).add((float)SerpuloPlanetGenerator.this.width / 2.0f, (float)SerpuloPlanetGenerator.this.height / 2.0f);
                int mx = (int)midpoint.x;
                int my = (int)midpoint.y;
                this.join(this.x, this.y, mx, my);
                this.join(mx, my, to.x, to.y);
            }

            void joinLiquid(int x1, int y1, int x2, int y2) {
                float nscl = SerpuloPlanetGenerator.this.rand.random(100.0f, 140.0f) * 6.0f;
                int rad = SerpuloPlanetGenerator.this.rand.random(7, 11);
                int avoid = 2 + rad;
                Seq<Tile> path = SerpuloPlanetGenerator.this.pathfind(x1, y1, x2, y2, tile -> (tile.solid() || !tile.floor().isLiquid ? 70.0f : 0.0f) + SerpuloPlanetGenerator.this.noise(tile.x, tile.y, 2.0, 0.4f, 1.0f / nscl) * 500.0f, Astar.manhattan);
                path.each(t -> {
                    if (Mathf.dst2(t.x, t.y, x2, y2) <= (float)(avoid * avoid)) {
                        return;
                    }
                    for (int x = -rad; x <= rad; ++x) {
                        for (int y = -rad; y <= rad; ++y) {
                            int wx = t.x + x;
                            int wy = t.y + y;
                            if (!Structs.inBounds(wx, wy, SerpuloPlanetGenerator.this.width, SerpuloPlanetGenerator.this.height) || !Mathf.within(x, y, rad)) continue;
                            Tile other = SerpuloPlanetGenerator.this.tiles.getn(wx, wy);
                            other.setBlock(Blocks.air);
                            if (!Mathf.within(x, y, rad - 1) || other.floor().isLiquid) continue;
                            Floor floor = other.floor();
                            other.setFloor((Floor)(floor == Blocks.sand || floor == Blocks.salt ? Blocks.sandWater : Blocks.darksandTaintedWater));
                        }
                    }
                });
            }

            void connectLiquid(Room to) {
                if (to == this) {
                    return;
                }
                Vec2 midpoint = Tmp.v1.set(to.x, to.y).add(this.x, (float)this.y).scl(0.5f);
                SerpuloPlanetGenerator.this.rand.nextFloat();
                midpoint.add(Tmp.v2.setToRandomDirection(SerpuloPlanetGenerator.this.rand).scl(Tmp.v1.dst(this.x, this.y)));
                midpoint.sub((float)SerpuloPlanetGenerator.this.width / 2.0f, (float)SerpuloPlanetGenerator.this.height / 2.0f).limit((float)SerpuloPlanetGenerator.this.width / 2.0f / Mathf.sqrt3).add((float)SerpuloPlanetGenerator.this.width / 2.0f, (float)SerpuloPlanetGenerator.this.height / 2.0f);
                int mx = (int)midpoint.x;
                int my = (int)midpoint.y;
                this.joinLiquid(this.x, this.y, mx, my);
                this.joinLiquid(mx, my, to.x, to.y);
            }
        }
        boolean naval;
        void var13_22;
        this.cells(4);
        this.distort(10.0f, 12.0f);
        float constraint = 1.3f;
        float radius = (float)this.width / 2.0f / Mathf.sqrt3;
        int rooms = this.rand.random(2, 5);
        Seq<Object> roomseq = new Seq<Object>();
        for (int i = 0; i < rooms; ++i) {
            Tmp.v1.trns(this.rand.random(360.0f), this.rand.random(radius / constraint));
            float rx = (float)this.width / 2.0f + Tmp.v1.x;
            float ry = (float)this.height / 2.0f + Tmp.v1.y;
            float maxrad = radius - Tmp.v1.len();
            float rrad = Math.min(this.rand.random(9.0f, maxrad / 2.0f), 30.0f);
            roomseq.add(new Room((int)rx, (int)ry, (int)rrad));
        }
        Room spawn = null;
        Seq<Room> enemies = new Seq<Room>();
        int enemySpawns = this.rand.random(1, Math.max((int)(this.sector.threat * 4.0f), 1));
        int offset = this.rand.nextInt(360);
        float length = (float)this.width / 2.55f - (float)this.rand.random(13, 23);
        int angleStep = 5;
        int waterCheckRad = 5;
        for (int i = 0; i < 360; i += angleStep) {
            int n = offset + i;
            int n2 = (int)((float)(this.width / 2) + Angles.trnsx(n, length));
            int cy2 = (int)((float)(this.height / 2) + Angles.trnsy(n, length));
            int waterTiles = 0;
            for (int rx = -waterCheckRad; rx <= waterCheckRad; ++rx) {
                for (int ry = -waterCheckRad; ry <= waterCheckRad; ++ry) {
                    Tile tile = this.tiles.get(n2 + rx, cy2 + ry);
                    if (tile != null && tile.floor().liquidDrop == null) continue;
                    ++waterTiles;
                }
            }
            if (waterTiles > 4 && i + angleStep < 360) continue;
            spawn = new Room(n2, cy2, this.rand.random(8, 15));
            roomseq.add(spawn);
            for (int j = 0; j < enemySpawns; ++j) {
                float enemyOffset = this.rand.range(60.0f);
                Tmp.v1.set(n2 - this.width / 2, cy2 - this.height / 2).rotate(180.0f + enemyOffset).add(this.width / 2, (float)(this.height / 2));
                Room espawn = new Room((int)Tmp.v1.x, (int)Tmp.v1.y, this.rand.random(8, 16));
                roomseq.add(espawn);
                enemies.add(espawn);
            }
            break;
        }
        for (Room room : roomseq) {
            this.erase(room.x, room.y, room.radius);
        }
        int connections = this.rand.random(Math.max(rooms - 1, 1), rooms + 3);
        boolean bl = false;
        while (var13_22 < connections) {
            ((Room)((Object)roomseq.random((Object)this.rand))).connect((Room)((Object)roomseq.random((Object)this.rand)));
            ++var13_22;
        }
        for (Room room : roomseq) {
            spawn.connect(room);
        }
        Room room = spawn;
        this.cells(1);
        int n = this.tiles.width * this.tiles.height;
        int total = 0;
        int waters = 0;
        for (int i = 0; i < n; ++i) {
            Tile tile = this.tiles.geti(i);
            if (tile.block() != Blocks.air) continue;
            ++total;
            if (tile.floor().liquidDrop != Liquids.water) continue;
            ++waters;
        }
        boolean bl2 = naval = (float)waters / (float)total >= 0.19f;
        if (naval) {
            for (Room room2 : enemies) {
                room2.connectLiquid(spawn);
            }
        }
        this.distort(10.0f, 6.0f);
        this.pass((x, y) -> {
            if (this.block.solid) {
                return;
            }
            Vec3 v = this.sector.rect.project(x, y);
            float rr = Simplex.noise2d(this.sector.id, 2.0, 0.6f, 0.1428571492433548, x, y) * 0.1f;
            float value = Ridged.noise3d(2, v.x, v.y, v.z, 1, 0.018181818f) + rr - this.rawHeight(v) * 0.0f;
            float rrscl = rr * 44.0f - 2.0f;
            if (value > 0.17f && !Mathf.within(x, y, fspawn.x, fspawn.y, 12.0f + rrscl)) {
                boolean spore;
                boolean deep = value > 0.27f && !Mathf.within(x, y, fspawn.x, fspawn.y, 15.0f + rrscl);
                boolean bl = spore = this.floor != Blocks.sand && this.floor != Blocks.salt;
                if (this.floor != Blocks.ice && this.floor != Blocks.iceSnow && this.floor != Blocks.snow && !this.floor.asFloor().isLiquid) {
                    this.floor = spore ? (deep ? Blocks.taintedWater : Blocks.darksandTaintedWater) : (deep ? Blocks.water : (this.floor == Blocks.sand || this.floor == Blocks.salt ? Blocks.sandWater : Blocks.darksandWater));
                }
            }
        });
        this.pass((x, y) -> {
            int deepRadius = 3;
            if (this.floor.asFloor().isLiquid && this.floor.asFloor().shallow) {
                for (int cx = -deepRadius; cx <= deepRadius; ++cx) {
                    for (int cy = -deepRadius; cy <= deepRadius; ++cy) {
                        int wy;
                        int wx;
                        Tile tile;
                        if (cx * cx + cy * cy > deepRadius * deepRadius || (tile = this.tiles.get(wx = cx + x, wy = cy + y)) == null || tile.floor().isLiquid && tile.block() == Blocks.air) continue;
                        return;
                    }
                }
                this.floor = this.floor == Blocks.darksandTaintedWater ? Blocks.taintedWater : Blocks.water;
            }
        });
        if (naval) {
            int deepRadius = 2;
            this.pass((x, y) -> {
                if (this.floor.asFloor().isLiquid && !this.floor.asFloor().isDeep() && !this.floor.asFloor().shallow) {
                    for (int cx = -deepRadius; cx <= deepRadius; ++cx) {
                        for (int cy = -deepRadius; cy <= deepRadius; ++cy) {
                            int wy;
                            int wx;
                            Tile tile;
                            if (cx * cx + cy * cy > deepRadius * deepRadius || (tile = this.tiles.get(wx = cx + x, wy = cy + y)) == null || !tile.floor().shallow && tile.floor().isLiquid) continue;
                            return;
                        }
                    }
                    this.floor = this.floor == Blocks.water ? Blocks.deepwater : Blocks.taintedWater;
                }
            });
        }
        Seq<Block> ores = Seq.with(Blocks.oreCopper, Blocks.oreLead);
        float poles = Math.abs(this.sector.tile.v.y);
        float nmag = 0.5f;
        float scl = 1.0f;
        float addscl = 1.3f;
        if (Simplex.noise3d(this.seed, 2.0, 0.5, scl, this.sector.tile.v.x, this.sector.tile.v.y, this.sector.tile.v.z) * nmag + poles > 0.25f * addscl) {
            ores.add(Blocks.oreCoal);
        }
        if (Simplex.noise3d(this.seed, 2.0, 0.5, scl, this.sector.tile.v.x + 1.0f, this.sector.tile.v.y, this.sector.tile.v.z) * nmag + poles > 0.5f * addscl) {
            ores.add(Blocks.oreTitanium);
        }
        if (Simplex.noise3d(this.seed, 2.0, 0.5, scl, this.sector.tile.v.x + 2.0f, this.sector.tile.v.y, this.sector.tile.v.z) * nmag + poles > 0.7f * addscl) {
            ores.add(Blocks.oreThorium);
        }
        if (this.rand.chance(0.25)) {
            ores.add(Blocks.oreScrap);
        }
        FloatSeq frequencies = new FloatSeq();
        for (int i = 0; i < ores.size; ++i) {
            frequencies.add(this.rand.random(-0.1f, 0.01f) - (float)i * 0.01f + poles * 0.04f);
        }
        this.pass((x, y) -> {
            if (!this.floor.asFloor().hasSurface()) {
                return;
            }
            int offsetX = x - 4;
            int offsetY = y + 23;
            for (int i = ores.size - 1; i >= 0; --i) {
                Block entry = (Block)ores.get(i);
                float freq = frequencies.get(i);
                if (!((double)Math.abs(0.5f - this.noise(offsetX, offsetY + i * 999, 2.0, 0.7, 40 + i * 2)) > (double)0.22f + (double)i * 0.01) || !(Math.abs(0.5f - this.noise(offsetX, offsetY - i * 999, 1.0, 1.0, 30 + i * 4)) > 0.37f + freq)) continue;
                this.ore = entry;
                break;
            }
            if (this.ore == Blocks.oreScrap && this.rand.chance(0.33)) {
                this.floor = Blocks.metalFloorDamaged;
            }
        });
        this.trimDark();
        this.median(2);
        this.inverseFloodFill(this.tiles.getn(spawn.x, spawn.y));
        this.tech();
        this.pass((x, y) -> {
            block18: {
                float noise;
                if (this.floor == Blocks.sporeMoss && (double)Math.abs(0.5f - this.noise(x - 90, y, 4.0, 0.8, 65.0)) > 0.02) {
                    this.floor = Blocks.moss;
                }
                if (this.floor == Blocks.darksand && Math.abs(0.5f - this.noise(x - 40, y, 2.0, 0.7, 80.0)) > 0.25f && Math.abs(0.5f - this.noise(x, y + this.sector.id * 10, 1.0, 1.0, 60.0)) > 0.41f && !roomseq.contains(r -> Mathf.within(x, y, r.x, r.y, 30.0f))) {
                    this.floor = Blocks.tar;
                }
                if (this.floor == Blocks.hotrock) {
                    if ((double)Math.abs(0.5f - this.noise(x - 90, y, 4.0, 0.8, 80.0)) > 0.035) {
                        this.floor = Blocks.basalt;
                    } else {
                        this.ore = Blocks.air;
                        boolean all = true;
                        for (Point2 p : Geometry.d4) {
                            Tile other = this.tiles.get(x + p.x, y + p.y);
                            if (other != null && (other.floor() == Blocks.hotrock || other.floor() == Blocks.magmarock)) continue;
                            all = false;
                        }
                        if (all) {
                            this.floor = Blocks.magmarock;
                        }
                    }
                } else if (this.genLakes && this.floor != Blocks.basalt && this.floor != Blocks.ice && this.floor.asFloor().hasSurface() && (noise = this.noise(x + 782, y, 5.0, 0.75, 260.0, 1.0)) > 0.67f && !roomseq.contains(e -> Mathf.within(x, y, e.x, e.y, 14.0f))) {
                    if (noise > 0.72f) {
                        this.floor = noise > 0.78f ? Blocks.taintedWater : (this.floor == Blocks.sand ? Blocks.sandWater : Blocks.darksandTaintedWater);
                    } else {
                        Block block = this.floor = this.floor == Blocks.sand ? this.floor : Blocks.darksand;
                    }
                }
                if (this.rand.chance(0.0075)) {
                    boolean any = false;
                    boolean all = true;
                    for (Point2 p : Geometry.d4) {
                        Tile other = this.tiles.get(x + p.x, y + p.y);
                        if (other != null && other.block() == Blocks.air) {
                            any = true;
                            continue;
                        }
                        all = false;
                    }
                    if (any && (this.block == Blocks.snowWall || this.block == Blocks.iceWall || all && this.block == Blocks.air && this.floor == Blocks.snow && this.rand.chance(0.03))) {
                        this.block = this.rand.chance(0.5) ? Blocks.whiteTree : Blocks.whiteTreeDead;
                    }
                }
                for (int i = 0; i < 4; ++i) {
                    Tile near = Vars.world.tile(x + Geometry.d4[i].x, y + Geometry.d4[i].y);
                    if (near == null || near.block() == Blocks.air) {
                        continue;
                    }
                    break block18;
                }
                if (this.rand.chance(0.01) && this.floor.asFloor().hasSurface() && this.block == Blocks.air) {
                    this.block = this.dec.get(this.floor, this.floor.asFloor().decoration);
                }
            }
        });
        float difficulty = this.sector.threat;
        this.ints.clear();
        this.ints.ensureCapacity(this.width * this.height / 4);
        int ruinCount = this.rand.random(-2, 4);
        if (ruinCount > 0) {
            int padding;
            for (int x2 = padding = 25; x2 < this.width - padding; ++x2) {
                for (int y2 = padding; y2 < this.height - padding; ++y2) {
                    Tile tile = this.tiles.getn(x2, y2);
                    if (tile.solid() || tile.drop() == null && tile.floor().liquidDrop == null) continue;
                    this.ints.add(tile.pos());
                }
            }
            this.ints.shuffle(this.rand);
            int placed = 0;
            float diffRange = 0.4f;
            for (int i = 0; i < this.ints.size && placed < ruinCount; ++i) {
                short y3;
                int val = this.ints.items[i];
                short x3 = Point2.x(val);
                if (Mathf.within(x3, y3 = Point2.y(val), spawn.x, spawn.y, 18.0f)) continue;
                float range = difficulty + this.rand.random(diffRange);
                Tile tile = this.tiles.getn(x3, y3);
                BaseRegistry.BasePart part = null;
                if (tile.overlay().itemDrop != null) {
                    part = Vars.bases.forResource(tile.drop()).getFrac(range);
                } else if (tile.floor().liquidDrop != null && this.rand.chance(0.05)) {
                    part = Vars.bases.forResource(tile.floor().liquidDrop).getFrac(range);
                } else if (this.rand.chance(0.05)) {
                    part = Vars.bases.parts.getFrac(range);
                }
                if (part == null || !BaseGenerator.tryPlace(part, x3, y3, Team.derelict, (cx, cy) -> {
                    Tile other = this.tiles.getn(cx, cy);
                    if (other.floor().hasSurface()) {
                        other.setOverlay(Blocks.oreScrap);
                        for (int j = 1; j <= 2; ++j) {
                            for (Point2 p : Geometry.d8) {
                                Tile t = this.tiles.get(cx + p.x * j, cy + p.y * j);
                                if (t == null || !t.floor().hasSurface() || !this.rand.chance(j == 1 ? 0.4 : 0.2)) continue;
                                t.setOverlay(Blocks.oreScrap);
                            }
                        }
                    }
                })) continue;
                ++placed;
                int debrisRadius = Math.max(part.schematic.width, part.schematic.height) / 2 + 3;
                Geometry.circle(x3, y3, this.tiles.width, this.tiles.height, debrisRadius, (cx, cy) -> {
                    float dst = Mathf.dst(cx, cy, x3, y3);
                    float removeChance = Mathf.lerp(0.05f, 0.5f, dst / (float)debrisRadius);
                    Tile other = this.tiles.getn(cx, cy);
                    if (other.build != null && other.isCenter()) {
                        if (other.team() == Team.derelict && this.rand.chance(removeChance)) {
                            other.remove();
                        } else if (this.rand.chance(0.5)) {
                            other.build.health -= this.rand.random(other.build.health * 0.9f);
                        }
                    }
                });
            }
        }
        for (Tile tile : this.tiles) {
            if (!tile.overlay().needsSurface || tile.floor().hasSurface()) continue;
            tile.setOverlay(Blocks.air);
        }
        Schematics.placeLaunchLoadout(spawn.x, spawn.y);
        for (Room espawn : enemies) {
            this.tiles.getn(espawn.x, espawn.y).setOverlay(Blocks.spawn);
        }
        if (this.sector.hasEnemyBase()) {
            this.basegen.generate(this.tiles, enemies.map(r -> this.tiles.getn(r.x, r.y)), this.tiles.get(spawn.x, spawn.y), Vars.state.rules.waveTeam, this.sector, difficulty);
            this.sector.info.attack = true;
            Vars.state.rules.attackMode = true;
        } else {
            Vars.state.rules.winWave = this.sector.info.winWave = 10 + 5 * (int)Math.max(difficulty * 10.0f, 1.0f);
        }
        float waveTimeDec = 0.4f;
        Vars.state.rules.waveSpacing = Mathf.lerp(7800.0f, 3600.0f, Math.max(difficulty - waveTimeDec, 0.0f));
        Vars.state.rules.waves = true;
        Vars.state.rules.env = this.sector.planet.defaultEnv;
        Vars.state.rules.enemyCoreBuildRadius = 600.0f;
        Vars.state.rules.spawns = Waves.generate(difficulty, new Rand(this.sector.id), Vars.state.rules.attackMode, Vars.state.rules.attackMode && Vars.spawner.countGroundSpawns() == 0, naval);
    }

    @Override
    public void postGenerate(Tiles tiles) {
        if (this.sector.hasEnemyBase()) {
            this.basegen.postGenerate();
            if (Vars.spawner.countGroundSpawns() == 0) {
                Vars.state.rules.spawns = Waves.generate(this.sector.threat, new Rand(this.sector.id), Vars.state.rules.attackMode, true, false);
            }
        }
    }
}

