/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.generators;

import arc.files.Fi;
import arc.math.geom.Geometry;
import java.util.Objects;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.game.Schematics;
import mindustry.io.SaveIO;
import mindustry.maps.Map;
import mindustry.maps.generators.WorldGenerator;
import mindustry.type.Sector;
import mindustry.type.SectorPreset;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.WorldContext;
import mindustry.world.blocks.storage.CoreBlock;

public class FileMapGenerator
implements WorldGenerator {
    public final Map map;
    public final SectorPreset preset;

    public FileMapGenerator(String mapName, SectorPreset preset) {
        this.map = Vars.maps != null ? Vars.maps.loadInternalMap(preset.minfo.mod == null || Vars.tree.get("maps/" + mapName + "." + "msav").exists() ? mapName : mapName.substring(1 + preset.minfo.mod.name.length())) : null;
        this.preset = preset;
    }

    public FileMapGenerator(Map map, SectorPreset preset) {
        this.map = map;
        this.preset = preset;
    }

    public FileMapGenerator(SectorPreset preset) {
        this(Vars.emptyMap, preset);
    }

    @Override
    public void generate(Tiles tiles) {
        if (this.map == null) {
            throw new RuntimeException("Generator has null map, cannot be used.");
        }
        final Sector sector = Vars.state.rules.sector;
        Vars.world.setGenerating(false);
        Fi fi = this.map.file;
        World world = Vars.world;
        Objects.requireNonNull(world);
        SaveIO.load(fi, (WorldContext)new World.FilterContext(world, this.map){
            {
                World world = x0;
                Objects.requireNonNull(world);
                super(map);
            }

            @Override
            public Sector getSector() {
                return sector;
            }

            @Override
            public void end() {
                this.applyFilters();
            }

            @Override
            public boolean isMap() {
                return true;
            }
        });
        Vars.world.setGenerating(true);
        if (sector != null) {
            Vars.state.rules.sector = sector;
        }
        tiles = Vars.world.tiles;
        boolean anyCores = false;
        for (Tile tile : tiles) {
            if (tile.overlay() == Blocks.spawn) {
                int rad = 10;
                Geometry.circle(tile.x, tile.y, tiles.width, tiles.height, rad, (wx, wy) -> {
                    if (tile.overlay().itemDrop != null) {
                        tile.clearOverlay();
                    }
                });
            }
            if (!tile.isCenter() || !(tile.block() instanceof CoreBlock) || tile.team() != Vars.state.rules.defaultTeam || anyCores) continue;
            if (Vars.state.rules.sector != null && Vars.state.rules.sector.allowLaunchLoadout()) {
                Schematics.placeLaunchLoadout(tile.x, tile.y);
            }
            anyCores = true;
            if (!this.preset.addStartingItems && this.preset.planet.allowLaunchLoadout) continue;
            tile.build.items.clear();
            tile.build.items.add(Vars.state.rules.loadout);
        }
        if (!anyCores) {
            throw new IllegalArgumentException("All maps must have a core.");
        }
        Vars.state.map = this.map;
    }
}

