/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps.generators;

import arc.func.Boolf;
import arc.func.Intc2;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.GridBits;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.struct.ShortSeq;
import arc.util.Nullable;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.content.Blocks;
import mindustry.content.Loadouts;
import mindustry.game.Schematic;
import mindustry.maps.generators.WorldGenerator;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.blocks.environment.Floor;

public abstract class BasicGenerator
implements WorldGenerator {
    protected static final ShortSeq ints1 = new ShortSeq();
    protected static final ShortSeq ints2 = new ShortSeq();
    protected Rand rand = new Rand();
    protected int width;
    protected int height;
    @Nullable
    protected Tiles tiles;
    @Nullable
    protected Block floor;
    @Nullable
    protected Block block;
    @Nullable
    protected Block ore;
    public Schematic defaultLoadout = Loadouts.basicShard;

    @Override
    public void generate(Tiles tiles) {
        this.tiles = tiles;
        this.width = tiles.width;
        this.height = tiles.height;
        this.generate();
    }

    protected void generate() {
    }

    public void median(int radius) {
        this.median(radius, 0.5);
    }

    public void median(int radius, double percentile) {
        this.median(radius, percentile, null);
    }

    public void median(int radius, double percentile, @Nullable Block targetFloor) {
        short[] blocks = new short[this.tiles.width * this.tiles.height];
        short[] floors = new short[blocks.length];
        this.tiles.each((x, y) -> {
            if (targetFloor != null && this.tiles.getn(x, y).floor() != targetFloor) {
                return;
            }
            ints1.clear();
            ints2.clear();
            Geometry.circle(x, y, this.width, this.height, radius, (cx, cy) -> {
                ints1.add(this.tiles.getn(cx, cy).floorID());
                ints2.add(this.tiles.getn(cx, cy).blockID());
            });
            ints1.sort();
            ints2.sort();
            floors[x + y * this.width] = ints1.get(Mathf.clamp((int)((double)BasicGenerator.ints1.size * percentile), 0, BasicGenerator.ints1.size - 1));
            blocks[x + y * this.width] = ints2.get(Mathf.clamp((int)((double)BasicGenerator.ints2.size * percentile), 0, BasicGenerator.ints2.size - 1));
        });
        this.pass((x, y) -> {
            if (targetFloor != null && this.floor != targetFloor) {
                return;
            }
            this.block = Vars.content.block(blocks[x + y * this.width]);
            this.floor = Vars.content.block(floors[x + y * this.width]);
        });
    }

    public void ores(Seq<Block> ores) {
        this.pass((x, y) -> {
            if (!this.floor.asFloor().hasSurface()) {
                return;
            }
            int offsetX = x - 4;
            int offsetY = y + 23;
            for (int i = ores.size - 1; i >= 0; --i) {
                Block entry = (Block)ores.get(i);
                if (!(Math.abs(0.5f - this.noise(offsetX, offsetY + i * 999, 2.0, 0.7, 40 + i * 2)) > 0.26f) || !(Math.abs(0.5f - this.noise(offsetX, offsetY - i * 999, 1.0, 1.0, 30 + i * 4)) > 0.37f)) continue;
                this.ore = entry;
                break;
            }
        });
    }

    public void ore(Block dest, Block src, float i, float thresh) {
        this.pass((x, y) -> {
            if (this.floor != src) {
                return;
            }
            if (Math.abs(0.5f - this.noise(x, (float)y + i * 999.0f, 2.0, 0.7, 40.0f + i * 2.0f)) > 0.26f * thresh && Math.abs(0.5f - this.noise(x, (float)y - i * 999.0f, 1.0, 1.0, 30.0f + i * 4.0f)) > 0.37f * thresh) {
                this.ore = dest;
            }
        });
    }

    public void oreAround(Block ore, Block wall, int radius, float scl, float thresh) {
        for (Tile tile : this.tiles) {
            short x = tile.x;
            short y = tile.y;
            if (tile.block() != Blocks.air || !tile.floor().hasSurface() || !(this.noise(x, y + ore.id * 999, scl, 1.0) > thresh)) continue;
            boolean found = false;
            block1: for (int dx = x - radius; dx <= x + radius; ++dx) {
                for (int dy = y - radius; dy <= y + radius; ++dy) {
                    if (!Mathf.within(dx, dy, x, y, (float)radius + 0.001f) || !this.tiles.in(dx, dy) || this.tiles.get(dx, dy).block() != wall) continue;
                    found = true;
                    break block1;
                }
            }
            if (!found) continue;
            tile.setOverlay(ore);
        }
    }

    public void wallOre(Block src, Block dest, float scl, float thresh) {
        boolean overlay = dest.isOverlay();
        this.pass((x, y) -> {
            if (this.block != Blocks.air) {
                boolean empty = false;
                for (Point2 p : Geometry.d8) {
                    Tile other = this.tiles.get(x + p.x, y + p.y);
                    if (other == null || other.block() != Blocks.air) continue;
                    empty = true;
                    break;
                }
                if (empty && this.noise(x + 78, y, 4.0, (double)0.7f, (double)scl, 1.0) > thresh && this.block == src) {
                    if (overlay) {
                        this.ore = dest;
                    } else {
                        this.block = dest;
                    }
                }
            }
        });
    }

    public void cliffs() {
        for (Tile tile : this.tiles) {
            if (!tile.block().isStatic() || tile.block() == Blocks.cliff) continue;
            int rotation = 0;
            for (int i = 0; i < 8; ++i) {
                Tile other = Vars.world.tiles.get(tile.x + Geometry.d8[i].x, tile.y + Geometry.d8[i].y);
                if (other == null || other.block().isStatic()) continue;
                rotation |= 1 << i;
            }
            if (rotation != 0) {
                tile.setBlock(Blocks.cliff);
            }
            tile.data = (byte)rotation;
        }
        for (Tile tile : this.tiles) {
            if (tile.block() == Blocks.cliff || !tile.block().isStatic()) continue;
            tile.setBlock(Blocks.air);
        }
    }

    public void terrain(Block dst, float scl, float mag, float cmag) {
        this.pass((x, y) -> {
            double transition;
            double rocks = this.noise(x, y, 5.0, 0.5, scl) * mag + Mathf.dst((float)x / (float)this.width, (float)y / (float)this.height, 0.5f, 0.5f) * cmag;
            double edgeDist = Math.min(x, Math.min(y, Math.min(Math.abs(x - (this.width - 1)), Math.abs(y - (this.height - 1)))));
            if (edgeDist < (transition = 5.0)) {
                rocks += (transition - edgeDist) / transition / 1.5;
            }
            if (rocks > 0.9) {
                this.block = dst;
            }
        });
    }

    public void noise(Block floor, Block block, int octaves, float falloff, float scl, float threshold) {
        this.pass((x, y) -> {
            if (this.noise(octaves, falloff, scl, x, y) > threshold) {
                Tile tile = this.tiles.getn(x, y);
                this.floor = floor;
                if (tile.block().solid) {
                    this.block = block;
                }
            }
        });
    }

    public void overlay(Block floor, Block block, float chance, int octaves, float falloff, float scl, float threshold) {
        this.pass((x, y) -> {
            if (this.noise(x, y, octaves, falloff, scl) > threshold && Mathf.chance(chance) && this.tiles.getn(x, y).floor() == floor) {
                this.ore = block;
            }
        });
    }

    public void tech() {
        this.tech(Blocks.darkPanel3, Blocks.darkPanel4, Blocks.darkMetal);
    }

    public void tech(Block floor1, Block floor2, Block wall) {
        int secSize = 20;
        this.pass((x, y) -> {
            if (!this.floor.asFloor().hasSurface()) {
                return;
            }
            int mx = x % secSize;
            int my = y % secSize;
            int sclx = x / secSize;
            int scly = y / secSize;
            if (this.noise(sclx, scly, 0.2f, 1.0) > 0.63f && this.noise(sclx, scly + 999, 200.0, 1.0) > 0.6f && (mx == 0 || my == 0 || mx == secSize - 1 || my == secSize - 1)) {
                if (Mathf.chance(this.noise(x + 2299171, y, 40.0, 1.0))) {
                    this.floor = floor1;
                    if (Mathf.dst(mx, my, secSize / 2, secSize / 2) > (float)secSize / 2.0f + 2.0f) {
                        this.floor = floor2;
                    }
                }
                if (this.block.solid && Mathf.chance(0.7)) {
                    this.block = wall;
                }
            }
        });
    }

    public void distort(float scl, float mag) {
        short[] blocks = new short[this.tiles.width * this.tiles.height];
        short[] floors = new short[blocks.length];
        this.tiles.each((x, y) -> {
            int idx = y * this.tiles.width + x;
            float cx = (float)x + this.noise((float)x - 155.0f, (float)y - 200.0f, scl, mag) - mag / 2.0f;
            float cy = (float)y + this.noise((float)x + 155.0f, (float)y + 155.0f, scl, mag) - mag / 2.0f;
            Tile other = this.tiles.getn(Mathf.clamp((int)cx, 0, this.tiles.width - 1), Mathf.clamp((int)cy, 0, this.tiles.height - 1));
            blocks[idx] = other.block().id;
            floors[idx] = other.floor().id;
        });
        for (int i = 0; i < blocks.length; ++i) {
            Tile tile = this.tiles.geti(i);
            tile.setFloor(Vars.content.block(floors[i]).asFloor());
            tile.setBlock(Vars.content.block(blocks[i]));
        }
    }

    public void scatter(Block target, Block dst, float chance) {
        this.pass((x, y) -> {
            if (!Mathf.chance(chance)) {
                return;
            }
            if (this.floor == target) {
                this.floor = dst;
            } else if (this.block == target) {
                this.block = dst;
            }
        });
    }

    public void each(Intc2 r) {
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                r.get(x, y);
            }
        }
    }

    public void cells(int iterations) {
        this.cells(iterations, 16, 16, 3);
    }

    public void cells(int iterations, int birthLimit, int deathLimit, int cradius) {
        GridBits write = new GridBits(this.tiles.width, this.tiles.height);
        GridBits read = new GridBits(this.tiles.width, this.tiles.height);
        this.tiles.each((x, y) -> read.set(x, y, !this.tiles.get(x, y).block().isAir()));
        for (int i = 0; i < iterations; ++i) {
            this.tiles.each((x, y) -> {
                int alive = 0;
                for (int cx = -cradius; cx <= cradius; ++cx) {
                    for (int cy = -cradius; cy <= cradius; ++cy) {
                        if (cx == 0 && cy == 0 || !Mathf.within(cx, cy, cradius) || Structs.inBounds(x + cx, y + cy, this.tiles.width, this.tiles.height) && !read.get(x + cx, y + cy)) continue;
                        ++alive;
                    }
                }
                if (read.get(x, y)) {
                    write.set(x, y, alive >= deathLimit);
                } else {
                    write.set(x, y, alive > birthLimit);
                }
            });
            read.set(write);
        }
        for (Tile t : this.tiles) {
            t.setBlock(!read.get(t.x, t.y) ? Blocks.air : t.floor().wall);
        }
    }

    protected float noise(float x, float y, double scl, double mag) {
        return this.noise(x, y, 1.0, 1.0, scl, mag);
    }

    protected abstract float noise(float var1, float var2, double var3, double var5, double var7, double var9);

    protected float noise(float x, float y, double octaves, double falloff, double scl) {
        return this.noise(x, y, octaves, falloff, scl, 1.0);
    }

    public void pass(Intc2 r) {
        for (Tile tile : this.tiles) {
            this.floor = tile.floor();
            this.block = tile.block();
            this.ore = tile.overlay();
            r.get(tile.x, tile.y);
            tile.setFloor(this.floor.asFloor());
            tile.setBlock(this.block);
            tile.setOverlay(this.ore);
        }
    }

    public boolean nearWall(int x, int y) {
        for (Point2 p : Geometry.d8) {
            Tile other = this.tiles.get(x + p.x, y + p.y);
            if (other == null || other.block() == Blocks.air) continue;
            return true;
        }
        return false;
    }

    public boolean nearAir(int x, int y) {
        for (Point2 p : Geometry.d4) {
            Tile other = this.tiles.get(x + p.x, y + p.y);
            if (other == null || other.block() != Blocks.air) continue;
            return true;
        }
        return false;
    }

    public void removeWall(int cx, int cy, int rad, Boolf<Block> pred) {
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                Tile other;
                int wx = cx + x;
                int wy = cy + y;
                if (!Structs.inBounds(wx, wy, this.width, this.height) || !Mathf.within(x, y, rad) || !pred.get((other = this.tiles.getn(wx, wy)).block())) continue;
                other.setBlock(Blocks.air);
            }
        }
    }

    public boolean near(int cx, int cy, int rad, Block block) {
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                Tile other;
                int wx = cx + x;
                int wy = cy + y;
                if (!Structs.inBounds(wx, wy, this.width, this.height) || !Mathf.within(x, y, rad) || (other = this.tiles.getn(wx, wy)).block() != block) continue;
                return true;
            }
        }
        return false;
    }

    public void decoration(float chance) {
        this.pass((x, y) -> {
            for (int i = 0; i < 4; ++i) {
                Tile near = Vars.world.tile(x + Geometry.d4[i].x, y + Geometry.d4[i].y);
                if (near == null || near.block() == Blocks.air) continue;
                return;
            }
            if (this.rand.chance(chance) && this.floor.asFloor().hasSurface() && this.block == Blocks.air) {
                this.block = this.floor.asFloor().decoration;
            }
        });
    }

    public void blend(Block floor, Block around, float radius) {
        float r2 = radius * radius;
        int cap = Mathf.ceil(radius);
        int max = this.tiles.width * this.tiles.height;
        Floor dest = around.asFloor();
        for (int i = 0; i < max; ++i) {
            Tile tile = this.tiles.geti(i);
            if (tile.floor() != floor && tile.block() != floor) continue;
            for (int cx = -cap; cx <= cap; ++cx) {
                for (int cy = -cap; cy <= cap; ++cy) {
                    Tile other;
                    if (!((float)(cx * cx + cy * cy) <= r2) || (other = this.tiles.get(tile.x + cx, tile.y + cy)) == null || other.floor() == floor) continue;
                    other.setFloor(dest);
                }
            }
        }
    }

    public void brush(Seq<Tile> path, int rad) {
        path.each((? super T tile) -> this.erase(tile.x, tile.y, rad));
    }

    public void erase(int cx, int cy, int rad) {
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                int wx = cx + x;
                int wy = cy + y;
                if (!Structs.inBounds(wx, wy, this.width, this.height) || !Mathf.within(x, y, rad)) continue;
                Tile other = this.tiles.getn(wx, wy);
                other.setBlock(Blocks.air);
            }
        }
    }

    public Seq<Tile> pathfind(int startX, int startY, int endX, int endY, Astar.TileHueristic th, Astar.DistanceHeuristic dh) {
        return Astar.pathfind(startX, startY, endX, endY, th, dh, tile -> Vars.world.getDarkness(tile.x, tile.y) <= 1.0f);
    }

    public void trimDark() {
        for (Tile tile : this.tiles) {
            boolean any = Vars.world.getDarkness(tile.x, tile.y) > 0.0f;
            for (int i = 0; i < 4 && !any; ++i) {
                any = Vars.world.getDarkness(tile.x + Geometry.d4[i].x, tile.y + Geometry.d4[i].y) > 0.0f;
            }
            if (!any) continue;
            tile.setBlock(tile.floor().wall);
        }
    }

    public void inverseFloodFill(Tile start) {
        GridBits used = new GridBits(this.tiles.width, this.tiles.height);
        IntSeq arr = new IntSeq();
        arr.add(start.pos());
        while (!arr.isEmpty()) {
            int i = arr.pop();
            short x = Point2.x(i);
            short y = Point2.y(i);
            used.set(x, y);
            for (Point2 point : Geometry.d4) {
                Tile child;
                int newx = x + point.x;
                int newy = y + point.y;
                if (!this.tiles.in(newx, newy) || (child = this.tiles.getn(newx, newy)).block() != Blocks.air || used.get(child.x, child.y)) continue;
                used.set(child.x, child.y);
                arr.add(child.pos());
            }
        }
        for (Tile tile : this.tiles) {
            if (used.get(tile.x, tile.y) || tile.block() != Blocks.air) continue;
            tile.setBlock(tile.floor().wall);
        }
    }
}

