/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps;

import arc.func.Boolf;
import arc.math.LinearRegression;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.math.geom.Vec2;
import arc.struct.IntSet;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Structs;
import mindustry.Vars;
import mindustry.ai.Astar;
import mindustry.ai.Pathfinder;
import mindustry.content.Blocks;
import mindustry.content.StatusEffects;
import mindustry.core.World;
import mindustry.entities.Effect;
import mindustry.entities.abilities.Ability;
import mindustry.entities.abilities.RepairFieldAbility;
import mindustry.game.SectorInfo;
import mindustry.game.SpawnGroup;
import mindustry.gen.Building;
import mindustry.gen.Groups;
import mindustry.gen.Unit;
import mindustry.logic.Ranged;
import mindustry.type.StatusEffect;
import mindustry.world.Tile;
import mindustry.world.Tiles;
import mindustry.world.blocks.defense.ForceProjector;
import mindustry.world.blocks.defense.MendProjector;
import mindustry.world.blocks.defense.turrets.PointDefenseTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.blocks.storage.CoreBlock;

public class SectorDamage {
    public static final int maxRetWave = 40;
    public static final int maxWavesSimulated = 50;
    private static final boolean rubble = true;

    public static float getDamage(SectorInfo info) {
        return SectorDamage.getDamage(info, info.wavesPassed);
    }

    public static float getDamage(SectorInfo info, int wavesPassed) {
        return SectorDamage.getDamage(info, wavesPassed, false);
    }

    public static int getWavesSurvived(SectorInfo info) {
        return (int)SectorDamage.getDamage(info, 40, true);
    }

    public static float getDamage(SectorInfo info, int wavesPassed, boolean retWave) {
        float health = info.sumHealth;
        int wave = info.wave;
        float waveSpace = info.waveSpacing;
        if (wavesPassed > 0) {
            int waveBegin = wave;
            int waveEnd = wave + wavesPassed;
            if (wavesPassed > 50 && !retWave) {
                waveBegin = waveEnd - 50;
            }
            for (int i = waveBegin; i <= waveEnd; ++i) {
                float efficiency = health / info.sumHealth;
                float dps = info.sumDps * efficiency;
                float rps = info.sumRps * efficiency;
                float enemyDps = info.waveDpsBase + info.waveDpsSlope * (float)i;
                float enemyHealth = info.waveHealthBase + info.waveHealthSlope * (float)i;
                if (info.bossWave == i) {
                    enemyDps += info.bossDps;
                    enemyHealth += info.bossHealth;
                }
                if (i == waveBegin) {
                    enemyDps += info.curEnemyDps;
                    enemyHealth += info.curEnemyHealth;
                }
                if (enemyHealth < 0.0f || enemyDps < 0.0f) continue;
                float timeDestroyEnemy = dps <= 1.0E-4f ? Float.POSITIVE_INFINITY : enemyHealth / dps;
                float timeDestroyBase = health / (enemyDps - rps);
                if (timeDestroyBase < 0.0f) continue;
                if (timeDestroyEnemy > timeDestroyBase) {
                    health = 0.0f;
                    if (!retWave) break;
                    return i - waveBegin;
                }
                float damageTaken = timeDestroyEnemy * (enemyDps - rps);
                health -= damageTaken;
                health = Math.min(health + rps / 60.0f * waveSpace, info.sumHealth);
            }
        }
        if (retWave) {
            return 40.0f;
        }
        return 1.0f - Mathf.clamp(health / info.sumHealth);
    }

    public static void applyCalculatedDamage() {
        float damage = SectorDamage.getDamage(Vars.state.rules.sector.info);
        float scaled = Mathf.pow(damage, 1.2f);
        Tile spawn = Vars.spawner.getFirstSpawn();
        if (spawn != null) {
            Seq<Unit> allies = new Seq<Unit>();
            float sumUnitHealth = 0.0f;
            for (Unit ally : Groups.unit) {
                if (ally.team != Vars.state.rules.defaultTeam || !ally.within(spawn, Vars.state.rules.dropZoneRadius * 2.5f)) continue;
                allies.add(ally);
                sumUnitHealth += ally.health;
            }
            allies.sort(u -> u.dst2(spawn));
            float unitDamage = damage * sumUnitHealth;
            for (Unit u2 : allies) {
                if (u2.health < unitDamage) {
                    u2.remove();
                    unitDamage -= u2.health;
                    continue;
                }
                u2.health -= unitDamage;
                break;
            }
        }
        if (Vars.state.rules.sector.info.wavesPassed > 0) {
            for (Tile spawner : Vars.spawner.getSpawns()) {
                spawner.circle((int)(Vars.state.rules.dropZoneRadius / 8.0f), tile -> {
                    if (tile.team() == Vars.state.rules.defaultTeam) {
                        if (tile.floor().hasSurface() && Mathf.chance(0.4)) {
                            Effect.rubble(tile.build.x, tile.build.y, tile.block().size);
                        }
                        tile.remove();
                    }
                });
            }
        }
        SectorDamage.apply(scaled);
    }

    public static void writeParameters(SectorInfo info) {
        Object tile;
        CoreBlock.CoreBuild core = Vars.state.rules.defaultTeam.core();
        Seq<Tile> spawns = new Seq<Tile>();
        Vars.spawner.eachGroundSpawn((x, y) -> spawns.add(Vars.world.tile(x, y)));
        if (spawns.isEmpty() && Vars.state.rules.waveTeam.core() != null) {
            spawns.add(Vars.state.rules.waveTeam.core().tile);
        }
        if (core == null || spawns.isEmpty()) {
            return;
        }
        boolean airOnly = !Vars.state.rules.spawns.contains((SpawnGroup)((Object)((Boolf<SpawnGroup>)g -> !g.type.flying)));
        Tile start = (Tile)spawns.first();
        Seq<Tile> path = new Seq<Tile>();
        if (airOnly) {
            World.raycastEach(start.x, start.y, core.tileX(), core.tileY(), (x, y) -> {
                path.add(Vars.world.rawTile(x, y));
                return false;
            });
        } else {
            Pathfinder.Flowfield field = Vars.pathfinder.getField(Vars.state.rules.waveTeam, 0, 0);
            boolean found = false;
            if (field != null && field.weights != null) {
                int[] weights = field.weights;
                Tile current = start;
                for (int count = 0; count < weights.length; ++count) {
                    int minCost = Integer.MAX_VALUE;
                    short cx = current.x;
                    short cy = current.y;
                    for (Point2 point2 : Geometry.d4) {
                        int nx = cx + point2.x;
                        int ny = cy + point2.y;
                        int packed = Vars.world.packArray(nx, ny);
                        Tile other = Vars.world.tile(nx, ny);
                        if (other == null || weights[packed] >= minCost || weights[packed] == -1) continue;
                        minCost = weights[packed];
                        current = other;
                    }
                    path.add(current);
                    if (current.build != core) continue;
                    found = true;
                    break;
                }
            }
            if (!found) {
                path.clear();
                path.addAll(Astar.pathfind(start, core.tile, SectorDamage::cost, t -> !t.block().isStatic() || !t.solid()));
            }
        }
        int sparseSkip = 5;
        int sparseSkip2 = 3;
        Seq<Object> sparse = new Seq<Object>(path.size / sparseSkip + 1);
        Seq<Tile> sparse2 = new Seq<Tile>(path.size / sparseSkip2 + 1);
        for (int i = 0; i < path.size; ++i) {
            if (i % sparseSkip == 0) {
                sparse.add((Tile)path.get(i));
            }
            if (i % sparseSkip2 != 0) continue;
            sparse2.add((Tile)path.get(i));
        }
        float sumHealth = 0.0f;
        float sumRps = 0.0f;
        float sumDps = 0.0f;
        float totalPathBuild = 0.0f;
        int radius = 6;
        IntSet counted = new IntSet();
        for (Tile tile2 : sparse2) {
            for (int dx = -radius; dx <= radius; ++dx) {
                for (int dy = -radius; dy <= radius; ++dy) {
                    int wx = dx + tile2.x;
                    int wy = dy + tile2.y;
                    if (wx < 0 || wy < 0 || wx >= Vars.world.width() || wy >= Vars.world.height()) continue;
                    tile = Vars.world.rawTile(wx, wy);
                    if (((Tile)tile).build == null || ((Tile)tile).team() != Vars.state.rules.defaultTeam || !counted.add(((Tile)tile).pos())) continue;
                    sumHealth += ((Tile)tile).build.health / (float)(((Tile)tile).block().size * ((Tile)tile).block().size);
                    totalPathBuild += 1.0f / (float)(((Tile)tile).block().size * ((Tile)tile).block().size);
                }
            }
        }
        float avgHealth = totalPathBuild <= 1.0f ? sumHealth : sumHealth / totalPathBuild;
        for (Building build : Vars.state.rules.defaultTeam.data().buildings) {
            Turret.TurretBuild b;
            Ranged ranged;
            float e = build.potentialEfficiency;
            if (!(e > 0.08f) || !(build instanceof Ranged) || !sparse.contains(arg_0 -> SectorDamage.lambda$writeParameters$6(build, ranged = (Ranged)((Object)build), arg_0))) continue;
            if (build instanceof Turret.TurretBuild && (b = (Turret.TurretBuild)build).hasAmmo()) {
                sumDps += b.estimateDps();
            }
            if ((tile = build.block) instanceof MendProjector) {
                MendProjector m = (MendProjector)tile;
                sumRps += m.healPercent / m.reload * avgHealth * 60.0f / 100.0f * e * build.timeScale();
            }
            if (build.block instanceof PointDefenseTurret) {
                sumHealth += 150.0f * build.timeScale() * build.potentialEfficiency;
            }
            if (!((tile = build.block) instanceof ForceProjector)) continue;
            ForceProjector f = (ForceProjector)tile;
            sumHealth += f.shieldHealth * e * build.timeScale();
            sumRps += e;
        }
        float f = 0.0f;
        float curEnemyDps = 0.0f;
        for (Unit unit : Groups.unit) {
            if (unit.isPlayer()) continue;
            float healthMult = 1.0f + Mathf.clamp(unit.armor / 20.0f);
            if (unit.team == Vars.state.rules.defaultTeam) {
                sumHealth += unit.health * healthMult + unit.shield;
                sumDps += unit.type.dpsEstimate;
                Ability ability = Structs.find(unit.abilities, a -> a instanceof RepairFieldAbility);
                if (ability instanceof RepairFieldAbility) {
                    RepairFieldAbility h = (RepairFieldAbility)ability;
                    sumRps += h.amount / h.reload * 60.0f;
                }
                sumRps += unit.type.weapons.sumf(w -> w.shotsPerSec() * (w.bullet.healPercent * 60.0f + w.bullet.healAmount));
                if (!unit.canBuild()) continue;
                sumRps += unit.type.buildSpeed * 3.0f * 0.5f * 50.0f;
                continue;
            }
            float bossMult = unit.isBoss() ? 3.0f : 1.0f;
            curEnemyDps += unit.type.dpsEstimate * unit.damageMultiplier() * bossMult;
            f += unit.health * healthMult * unit.healthMultiplier() * bossMult + unit.shield;
        }
        LinearRegression reg = new LinearRegression();
        SpawnGroup bossGroup = null;
        Seq<Vec2> waveDps = new Seq<Vec2>();
        Seq<Vec2> waveHealth = new Seq<Vec2>();
        int groundSpawns = Math.max(Vars.spawner.countFlyerSpawns(), 1);
        int airSpawns = Math.max(Vars.spawner.countGroundSpawns(), 1);
        for (int wave = Vars.state.wave; wave < Vars.state.wave + 10; ++wave) {
            float sumWaveDps = 0.0f;
            float sumWaveHealth = 0.0f;
            for (SpawnGroup group : Vars.state.rules.spawns) {
                int spawnCount = group.spawn != -1 ? 1 : (group.type.flying ? airSpawns : groundSpawns);
                float healthMult = 1.0f + Mathf.clamp(group.type.armor / 20.0f);
                StatusEffect effect = group.effect == null ? StatusEffects.none : group.effect;
                int spawned = group.getSpawned(wave) * spawnCount;
                if (group.effect == StatusEffects.boss) {
                    bossGroup = group;
                    continue;
                }
                if (spawned <= 0) continue;
                sumWaveHealth += (float)spawned * (group.getShield(wave) + group.type.health * effect.healthMultiplier * healthMult);
                sumWaveDps += (float)spawned * group.type.dpsEstimate * effect.damageMultiplier;
            }
            waveDps.add(new Vec2(wave, sumWaveDps));
            waveHealth.add(new Vec2(wave, sumWaveHealth));
        }
        if (bossGroup != null) {
            float bossMult = 1.2f;
            for (int wave = Vars.state.wave; wave < Vars.state.wave + 60; ++wave) {
                int spawned = bossGroup.getSpawned(wave - 1);
                if (spawned <= 0) continue;
                info.bossWave = wave;
                info.bossDps = (float)spawned * bossGroup.type.dpsEstimate * StatusEffects.boss.damageMultiplier * bossMult;
                info.bossHealth = (float)spawned * (bossGroup.getShield(wave) + bossGroup.type.health * StatusEffects.boss.healthMultiplier * (1.0f + Mathf.clamp(bossGroup.type.armor / 20.0f))) * bossMult;
                break;
            }
        }
        reg.calculate(waveHealth);
        info.waveHealthBase = reg.intercept;
        info.waveHealthSlope = reg.slope;
        reg.calculate(waveDps);
        info.waveDpsBase = reg.intercept;
        info.waveDpsSlope = reg.slope;
        info.sumHealth = sumHealth * 0.9f;
        info.sumDps = sumDps;
        info.sumRps = sumRps;
        float cmult = 1.6f;
        info.curEnemyDps = curEnemyDps * cmult;
        info.curEnemyHealth = f * cmult;
        info.wavesSurvived = SectorDamage.getWavesSurvived(info);
    }

    public static void apply(float fraction) {
        Tiles tiles = Vars.world.tiles;
        Queue<Object> frontier = new Queue<Object>();
        float[][] values = new float[tiles.width][tiles.height];
        for (Object tile : tiles) {
            if ((!(((Tile)tile).block() instanceof CoreBlock) || ((Tile)tile).team() != Vars.state.rules.waveTeam) && ((Tile)tile).overlay() != Blocks.spawn) continue;
            frontier.add(tile);
            values[((Tile)tile).x][((Tile)tile).y] = fraction * 24.0f;
        }
        CoreBlock.CoreBuild core = Vars.state.rules.defaultTeam.core();
        if (core != null && !frontier.isEmpty()) {
            for (Tile tile : frontier) {
                Seq<Tile> path = Astar.pathfind(tile, core.tile, SectorDamage::cost, t -> !t.block().isStatic() || !t.solid());
                Seq<Building> removal = new Seq<Building>();
                int radius = 3;
                float totalHealth = fraction >= 1.0f ? 1.0f : path.sumf(t -> {
                    float s = 0.0f;
                    for (int dx = -radius; dx <= radius; ++dx) {
                        for (int dy = -radius; dy <= radius; ++dy) {
                            Tile other;
                            int wx = dx + t.x;
                            int wy = dy + t.y;
                            if (wx < 0 || wy < 0 || wx >= Vars.world.width() || wy >= Vars.world.height() || !Mathf.within(dx, dy, radius) || (other = Vars.world.rawTile(wx, wy)).block() instanceof CoreBlock) continue;
                            s += other.team() == Vars.state.rules.defaultTeam ? other.build.health / (float)(other.block().size * other.block().size) : 0.0f;
                        }
                    }
                    return s;
                });
                float targetHealth = totalHealth * fraction;
                float healthCount = 0.0f;
                block2: for (int i = 0; i < path.size && (healthCount < targetHealth || fraction >= 1.0f); ++i) {
                    Tile t2 = path.get(i);
                    for (int dx = -radius; dx <= radius; ++dx) {
                        for (int dy = -radius; dy <= radius; ++dy) {
                            int wx = dx + t2.x;
                            int wy = dy + t2.y;
                            if (wx < 0 || wy < 0 || wx >= Vars.world.width() || wy >= Vars.world.height() || !Mathf.within(dx, dy, radius)) continue;
                            Tile other = Vars.world.rawTile(wx, wy);
                            if (other.build == null || other.team() != Vars.state.rules.defaultTeam || other.block() instanceof CoreBlock) continue;
                            if (!other.floor().solid && !other.floor().isLiquid && Mathf.chance(0.4)) {
                                Effect.rubble(other.build.x, other.build.y, other.block().size);
                            }
                            removal.add(other.build);
                            if ((healthCount += other.build.health) >= targetHealth && fraction < 0.999f) break block2;
                        }
                    }
                }
                for (Building r : removal) {
                    if (r.tile.build != r) continue;
                    r.addPlan(false);
                    r.tile.remove();
                }
            }
        }
        if (fraction >= 1.0f) {
            for (Building building : Vars.state.rules.defaultTeam.cores().copy()) {
                building.tile.remove();
            }
        }
        float falloff = fraction / ((float)Math.max(tiles.width, tiles.height) * Mathf.sqrt2);
        boolean bl = false;
        if (fraction > 0.15f) {
            while (!frontier.isEmpty()) {
                int n;
                n = Math.max(n, frontier.size);
                Tile tile = (Tile)frontier.removeFirst();
                float currDamage = values[tile.x][tile.y] - falloff;
                for (int i = 0; i < 4; ++i) {
                    int cx = tile.x + Geometry.d4x[i];
                    int cy = tile.y + Geometry.d4y[i];
                    if (!tiles.in(cx, cy) || !(values[cx][cy] < currDamage)) continue;
                    Tile other = tiles.getn(cx, cy);
                    float resultDamage = currDamage;
                    if (other.build != null && other.team() != Vars.state.rules.waveTeam) {
                        resultDamage -= other.build.health();
                        other.build.health -= currDamage;
                        if (other.block() instanceof CoreBlock) {
                            other.build.health = Math.max(other.build.health, 1.0f);
                        }
                        if (other.build.health < 0.0f) {
                            if (!other.floor().solid && !other.floor().isLiquid && Mathf.chance(0.4)) {
                                Effect.rubble(other.build.x, other.build.y, other.block().size);
                            }
                            other.build.addPlan(false);
                            other.remove();
                        } else {
                            Vars.indexer.notifyHealthChanged(other.build);
                        }
                    } else if (other.solid() && !other.synthetic()) continue;
                    if (!(resultDamage > 0.0f) || !(values[cx][cy] < resultDamage)) continue;
                    frontier.addLast(other);
                    values[cx][cy] = resultDamage;
                }
            }
        }
    }

    static float cost(Tile tile) {
        return 1.0f + (tile.block().isStatic() && tile.solid() ? 200.0f : 0.0f) + (tile.build != null ? tile.build.health / (float)(tile.build.block.size * tile.build.block.size) / 20.0f : 0.0f) + (tile.floor().isLiquid ? 10.0f : 0.0f);
    }

    private static /* synthetic */ boolean lambda$writeParameters$6(Building build, Ranged ranged, Tile t) {
        return t.within(build, ranged.range() + 32.0f);
    }
}

