/*
 * Decompiled with CFR 0.152.
 */
package mindustry.maps;

import arc.Core;
import arc.Events;
import arc.files.Fi;
import arc.graphics.Texture;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.struct.StringMap;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import mindustry.Vars;
import mindustry.content.Planets;
import mindustry.game.EventType;
import mindustry.game.Gamemode;
import mindustry.game.Rules;
import mindustry.io.JsonIO;
import mindustry.maps.filters.GenerateFilter;
import mindustry.mod.Mods;
import mindustry.type.Publishable;

public class Map
implements Comparable<Map>,
Publishable {
    public final boolean custom;
    public final StringMap tags;
    public final Fi file;
    public final int version;
    public boolean workshop;
    public int width;
    public int height;
    public Texture texture;
    public int build;
    public IntSet teams = new IntSet();
    public int spawns = 0;
    @Nullable
    public Mods.LoadedMod mod;

    public Map(Fi file, int width, int height, StringMap tags, boolean custom, int version, int build) {
        this.custom = custom;
        this.tags = tags;
        this.file = file;
        this.width = width;
        this.height = height;
        this.version = version;
        this.build = build;
    }

    public Map(Fi file, int width, int height, StringMap tags, boolean custom, int version) {
        this(file, width, height, tags, custom, version, -1);
    }

    public Map(Fi file, int width, int height, StringMap tags, boolean custom) {
        this(file, width, height, tags, custom, -1);
    }

    public Map(StringMap tags) {
        this(Vars.customMapDirectory.child(tags.get("name", "unknown")), 0, 0, tags, true);
    }

    public int getHightScore() {
        return Core.settings.getInt("hiscore" + this.file.nameWithoutExtension() + this.tags.get("steamid", ""), 0);
    }

    public Texture safeTexture() {
        return this.texture == null ? (Texture)Core.assets.get("sprites/error.png") : this.texture;
    }

    public Fi previewFile() {
        return Vars.mapPreviewDirectory.child((this.workshop ? this.file.parent().name() : this.file.nameWithoutExtension()) + "_v2.png");
    }

    public Fi cacheFile() {
        return Vars.mapPreviewDirectory.child(this.workshop ? this.file.parent().name() + "-workshop-cache.dat" : this.file.nameWithoutExtension() + "-cache_v2.dat");
    }

    public void setHighScore(int score) {
        Core.settings.put("hiscore" + this.file.nameWithoutExtension() + this.tags.get("steamid", ""), score);
    }

    public Rules applyRules(Gamemode mode) {
        Rules out = new Rules();
        mode.apply(out);
        return this.rules(out);
    }

    public Rules rules() {
        return this.rules(new Rules());
    }

    public Rules rules(Rules base) {
        try {
            Rules result = JsonIO.read(Rules.class, base, this.tags.get("rules", "{}").replace("teams:{2:{infiniteAmmo:true}},", ""));
            if (result.planet == Planets.serpulo && result.hasEnv(16)) {
                result.planet = Planets.erekir;
            }
            if (result.spawns.isEmpty()) {
                result.spawns = Vars.waves.get();
            }
            return result;
        }
        catch (Exception e) {
            Log.err(e);
            return new Rules();
        }
    }

    public Seq<GenerateFilter> filters() {
        if (this.tags.getInt("build", -1) < 83 && this.tags.getInt("build", -1) != -1 && this.tags.get("genfilters", "").isEmpty()) {
            return Seq.with(new GenerateFilter[0]);
        }
        return Vars.maps.readFilters(this.tags.get("genfilters", ""));
    }

    public String name() {
        return this.tag("name");
    }

    public String author() {
        return this.tag("author");
    }

    public String description() {
        return this.tag("description");
    }

    public String plainName() {
        return Strings.stripColors(this.name());
    }

    public String plainAuthor() {
        return Strings.stripColors(this.author());
    }

    public String plainDescription() {
        return Strings.stripColors(this.description());
    }

    public String tag(String name) {
        return this.hasTag(name) ? (String)this.tags.get(name) : Core.bundle.get("unknown", "unknown");
    }

    public boolean hasTag(String name) {
        return this.tags.containsKey(name) && !((String)this.tags.get(name)).trim().isEmpty();
    }

    @Override
    public String getSteamID() {
        return (String)this.tags.get("steamid");
    }

    @Override
    public void addSteamID(String id) {
        this.tags.put("steamid", id);
        Vars.editor.tags.put("steamid", id);
        try {
            Vars.ui.editor.save();
        }
        catch (Exception e) {
            Log.err(e);
        }
        Events.fire(new EventType.MapPublishEvent());
    }

    @Override
    public void removeSteamID() {
        this.tags.remove("steamid");
        Vars.editor.tags.remove("steamid");
        try {
            Vars.ui.editor.save();
        }
        catch (Exception e) {
            Log.err(e);
        }
    }

    @Override
    public String steamTitle() {
        return this.name();
    }

    @Override
    public String steamDescription() {
        return this.description();
    }

    @Override
    public String steamTag() {
        return "map";
    }

    @Override
    public Fi createSteamFolder(String id) {
        Fi mapFile = Vars.tmpDirectory.child("map_" + id).child("map.msav");
        this.file.copyTo(mapFile);
        return mapFile.parent();
    }

    @Override
    public Fi createSteamPreview(String id) {
        return Vars.mapPreviewDirectory.child((this.workshop && this.file.parent().exists() && this.file.parent().extEquals(".png") ? this.file.parent().name() : this.file.nameWithoutExtension()) + "_v2.png");
    }

    @Override
    public Seq<String> extraTags() {
        Gamemode mode = Gamemode.attack.valid(this) ? Gamemode.attack : Gamemode.survival;
        return Seq.with(mode.name());
    }

    @Override
    public boolean prePublish() {
        this.tags.put("author", Vars.player.name);
        Vars.editor.tags.put("author", Vars.player.name);
        Vars.ui.editor.save();
        return true;
    }

    @Override
    public int compareTo(Map map) {
        int work = -Boolean.compare(this.workshop, map.workshop);
        if (work != 0) {
            return work;
        }
        int type = -Boolean.compare(this.custom, map.custom);
        if (type != 0) {
            return type;
        }
        int modes = Boolean.compare(Gamemode.pvp.valid(this), Gamemode.pvp.valid(map));
        if (modes != 0) {
            return modes;
        }
        return this.name().compareTo(map.name());
    }

    public String toString() {
        return "Map{file='" + this.file + '\'' + ", custom=" + this.custom + ", tags=" + this.tags + '}';
    }
}

