/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Point2;
import arc.struct.IntFloatMap;
import arc.struct.IntSet;
import arc.struct.LongSeq;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Structs;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.LogicAI;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.MappableContent;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.entities.Units;
import mindustry.entities.units.BuildPlan;
import mindustry.entities.units.UnitController;
import mindustry.game.SpawnGroup;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.gen.DisplayCmd;
import mindustry.gen.Healthc;
import mindustry.gen.Icon;
import mindustry.gen.Payloadc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.logic.ConditionOp;
import mindustry.logic.CutsceneAction;
import mindustry.logic.FetchType;
import mindustry.logic.LAccess;
import mindustry.logic.LAssembler;
import mindustry.logic.LLocate;
import mindustry.logic.LUnitControl;
import mindustry.logic.LogicFx;
import mindustry.logic.LogicOp;
import mindustry.logic.LogicRule;
import mindustry.logic.MessageType;
import mindustry.logic.RadarSort;
import mindustry.logic.RadarTarget;
import mindustry.logic.Ranged;
import mindustry.logic.Senseable;
import mindustry.logic.Settable;
import mindustry.logic.TileLayer;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.OverlayFloor;
import mindustry.world.blocks.logic.LogicBlock;
import mindustry.world.blocks.logic.LogicDisplay;
import mindustry.world.blocks.logic.MemoryBlock;
import mindustry.world.blocks.logic.MessageBlock;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.meta.BlockFlag;
import mindustry.world.meta.BuildVisibility;

public class LExecutor {
    public static final int maxInstructions = 1000;
    public static final int varCounter = 0;
    public static final int varUnit = 1;
    public static final int varThis = 2;
    public static final int maxGraphicsBuffer = 256;
    public static final int maxDisplayBuffer = 1024;
    public static final int maxTextBuffer = 400;
    public LInstruction[] instructions = new LInstruction[0];
    public Var[] vars = new Var[0];
    public Var counter;
    public int[] binds;
    public int iptIndex = -1;
    public LongSeq graphicsBuffer = new LongSeq();
    public StringBuilder textBuffer = new StringBuilder();
    public Building[] links = new Building[0];
    @Nullable
    public LogicBlock.LogicBuild build;
    public IntSet linkIds = new IntSet();
    public Team team = Team.derelict;
    public boolean privileged = false;
    protected IntFloatMap unitTimeouts = new IntFloatMap();

    boolean timeoutDone(Unit unit, float delay) {
        return Time.time >= this.unitTimeouts.get(unit.id) + delay;
    }

    void updateTimeout(Unit unit) {
        this.unitTimeouts.put(unit.id, Time.time);
    }

    public boolean initialized() {
        return this.instructions.length > 0;
    }

    public void runOnce() {
        if (this.counter.numval >= (double)this.instructions.length || this.counter.numval < 0.0) {
            this.counter.numval = 0.0;
        }
        if (this.counter.numval < (double)this.instructions.length) {
            double d = this.counter.numval;
            this.counter.numval = d + 1.0;
            this.instructions[(int)d].run(this);
        }
    }

    public void load(LAssembler builder) {
        this.vars = new Var[builder.vars.size];
        this.instructions = builder.instructions;
        this.iptIndex = -1;
        builder.vars.each((name, var) -> {
            Var dest;
            this.vars[var.id] = dest = new Var((String)name);
            if (dest.name.equals("@ipt")) {
                this.iptIndex = var.id;
            }
            dest.constant = var.constant;
            Object patt2928$temp = var.value;
            if (patt2928$temp instanceof Number) {
                Number number = (Number)patt2928$temp;
                dest.isobj = false;
                dest.numval = number.doubleValue();
            } else {
                dest.isobj = true;
                dest.objval = var.value;
            }
        });
        this.counter = this.vars[0];
    }

    private static boolean invalid(double d) {
        return Double.isNaN(d) || Double.isInfinite(d);
    }

    public Var var(int index) {
        return index < 0 ? Vars.logicVars.get(-index) : this.vars[index];
    }

    @Nullable
    public Var optionalVar(int index) {
        return index < 0 || index >= this.vars.length ? null : this.vars[index];
    }

    @Nullable
    public Building building(int index) {
        Building building;
        Object o = this.var((int)index).objval;
        return this.var((int)index).isobj && o instanceof Building ? (building = (Building)o) : null;
    }

    @Nullable
    public Object obj(int index) {
        Object o = this.var((int)index).objval;
        return this.var((int)index).isobj ? o : null;
    }

    @Nullable
    public Team team(int index) {
        Var v = this.var(index);
        if (v.isobj) {
            Team t;
            Object object = v.objval;
            return object instanceof Team ? (t = (Team)object) : null;
        }
        int t = (int)v.numval;
        if (t < 0 || t >= Team.all.length) {
            return null;
        }
        return Team.all[t];
    }

    public boolean bool(int index) {
        Var v = this.var(index);
        return v.isobj ? v.objval != null : Math.abs(v.numval) >= 1.0E-5;
    }

    public double num(int index) {
        Var v = this.var(index);
        return v.isobj ? (v.objval != null ? 1.0 : 0.0) : (LExecutor.invalid(v.numval) ? 0.0 : v.numval);
    }

    public float numf(int index) {
        Var v = this.var(index);
        return v.isobj ? (v.objval != null ? 1.0f : 0.0f) : (LExecutor.invalid(v.numval) ? 0.0f : (float)v.numval);
    }

    public int numi(int index) {
        return (int)this.num(index);
    }

    public void setbool(int index, boolean value) {
        this.setnum(index, value ? 1.0 : 0.0);
    }

    public void setnum(int index, double value) {
        Var v = this.var(index);
        if (v.constant) {
            return;
        }
        if (LExecutor.invalid(value)) {
            v.objval = null;
            v.isobj = true;
        } else {
            v.numval = value;
            v.objval = null;
            v.isobj = false;
        }
    }

    public void setobj(int index, Object value) {
        Var v = this.var(index);
        if (v.constant) {
            return;
        }
        v.objval = value;
        v.isobj = true;
    }

    public void setconst(int index, Object value) {
        Var v = this.var(index);
        v.objval = value;
        v.isobj = true;
    }

    static boolean checkMapArea(int x, int y, int w, int h, boolean set) {
        boolean full;
        x = Math.max(x, 0);
        y = Math.max(y, 0);
        w = Math.min(Vars.world.width(), w);
        h = Math.min(Vars.world.height(), h);
        boolean bl = full = x == 0 && y == 0 && w == Vars.world.width() && h == Vars.world.height();
        if (Vars.state.rules.limitMapArea) {
            if (Vars.state.rules.limitX == x && Vars.state.rules.limitY == y && Vars.state.rules.limitWidth == w && Vars.state.rules.limitHeight == h) {
                return true;
            }
            if (full && set) {
                Vars.state.rules.limitMapArea = false;
                if (!Vars.headless) {
                    Vars.renderer.updateAllDarkness();
                }
                Vars.world.checkMapArea();
                return false;
            }
        } else if (full) {
            return true;
        }
        if (set) {
            Vars.state.rules.limitMapArea = true;
            Vars.state.rules.limitX = x;
            Vars.state.rules.limitY = y;
            Vars.state.rules.limitWidth = w;
            Vars.state.rules.limitHeight = h;
            Vars.world.checkMapArea();
            if (!Vars.headless) {
                Vars.renderer.updateAllDarkness();
            }
        }
        return false;
    }

    public static void setMapArea(int x, int y, int w, int h) {
        LExecutor.checkMapArea(x, y, w, h, true);
    }

    public static void logicExplosion(Team team, float x, float y, float radius, float damage, boolean air, boolean ground, boolean pierce) {
        if (damage < 0.0f) {
            return;
        }
        Damage.damage(team, x, y, radius, damage, pierce, air, ground);
        if (pierce) {
            Fx.spawnShockwave.at(x, y, World.conv(radius));
        } else {
            Fx.dynamicExplosion.at(x, y, World.conv(radius) / 8.0f);
        }
    }

    public static void syncVariable(Building building, int variable, Object value) {
        if (building instanceof LogicBlock.LogicBuild) {
            LogicBlock.LogicBuild build = (LogicBlock.LogicBuild)building;
            Var v = build.executor.optionalVar(variable);
            if (v != null && !v.constant) {
                if (value instanceof Double) {
                    Double d = (Double)value;
                    v.isobj = false;
                    v.numval = d;
                } else {
                    v.isobj = true;
                    v.objval = value;
                }
            }
        }
    }

    public static void setFlag(String flag, boolean add) {
        if (add) {
            Vars.state.rules.objectiveFlags.add(flag);
        } else {
            Vars.state.rules.objectiveFlags.remove(flag);
        }
    }

    public static interface LInstruction {
        public void run(LExecutor var1);
    }

    public static class Var {
        public final String name;
        public boolean isobj;
        public boolean constant;
        public Object objval;
        public double numval;
        public long syncTime;

        public Var(String name) {
            this.name = name;
        }
    }

    public static class SetPropI
    implements LInstruction {
        public int type;
        public int of;
        public int value;

        public SetPropI(int type, int of, int value) {
            this.type = type;
            this.of = of;
            this.value = value;
        }

        public SetPropI() {
        }

        @Override
        public void run(LExecutor exec) {
            Object target = exec.obj(this.of);
            Object key = exec.obj(this.type);
            if (target instanceof Settable) {
                Settable sp = (Settable)target;
                if (key instanceof LAccess) {
                    LAccess property = (LAccess)((Object)key);
                    Var var = exec.var(this.value);
                    if (var.isobj) {
                        sp.setProp(property, var.objval);
                    } else {
                        sp.setProp(property, var.numval);
                    }
                } else if (key instanceof UnlockableContent) {
                    UnlockableContent content = (UnlockableContent)key;
                    sp.setProp(content, exec.num(this.value));
                }
            }
        }
    }

    public static class SpawnWaveI
    implements LInstruction {
        public int natural;
        public int x;
        public int y;

        public SpawnWaveI() {
        }

        public SpawnWaveI(int natural, int x, int y) {
            this.natural = natural;
            this.x = x;
            this.y = y;
        }

        @Override
        public void run(LExecutor exec) {
            if (Vars.net.client()) {
                return;
            }
            if (exec.bool(this.natural)) {
                Vars.logic.skipWave();
                return;
            }
            float spawnX = World.unconv(exec.numf(this.x));
            float spawnY = World.unconv(exec.numf(this.y));
            int packed = Point2.pack(exec.numi(this.x), exec.numi(this.y));
            for (SpawnGroup group : Vars.state.rules.spawns) {
                if (group.type == null || group.spawn != -1 && group.spawn != packed) continue;
                int spawned = group.getSpawned(Vars.state.wave - 1);
                float spread = 16.0f;
                for (int i = 0; i < spawned; ++i) {
                    Tmp.v1.rnd(spread);
                    Unit unit = group.createUnit(Vars.state.rules.waveTeam, Vars.state.wave - 1);
                    unit.set(spawnX + Tmp.v1.x, spawnY + Tmp.v1.y);
                    Vars.spawner.spawnEffect(unit);
                }
            }
        }
    }

    public static class SetFlagI
    implements LInstruction {
        public int flag;
        public int value;

        public SetFlagI(int flag, int value) {
            this.flag = flag;
            this.value = value;
        }

        public SetFlagI() {
        }

        @Override
        public void run(LExecutor exec) {
            String str;
            Object object = exec.obj(this.flag);
            if (object instanceof String && Vars.state.rules.objectiveFlags.contains(str = (String)object) != exec.bool(this.value)) {
                Call.setFlag(str, exec.bool(this.value));
            }
        }
    }

    public static class GetFlagI
    implements LInstruction {
        public int result;
        public int flag;

        public GetFlagI(int result, int flag) {
            this.result = result;
            this.flag = flag;
        }

        public GetFlagI() {
        }

        @Override
        public void run(LExecutor exec) {
            Object object = exec.obj(this.flag);
            if (object instanceof String) {
                String str = (String)object;
                exec.setbool(this.result, Vars.state.rules.objectiveFlags.contains(str));
            } else {
                exec.setobj(this.result, null);
            }
        }
    }

    public static class SyncI
    implements LInstruction {
        public static long syncInterval = 50L;
        public int variable;

        public SyncI(int variable) {
            this.variable = variable;
        }

        public SyncI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (exec.build != null && exec.build.block.privileged) {
                Var v = exec.var(this.variable);
                if (!v.constant && Time.timeSinceMillis(v.syncTime) > syncInterval) {
                    v.syncTime = Time.millis();
                    Call.syncVariable(exec.build, this.variable, v.isobj ? v.objval : Double.valueOf(v.numval));
                }
            }
        }
    }

    public static class SetRateI
    implements LInstruction {
        public int amount;

        public SetRateI(int amount) {
            this.amount = amount;
        }

        public SetRateI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (exec.build != null && exec.build.block.privileged) {
                exec.build.ipt = Mathf.clamp(exec.numi(this.amount), 1, ((LogicBlock)exec.build.block).maxInstructionsPerTick);
                if (exec.iptIndex >= 0 && exec.vars.length > exec.iptIndex) {
                    exec.vars[exec.iptIndex].numval = exec.build.ipt;
                }
            }
        }
    }

    public static class ExplosionI
    implements LInstruction {
        public int team;
        public int x;
        public int y;
        public int radius;
        public int damage;
        public int air;
        public int ground;
        public int pierce;

        public ExplosionI(int team, int x, int y, int radius, int damage, int air, int ground, int pierce) {
            this.team = team;
            this.x = x;
            this.y = y;
            this.radius = radius;
            this.damage = damage;
            this.air = air;
            this.ground = ground;
            this.pierce = pierce;
        }

        public ExplosionI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (Vars.net.client()) {
                return;
            }
            Team t = exec.team(this.team);
            Call.logicExplosion(t, World.unconv(exec.numf(this.x)), World.unconv(exec.numf(this.y)), World.unconv(Math.min(exec.numf(this.radius), 100.0f)), exec.numf(this.damage), exec.bool(this.air), exec.bool(this.ground), exec.bool(this.pierce));
        }
    }

    public static class EffectI
    implements LInstruction {
        public LogicFx.EffectEntry type;
        public int x;
        public int y;
        public int rotation;
        public int color;
        public int data;

        public EffectI(LogicFx.EffectEntry type, int x, int y, int rotation, int color, int data) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.color = color;
            this.data = data;
        }

        public EffectI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (this.type != null) {
                double col = exec.num(this.color);
                float rot = this.type.rotate ? exec.numf(this.rotation) : Math.min(exec.numf(this.rotation), 1000.0f);
                this.type.effect.at(World.unconv(exec.numf(this.x)), World.unconv(exec.numf(this.y)), rot, Tmp.c1.fromDouble(col), exec.obj(this.data));
            }
        }
    }

    public static class FlushMessageI
    implements LInstruction {
        public MessageType type = MessageType.announce;
        public int duration;

        public FlushMessageI(MessageType type, int duration) {
            this.type = type;
            this.duration = duration;
        }

        public FlushMessageI() {
        }

        @Override
        public void run(LExecutor exec) {
            String substr;
            if (Vars.headless && this.type != MessageType.mission) {
                return;
            }
            if (this.type == MessageType.announce && Vars.ui.hasAnnouncement() || this.type == MessageType.notify && Vars.ui.hudfrag.hasToast() || this.type == MessageType.toast && Vars.ui.hasAnnouncement()) {
                exec.var((int)0).numval -= 1.0;
                return;
            }
            String text = exec.textBuffer.toString();
            if (text.startsWith("@") && Core.bundle.has(substr = text.substring(1))) {
                text = Core.bundle.get(substr);
            }
            switch (this.type) {
                case notify: {
                    Vars.ui.hudfrag.showToast(Icon.info, text);
                    break;
                }
                case announce: {
                    Vars.ui.announce(text, exec.numf(this.duration));
                    break;
                }
                case toast: {
                    Vars.ui.showInfoToast(text, exec.numf(this.duration));
                    break;
                }
                case mission: {
                    Vars.state.rules.mission = text;
                }
            }
            exec.textBuffer.setLength(0);
        }
    }

    public static class SetRuleI
    implements LInstruction {
        public LogicRule rule = LogicRule.waveSpacing;
        public int value;
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        public SetRuleI(LogicRule rule, int value, int p1, int p2, int p3, int p4) {
            this.rule = rule;
            this.value = value;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        public SetRuleI() {
        }

        @Override
        public void run(LExecutor exec) {
            block0 : switch (this.rule) {
                case waveTimer: {
                    Vars.state.rules.waveTimer = exec.bool(this.value);
                    break;
                }
                case wave: {
                    Vars.state.wave = Math.max(exec.numi(this.value), 1);
                    break;
                }
                case currentWaveTime: {
                    Vars.state.wavetime = Math.max(exec.numf(this.value) * 60.0f, 0.0f);
                    break;
                }
                case waves: {
                    Vars.state.rules.waves = exec.bool(this.value);
                    break;
                }
                case waveSending: {
                    Vars.state.rules.waveSending = exec.bool(this.value);
                    break;
                }
                case attackMode: {
                    Vars.state.rules.attackMode = exec.bool(this.value);
                    break;
                }
                case waveSpacing: {
                    Vars.state.rules.waveSpacing = exec.numf(this.value) * 60.0f;
                    break;
                }
                case enemyCoreBuildRadius: {
                    Vars.state.rules.enemyCoreBuildRadius = exec.numf(this.value) * 8.0f;
                    break;
                }
                case dropZoneRadius: {
                    Vars.state.rules.dropZoneRadius = exec.numf(this.value) * 8.0f;
                    break;
                }
                case unitCap: {
                    Vars.state.rules.unitCap = Math.max(exec.numi(this.value), 0);
                    break;
                }
                case lighting: {
                    Vars.state.rules.lighting = exec.bool(this.value);
                    break;
                }
                case mapArea: {
                    int x = exec.numi(this.p1);
                    int y = exec.numi(this.p2);
                    int w = exec.numi(this.p3);
                    int h = exec.numi(this.p4);
                    if (LExecutor.checkMapArea(x, y, w, h, false)) break;
                    Call.setMapArea(x, y, w, h);
                    break;
                }
                case ambientLight: {
                    Vars.state.rules.ambientLight.fromDouble(exec.num(this.value));
                    break;
                }
                case solarMultiplier: {
                    Vars.state.rules.solarMultiplier = Math.max(exec.numf(this.value), 0.0f);
                    break;
                }
                case buildSpeed: 
                case unitHealth: 
                case unitBuildSpeed: 
                case unitCost: 
                case unitDamage: 
                case blockHealth: 
                case blockDamage: 
                case rtsMinWeight: 
                case rtsMinSquad: {
                    Team team = exec.team(this.p1);
                    if (team == null) break;
                    float num = exec.numf(this.value);
                    switch (this.rule) {
                        case buildSpeed: {
                            team.rules().buildSpeedMultiplier = Mathf.clamp(num, 0.001f, 50.0f);
                            break block0;
                        }
                        case unitHealth: {
                            team.rules().unitHealthMultiplier = Math.max(num, 0.001f);
                            break block0;
                        }
                        case unitBuildSpeed: {
                            team.rules().unitBuildSpeedMultiplier = Mathf.clamp(num, 0.0f, 50.0f);
                            break block0;
                        }
                        case unitCost: {
                            team.rules().unitCostMultiplier = Math.max(num, 0.0f);
                            break block0;
                        }
                        case unitDamage: {
                            team.rules().unitDamageMultiplier = Math.max(num, 0.0f);
                            break block0;
                        }
                        case blockHealth: {
                            team.rules().blockHealthMultiplier = Math.max(num, 0.001f);
                            break block0;
                        }
                        case blockDamage: {
                            team.rules().blockDamageMultiplier = Math.max(num, 0.0f);
                            break block0;
                        }
                        case rtsMinWeight: {
                            team.rules().rtsMinWeight = num;
                            break block0;
                        }
                        case rtsMinSquad: {
                            team.rules().rtsMinSquad = (int)num;
                        }
                    }
                }
            }
        }
    }

    public static class ApplyEffectI
    implements LInstruction {
        public boolean clear;
        public String effect;
        public int unit;
        public int duration;

        public ApplyEffectI(boolean clear, String effect, int unit, int duration) {
            this.clear = clear;
            this.effect = effect;
            this.unit = unit;
            this.duration = duration;
        }

        public ApplyEffectI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (Vars.net.client()) {
                return;
            }
            Object object = exec.obj(this.unit);
            if (object instanceof Unit) {
                Unit unit = (Unit)object;
                if (Vars.content.statusEffect(this.effect) != null) {
                    if (this.clear) {
                        unit.unapply(Vars.content.statusEffect(this.effect));
                    } else {
                        unit.apply(Vars.content.statusEffect(this.effect), exec.numf(this.duration) * 60.0f);
                    }
                }
            }
        }
    }

    public static class SpawnUnitI
    implements LInstruction {
        public int type;
        public int x;
        public int y;
        public int rotation;
        public int team;
        public int result;

        public SpawnUnitI(int type, int x, int y, int rotation, int team, int result) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.rotation = rotation;
            this.team = team;
            this.result = result;
        }

        public SpawnUnitI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (Vars.net.client()) {
                return;
            }
            Team t = exec.team(this.team);
            Object object = exec.obj(this.type);
            if (object instanceof UnitType) {
                UnitType type = (UnitType)object;
                if (!type.hidden && t != null && Units.canCreate(t, type)) {
                    Unit unit = type.spawn(t, World.unconv(exec.numf(this.x)) + Mathf.range(0.01f), World.unconv(exec.numf(this.y)) + Mathf.range(0.01f));
                    Vars.spawner.spawnEffect(unit, exec.numf(this.rotation));
                    exec.setobj(this.result, unit);
                }
            }
        }
    }

    public static class SetBlockI
    implements LInstruction {
        public int x;
        public int y;
        public int block;
        public int team;
        public int rotation;
        public TileLayer layer = TileLayer.block;

        public SetBlockI(int x, int y, int block, int team, int rotation, TileLayer layer) {
            this.x = x;
            this.y = y;
            this.block = block;
            this.team = team;
            this.rotation = rotation;
            this.layer = layer;
        }

        public SetBlockI() {
        }

        @Override
        public void run(LExecutor exec) {
            Object object;
            if (Vars.net.client()) {
                return;
            }
            Tile tile = Vars.world.tile(exec.numi(this.x), exec.numi(this.y));
            if (tile != null && (object = exec.obj(this.block)) instanceof Block) {
                Block b = (Block)object;
                switch (this.layer) {
                    case ore: {
                        if (!(b instanceof OverlayFloor) && b != Blocks.air || tile.overlay() == b) break;
                        tile.setOverlayNet(b);
                        break;
                    }
                    case floor: {
                        if (!(b instanceof Floor)) break;
                        Floor f = (Floor)b;
                        if (tile.floor() == f || f.isOverlay() || f.isAir()) break;
                        tile.setFloorNet(f);
                        break;
                    }
                    case block: {
                        if (b.isFloor() && b != Blocks.air) break;
                        Team t = exec.team(this.team);
                        if (t == null) {
                            t = Team.derelict;
                        }
                        if (tile.block() == b && tile.team() == t) break;
                        tile.setNet(b, t, Mathf.clamp(exec.numi(this.rotation), 0, 3));
                    }
                }
            }
        }
    }

    public static class GetBlockI
    implements LInstruction {
        public int x;
        public int y;
        public int dest;
        public TileLayer layer = TileLayer.block;

        public GetBlockI(int x, int y, int dest, TileLayer layer) {
            this.x = x;
            this.y = y;
            this.dest = dest;
            this.layer = layer;
        }

        public GetBlockI() {
        }

        @Override
        public void run(LExecutor exec) {
            Tile tile = Vars.world.tile(exec.numi(this.x), exec.numi(this.y));
            if (tile == null) {
                exec.setobj(this.dest, null);
            } else {
                Senseable senseable;
                switch (this.layer) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case floor: {
                        senseable = tile.floor();
                        break;
                    }
                    case ore: {
                        senseable = tile.overlay();
                        break;
                    }
                    case block: {
                        senseable = tile.block();
                        break;
                    }
                    case building: {
                        senseable = tile.build;
                    }
                }
                exec.setobj(this.dest, senseable);
            }
        }
    }

    public static class FetchI
    implements LInstruction {
        public FetchType type = FetchType.unit;
        public int result;
        public int team;
        public int extra;
        public int index;

        public FetchI(FetchType type, int result, int team, int extra, int index) {
            this.type = type;
            this.result = result;
            this.team = team;
            this.extra = extra;
            this.index = index;
        }

        public FetchI() {
        }

        @Override
        public void run(LExecutor exec) {
            int i = exec.numi(this.index);
            Team t = exec.team(this.team);
            if (t == null) {
                return;
            }
            Teams.TeamData data = t.data();
            switch (this.type) {
                case unit: {
                    exec.setobj(this.result, i < 0 || i >= data.units.size ? null : data.units.get(i));
                    break;
                }
                case player: {
                    exec.setobj(this.result, i < 0 || i >= data.players.size || data.players.get(i).unit().isNull() ? null : data.players.get(i).unit());
                    break;
                }
                case core: {
                    exec.setobj(this.result, i < 0 || i >= data.cores.size ? null : data.cores.get(i));
                    break;
                }
                case build: {
                    Block b;
                    Block block;
                    Object object = exec.obj(this.extra);
                    Block block2 = block = object instanceof Block ? (b = (Block)object) : null;
                    if (block == null) {
                        exec.setobj(this.result, null);
                        break;
                    }
                    Seq<Building> builds = data.getBuildings(block);
                    exec.setobj(this.result, i < 0 || i >= builds.size ? null : builds.get(i));
                    break;
                }
                case unitCount: {
                    exec.setnum(this.result, data.units.size);
                    break;
                }
                case coreCount: {
                    exec.setnum(this.result, data.cores.size);
                    break;
                }
                case playerCount: {
                    exec.setnum(this.result, data.players.size);
                    break;
                }
                case buildCount: {
                    Block b;
                    Block block;
                    Object object = exec.obj(this.extra);
                    Block block3 = block = object instanceof Block ? (b = (Block)object) : null;
                    if (block == null) {
                        exec.setobj(this.result, null);
                        break;
                    }
                    exec.setnum(this.result, data.getBuildings((Block)block).size);
                }
            }
        }
    }

    public static class CutsceneI
    implements LInstruction {
        public CutsceneAction action = CutsceneAction.stop;
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        public CutsceneI(CutsceneAction action, int p1, int p2, int p3, int p4) {
            this.action = action;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        public CutsceneI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (Vars.headless) {
                return;
            }
            switch (this.action) {
                case pan: {
                    Vars.control.input.logicCutscene = true;
                    Vars.control.input.logicCamPan.set(World.unconv(exec.numf(this.p1)), World.unconv(exec.numf(this.p2)));
                    Vars.control.input.logicCamSpeed = exec.numf(this.p3);
                    break;
                }
                case zoom: {
                    Vars.control.input.logicCutscene = true;
                    Vars.control.input.logicCutsceneZoom = Mathf.clamp(exec.numf(this.p1));
                    break;
                }
                case stop: {
                    Vars.control.input.logicCutscene = false;
                }
            }
        }
    }

    public static class PackColorI
    implements LInstruction {
        public int result;
        public int r;
        public int g;
        public int b;
        public int a;

        public PackColorI(int result, int r, int g, int b, int a) {
            this.result = result;
            this.r = r;
            this.g = g;
            this.b = b;
            this.a = a;
        }

        public PackColorI() {
        }

        @Override
        public void run(LExecutor exec) {
            exec.setnum(this.result, Color.toDoubleBits(Mathf.clamp(exec.numf(this.r)), Mathf.clamp(exec.numf(this.g)), Mathf.clamp(exec.numf(this.b)), Mathf.clamp(exec.numf(this.a))));
        }
    }

    public static class LookupI
    implements LInstruction {
        public int dest;
        public int from;
        public ContentType type;

        public LookupI(int dest, int from, ContentType type) {
            this.dest = dest;
            this.from = from;
            this.type = type;
        }

        public LookupI() {
        }

        @Override
        public void run(LExecutor exec) {
            exec.setobj(this.dest, Vars.logicVars.lookupContent(this.type, exec.numi(this.from)));
        }
    }

    public static class StopI
    implements LInstruction {
        @Override
        public void run(LExecutor exec) {
            exec.var((int)0).numval -= 1.0;
        }
    }

    public static class WaitI
    implements LInstruction {
        public int value;
        public float curTime;
        public long frameId;

        public WaitI(int value) {
            this.value = value;
        }

        public WaitI() {
        }

        @Override
        public void run(LExecutor exec) {
            if ((double)this.curTime >= exec.num(this.value)) {
                this.curTime = 0.0f;
            } else {
                exec.var((int)0).numval -= 1.0;
            }
            if (Vars.state.updateId != this.frameId) {
                this.curTime += Time.delta / 60.0f;
                this.frameId = Vars.state.updateId;
            }
        }
    }

    public static class JumpI
    implements LInstruction {
        public ConditionOp op = ConditionOp.notEqual;
        public int value;
        public int compare;
        public int address;

        public JumpI(ConditionOp op, int value, int compare, int address) {
            this.op = op;
            this.value = value;
            this.compare = compare;
            this.address = address;
        }

        public JumpI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (this.address != -1) {
                Var va = exec.var(this.value);
                Var vb = exec.var(this.compare);
                boolean cmp = this.op == ConditionOp.strictEqual ? va.isobj == vb.isobj && (va.isobj && va.objval == vb.objval || !va.isobj && va.numval == vb.numval) : (this.op.objFunction != null && va.isobj && vb.isobj ? this.op.objFunction.get(exec.obj(this.value), exec.obj(this.compare)) : this.op.function.get(exec.num(this.value), exec.num(this.compare)));
                if (cmp) {
                    exec.var((int)0).numval = this.address;
                }
            }
        }
    }

    public static class PrintFlushI
    implements LInstruction {
        public int target;

        public PrintFlushI(int target) {
            this.target = target;
        }

        public PrintFlushI() {
        }

        @Override
        public void run(LExecutor exec) {
            Building building = exec.building(this.target);
            if (building instanceof MessageBlock.MessageBuild) {
                MessageBlock.MessageBuild d = (MessageBlock.MessageBuild)building;
                if (d.team == exec.team || exec.privileged) {
                    d.message.setLength(0);
                    d.message.append(exec.textBuffer, 0, Math.min(exec.textBuffer.length(), 400));
                }
            }
            exec.textBuffer.setLength(0);
        }
    }

    public static class PrintI
    implements LInstruction {
        public int value;

        public PrintI(int value) {
            this.value = value;
        }

        PrintI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (exec.textBuffer.length() >= 400) {
                return;
            }
            Var v = exec.var(this.value);
            if (v.isobj && this.value != 0) {
                String strValue = PrintI.toString(v.objval);
                exec.textBuffer.append(strValue);
            } else if (Math.abs(v.numval - (double)((long)v.numval)) < 1.0E-5) {
                exec.textBuffer.append((long)v.numval);
            } else {
                exec.textBuffer.append(v.numval);
            }
        }

        public static String toString(Object obj) {
            String string;
            if (obj == null) {
                string = "null";
            } else if (obj instanceof String) {
                String s;
                string = s = (String)obj;
            } else if (obj == Blocks.stoneWall) {
                string = "solid";
            } else if (obj instanceof MappableContent) {
                MappableContent content = (MappableContent)obj;
                string = content.name;
            } else if (obj instanceof Content) {
                string = "[content]";
            } else if (obj instanceof Building) {
                Building build = (Building)obj;
                string = build.block.name;
            } else if (obj instanceof Unit) {
                Unit unit = (Unit)obj;
                string = unit.type.name;
            } else if (obj instanceof Enum) {
                Enum e = (Enum)obj;
                string = e.name();
            } else if (obj instanceof Team) {
                Team team = (Team)obj;
                string = team.name;
            } else {
                string = "[object]";
            }
            return string;
        }
    }

    public static class DrawFlushI
    implements LInstruction {
        public int target;

        public DrawFlushI(int target) {
            this.target = target;
        }

        public DrawFlushI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (Vars.headless) {
                return;
            }
            Building building = exec.building(this.target);
            if (building instanceof LogicDisplay.LogicDisplayBuild) {
                LogicDisplay.LogicDisplayBuild d = (LogicDisplay.LogicDisplayBuild)building;
                if (d.team == exec.team || exec.privileged) {
                    if (d.commands.size + exec.graphicsBuffer.size < 1024) {
                        for (int i = 0; i < exec.graphicsBuffer.size; ++i) {
                            d.commands.addLast(exec.graphicsBuffer.items[i]);
                        }
                    }
                    exec.graphicsBuffer.clear();
                }
            }
        }
    }

    public static class DrawI
    implements LInstruction {
        public byte type;
        public int target;
        public int x;
        public int y;
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        public DrawI(byte type, int target, int x, int y, int p1, int p2, int p3, int p4) {
            this.type = type;
            this.target = target;
            this.x = x;
            this.y = y;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        public DrawI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (Vars.headless || exec.graphicsBuffer.size >= 256) {
                return;
            }
            int num1 = exec.numi(this.p1);
            if (this.type == 10) {
                int n;
                Object object = exec.obj(this.p1);
                if (object instanceof UnlockableContent) {
                    UnlockableContent u = (UnlockableContent)object;
                    n = u.iconId;
                } else {
                    n = num1 = 0;
                }
            }
            if (this.type == 2) {
                double packed = exec.num(this.x);
                int value = (int)Double.doubleToRawLongBits(packed);
                int r = (value & 0xFF000000) >>> 24;
                int g = (value & 0xFF0000) >>> 16;
                int b = (value & 0xFF00) >>> 8;
                int a = value & 0xFF;
                exec.graphicsBuffer.add(DisplayCmd.get((byte)1, DrawI.pack(r), DrawI.pack(g), DrawI.pack(b), DrawI.pack(a), 0, 0));
            } else {
                exec.graphicsBuffer.add(DisplayCmd.get(this.type, DrawI.packSign(exec.numi(this.x)), DrawI.packSign(exec.numi(this.y)), DrawI.packSign(num1), DrawI.packSign(exec.numi(this.p2)), DrawI.packSign(exec.numi(this.p3)), DrawI.packSign(exec.numi(this.p4))));
            }
        }

        static int pack(int value) {
            return value & 0x1FF;
        }

        static int packSign(int value) {
            return Math.abs(value) & 0x1FF | (value < 0 ? 512 : 0);
        }
    }

    public static class NoopI
    implements LInstruction {
        @Override
        public void run(LExecutor exec) {
        }
    }

    public static class EndI
    implements LInstruction {
        @Override
        public void run(LExecutor exec) {
            exec.var((int)0).numval = exec.instructions.length;
        }
    }

    public static class OpI
    implements LInstruction {
        public LogicOp op = LogicOp.add;
        public int a;
        public int b;
        public int dest;

        public OpI(LogicOp op, int a, int b, int dest) {
            this.op = op;
            this.a = a;
            this.b = b;
            this.dest = dest;
        }

        OpI() {
        }

        @Override
        public void run(LExecutor exec) {
            if (this.op == LogicOp.strictEqual) {
                Var v = exec.var(this.a);
                Var v2 = exec.var(this.b);
                exec.setnum(this.dest, v.isobj == v2.isobj && (v.isobj && Structs.eq(v.objval, v2.objval) || !v.isobj && v.numval == v2.numval) ? 1.0 : 0.0);
            } else if (this.op.unary) {
                exec.setnum(this.dest, this.op.function1.get(exec.num(this.a)));
            } else {
                Var va = exec.var(this.a);
                Var vb = exec.var(this.b);
                if (this.op.objFunction2 != null && va.isobj && vb.isobj) {
                    exec.setnum(this.dest, this.op.objFunction2.get(exec.obj(this.a), exec.obj(this.b)));
                } else {
                    exec.setnum(this.dest, this.op.function2.get(exec.num(this.a), exec.num(this.b)));
                }
            }
        }
    }

    public static class SetI
    implements LInstruction {
        public int from;
        public int to;

        public SetI(int from, int to) {
            this.from = from;
            this.to = to;
        }

        SetI() {
        }

        @Override
        public void run(LExecutor exec) {
            Var v = exec.var(this.to);
            Var f = exec.var(this.from);
            if (!v.constant) {
                if (f.isobj) {
                    v.objval = f.objval;
                    v.isobj = true;
                } else {
                    v.numval = LExecutor.invalid(f.numval) ? 0.0 : f.numval;
                    v.isobj = false;
                }
            }
        }
    }

    public static class RadarI
    implements LInstruction {
        public RadarTarget target1 = RadarTarget.enemy;
        public RadarTarget target2 = RadarTarget.any;
        public RadarTarget target3 = RadarTarget.any;
        public RadarSort sort = RadarSort.distance;
        public int radar;
        public int sortOrder;
        public int output;
        public Healthc lastTarget;
        public Object lastSourceBuild;
        public Interval timer = new Interval();
        static float bestValue = 0.0f;
        static Unit best = null;

        public RadarI(RadarTarget target1, RadarTarget target2, RadarTarget target3, RadarSort sort, int radar, int sortOrder, int output) {
            this.target1 = target1;
            this.target2 = target2;
            this.target3 = target3;
            this.sort = sort;
            this.radar = radar;
            this.sortOrder = sortOrder;
            this.output = output;
        }

        public RadarI() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run(LExecutor exec) {
            Object base = exec.obj(this.radar);
            int sortDir = exec.bool(this.sortOrder) ? 1 : -1;
            LogicAI ai = null;
            if (base instanceof Ranged) {
                Ranged r = (Ranged)base;
                if ((exec.privileged || r.team() == exec.team) && (base instanceof Building || (ai = UnitControlI.checkLogicAI(exec, base)) != null)) {
                    Healthc targeted;
                    float range = r.range();
                    if (base instanceof Building && (this.timer.get(30.0f) || this.lastSourceBuild != base) || ai != null && ai.checkTargetTimer(this)) {
                        boolean enemies = this.target1 == RadarTarget.enemy || this.target2 == RadarTarget.enemy || this.target3 == RadarTarget.enemy;
                        boolean allies = this.target1 == RadarTarget.ally || this.target2 == RadarTarget.ally || this.target3 == RadarTarget.ally;
                        best = null;
                        bestValue = 0.0f;
                        if (enemies) {
                            Seq<Teams.TeamData> data = Vars.state.teams.present;
                            for (int i = 0; i < data.size; ++i) {
                                if (((Teams.TeamData[])data.items)[i].team == r.team()) continue;
                                this.find(r, range, sortDir, ((Teams.TeamData[])data.items)[i].team);
                            }
                        } else if (!allies) {
                            Seq<Teams.TeamData> data = Vars.state.teams.present;
                            for (int i = 0; i < data.size; ++i) {
                                this.find(r, range, sortDir, ((Teams.TeamData[])data.items)[i].team);
                            }
                        } else {
                            this.find(r, range, sortDir, r.team());
                        }
                        if (ai != null) {
                            ai.execCache.put(this, best);
                        }
                        this.lastSourceBuild = base;
                        this.lastTarget = targeted = best;
                    } else {
                        targeted = ai != null ? (Healthc)ai.execCache.get(this) : this.lastTarget;
                    }
                    exec.setobj(this.output, targeted);
                    return;
                }
            }
            exec.setobj(this.output, null);
        }

        void find(Ranged b, float range, int sortDir, Team team) {
            Units.nearby(team, b.x(), b.y(), range, u -> {
                boolean valid;
                if (!u.within(b, range) || !u.targetable(team) || b == u) {
                    return;
                }
                boolean bl = valid = this.target1.func.get(b.team(), (Unit)u) && this.target2.func.get(b.team(), (Unit)u) && this.target3.func.get(b.team(), (Unit)u);
                if (!valid) {
                    return;
                }
                float val = this.sort.func.get(b, (Unit)u) * (float)sortDir;
                if (val > bestValue || best == null) {
                    bestValue = val;
                    best = u;
                }
            });
        }
    }

    public static class SenseI
    implements LInstruction {
        public int from;
        public int to;
        public int type;

        public SenseI(int from, int to, int type) {
            this.from = from;
            this.to = to;
            this.type = type;
        }

        public SenseI() {
        }

        @Override
        public void run(LExecutor exec) {
            Object target = exec.obj(this.from);
            Object sense = exec.obj(this.type);
            if (target == null && sense == LAccess.dead) {
                exec.setnum(this.to, 1.0);
                return;
            }
            if (target instanceof Senseable) {
                Senseable se = (Senseable)target;
                if (sense instanceof Content) {
                    Content co = (Content)sense;
                    exec.setnum(this.to, se.sense(co));
                } else if (sense instanceof LAccess) {
                    LAccess la = (LAccess)((Object)sense);
                    Object objOut = se.senseObject(la);
                    if (objOut == Senseable.noSensed) {
                        exec.setnum(this.to, se.sense(la));
                    } else {
                        exec.setobj(this.to, objOut);
                    }
                }
            } else {
                exec.setobj(this.to, null);
            }
        }
    }

    public static class WriteI
    implements LInstruction {
        public int target;
        public int position;
        public int value;

        public WriteI(int target, int position, int value) {
            this.target = target;
            this.position = position;
            this.value = value;
        }

        public WriteI() {
        }

        @Override
        public void run(LExecutor exec) {
            int address = exec.numi(this.position);
            Building from = exec.building(this.target);
            if (from instanceof MemoryBlock.MemoryBuild) {
                MemoryBlock.MemoryBuild mem = (MemoryBlock.MemoryBuild)from;
                if ((exec.privileged || from.team == exec.team) && address >= 0 && address < mem.memory.length) {
                    mem.memory[address] = exec.num(this.value);
                }
            }
        }
    }

    public static class ReadI
    implements LInstruction {
        public int target;
        public int position;
        public int output;

        public ReadI(int target, int position, int output) {
            this.target = target;
            this.position = position;
            this.output = output;
        }

        public ReadI() {
        }

        @Override
        public void run(LExecutor exec) {
            int address = exec.numi(this.position);
            Building from = exec.building(this.target);
            if (from instanceof MemoryBlock.MemoryBuild) {
                MemoryBlock.MemoryBuild mem = (MemoryBlock.MemoryBuild)from;
                if (exec.privileged || from.team == exec.team) {
                    exec.setnum(this.output, address < 0 || address >= mem.memory.length ? 0.0 : mem.memory[address]);
                }
            }
        }
    }

    public static class GetLinkI
    implements LInstruction {
        public int output;
        public int index;

        public GetLinkI(int output, int index) {
            this.index = index;
            this.output = output;
        }

        public GetLinkI() {
        }

        @Override
        public void run(LExecutor exec) {
            int address = exec.numi(this.index);
            exec.setobj(this.output, address >= 0 && address < exec.links.length ? exec.links[address] : null);
        }
    }

    public static class ControlI
    implements LInstruction {
        public int target;
        public LAccess type = LAccess.enabled;
        public int p1;
        public int p2;
        public int p3;
        public int p4;

        public ControlI(LAccess type, int target, int p1, int p2, int p3, int p4) {
            this.type = type;
            this.target = target;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
        }

        ControlI() {
        }

        @Override
        public void run(LExecutor exec) {
            Object obj = exec.obj(this.target);
            if (obj instanceof Building) {
                Building b = (Building)obj;
                if (exec.privileged || b.team == exec.team && exec.linkIds.contains(b.id)) {
                    if (this.type == LAccess.enabled && !exec.bool(this.p1)) {
                        b.lastDisabler = exec.build;
                    }
                    if (this.type == LAccess.enabled && exec.bool(this.p1)) {
                        b.noSleep();
                    }
                    if (this.type.isObj && exec.var((int)this.p1).isobj) {
                        b.control(this.type, exec.obj(this.p1), exec.num(this.p2), exec.num(this.p3), exec.num(this.p4));
                    } else {
                        b.control(this.type, exec.num(this.p1), exec.num(this.p2), exec.num(this.p3), exec.num(this.p4));
                    }
                }
            }
        }
    }

    public static class UnitControlI
    implements LInstruction {
        public LUnitControl type = LUnitControl.move;
        public int p1;
        public int p2;
        public int p3;
        public int p4;
        public int p5;

        public UnitControlI(LUnitControl type, int p1, int p2, int p3, int p4, int p5) {
            this.type = type;
            this.p1 = p1;
            this.p2 = p2;
            this.p3 = p3;
            this.p4 = p4;
            this.p5 = p5;
        }

        public UnitControlI() {
        }

        @Nullable
        public static LogicAI checkLogicAI(LExecutor exec, Object unitObj) {
            Unit unit;
            if (unitObj instanceof Unit && (unit = (Unit)unitObj).isValid() && exec.obj(1) == unit && (unit.team == exec.team || exec.privileged) && unit.controller().isLogicControllable()) {
                UnitController unitController = unit.controller();
                if (unitController instanceof LogicAI) {
                    LogicAI la = (LogicAI)unitController;
                    la.controller = exec.building(2);
                    return la;
                }
                LogicAI la = new LogicAI();
                la.controller = exec.building(2);
                unit.controller(la);
                unit.mineTile = null;
                unit.clearBuilding();
                return la;
            }
            return null;
        }

        @Override
        public void run(LExecutor exec) {
            Object unitObj = exec.obj(1);
            LogicAI ai = UnitControlI.checkLogicAI(exec, unitObj);
            if (unitObj instanceof Unit) {
                Unit unit = (Unit)unitObj;
                if (ai != null) {
                    ai.controlTimer = 600.0f;
                    float x1 = World.unconv(exec.numf(this.p1));
                    float y1 = World.unconv(exec.numf(this.p2));
                    float d1 = World.unconv(exec.numf(this.p3));
                    switch (this.type) {
                        case idle: 
                        case autoPathfind: {
                            ai.control = this.type;
                            break;
                        }
                        case move: 
                        case stop: 
                        case approach: 
                        case pathfind: {
                            ai.control = this.type;
                            ai.moveX = x1;
                            ai.moveY = y1;
                            if (this.type == LUnitControl.approach) {
                                ai.moveRad = d1;
                            }
                            if (this.type != LUnitControl.stop) break;
                            unit.mineTile = null;
                            unit.clearBuilding();
                            break;
                        }
                        case unbind: {
                            unit.resetController();
                            exec.setobj(1, null);
                            break;
                        }
                        case within: {
                            exec.setnum(this.p4, unit.within(x1, y1, d1) ? 1.0 : 0.0);
                            break;
                        }
                        case target: {
                            ai.posTarget.set(x1, y1);
                            ai.aimControl = this.type;
                            ai.mainTarget = null;
                            ai.shoot = exec.bool(this.p3);
                            break;
                        }
                        case targetp: {
                            Teamc t;
                            ai.aimControl = this.type;
                            Object object = exec.obj(this.p1);
                            ai.mainTarget = object instanceof Teamc ? (t = (Teamc)object) : null;
                            ai.shoot = exec.bool(this.p2);
                            break;
                        }
                        case boost: {
                            ai.boost = exec.bool(this.p1);
                            break;
                        }
                        case flag: {
                            unit.flag = exec.num(this.p1);
                            break;
                        }
                        case mine: {
                            Tile tile = Vars.world.tileWorld(x1, y1);
                            if (!unit.canMine()) break;
                            unit.mineTile = unit.validMine(tile) ? tile : null;
                            break;
                        }
                        case payDrop: {
                            Payloadc pay;
                            if (!exec.timeoutDone(unit, 90.0f)) {
                                return;
                            }
                            if (!(unit instanceof Payloadc) || !(pay = (Payloadc)((Object)unit)).hasPayload()) break;
                            Call.payloadDropped(unit, unit.x, unit.y);
                            exec.updateTimeout(unit);
                            break;
                        }
                        case payTake: {
                            if (!exec.timeoutDone(unit, 90.0f)) {
                                return;
                            }
                            if (!(unit instanceof Payloadc)) break;
                            Payloadc pay = (Payloadc)((Object)unit);
                            if (exec.bool(this.p1)) {
                                Unit result = Units.closest(unit.team, unit.x, unit.y, unit.type.hitSize * 2.0f, u -> u.isAI() && u.isGrounded() && pay.canPickup((Unit)u) && u.within(unit, u.hitSize + unit.hitSize * 1.2f));
                                if (result != null) {
                                    Call.pickedUnitPayload(unit, result);
                                }
                            } else {
                                Building build = Vars.world.buildWorld(unit.x, unit.y);
                                if (build != null && build.team == unit.team) {
                                    Payload current = build.getPayload();
                                    if (current != null && pay.canPickupPayload(current)) {
                                        Call.pickedBuildPayload(unit, build, false);
                                    } else if (build.block.buildVisibility != BuildVisibility.hidden && build.canPickup() && pay.canPickup(build)) {
                                        Call.pickedBuildPayload(unit, build, true);
                                    }
                                }
                            }
                            exec.updateTimeout(unit);
                            break;
                        }
                        case payEnter: {
                            Building build = Vars.world.buildWorld(unit.x, unit.y);
                            if (build == null || unit.team() != build.team || !build.canControlSelect(unit)) break;
                            Call.unitBuildingControlSelect(unit, build);
                            break;
                        }
                        case build: {
                            Object object;
                            Block block;
                            Object build;
                            if (!Vars.state.rules.logicUnitBuild && !exec.privileged || !unit.canBuild() || !((build = exec.obj(this.p3)) instanceof Block) || !(block = (Block)build).canBeBuilt() || !block.unlockedNow() && !unit.team.isAI()) break;
                            int x = World.toTile(x1 - block.offset / 8.0f);
                            int y = World.toTile(y1 - block.offset / 8.0f);
                            int rot = Mathf.mod(exec.numi(this.p4), 4);
                            if (ai.plan.x != x || ai.plan.y != y || ai.plan.block != block || unit.plans.isEmpty()) {
                                ai.plan.progress = 0.0f;
                                ai.plan.initialized = false;
                                ai.plan.stuck = false;
                            }
                            Object conf = exec.obj(this.p5);
                            ai.plan.set(x, y, rot, block);
                            BuildPlan buildPlan = ai.plan;
                            if (conf instanceof Content) {
                                Content c = (Content)conf;
                                object = c;
                            } else if (conf instanceof Building) {
                                Building b = (Building)conf;
                                object = b;
                            } else {
                                object = null;
                            }
                            buildPlan.config = object;
                            unit.clearBuilding();
                            Tile tile = ai.plan.tile();
                            if (tile == null || tile.block() == block && tile.build != null && tile.build.rotation == rot) break;
                            unit.updateBuilding = true;
                            unit.addBuild(ai.plan);
                            break;
                        }
                        case getBlock: {
                            float range = Math.max(unit.range(), unit.type.buildRange);
                            if (!unit.within(x1, y1, range)) {
                                exec.setobj(this.p3, null);
                                exec.setobj(this.p4, null);
                                exec.setobj(this.p5, null);
                                break;
                            }
                            Tile tile = Vars.world.tileWorld(x1, y1);
                            if (tile == null) {
                                exec.setobj(this.p3, null);
                                exec.setobj(this.p4, null);
                                exec.setobj(this.p5, null);
                                break;
                            }
                            Block block = !tile.synthetic() ? (tile.solid() ? Blocks.stoneWall : Blocks.air) : tile.block();
                            exec.setobj(this.p3, block);
                            exec.setobj(this.p4, tile.build != null ? tile.build : null);
                            exec.setobj(this.p5, tile.overlay() == Blocks.air ? tile.floor() : tile.overlay());
                            break;
                        }
                        case itemDrop: {
                            int accepted;
                            if (!exec.timeoutDone(unit, 90.0f)) {
                                return;
                            }
                            if (exec.obj(this.p1) == Blocks.air) {
                                if (!Vars.net.client()) {
                                    unit.clearItem();
                                }
                                exec.updateTimeout(unit);
                                break;
                            }
                            Building build = exec.building(this.p1);
                            int dropped = Math.min(unit.stack.amount, exec.numi(this.p2));
                            if (build == null || build.team != unit.team || !build.isValid() || dropped <= 0 || !unit.within(build, 45.0f + (float)(build.block.size * 8) / 2.0f) || (accepted = build.acceptStack(unit.item(), dropped, unit)) <= 0) break;
                            Call.transferItemTo(unit, unit.item(), accepted, unit.x, unit.y, build);
                            exec.updateTimeout(unit);
                            break;
                        }
                        case itemTake: {
                            int taken;
                            Object rot;
                            if (!exec.timeoutDone(unit, 90.0f)) {
                                return;
                            }
                            Building build = exec.building(this.p1);
                            int amount = exec.numi(this.p3);
                            if (build == null || build.team != unit.team || !build.isValid() || build.items == null || !((rot = exec.obj(this.p2)) instanceof Item)) break;
                            Item item = (Item)rot;
                            if (!unit.within(build, 45.0f + (float)(build.block.size * 8) / 2.0f) || (taken = Math.min(build.items.get(item), Math.min(amount, unit.maxAccepted(item)))) <= 0) break;
                            Call.takeItems(build, item, taken, unit);
                            exec.updateTimeout(unit);
                            break;
                        }
                    }
                }
            }
        }
    }

    public static class UnitLocateI
    implements LInstruction {
        public LLocate locate = LLocate.building;
        public BlockFlag flag = BlockFlag.core;
        public int enemy;
        public int ore;
        public int outX;
        public int outY;
        public int outFound;
        public int outBuild;

        public UnitLocateI(LLocate locate, BlockFlag flag, int enemy, int ore, int outX, int outY, int outFound, int outBuild) {
            this.locate = locate;
            this.flag = flag;
            this.enemy = enemy;
            this.ore = ore;
            this.outX = outX;
            this.outY = outY;
            this.outFound = outFound;
            this.outBuild = outBuild;
        }

        public UnitLocateI() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run(LExecutor exec) {
            Object unitObj = exec.obj(1);
            LogicAI ai = UnitControlI.checkLogicAI(exec, unitObj);
            if (unitObj instanceof Unit) {
                Unit unit = (Unit)unitObj;
                if (ai != null) {
                    ai.controlTimer = 600.0f;
                    Cache cache = (Cache)((Object)ai.execCache.get((Object)this, Cache::new));
                    if (!ai.checkTargetTimer(this)) {
                        exec.setobj(this.outBuild, cache.build);
                        exec.setbool(this.outFound, cache.found);
                        exec.setnum(this.outX, cache.x);
                        exec.setnum(this.outY, cache.y);
                        return;
                    }
                    Tile res = null;
                    boolean build = false;
                    switch (this.locate) {
                        case ore: {
                            Object object = exec.obj(this.ore);
                            if (!(object instanceof Item)) break;
                            Item item = (Item)object;
                            res = Vars.indexer.findClosestOre(unit, item);
                            break;
                        }
                        case building: {
                            Building b = Geometry.findClosest(unit.x, unit.y, exec.bool(this.enemy) ? Vars.indexer.getEnemy(unit.team, this.flag) : Vars.indexer.getFlagged(unit.team, this.flag));
                            res = b == null ? null : b.tile;
                            build = true;
                            break;
                        }
                        case spawn: {
                            res = Geometry.findClosest(unit.x, unit.y, Vars.spawner.getSpawns());
                            break;
                        }
                        case damaged: {
                            Building b = Units.findDamagedTile(unit.team, unit.x, unit.y);
                            res = b == null ? null : b.tile;
                            build = true;
                            break;
                        }
                    }
                    if (!(res == null || build && res.build == null)) {
                        cache.found = true;
                        cache.x = World.conv(build ? res.build.x : res.worldx());
                        exec.setnum(this.outX, cache.x);
                        cache.y = World.conv(build ? res.build.y : res.worldy());
                        exec.setnum(this.outY, cache.y);
                        exec.setnum(this.outFound, 1.0);
                    } else {
                        cache.found = false;
                        exec.setnum(this.outFound, 0.0);
                    }
                    if (res != null && res.build != null && (unit.within(res.build.x, res.build.y, Math.max(unit.range(), 220.0f)) || res.build.team == exec.team)) {
                        cache.build = res.build;
                        exec.setobj(this.outBuild, res.build);
                        return;
                    }
                    exec.setobj(this.outBuild, null);
                    return;
                }
            }
            exec.setbool(this.outFound, false);
        }

        static class Cache {
            float x;
            float y;
            boolean found;
            Building build;

            Cache() {
            }
        }
    }

    public static class UnitBindI
    implements LInstruction {
        public int type;

        public UnitBindI(int type) {
            this.type = type;
        }

        public UnitBindI() {
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void run(LExecutor exec) {
            Object object;
            if (exec.binds == null || exec.binds.length != Vars.content.units().size) {
                exec.binds = new int[Vars.content.units().size];
            }
            if ((object = exec.obj(this.type)) instanceof UnitType) {
                UnitType type = (UnitType)object;
                if (type.logicControllable) {
                    Seq<Unit> seq = exec.team.data().unitCache(type);
                    if (seq != null && seq.any()) {
                        short s = type.id;
                        exec.binds[s] = exec.binds[s] % seq.size;
                        if (exec.binds[type.id] < seq.size) {
                            exec.setconst(1, seq.get(exec.binds[type.id]));
                        }
                        short s2 = type.id;
                        exec.binds[s2] = exec.binds[s2] + 1;
                        return;
                    }
                    exec.setconst(1, null);
                    return;
                }
            }
            if ((object = exec.obj(this.type)) instanceof Unit) {
                Unit u = (Unit)object;
                if ((u.team == exec.team || exec.privileged) && u.type.logicControllable) {
                    exec.setconst(1, u);
                    return;
                }
            }
            exec.setconst(1, null);
        }
    }
}

