/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.func.Cons;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.input.KeyCode;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.Group;
import arc.scene.Scene;
import arc.scene.event.ClickListener;
import arc.scene.event.ElementGestureListener;
import arc.scene.event.EventListener;
import arc.scene.event.HandCursorListener;
import arc.scene.event.InputEvent;
import arc.scene.event.InputListener;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.ImageButton;
import arc.scene.ui.Label;
import arc.scene.ui.ScrollPane;
import arc.scene.ui.Tooltip;
import arc.scene.ui.layout.Cell;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Pal;
import mindustry.logic.LAssembler;
import mindustry.logic.LStatement;
import mindustry.logic.LStatements;
import mindustry.ui.Styles;

public class LCanvas
extends Table {
    public static final int maxJumpsDrawn = 100;
    static LCanvas canvas;
    public DragLayout statements;
    public ScrollPane pane;
    public Group jumps;
    StatementElem dragging;
    StatementElem hovered;
    float targetWidth;
    int jumpCount = 0;
    boolean privileged;
    Seq<Tooltip> tooltips = new Seq();

    public LCanvas() {
        canvas = this;
        Core.scene.addListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                for (Tooltip t : LCanvas.this.tooltips) {
                    t.container.toFront();
                }
                Core.app.post(() -> {
                    LCanvas.this.tooltips.each(Tooltip::hide);
                    LCanvas.this.tooltips.clear();
                });
                return super.touchDown(event, x, y, pointer, button);
            }
        });
        this.rebuild();
    }

    public static boolean useRows() {
        return (float)Core.graphics.getWidth() < Scl.scl(900.0f) * 1.2f;
    }

    public static void tooltip(final Cell<?> cell, String key) {
        String lkey = key.toLowerCase().replace(" ", "");
        if (Core.settings.getBool("logichints", true) && Core.bundle.has(lkey)) {
            final Tooltip tip = new Tooltip(t -> t.background(Styles.black8).margin(4.0f).add("[lightgray]" + Core.bundle.get(lkey)).style(Styles.outlineLabel));
            if (Vars.mobile) {
                ((Element)cell.get()).addListener(new ElementGestureListener(20.0f, 0.4f, 0.43f, 0.15f){

                    @Override
                    public boolean longPress(Element element, float x, float y) {
                        tip.show(element, x, y);
                        LCanvas.canvas.tooltips.add(tip);
                        for (EventListener list : ((Element)cell.get()).getListeners()) {
                            if (!(list instanceof ClickListener)) continue;
                            ClickListener cl = (ClickListener)list;
                            cl.cancel();
                        }
                        return true;
                    }
                });
            } else {
                ((Element)cell.get()).addListener(tip);
            }
        }
    }

    public static void tooltip(Cell<?> cell, Enum<?> key) {
        String cl = key.getClass().getSimpleName().toLowerCase() + "." + key.name().toLowerCase();
        if (Core.bundle.has(cl)) {
            LCanvas.tooltip(cell, cl);
        } else {
            LCanvas.tooltip(cell, "lenum." + key.name());
        }
    }

    public void rebuild() {
        this.targetWidth = LCanvas.useRows() ? 400.0f : 900.0f;
        float s = this.pane != null ? this.pane.getVisualScrollY() : 0.0f;
        String toLoad = this.statements != null ? this.save() : null;
        this.clear();
        this.statements = new DragLayout();
        this.jumps = new WidgetGroup();
        this.pane = this.pane((Table t) -> {
            t.center();
            t.add(this.statements).pad(2.0f).center().width(this.targetWidth);
            t.addChild(this.jumps);
            this.jumps.cullable = false;
        }).grow().get();
        this.pane.setFlickScroll(false);
        this.pane.setScrollYForce(s);
        this.pane.updateVisualScroll();
        Core.app.post(() -> {
            this.pane.setScrollYForce(s);
            this.pane.updateVisualScroll();
        });
        if (toLoad != null) {
            this.load(toLoad);
        }
    }

    @Override
    public void draw() {
        this.jumpCount = 0;
        super.draw();
    }

    public void add(LStatement statement) {
        this.statements.addChild(new StatementElem(statement));
    }

    public String save() {
        Seq<LStatement> st = this.statements.getChildren().as().map(s -> s.st);
        st.each(LStatement::saveUI);
        return LAssembler.write(st);
    }

    public void load(String asm) {
        this.jumps.clear();
        Seq<LStatement> statements = LAssembler.read(asm, this.privileged);
        statements.truncate(1000);
        this.statements.clearChildren();
        for (LStatement st : statements) {
            this.add(st);
        }
        for (LStatement st : statements) {
            st.setupUI();
        }
        this.statements.layout();
    }

    StatementElem checkHovered() {
        Element e = Core.scene.hit(Core.input.mouseX(), Core.input.mouseY(), true);
        if (e != null) {
            while (e != null && !(e instanceof StatementElem)) {
                e = e.parent;
            }
        }
        if (e == null || this.isDescendantOf(e)) {
            return null;
        }
        return (StatementElem)e;
    }

    @Override
    public void act(float delta) {
        float y;
        float dst;
        super.act(delta);
        this.hovered = this.checkHovered();
        if (Core.input.isTouched() && (dst = Math.min((y = (float)Core.input.mouseY()) - this.y, (float)Core.graphics.getHeight() - y)) < Scl.scl(100.0f)) {
            int sign = Mathf.sign((float)Core.graphics.getHeight() / 2.0f - y);
            this.pane.setScrollY(this.pane.getScrollY() + (float)sign * Scl.scl(15.0f) * Time.delta);
        }
    }

    public class DragLayout
    extends WidgetGroup {
        float space = Scl.scl(10.0f);
        float prefWidth;
        float prefHeight;
        Seq<Element> seq = new Seq();
        int insertPosition = 0;
        boolean invalidated;

        public DragLayout() {
            this.setTransform(true);
        }

        @Override
        public void layout() {
            float totalHeight;
            this.invalidated = true;
            float cy = 0.0f;
            this.seq.clear();
            this.height = this.prefHeight = (totalHeight = this.getChildren().sumf(e -> e.getHeight() + this.space));
            this.width = this.prefWidth = Scl.scl(LCanvas.this.targetWidth);
            for (int i = 0; i < this.getChildren().size; ++i) {
                Element e2 = (Element)this.getChildren().get(i);
                if (LCanvas.this.dragging == e2) continue;
                e2.setSize(this.width, e2.getPrefHeight());
                e2.setPosition(0.0f, this.height - cy, 10);
                ((StatementElem)e2).updateAddress(i);
                cy += e2.getPrefHeight() + this.space;
                this.seq.add(e2);
            }
            if (LCanvas.this.dragging != null) {
                float realY = LCanvas.this.dragging.getY(2) + LCanvas.this.dragging.translation.y;
                this.insertPosition = 0;
                for (int i = 0; i < this.seq.size; ++i) {
                    Element cur = this.seq.get(i);
                    if (!(realY < cur.y) || i != this.seq.size - 1 && !(realY > this.seq.get((int)(i + 1)).y)) continue;
                    this.insertPosition = i + 1;
                    break;
                }
                float shiftAmount = LCanvas.this.dragging.getHeight() + this.space;
                for (int i = this.insertPosition; i < this.seq.size; ++i) {
                    this.seq.get((int)i).y -= shiftAmount;
                }
            }
            this.invalidateHierarchy();
            if (this.parent != null && this.parent instanceof Table) {
                this.setCullingArea(this.parent.getCullingArea());
            }
        }

        @Override
        public float getPrefWidth() {
            return this.prefWidth;
        }

        @Override
        public float getPrefHeight() {
            return this.prefHeight;
        }

        @Override
        public void draw() {
            Draw.alpha(this.parentAlpha);
            if (LCanvas.this.dragging != null && this.insertPosition <= this.seq.size) {
                float shiftAmount = LCanvas.this.dragging.getHeight();
                float lastX = this.x;
                float lastY = this.insertPosition == 0 ? this.height + this.y : this.seq.get((int)(this.insertPosition - 1)).y + this.y - this.space;
                Tex.pane.draw(lastX, lastY - shiftAmount, this.width, LCanvas.this.dragging.getHeight());
            }
            if (this.invalidated) {
                this.children.each(c -> {
                    c.cullable = false;
                });
            }
            super.draw();
            if (this.invalidated) {
                this.children.each(c -> {
                    c.cullable = true;
                });
                this.invalidated = false;
            }
        }

        void finishLayout() {
            if (LCanvas.this.dragging != null) {
                int i;
                for (Element child : this.getChildren()) {
                    child.setTranslation(0.0f, 0.0f);
                }
                this.clearChildren();
                for (i = 0; i <= this.insertPosition - 1 && i < this.seq.size; ++i) {
                    this.addChild(this.seq.get(i));
                }
                this.addChild(LCanvas.this.dragging);
                for (i = this.insertPosition; i < this.seq.size; ++i) {
                    this.addChild(this.seq.get(i));
                }
                LCanvas.this.dragging = null;
            }
            this.layout();
        }
    }

    public class StatementElem
    extends Table {
        public LStatement st;
        public int index;
        Label addressLabel;

        public StatementElem(LStatement st) {
            this.st = st;
            st.elem = this;
            this.background(Tex.whitePane);
            this.setColor(st.category().color);
            this.margin(0.0f);
            this.touchable = Touchable.enabled;
            this.table(Tex.whiteui, t -> {
                t.color.set(this.color);
                t.addListener(new HandCursorListener());
                t.margin(6.0f);
                t.touchable = Touchable.enabled;
                t.add(st.name()).style(Styles.outlineLabel).name("statement-name").color(this.color).padRight(8.0f);
                t.add().growX();
                this.addressLabel = t.add(this.index + "").style(Styles.outlineLabel).color(this.color).padRight(8.0f).get();
                t.button((Drawable)Icon.copy, Styles.logici, () -> {}).size(24.0f).padRight(6.0f).get().tapped(this::copy);
                t.button((Drawable)Icon.cancel, Styles.logici, () -> {
                    this.remove();
                    LCanvas.this.dragging = null;
                    LCanvas.this.statements.layout();
                }).size(24.0f);
                t.addListener(new InputListener(){
                    float lastx;
                    float lasty;

                    @Override
                    public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode button) {
                        if (button == KeyCode.mouseMiddle) {
                            StatementElem.this.copy();
                            return false;
                        }
                        Vec2 v = StatementElem.this.localToParentCoordinates(Tmp.v1.set(x, y));
                        this.lastx = v.x;
                        this.lasty = v.y;
                        LCanvas.this.dragging = StatementElem.this;
                        StatementElem.this.toFront();
                        LCanvas.this.statements.layout();
                        return true;
                    }

                    @Override
                    public void touchDragged(InputEvent event, float x, float y, int pointer) {
                        Vec2 v = StatementElem.this.localToParentCoordinates(Tmp.v1.set(x, y));
                        StatementElem.this.translation.add(v.x - this.lastx, v.y - this.lasty);
                        this.lastx = v.x;
                        this.lasty = v.y;
                        LCanvas.this.statements.layout();
                    }

                    @Override
                    public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode button) {
                        LCanvas.this.statements.finishLayout();
                    }
                });
            }).growX().height(38.0f);
            this.row();
            this.table((Table t) -> {
                t.left();
                t.marginLeft(4.0f);
                t.setColor(this.color);
                st.build((Table)t);
            }).pad(4.0f).padTop(2.0f).left().grow();
            this.marginBottom(7.0f);
        }

        public void updateAddress(int index) {
            this.index = index;
            this.addressLabel.setText(index + "");
        }

        public void copy() {
            this.st.saveUI();
            LStatement copy = this.st.copy();
            if (copy instanceof LStatements.JumpStatement) {
                int index;
                LStatements.JumpStatement st = (LStatements.JumpStatement)copy;
                if (st.destIndex != -1 && (index = LCanvas.this.statements.getChildren().indexOf(this)) != -1 && index < st.destIndex) {
                    ++st.destIndex;
                }
            }
            if (copy != null) {
                StatementElem s = new StatementElem(copy);
                LCanvas.this.statements.addChildAfter(this, s);
                LCanvas.this.statements.layout();
                copy.elem = s;
                copy.setupUI();
            }
        }

        @Override
        public void draw() {
            float pad = 5.0f;
            Fill.dropShadow(this.x + this.width / 2.0f, this.y + this.height / 2.0f, this.width + pad, this.height + pad, 10.0f, 0.9f * this.parentAlpha);
            Draw.color(0.0f, 0.0f, 0.0f, 0.3f * this.parentAlpha);
            Fill.crect(this.x, this.y, this.width, this.height);
            Draw.reset();
            super.draw();
        }
    }

    public static class JumpCurve
    extends Element {
        public JumpButton button;

        public JumpCurve(JumpButton button) {
            this.button = button;
        }

        @Override
        public void act(float delta) {
            super.act(delta);
            if (this.button.listener.isOver()) {
                this.toFront();
            }
        }

        @Override
        public void draw() {
            ++LCanvas.canvas.jumpCount;
            if (LCanvas.canvas.jumpCount > 100 && !this.button.selecting && !this.button.listener.isOver()) {
                return;
            }
            Element hover = this.button.to.get() == null && this.button.selecting ? LCanvas.canvas.hovered : (Element)this.button.to.get();
            boolean draw = false;
            Vec2 t = Tmp.v1;
            Vec2 r = Tmp.v2;
            ScrollPane desc = LCanvas.canvas.pane;
            this.button.localToAscendantCoordinates(desc, r.set(0.0f, 0.0f));
            if (hover != null) {
                hover.localToAscendantCoordinates(desc, t.set(hover.getWidth(), hover.getHeight() / 2.0f));
                draw = true;
            } else if (this.button.selecting) {
                t.set(r).add(this.button.mx, this.button.my);
                draw = true;
            }
            float offset = LCanvas.canvas.pane.getVisualScrollY() - LCanvas.canvas.pane.getMaxY();
            t.y += offset;
            r.y += offset;
            if (draw) {
                this.drawCurve(r.x + this.button.getWidth() / 2.0f, r.y + this.button.getHeight() / 2.0f, t.x, t.y);
                float s = this.button.getWidth();
                Draw.color(this.button.color);
                Tex.logicNode.draw(t.x + s * 0.75f, t.y - s / 2.0f, -s, s);
                Draw.reset();
            }
        }

        public void drawCurve(float x, float y, float x2, float y2) {
            Lines.stroke(4.0f, this.button.color);
            Draw.alpha(this.parentAlpha);
            float dist = 100.0f;
            Lines.curve(x, y, x + dist, y, x2 + dist, y2, x2, y2, Math.max(18, (int)(Mathf.dst(x, y, x2, y2) / 6.0f)));
        }
    }

    public static class JumpButton
    extends ImageButton {
        Color hoverColor = Pal.place;
        Color defaultColor = Color.white;
        Prov<StatementElem> to;
        boolean selecting;
        float mx;
        float my;
        ClickListener listener;
        public JumpCurve curve;

        public JumpButton(Prov<StatementElem> getter, final Cons<StatementElem> setter) {
            super(Tex.logicNode, new ImageButton.ImageButtonStyle(){
                {
                    this.imageUpColor = Color.white;
                }
            });
            this.to = getter;
            this.listener = new ClickListener();
            this.addListener(this.listener);
            this.addListener(new InputListener(){

                @Override
                public boolean touchDown(InputEvent event, float x, float y, int pointer, KeyCode code) {
                    selecting = true;
                    setter.get(null);
                    mx = x;
                    my = y;
                    return true;
                }

                @Override
                public void touchDragged(InputEvent event, float x, float y, int pointer) {
                    mx = x;
                    my = y;
                }

                @Override
                public void touchUp(InputEvent event, float x, float y, int pointer, KeyCode code) {
                    this.localToStageCoordinates(Tmp.v1.set(x, y));
                    StatementElem elem = LCanvas.canvas.hovered;
                    if (elem != null && !this.isDescendantOf(elem)) {
                        setter.get(elem);
                    } else {
                        setter.get(null);
                    }
                    selecting = false;
                }
            });
            this.update(() -> {
                if (this.to.get() != null && this.to.get().parent == null) {
                    setter.get(null);
                }
                this.setColor(this.listener.isOver() ? this.hoverColor : this.defaultColor);
                this.getStyle().imageUpColor = this.color;
            });
            this.curve = new JumpCurve(this);
        }

        @Override
        protected void setScene(Scene stage) {
            super.setScene(stage);
            if (stage == null) {
                this.curve.remove();
            } else {
                LCanvas.canvas.jumps.addChild(this.curve);
            }
        }
    }
}

