/*
 * Decompiled with CFR 0.152.
 */
package mindustry.logic;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Colors;
import arc.math.Rand;
import arc.struct.ObjectIntMap;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Nullable;
import arc.util.Strings;
import java.io.DataInputStream;
import java.io.IOException;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.game.Team;
import mindustry.logic.LAccess;
import mindustry.logic.LExecutor;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.UnitType;
import mindustry.world.Block;
import mindustry.world.blocks.legacy.LegacyBlock;

public class GlobalVars {
    public static final int ctrlProcessor = 1;
    public static final int ctrlPlayer = 2;
    public static final int ctrlCommand = 3;
    public static final ContentType[] lookableContent = new ContentType[]{ContentType.block, ContentType.unit, ContentType.item, ContentType.liquid};
    public static final Rand rand = new Rand();
    private static int varTime;
    private static int varTick;
    private static int varSecond;
    private static int varMinute;
    private static int varWave;
    private static int varWaveTime;
    private ObjectIntMap<String> namesToIds = new ObjectIntMap();
    private Seq<LExecutor.Var> vars = new Seq(LExecutor.Var.class);
    private UnlockableContent[][] logicIdToContent;
    private int[][] contentIdToLogicId;

    public void init() {
        this.put("the end", null);
        this.put("false", 0);
        this.put("true", 1);
        this.put("null", null);
        this.put("@pi", Float.valueOf((float)Math.PI));
        this.put("\u03c0", Float.valueOf((float)Math.PI));
        this.put("@e", Float.valueOf((float)Math.E));
        this.put("@degToRad", Float.valueOf((float)Math.PI / 180));
        this.put("@radToDeg", Float.valueOf(57.295776f));
        varTime = this.put("@time", 0);
        varTick = this.put("@tick", 0);
        varSecond = this.put("@second", 0);
        varMinute = this.put("@minute", 0);
        varWave = this.put("@waveNumber", 0);
        varWaveTime = this.put("@waveTime", 0);
        this.put("@ctrlProcessor", 1);
        this.put("@ctrlPlayer", 2);
        this.put("@ctrlCommand", 3);
        for (Team team : Team.baseTeams) {
            this.put("@" + team.name, team);
        }
        for (Item item : Vars.content.items()) {
            this.put("@" + item.name, item);
        }
        for (Liquid liquid : Vars.content.liquids()) {
            this.put("@" + liquid.name, liquid);
        }
        for (Block block : Vars.content.blocks()) {
            if (!(Vars.content.item(block.name) == null & !(block instanceof LegacyBlock))) continue;
            this.put("@" + block.name, block);
        }
        for (ObjectMap.Entry entry : Colors.getColors().entries()) {
            if (Character.isUpperCase(((String)entry.key).charAt(0))) continue;
            this.put("@color" + Strings.capitalize((String)entry.key), ((Color)entry.value).toDoubleBits());
        }
        this.put("@solid", Blocks.stoneWall);
        for (UnitType unitType : Vars.content.units()) {
            this.put("@" + unitType.name, unitType);
        }
        for (LAccess sensor : LAccess.all) {
            this.put("@" + sensor.name(), (Object)sensor);
        }
        this.logicIdToContent = new UnlockableContent[ContentType.all.length][];
        this.contentIdToLogicId = new int[ContentType.all.length][];
        Fi ids = Core.files.internal("logicids.dat");
        if (ids.exists()) {
            try (DataInputStream dataInputStream = new DataInputStream(ids.readByteStream());){
                for (ContentType ctype : lookableContent) {
                    int amount = dataInputStream.readShort();
                    this.logicIdToContent[ctype.ordinal()] = new UnlockableContent[amount];
                    this.contentIdToLogicId[ctype.ordinal()] = new int[Vars.content.getBy((ContentType)ctype).size];
                    this.put("@" + ctype.name() + "Count", (short)amount);
                    for (int i = 0; i < amount; ++i) {
                        String name = dataInputStream.readUTF();
                        UnlockableContent fetched = (UnlockableContent)Vars.content.getByName(ctype, name);
                        if (fetched == null) continue;
                        this.logicIdToContent[ctype.ordinal()][i] = fetched;
                        this.contentIdToLogicId[ctype.ordinal()][fetched.id] = i;
                    }
                }
            }
            catch (IOException iOException) {
                Log.err("Error reading logic ID mapping", iOException);
            }
        }
    }

    public void update() {
        ((LExecutor.Var[])this.vars.items)[GlobalVars.varTime].numval = Vars.state.tick / 60.0 * 1000.0;
        ((LExecutor.Var[])this.vars.items)[GlobalVars.varTick].numval = Vars.state.tick;
        ((LExecutor.Var[])this.vars.items)[GlobalVars.varSecond].numval = Vars.state.tick / 60.0;
        ((LExecutor.Var[])this.vars.items)[GlobalVars.varMinute].numval = Vars.state.tick / 60.0 / 60.0;
        ((LExecutor.Var[])this.vars.items)[GlobalVars.varWave].numval = Vars.state.wave;
        ((LExecutor.Var[])this.vars.items)[GlobalVars.varWaveTime].numval = Vars.state.wavetime / 60.0f;
    }

    @Nullable
    public Content lookupContent(ContentType type, int id) {
        UnlockableContent[] arr = this.logicIdToContent[type.ordinal()];
        return arr != null && id >= 0 && id < arr.length ? arr[id] : null;
    }

    public int lookupLogicId(UnlockableContent content) {
        int[] arr = this.contentIdToLogicId[content.getContentType().ordinal()];
        return arr != null && content.id >= 0 && content.id < arr.length ? arr[content.id] : -1;
    }

    public int get(String name) {
        return this.namesToIds.get(name, -1);
    }

    public LExecutor.Var get(int id) {
        return ((LExecutor.Var[])this.vars.items)[id];
    }

    public void set(int id, double value) {
        this.get((int)id).numval = value;
    }

    public int put(String name, Object value) {
        int existingIdx = this.namesToIds.get(name, -1);
        if (existingIdx != -1) {
            Log.debug("Failed to add global logic variable '@', as it already exists.", name);
            return existingIdx;
        }
        LExecutor.Var var = new LExecutor.Var(name);
        var.constant = true;
        if (value instanceof Number) {
            Number num = (Number)value;
            var.numval = num.doubleValue();
        } else {
            var.isobj = true;
            var.objval = value;
        }
        int index = this.vars.size;
        this.namesToIds.put(name, index);
        this.vars.add(var);
        return index;
    }
}

