/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.PixmapPacker;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureAtlas;
import arc.struct.ObjectSet;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Nullable;
import mindustry.Vars;

public class MultiPacker
implements Disposable {
    private PixmapPacker[] packers = new PixmapPacker[PageType.all.length];
    private ObjectSet<String> outlined = new ObjectSet();

    public MultiPacker() {
        for (int i = 0; i < this.packers.length; ++i) {
            this.packers[i] = new PixmapPacker(Math.min(Vars.maxTextureSize, PageType.all[i].width), Math.min(Vars.maxTextureSize, PageType.all[i].height), 2, true);
        }
    }

    @Nullable
    public PixmapRegion get(String name) {
        for (PixmapPacker packer : this.packers) {
            PixmapRegion region = packer.getRegion(name);
            if (region == null) continue;
            return region;
        }
        return null;
    }

    public void printStats() {
        if (Log.level != Log.LogLevel.debug) {
            return;
        }
        for (PageType type : PageType.all) {
            PixmapPacker packer = this.packers[type.ordinal()];
            Log.debug("[Atlas] [&ly@&fr]", new Object[]{type});
            Log.debug("[Atlas] - " + (packer.getPages().size > 1 ? "&fb&lr" : "&lg") + "@ page@&r", packer.getPages().size, packer.getPages().size > 1 ? "s" : "");
            int i = 0;
            for (PixmapPacker.Page page : packer.getPages()) {
                float totalArea = 0.0f;
                for (PixmapPacker.PixmapPackerRect region : page.getRects().values()) {
                    totalArea += region.area();
                }
                Log.debug("[Atlas] - [@] @x@ (&lk@% used&fr)", i, page.getPixmap().width, page.getPixmap().height, (int)(totalArea / (float)(page.getPixmap().width * page.getPixmap().height) * 100.0f));
                ++i;
            }
        }
    }

    public boolean registerOutlined(String named) {
        return this.outlined.add(named);
    }

    public boolean isOutlined(String name) {
        return this.outlined.contains(name);
    }

    public PixmapPacker getPacker(PageType type) {
        return this.packers[type.ordinal()];
    }

    public boolean has(String name) {
        for (PageType page : PageType.all) {
            if (this.packers[page.ordinal()].getRect(name) == null) continue;
            return true;
        }
        return false;
    }

    public boolean has(PageType type, String name) {
        return this.packers[type.ordinal()].getRect(name) != null;
    }

    public void add(PageType type, String name, PixmapRegion region) {
        this.add(type, name, region, null, null);
    }

    public void add(PageType type, String name, PixmapRegion region, int[] splits, int[] pads) {
        this.packers[type.ordinal()].pack(name, region, splits, pads);
    }

    public void add(PageType type, String name, Pixmap pix) {
        this.add(type, name, new PixmapRegion(pix));
    }

    public TextureAtlas flush(Texture.TextureFilter filter, TextureAtlas atlas) {
        for (PixmapPacker p : this.packers) {
            p.updateTextureAtlas(atlas, filter, filter, false, false);
        }
        return atlas;
    }

    @Override
    public void dispose() {
        for (PixmapPacker packer : this.packers) {
            packer.dispose();
        }
    }

    public static enum PageType {
        main(4096),
        environment(4096, 2048),
        ui(4096),
        rubble(4096, 2048),
        editor(4096, 2048);

        public static final PageType[] all;
        public int width = 2048;
        public int height = 2048;

        private PageType(int defaultSize) {
            this.width = this.height = defaultSize;
        }

        private PageType(int width, int height) {
            this.width = width;
            this.height = height;
        }

        private PageType() {
        }

        static {
            all = PageType.values();
        }
    }
}

