/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.func.Boolp;
import arc.func.Floatp;
import arc.fx.FxProcessor;
import arc.fx.filters.BloomFilter;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.Pixmap;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.GlyphLayout;
import arc.graphics.g2d.Lines;
import arc.graphics.g3d.Camera3D;
import arc.graphics.gl.GLVersion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.WindowedMean;
import arc.math.geom.Vec2;
import arc.scene.ui.layout.Scl;
import arc.struct.FloatSeq;
import arc.util.Disposable;
import arc.util.OS;
import arc.util.Pack;
import arc.util.Scaling;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.core.Version;
import mindustry.graphics.Pal;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.MeshBuilder;

public class LoadRenderer
implements Disposable {
    private static final Color color = new Color(Pal.accent).lerp(Color.black, 0.5f);
    private static final Color colorRed = Pal.breakInvalid.cpy().lerp(Color.black, 0.3f);
    private static final String red = "[#" + colorRed + "]";
    private static final String orange = "[#" + color + "]";
    private static final FloatSeq floats = new FloatSeq();
    private static final boolean preview = false;
    private float testprogress = 0.0f;
    private StringBuilder assetText = new StringBuilder();
    private Bar[] bars;
    private Mesh mesh = MeshBuilder.buildHex(colorRed, 2, true, 1.0f);
    private Camera3D cam = new Camera3D();
    private int lastLength = -1;
    private FxProcessor fx;
    private WindowedMean renderTimes = new WindowedMean(20);
    private BloomFilter bloom;
    private boolean renderStencil = true;
    private long lastFrameTime;

    public LoadRenderer() {
        try {
            this.fx = new FxProcessor(Pixmap.Format.rgba8888, 2, 2, false, true);
        }
        catch (Exception e) {
            try {
                this.fx = new FxProcessor(Pixmap.Format.rgb565, 2, 2, false, true);
            }
            catch (Exception awful) {
                this.renderStencil = false;
                this.fx = new FxProcessor(Pixmap.Format.rgba8888, 2, 2, false, false);
            }
        }
        this.bloom = new BloomFilter();
        this.fx.addEffect(this.bloom);
        this.bars = new Bar[]{new Bar("s_proc#", (float)OS.cores / 16.0f, OS.cores < 4), new Bar("c_aprog", () -> Core.assets != null, () -> Core.assets.getProgress(), () -> false), new Bar("g_vtype", Core.graphics.getGLVersion().type == GLVersion.GlType.GLES ? 0.5f : 1.0f, Core.graphics.getGLVersion().type == GLVersion.GlType.GLES), new Bar("s_mem#", () -> true, () -> (float)Core.app.getJavaHeap() / 1024.0f / 1024.0f / 200.0f, () -> Core.app.getJavaHeap() > 0x6E00000L), new Bar("v_ver#", () -> Version.build != 0, () -> Version.build == -1 ? 0.3f : ((float)Version.build - 103.0f) / 10.0f, () -> !Version.modifier.equals("release")), new Bar("s_osv", OS.isWindows ? 0.35f : (OS.isLinux ? 0.9f : (OS.isMac ? 0.5f : 0.2f)), OS.isMac), new Bar("v_worlds#", () -> Vars.control != null && Vars.control.saves != null, () -> (float)Vars.control.saves.getSaveSlots().size / 30.0f, () -> Vars.control.saves.getSaveSlots().size > 30), new Bar("c_datas#", () -> Core.settings.keySize() > 0, () -> (float)Core.settings.keySize() / 50.0f, () -> Core.settings.keySize() > 20), new Bar("v_alterc", () -> Vars.mods != null, () -> (float)(Vars.mods.list().size + 1) / 6.0f, () -> Vars.mods.list().size > 0), new Bar("g_vcomp#", ((float)Core.graphics.getGLVersion().majorVersion + (float)Core.graphics.getGLVersion().minorVersion / 10.0f) / 4.6f, !Core.graphics.getGLVersion().atLeast(3, 2))};
    }

    @Override
    public void dispose() {
        this.mesh.dispose();
        this.fx.dispose();
        this.bloom.dispose();
    }

    public void draw() {
        if (this.lastFrameTime == 0L) {
            this.lastFrameTime = Time.millis();
        }
        float timespace = (float)Time.timeSinceMillis(this.lastFrameTime) / 1000.0f;
        this.renderTimes.add(timespace);
        this.lastFrameTime = Time.millis();
        if (this.fx.getWidth() != Core.graphics.getWidth() || this.fx.getHeight() != Core.graphics.getHeight()) {
            this.fx.resize(Core.graphics.getWidth(), Core.graphics.getHeight());
        }
        this.fx.begin();
        if (Core.assets.getLoadedAssets() != this.lastLength) {
            this.assetText.setLength(0);
            for (String name : Core.assets.getAssetNames()) {
                boolean isRed = name.toLowerCase().contains("mod") || Core.assets.getAssetType(name).getSimpleName().toLowerCase().contains("mod") || name.contains("preview");
                this.assetText.append(isRed ? red : orange).append(name.replace(OS.username, "<<host>>").replace("/", "::")).append(red).append("::[]").append(Core.assets.getAssetType(name).getSimpleName()).append("\n");
            }
            this.lastLength = Core.assets.getLoadedAssets();
        }
        Core.graphics.clear(Color.black);
        float w = Core.graphics.getWidth();
        float h = Core.graphics.getHeight();
        float s = Scl.scl();
        Draw.proj().setOrtho(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        int lightVerts = 20;
        float lightRad = Math.max(w, h) * 0.6f;
        float stroke = 5.0f * s;
        Fill.light(w / 2.0f, h / 2.0f, lightVerts, lightRad, Tmp.c1.set(color).a(0.15f), Color.clear);
        float space = s * 60.0f;
        float progress = Core.assets.getProgress();
        int dotw = (int)(w / space) / 2 + 1;
        int doth = (int)(h / space) / 2 + 1;
        Draw.color(Pal.accent, Color.black, 0.9f);
        Lines.stroke(stroke);
        for (int cx = -dotw; cx <= dotw; ++cx) {
            for (int cy = -doth; cy <= doth; ++cy) {
                float dx = (float)cx * space + w / 2.0f;
                float dy = (float)cy * space + h / 2.0f;
                Lines.poly(dx, dy, 4, space / 2.0f);
            }
        }
        Draw.flush();
        float aspect = 1.94f;
        Vec2 size = Scaling.fit.apply(Core.graphics.getWidth(), (float)Core.graphics.getWidth() / aspect, Core.graphics.getWidth(), Core.graphics.getHeight());
        int viewportWidth = (int)size.x;
        int viewportHeight = (int)size.y;
        int viewportX = (int)((float)Core.graphics.getWidth() / 2.0f - size.x / 2.0f);
        int viewportY = (int)((float)Core.graphics.getHeight() / 2.0f - size.y / 2.0f);
        if (Core.graphics.getHeight() > Core.graphics.getWidth()) {
            viewportHeight = Core.graphics.getHeight();
            viewportWidth = Core.graphics.getWidth();
            viewportY = 0;
            viewportX = 0;
        }
        w = viewportWidth;
        h = viewportHeight;
        Gl.viewport(viewportX, viewportY, viewportWidth, viewportHeight);
        Draw.proj().setOrtho(0.0f, 0.0f, viewportWidth, viewportHeight);
        float rads = 110.0f * s;
        float rad = Math.min(Math.min(w, h) / 3.1f, Math.min(w, h) / 2.0f - rads);
        float rad2 = rad + rads;
        float epad = 60.0f * s;
        float mpad = 100.0f * s;
        Draw.color(color);
        Lines.stroke(stroke);
        Lines.poly(w / 2.0f, h / 2.0f, 4, rad);
        Lines.poly(w / 2.0f, h / 2.0f, 4, rad2);
        if (Core.assets.isLoaded("tech") && this.renderStencil) {
            Font font = (Font)Core.assets.get("tech");
            font.getData().markupEnabled = true;
            int panei = 0;
            for (int sx : Mathf.signs) {
                for (int sy : Mathf.signs) {
                    float y1 = h / 2.0f + (float)sy * rad2;
                    float y2 = h / 2.0f + (float)sy * 120.0f;
                    floats.clear();
                    if (w > h) {
                        floats.add(w / 2.0f + (float)sx * mpad, y1);
                        floats.add(w / 2.0f + (w / 2.0f - epad) * (float)sx, y1);
                        floats.add(w / 2.0f + (w / 2.0f - epad) * (float)sx, y2);
                        floats.add(w / 2.0f + (float)sx * mpad + (float)sx * Math.abs(y2 - y1), y2);
                    } else {
                        float testval;
                        float py2 = h / 2.0f + (h / 2.0f - epad) * (float)sy;
                        float f = testval = sy < 0 ? Math.min(y2, y1) : Math.max(y2, y1);
                        if (py2 * (float)sy < testval * (float)sy) continue;
                        floats.add(w / 2.0f + (float)sx * mpad, y1);
                        floats.add(w / 2.0f + (float)sx * mpad, py2);
                        floats.add(Mathf.clamp(w / 2.0f + (float)sx * (mpad + Math.abs(y2 - y1)), stroke / 2.0f, w - stroke / 2.0f), py2);
                        floats.add(Mathf.clamp(w / 2.0f + (float)sx * (mpad + Math.abs(y2 - y1)), stroke / 2.0f, w - stroke / 2.0f), y2);
                    }
                    float minx = Float.MAX_VALUE;
                    float miny = Float.MAX_VALUE;
                    float maxx = 0.0f;
                    float maxy = 0.0f;
                    for (int i = 0; i < LoadRenderer.floats.size; i += 2) {
                        float x = LoadRenderer.floats.items[i];
                        float y = LoadRenderer.floats.items[i + 1];
                        minx = Math.min(x, minx);
                        miny = Math.min(y, miny);
                        maxx = Math.max(x, maxx);
                        maxy = Math.max(y, maxy);
                    }
                    Draw.flush();
                    Gl.clear(1024);
                    Draw.beginStencil();
                    Fill.poly(floats);
                    Draw.beginStenciled();
                    GlyphLayout layout = GlyphLayout.obtain();
                    float pad = 4.0f;
                    if (panei == 0) {
                        layout.setText(font, this.assetText);
                        font.draw(this.assetText, minx + pad, maxy - pad + Math.max(0.0f, layout.height - (maxy - miny)));
                    } else if (panei == 1) {
                        float height = maxy - miny;
                        float barpad = s * 8.0f;
                        int barsUsed = Math.min((int)((height - barpad) / (font.getLineHeight() * 1.4f)), this.bars.length);
                        float barspace = (height - barpad) / (float)barsUsed;
                        float barheight = barspace * 0.8f;
                        for (int i = 0; i < barsUsed; ++i) {
                            Bar bar = this.bars[i];
                            if (!bar.valid()) continue;
                            Draw.color(bar.red() ? colorRed : color);
                            float y = maxy - (float)i * barspace - barpad - barheight;
                            float width = Mathf.clamp(bar.value());
                            float baseWidth = Core.graphics.isPortrait() ? maxx - minx : maxx - minx - (maxy - y) - barpad * 2.0f - s * 4.0f;
                            float cx = minx + barpad;
                            float cy = y;
                            float topY = cy + barheight;
                            float botY = cy;
                            Lines.square(cx + barheight / 2.0f, botY + barheight / 2.0f, barheight / 2.0f);
                            Fill.quad(cx + barheight, cy, cx + barheight, topY, cx + width * baseWidth + barheight, topY, cx + width * baseWidth, botY);
                            Draw.color(Color.black);
                            Fill.quad(cx + width * baseWidth + barheight, topY, cx + width * baseWidth, botY, cx + baseWidth, botY, cx + baseWidth + barheight, topY);
                            font.setColor(Color.black);
                            layout.setText(font, bar.text);
                            font.draw(bar.text, cx + barheight * 1.5f, botY + barheight / 2.0f + layout.height / 2.0f);
                        }
                        Draw.color(color);
                    } else if (panei == 2) {
                        float barw = 30.0f * s;
                        float barspace = 40.0f * s;
                        float barpad = 10.0f * s;
                        int bars = (int)(maxx - minx / barspace) + 1;
                        int barmax = (int)((maxy - miny) / barspace);
                        for (int i = 0; i < bars; ++i) {
                            int index = i % this.renderTimes.getWindowSize();
                            float val = this.renderTimes.get(index);
                            float scale = Mathf.clamp(!this.renderTimes.hasEnoughData() ? Mathf.randomSeed(i) : val / this.renderTimes.mean() - 0.5f);
                            Color dst = scale > 0.8f ? colorRed : color;
                            Draw.color(dst);
                            int height = Math.max((int)(scale * (float)barmax), 1);
                            float cx = maxx - barw / 2.0f - barpad - (float)i * barspace;
                            for (int j = 0; j < barmax; ++j) {
                                if (j >= height) {
                                    Draw.color(color, Color.black, 0.7f);
                                } else {
                                    Draw.color(dst);
                                }
                                Fill.square(cx, miny + (float)j * barspace + barw / 2.0f + barpad, barw / 2.0f);
                            }
                        }
                        Draw.color(color);
                    } else if (panei == 3) {
                        Draw.flush();
                        float vx = floats.get(6);
                        float vy = floats.get(7);
                        float vw = maxx - vx;
                        float vh = maxy - vy;
                        float cx = vx + vw / 2.0f;
                        float cy = vy + vh / 2.0f;
                        float vpad = 30.0f * s;
                        float vcont = Math.min(vw, vh);
                        float vsize = vcont - vpad * 2.0f;
                        int rx = (int)(vx + vw / 2.0f - vsize / 2.0f);
                        int ry = (int)(vy + vh / 2.0f - vsize / 2.0f);
                        int rw = (int)vsize;
                        int rh = (int)vsize;
                        float vrad = vsize / 2.0f + vpad;
                        if (!Core.graphics.isPortrait()) {
                            String text = "<<ready>>";
                            layout.setText(font, text);
                            if (layout.width * 1.5f < vw) {
                                Lines.circle(cx, cy, vsize / 2.0f);
                                if (rw > 0 && rh > 0) {
                                    Gl.viewport(viewportX + rx, viewportY + ry, rw, rh);
                                    this.cam.position.set(2.0f, 0.0f, 2.0f);
                                    this.cam.resize(rw, rh);
                                    this.cam.lookAt(0.0f, 0.0f, 0.0f);
                                    this.cam.fov = 42.0f;
                                    this.cam.update();
                                    Shaders.mesh.bind();
                                    Shaders.mesh.setUniformMatrix4("u_proj", this.cam.combined.val);
                                    this.mesh.render(Shaders.mesh, 1);
                                    Gl.viewport(viewportX, viewportY, viewportWidth, viewportHeight);
                                }
                                int points = 4;
                                for (int i = 0; i < points; ++i) {
                                    float ang = (float)i * 360.0f / (float)points + 45.0f;
                                    Fill.poly(cx + Angles.trnsx(ang, vrad), cy + Angles.trnsy(ang, vrad), 3, 20.0f * s, ang);
                                }
                                Draw.color(Color.black);
                                Fill.rect(cx, cy, layout.width + 14.0f * s, layout.height + 14.0f * s);
                                font.setColor(color);
                                font.draw(text, cx - layout.width / 2.0f, cy + layout.height / 2.0f);
                                Draw.color(color);
                                Lines.square(cx, cy, vcont / 2.0f);
                                Lines.line(vx, vy, vx, vy + vh);
                                float pspace = 70.0f * s;
                                int pcount = (int)(vh / pspace / 2.0f) + 2;
                                float pw = (vw - vcont) / 2.0f;
                                float slope = pw / 2.0f;
                                for (int i : Mathf.signs) {
                                    float px = cx + (float)i * (vcont / 2.0f + pw / 2.0f);
                                    float xleft = px - pw / 2.0f;
                                    float xright = px + pw / 2.0f;
                                    for (int j = -2; j < pcount * 2; ++j) {
                                        float py = vy + (float)j * pspace * 2.0f;
                                        float ybot = py - slope;
                                        float ytop = py + slope;
                                        Fill.quad(xleft, ybot, xleft, ybot + pspace, xright, ytop + pspace, xright, ytop);
                                    }
                                }
                            } else {
                                Lines.line(vx, vy, vx + vw, vy + vh);
                                Lines.line(vx, vy + vh, vx + vw, vy);
                            }
                        }
                        float trispace = 70.0f * s;
                        float tpad = 5.0f * s;
                        int tris = (int)(vh / trispace) + 1;
                        for (int tx = 0; tx < tris; ++tx) {
                            for (int ty = 0; ty < tris; ++ty) {
                                float trix = vx - trispace / 2.0f - trispace * (float)tx - tpad;
                                float triy = vy + vh - trispace / 2.0f - trispace * (float)ty - tpad;
                                Draw.color((double)Mathf.randomSeed(Pack.longInt(tx + 91, ty + 55)) < 0.5 * (double)(1.0f - progress) ? colorRed : color);
                                Fill.square(trix, triy, trispace / 2.5f, 0.0f);
                                Draw.color(Color.black);
                                Fill.square(trix, triy, trispace / 2.5f / Mathf.sqrt2, 0.0f);
                            }
                        }
                        Draw.color(color);
                    }
                    layout.free();
                    Draw.endStencil();
                    Lines.polyline(floats, true);
                    ++panei;
                }
            }
        }
        Draw.flush();
        Gl.viewport(0, 0, Core.graphics.getWidth(), Core.graphics.getHeight());
        Draw.proj(0.0f, 0.0f, Core.graphics.getWidth(), Core.graphics.getHeight());
        w = Core.graphics.getWidth();
        h = Core.graphics.getHeight();
        float bspace = s * 100.0f;
        float bsize = s * 80.0f;
        int bars = (int)(w / bspace / 2.0f) + 1;
        float pscale = 1.0f / (float)bars;
        float barScale = 1.5f;
        Draw.color(Color.black);
        Fill.rect(w / 2.0f, h / 2.0f, w, bsize * barScale);
        Lines.stroke(stroke);
        Draw.color(color);
        Lines.rect(0.0f, h / 2.0f - bsize * barScale / 2.0f, w, bsize * barScale, 10.0f, 0.0f);
        for (int i = 1; i < bars; ++i) {
            float cx = (float)i * bspace;
            float fract = 1.0f - (float)(i - 1) / (float)(bars - 1);
            float alpha = progress >= fract ? 1.0f : Mathf.clamp((pscale - (fract - progress)) / pscale);
            Draw.color(Color.black, color, alpha);
            for (int dir : Mathf.signs) {
                float width = bsize / 1.7f;
                float skew = bsize / 2.0f;
                float v = w / 2.0f + cx * (float)dir - width / 2.0f;
                Fill.rects(v + (float)dir * skew, h / 2.0f, width, bsize / 2.0f, (float)(-dir) * skew);
                Fill.rects(v, h / 2.0f - bsize / 2.0f, width, bsize / 2.0f, (float)dir * skew);
            }
        }
        float fract = 1.0f - -1.0f / (float)(bars - 1);
        float alpha = progress >= fract ? 1.0f : Mathf.clamp((pscale - (fract - progress)) / pscale);
        Draw.color(Color.black, color, alpha);
        Fill.square(w / 2.0f, h / 2.0f, bsize / 3.0f, 45.0f);
        if (Core.assets.isLoaded("tech")) {
            String name;
            String string = name = Core.assets.getCurrentLoading() != null ? Core.assets.getCurrentLoading().fileName.toLowerCase() : "system";
            String key = name.contains("script") ? "scripts" : (name.contains("content") ? "content" : (name.contains("mod") ? "mods" : (name.contains("msav") || name.contains("maps") ? "map" : (name.contains("ogg") || name.contains("mp3") ? "sound" : (name.contains("png") ? "image" : "system")))));
            Font font = (Font)Core.assets.get("tech");
            font.getData().markupEnabled = true;
            font.setColor(Pal.accent);
            Draw.color(Color.black);
            font.draw(red + "[[[[ " + key + " ]]\n" + orange + "<" + Version.modifier + "  " + (Version.build == 0 ? "[init]" : Version.buildString()) + ">", w / 2.0f, h / 2.0f + 110.0f * s, 1);
        }
        Draw.flush();
        this.fx.end();
        this.fx.applyEffects();
        this.fx.render();
    }

    static class Bar {
        final Floatp value;
        final Boolp red;
        final Boolp valid;
        final String text;

        public Bar(String text, float value, boolean red) {
            this.value = () -> value;
            this.red = () -> red;
            this.valid = () -> true;
            this.text = text;
        }

        public Bar(String text, Boolp valid, Floatp value, Boolp red) {
            this.valid = valid;
            this.value = value;
            this.red = red;
            this.text = text;
        }

        boolean valid() {
            return this.valid.get();
        }

        boolean red() {
            return this.red.get();
        }

        float value() {
            return Mathf.clamp(this.value.get());
        }
    }
}

