/*
 * Decompiled with CFR 0.152.
 */
package mindustry.graphics;

import arc.Core;
import arc.Events;
import arc.graphics.Camera;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.Texture;
import arc.graphics.VertexAttribute;
import arc.graphics.g2d.Batch;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.IndexBufferObject;
import arc.graphics.gl.Shader;
import arc.graphics.gl.VertexBufferObject;
import arc.math.Mathf;
import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.struct.IntSet;
import arc.struct.ObjectSet;
import arc.util.Disposable;
import arc.util.Log;
import arc.util.Structs;
import arc.util.Time;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.graphics.CacheLayer;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public class FloorRenderer {
    private static final VertexAttribute[] attributes = new VertexAttribute[]{VertexAttribute.position, VertexAttribute.color, VertexAttribute.texCoords};
    private static final int chunksize = 30;
    private static final int chunkunits = 240;
    private static final int vertexSize = 5;
    private static final int spriteSize = 20;
    private static final int maxSprites = 8100;
    private static final float pad = 4.0f;
    private static final boolean dynamic = false;
    private float[] vertices = new float[162000];
    private short[] indices = new short[48600];
    private int vidx;
    private FloorRenderBatch batch = new FloorRenderBatch();
    private Shader shader;
    private Texture texture;
    private TextureRegion error;
    private Mesh[][][] cache;
    private IntSet drawnLayerSet = new IntSet();
    private IntSet recacheSet = new IntSet();
    private IntSeq drawnLayers = new IntSeq();
    private ObjectSet<CacheLayer> used = new ObjectSet();

    public FloorRenderer() {
        short j = 0;
        int i = 0;
        while (i < this.indices.length) {
            this.indices[i] = j;
            this.indices[i + 1] = (short)(j + 1);
            this.indices[i + 2] = (short)(j + 2);
            this.indices[i + 3] = (short)(j + 2);
            this.indices[i + 4] = (short)(j + 3);
            this.indices[i + 5] = j;
            i += 6;
            j = (short)(j + 4);
        }
        this.shader = new Shader("attribute vec4 a_position;\nattribute vec4 a_color;\nattribute vec2 a_texCoord0;\nuniform mat4 u_projectionViewMatrix;\nvarying vec4 v_color;\nvarying vec2 v_texCoords;\n\nvoid main(){\n   v_color = a_color;\n   v_color.a = v_color.a * (255.0/254.0);\n   v_texCoords = a_texCoord0;\n   gl_Position =  u_projectionViewMatrix * a_position;\n}\n", "varying vec4 v_color;\nvarying vec2 v_texCoords;\nuniform sampler2D u_texture;\n\nvoid main(){\n  gl_FragColor = v_color * texture2D(u_texture, v_texCoords);\n}\n");
        Events.on(EventType.WorldLoadEvent.class, event -> this.clearTiles());
    }

    public void recacheTile(Tile tile) {
        this.recacheSet.add(Point2.pack(tile.x / 30, tile.y / 30));
    }

    public void drawFloor() {
        if (this.cache == null) {
            return;
        }
        Camera camera = Core.camera;
        float pad = 4.0f;
        int minx = (int)((camera.position.x - camera.width / 2.0f - pad) / 240.0f);
        int miny = (int)((camera.position.y - camera.height / 2.0f - pad) / 240.0f);
        int maxx = Mathf.ceil((camera.position.x + camera.width / 2.0f + pad) / 240.0f);
        int maxy = Mathf.ceil((camera.position.y + camera.height / 2.0f + pad) / 240.0f);
        int layers = CacheLayer.all.length;
        this.drawnLayers.clear();
        this.drawnLayerSet.clear();
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                if (!Structs.inBounds(x, y, this.cache)) continue;
                if (this.cache[x][y].length == 0) {
                    this.cacheChunk(x, y);
                }
                Mesh[] chunk = this.cache[x][y];
                for (int i = 0; i < layers; ++i) {
                    if (chunk[i] == null || i == CacheLayer.walls.id) continue;
                    this.drawnLayerSet.add(i);
                }
            }
        }
        IntSet.IntSetIterator it = this.drawnLayerSet.iterator();
        while (it.hasNext) {
            this.drawnLayers.add(it.next());
        }
        this.drawnLayers.sort();
        Draw.flush();
        this.beginDraw();
        for (int i = 0; i < this.drawnLayers.size; ++i) {
            CacheLayer layer = CacheLayer.all[this.drawnLayers.get(i)];
            this.drawLayer(layer);
        }
        this.endDraw();
    }

    public void beginc() {
        this.shader.bind();
        this.shader.setUniformMatrix4("u_projectionViewMatrix", Core.camera.mat);
        this.texture.bind(0);
        if (Core.gl30 == null) {
            for (VertexAttribute attribute : attributes) {
                int loc = this.shader.getAttributeLocation(attribute.alias);
                if (loc == -1) continue;
                Gl.enableVertexAttribArray(loc);
            }
        }
    }

    public void endc() {
        if (Core.gl30 == null) {
            for (VertexAttribute attribute : attributes) {
                int loc = this.shader.getAttributeLocation(attribute.alias);
                if (loc == -1) continue;
                Gl.disableVertexAttribArray(loc);
            }
        }
        Gl.bindBuffer(34962, 0);
        Gl.bindBuffer(34963, 0);
    }

    public void checkChanges() {
        if (this.recacheSet.size > 0) {
            IntSet.IntSetIterator iterator = this.recacheSet.iterator();
            while (iterator.hasNext) {
                int chunk = iterator.next();
                this.cacheChunk(Point2.x(chunk), Point2.y(chunk));
            }
            this.recacheSet.clear();
        }
    }

    public void beginDraw() {
        if (this.cache == null) {
            return;
        }
        Draw.flush();
        this.beginc();
        Gl.enable(3042);
    }

    public void endDraw() {
        if (this.cache == null) {
            return;
        }
        this.endc();
    }

    public void drawLayer(CacheLayer layer) {
        if (this.cache == null) {
            return;
        }
        Camera camera = Core.camera;
        int minx = (int)((camera.position.x - camera.width / 2.0f - 4.0f) / 240.0f);
        int miny = (int)((camera.position.y - camera.height / 2.0f - 4.0f) / 240.0f);
        int maxx = Mathf.ceil((camera.position.x + camera.width / 2.0f + 4.0f) / 240.0f);
        int maxy = Mathf.ceil((camera.position.y + camera.height / 2.0f + 4.0f) / 240.0f);
        layer.begin();
        for (int x = minx; x <= maxx; ++x) {
            for (int y = miny; y <= maxy; ++y) {
                Disposable disposable;
                if (!Structs.inBounds(x, y, this.cache) || this.cache[x][y].length == 0) continue;
                Mesh mesh = this.cache[x][y][layer.id];
                if (mesh != null && (disposable = mesh.vertices) instanceof VertexBufferObject) {
                    VertexBufferObject vbo = (VertexBufferObject)disposable;
                    disposable = mesh.indices;
                    if (disposable instanceof IndexBufferObject) {
                        IndexBufferObject ibo = (IndexBufferObject)disposable;
                        vbo.bind();
                        int offset = 0;
                        for (VertexAttribute attribute : attributes) {
                            int location = this.shader.getAttributeLocation(attribute.alias);
                            int aoffset = offset;
                            offset += attribute.size;
                            if (location < 0) continue;
                            Gl.vertexAttribPointer(location, attribute.components, attribute.type, attribute.normalized, 20, aoffset);
                        }
                        ibo.bind();
                        mesh.vertices.render(mesh.indices, 4, 0, mesh.getNumIndices());
                        continue;
                    }
                }
                if (mesh == null) continue;
                mesh.bind(this.shader);
                mesh.render(this.shader, 4);
            }
        }
        layer.end();
    }

    private void cacheChunk(int cx, int cy) {
        this.used.clear();
        for (int tilex = Math.max(cx * 30 - 1, 0); tilex < (cx + 1) * 30 + 1 && tilex < Vars.world.width(); ++tilex) {
            for (int tiley = Math.max(cy * 30 - 1, 0); tiley < (cy + 1) * 30 + 1 && tiley < Vars.world.height(); ++tiley) {
                boolean wall;
                Tile tile = Vars.world.rawTile(tilex, tiley);
                boolean bl = wall = tile.block().cacheLayer != CacheLayer.normal;
                if (wall) {
                    this.used.add(tile.block().cacheLayer);
                }
                if (wall && !Vars.world.isAccessible(tilex, tiley)) continue;
                this.used.add(tile.floor().cacheLayer);
            }
        }
        if (this.cache[cx][cy].length == 0) {
            this.cache[cx][cy] = new Mesh[CacheLayer.all.length];
        }
        Mesh[] meshes = this.cache[cx][cy];
        for (CacheLayer layer : CacheLayer.all) {
            if (meshes[layer.id] != null) {
                meshes[layer.id].dispose();
            }
            meshes[layer.id] = null;
        }
        for (CacheLayer layer : this.used) {
            meshes[layer.id] = this.cacheChunkLayer(cx, cy, layer);
        }
    }

    private Mesh cacheChunkLayer(int cx, int cy, CacheLayer layer) {
        this.vidx = 0;
        Batch current = Core.batch;
        Core.batch = this.batch;
        for (int tilex = cx * 30; tilex < (cx + 1) * 30; ++tilex) {
            for (int tiley = cy * 30; tiley < (cy + 1) * 30; ++tiley) {
                Tile tile = Vars.world.tile(tilex, tiley);
                if (tile == null) continue;
                Floor floor = tile.floor();
                if (!(tile.block().cacheLayer != layer || layer != CacheLayer.walls || tile.isDarkened() && tile.data >= 5)) {
                    tile.block().drawBase(tile);
                    continue;
                }
                if (floor.cacheLayer == layer && (Vars.world.isAccessible(tile.x, tile.y) || tile.block().cacheLayer != CacheLayer.walls || !tile.block().fillsTile)) {
                    floor.drawBase(tile);
                    continue;
                }
                if (floor.cacheLayer == layer || layer == CacheLayer.walls) continue;
                floor.drawNonLayer(tile, layer);
            }
        }
        Core.batch = current;
        int floats = this.vidx;
        int vertCount = floats / 5;
        int indCount = vertCount * 6 / 4;
        Mesh mesh = new Mesh(true, vertCount, indCount, attributes);
        mesh.setVertices(this.vertices, 0, this.vidx);
        mesh.setAutoBind(false);
        mesh.setIndices(this.indices, 0, indCount);
        return mesh;
    }

    public void clearTiles() {
        if (this.cache != null) {
            Mesh[][][] meshArray = this.cache;
            int n = meshArray.length;
            for (int i = 0; i < n; ++i) {
                Mesh[][] x;
                Mesh[][] meshArray2 = x = meshArray[i];
                int n2 = meshArray2.length;
                for (int j = 0; j < n2; ++j) {
                    Mesh[] y;
                    for (Mesh mesh : y = meshArray2[j]) {
                        if (mesh == null) continue;
                        mesh.dispose();
                    }
                }
            }
        }
        this.recacheSet.clear();
        int chunksx = Mathf.ceil((float)Vars.world.width() / 30.0f);
        int chunksy = Mathf.ceil((float)Vars.world.height() / 30.0f);
        this.cache = new Mesh[chunksx][chunksy][CacheLayer.all.length];
        this.texture = Core.atlas.find((String)"grass1").texture;
        this.error = Core.atlas.find("env-error");
        Time.mark();
        for (int x = 0; x < chunksx; ++x) {
            for (int y = 0; y < chunksy; ++y) {
                this.cacheChunk(x, y);
            }
        }
        Log.debug("Generated world mesh: @ms", Float.valueOf(Time.elapsed()));
    }

    class FloorRenderBatch
    extends Batch {
        FloorRenderBatch() {
        }

        @Override
        protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
            if (region.texture != FloorRenderer.this.texture && region != FloorRenderer.this.error) {
                this.draw(FloorRenderer.this.error, x, y, originX, originY, width, height, rotation);
                return;
            }
            float[] verts = FloorRenderer.this.vertices;
            int idx = FloorRenderer.this.vidx;
            FloorRenderer.this.vidx += 20;
            if (!Mathf.zero(rotation)) {
                float worldOriginX = x + originX;
                float worldOriginY = y + originY;
                float fx = -originX;
                float fy = -originY;
                float fx2 = width - originX;
                float fy2 = height - originY;
                float cos = Mathf.cosDeg(rotation);
                float sin = Mathf.sinDeg(rotation);
                float x1 = cos * fx - sin * fy + worldOriginX;
                float y1 = sin * fx + cos * fy + worldOriginY;
                float x2 = cos * fx - sin * fy2 + worldOriginX;
                float y2 = sin * fx + cos * fy2 + worldOriginY;
                float x3 = cos * fx2 - sin * fy2 + worldOriginX;
                float y3 = sin * fx2 + cos * fy2 + worldOriginY;
                float x4 = x1 + (x3 - x2);
                float y4 = y3 - (y2 - y1);
                float u = region.u;
                float v = region.v2;
                float u2 = region.u2;
                float v2 = region.v;
                float color = this.colorPacked;
                verts[idx] = x1;
                verts[idx + 1] = y1;
                verts[idx + 2] = color;
                verts[idx + 3] = u;
                verts[idx + 4] = v;
                verts[idx + 5] = x2;
                verts[idx + 6] = y2;
                verts[idx + 7] = color;
                verts[idx + 8] = u;
                verts[idx + 9] = v2;
                verts[idx + 10] = x3;
                verts[idx + 11] = y3;
                verts[idx + 12] = color;
                verts[idx + 13] = u2;
                verts[idx + 14] = v2;
                verts[idx + 15] = x4;
                verts[idx + 16] = y4;
                verts[idx + 17] = color;
                verts[idx + 18] = u2;
                verts[idx + 19] = v;
            } else {
                float fx2 = x + width;
                float fy2 = y + height;
                float u = region.u;
                float v = region.v2;
                float u2 = region.u2;
                float v2 = region.v;
                float color = this.colorPacked;
                verts[idx] = x;
                verts[idx + 1] = y;
                verts[idx + 2] = color;
                verts[idx + 3] = u;
                verts[idx + 4] = v;
                verts[idx + 5] = x;
                verts[idx + 6] = fy2;
                verts[idx + 7] = color;
                verts[idx + 8] = u;
                verts[idx + 9] = v2;
                verts[idx + 10] = fx2;
                verts[idx + 11] = fy2;
                verts[idx + 12] = color;
                verts[idx + 13] = u2;
                verts[idx + 14] = v2;
                verts[idx + 15] = fx2;
                verts[idx + 16] = y;
                verts[idx + 17] = color;
                verts[idx + 18] = u2;
                verts[idx + 19] = v;
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void setShader(Shader shader, boolean apply) {
            throw new IllegalArgumentException("cache shader unsupported");
        }

        @Override
        protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
            throw new IllegalArgumentException("cache vertices unsupported");
        }
    }
}

