/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.struct.Queue;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.core.NetServer;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Player;
import mindustry.io.TypeIO;
import mindustry.net.NetConnection;
import mindustry.net.Packet;
import mindustry.world.Tile;

public class ClientSnapshotCallPacket
extends Packet {
    private byte[] DATA = NODATA;
    public int snapshotID;
    public int unitID;
    public boolean dead;
    public float x;
    public float y;
    public float pointerX;
    public float pointerY;
    public float rotation;
    public float baseRotation;
    public float xVelocity;
    public float yVelocity;
    public Tile mining;
    public boolean boosting;
    public boolean shooting;
    public boolean chatting;
    public boolean building;
    public Queue<BuildPlan> plans;
    public float viewX;
    public float viewY;
    public float viewWidth;
    public float viewHeight;

    @Override
    public void write(Writes WRITE) {
        WRITE.i(this.snapshotID);
        WRITE.i(this.unitID);
        WRITE.bool(this.dead);
        WRITE.f(this.x);
        WRITE.f(this.y);
        WRITE.f(this.pointerX);
        WRITE.f(this.pointerY);
        WRITE.f(this.rotation);
        WRITE.f(this.baseRotation);
        WRITE.f(this.xVelocity);
        WRITE.f(this.yVelocity);
        TypeIO.writeTile(WRITE, this.mining);
        WRITE.bool(this.boosting);
        WRITE.bool(this.shooting);
        WRITE.bool(this.chatting);
        WRITE.bool(this.building);
        TypeIO.writePlansQueueNet(WRITE, this.plans);
        WRITE.f(this.viewX);
        WRITE.f(this.viewY);
        WRITE.f(this.viewWidth);
        WRITE.f(this.viewHeight);
    }

    @Override
    public void read(Reads READ, int LENGTH) {
        this.DATA = READ.b(LENGTH);
    }

    @Override
    public void handled() {
        BAIS.setBytes(this.DATA);
        this.snapshotID = READ.i();
        this.unitID = READ.i();
        this.dead = READ.bool();
        this.x = READ.f();
        this.y = READ.f();
        this.pointerX = READ.f();
        this.pointerY = READ.f();
        this.rotation = READ.f();
        this.baseRotation = READ.f();
        this.xVelocity = READ.f();
        this.yVelocity = READ.f();
        this.mining = TypeIO.readTile(READ);
        this.boosting = READ.bool();
        this.shooting = READ.bool();
        this.chatting = READ.bool();
        this.building = READ.bool();
        this.plans = TypeIO.readPlansQueue(READ);
        this.viewX = READ.f();
        this.viewY = READ.f();
        this.viewWidth = READ.f();
        this.viewHeight = READ.f();
    }

    @Override
    public void handleServer(NetConnection con) {
        if (con.player == null || con.kicked) {
            return;
        }
        Player player = con.player;
        NetServer.clientSnapshot(player, this.snapshotID, this.unitID, this.dead, this.x, this.y, this.pointerX, this.pointerY, this.rotation, this.baseRotation, this.xVelocity, this.yVelocity, this.mining, this.boosting, this.shooting, this.chatting, this.building, this.plans, this.viewX, this.viewY, this.viewWidth, this.viewHeight);
    }
}

