/*
 * Decompiled with CFR 0.152.
 */
package mindustry.gen;

import arc.func.Cons;
import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.core.World;
import mindustry.entities.EntityCollisions;
import mindustry.entities.EntityGroup;
import mindustry.entities.Mover;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Bulletc;
import mindustry.gen.Damagec;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Flyingc;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.IndexableEntity__all;
import mindustry.gen.IndexableEntity__bullet;
import mindustry.gen.IndexableEntity__draw;
import mindustry.gen.Ownerc;
import mindustry.gen.Posc;
import mindustry.gen.Shielderc;
import mindustry.gen.Teamc;
import mindustry.gen.Timedc;
import mindustry.gen.Timerc;
import mindustry.gen.Unitc;
import mindustry.gen.Velc;
import mindustry.graphics.Trail;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;
import mindustry.world.blocks.environment.StaticWall;
import mindustry.world.blocks.storage.CoreBlock;

public class Bullet
implements Pool.Poolable,
Bulletc,
Damagec,
Drawc,
Entityc,
Hitboxc,
IndexableEntity__all,
IndexableEntity__bullet,
IndexableEntity__draw,
Ownerc,
Posc,
Shielderc,
Teamc,
Timedc,
Timerc,
Velc {
    public transient boolean absorbed;
    protected transient boolean added;
    @Nullable
    public transient Tile aimTile;
    public transient float aimX;
    public transient float aimY;
    public IntSeq collided = new IntSeq(6);
    public float damage;
    public Object data;
    public transient float deltaX;
    public transient float deltaY;
    public transient float drag = 0.0f;
    public float fdata;
    public transient boolean hit;
    public transient float hitSize;
    public transient int id = EntityGroup.nextId();
    protected transient int index__all = -1;
    protected transient int index__bullet = -1;
    protected transient int index__draw = -1;
    public transient boolean keepAlive;
    public transient float lastX;
    public transient float lastY;
    public float lifetime;
    @Nullable
    public transient Mover mover;
    public transient float originX;
    public transient float originY;
    public Entityc owner;
    protected float rotation;
    public Team team = Team.derelict;
    public float time;
    public transient Interval timer = new Interval(6);
    @Nullable
    public transient Trail trail;
    public BulletType type;
    public Vec2 vel = new Vec2();
    public float x;
    public float y;

    protected Bullet() {
    }

    @Override
    public Vec2 vel() {
        return this.vel;
    }

    @Override
    public IntSeq collided() {
        return this.collided;
    }

    @Override
    public Interval timer() {
        return this.timer;
    }

    @Override
    public boolean absorbed() {
        return this.absorbed;
    }

    @Override
    public boolean hit() {
        return this.hit;
    }

    @Override
    public boolean keepAlive() {
        return this.keepAlive;
    }

    @Override
    public float aimX() {
        return this.aimX;
    }

    @Override
    public float aimY() {
        return this.aimY;
    }

    @Override
    public float damage() {
        return this.damage;
    }

    @Override
    public float deltaX() {
        return this.deltaX;
    }

    @Override
    public float deltaY() {
        return this.deltaY;
    }

    @Override
    public float drag() {
        return this.drag;
    }

    @Override
    public float fdata() {
        return this.fdata;
    }

    @Override
    public float lastX() {
        return this.lastX;
    }

    @Override
    public float lastY() {
        return this.lastY;
    }

    @Override
    public float lifetime() {
        return this.lifetime;
    }

    @Override
    public float originX() {
        return this.originX;
    }

    @Override
    public float originY() {
        return this.originY;
    }

    @Override
    public float time() {
        return this.time;
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public int classId() {
        return 7;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public Object data() {
        return this.data;
    }

    public String toString() {
        return "Bullet#" + this.id;
    }

    @Override
    public Mover mover() {
        return this.mover;
    }

    @Override
    public BulletType type() {
        return this.type;
    }

    @Override
    public Team team() {
        return this.team;
    }

    @Override
    public Entityc owner() {
        return this.owner;
    }

    @Override
    public Trail trail() {
        return this.trail;
    }

    @Override
    public Tile aimTile() {
        return this.aimTile;
    }

    @Override
    public void absorbed(boolean absorbed) {
        this.absorbed = absorbed;
    }

    @Override
    public void aimTile(Tile aimTile) {
        this.aimTile = aimTile;
    }

    @Override
    public void aimX(float aimX) {
        this.aimX = aimX;
    }

    @Override
    public void aimY(float aimY) {
        this.aimY = aimY;
    }

    @Override
    public void collided(IntSeq collided) {
        this.collided = collided;
    }

    @Override
    public void damage(float damage) {
        this.damage = damage;
    }

    @Override
    public void data(Object data) {
        this.data = data;
    }

    @Override
    public void deltaX(float deltaX) {
        this.deltaX = deltaX;
    }

    @Override
    public void deltaY(float deltaY) {
        this.deltaY = deltaY;
    }

    @Override
    public void drag(float drag) {
        this.drag = drag;
    }

    @Override
    public void fdata(float fdata) {
        this.fdata = fdata;
    }

    @Override
    public void hit(boolean hit) {
        this.hit = hit;
    }

    @Override
    public void hitSize(float hitSize) {
        this.hitSize = hitSize;
    }

    @Override
    public void id(int id) {
        this.id = id;
    }

    @Override
    public void keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public void lastX(float lastX) {
        this.lastX = lastX;
    }

    @Override
    public void lastY(float lastY) {
        this.lastY = lastY;
    }

    @Override
    public void lifetime(float lifetime) {
        this.lifetime = lifetime;
    }

    @Override
    public void mover(Mover mover) {
        this.mover = mover;
    }

    @Override
    public void originX(float originX) {
        this.originX = originX;
    }

    @Override
    public void originY(float originY) {
        this.originY = originY;
    }

    @Override
    public void owner(Entityc owner) {
        this.owner = owner;
    }

    @Override
    public void setIndex__all(int index) {
        this.index__all = index;
    }

    @Override
    public void setIndex__bullet(int index) {
        this.index__bullet = index;
    }

    @Override
    public void setIndex__draw(int index) {
        this.index__draw = index;
    }

    @Override
    public void team(Team team) {
        this.team = team;
    }

    @Override
    public void time(float time) {
        this.time = time;
    }

    @Override
    public void timer(Interval timer) {
        this.timer = timer;
    }

    @Override
    public void trail(Trail trail) {
        this.trail = trail;
    }

    @Override
    public void type(BulletType type) {
        this.type = type;
    }

    @Override
    public void vel(Vec2 vel) {
        this.vel = vel;
    }

    @Override
    public void x(float x) {
        this.x = x;
    }

    @Override
    public void y(float y) {
        this.y = y;
    }

    @Override
    public <T extends Entityc> T self() {
        return (T)this;
    }

    @Override
    public <T> T as() {
        return (T)this;
    }

    @Override
    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }

    @Override
    public boolean canPass(int tileX, int tileY) {
        EntityCollisions.SolidPred s = this.solidity();
        return s == null || !s.solid(tileX, tileY);
    }

    @Override
    public boolean canPassOn() {
        return this.canPass(this.tileX(), this.tileY());
    }

    @Override
    public boolean cheating() {
        return this.team.rules().cheat;
    }

    @Override
    public boolean checkUnderBuild(Building build, float x, float y) {
        return !build.block.underBullets || this.aimTile != null && this.aimTile.build == build || build.team == this.team || this.type.pierce && this.aimTile != null && Mathf.dst(x, y, this.originX, this.originY) > this.aimTile.dst(this.originX, this.originY) + 2.0f || this.aimX == -1.0f && this.aimY == -1.0f;
    }

    @Override
    public boolean collides(Hitboxc other) {
        Flyingc f;
        Teamc t;
        return !(!this.type.collides || !(other instanceof Teamc) || (t = (Teamc)((Object)other)).team() == this.team || other instanceof Flyingc && !(f = (Flyingc)other).checkTarget(this.type.collidesAir, this.type.collidesGround) || this.type.pierce && this.hasCollided(other.id()));
    }

    @Override
    public boolean hasCollided(int id) {
        return this.collided.size != 0 && this.collided.contains(id);
    }

    @Override
    public boolean inFogTo(Team viewer) {
        return this.team != viewer && !Vars.fogControl.isVisible(viewer, this.x, this.y);
    }

    @Override
    public boolean isAdded() {
        return this.added;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public boolean isRemote() {
        Unitc u;
        Bullet bullet = this;
        return bullet instanceof Unitc && (u = (Unitc)((Object)bullet)).isPlayer() && !this.isLocal();
    }

    @Override
    public boolean moving() {
        return !this.vel.isZero(0.01f);
    }

    @Override
    public boolean onSolid() {
        Tile tile = this.tileOn();
        return tile == null || tile.solid();
    }

    @Override
    public boolean serialize() {
        return false;
    }

    @Override
    public boolean timer(int index, float time) {
        if (Float.isInfinite(time)) {
            return false;
        }
        return this.timer.get(index, time);
    }

    @Override
    public float clipSize() {
        return this.type.drawSize;
    }

    @Override
    public float damageMultiplier() {
        return this.type.damageMultiplier(this);
    }

    @Override
    public float deltaAngle() {
        return Mathf.angle(this.deltaX, this.deltaY);
    }

    @Override
    public float deltaLen() {
        return Mathf.len(this.deltaX, this.deltaY);
    }

    @Override
    public float fin() {
        return this.time / this.lifetime;
    }

    @Override
    public float getX() {
        return this.x;
    }

    @Override
    public float getY() {
        return this.y;
    }

    @Override
    public float hitSize() {
        return this.hitSize;
    }

    @Override
    public float rotation() {
        return this.vel.isZero(0.001f) ? this.rotation : this.vel.angle();
    }

    @Override
    public int tileX() {
        return World.toTile(this.x);
    }

    @Override
    public int tileY() {
        return World.toTile(this.y);
    }

    @Override
    public EntityCollisions.SolidPred solidity() {
        return null;
    }

    @Override
    public Block blockOn() {
        Tile tile = this.tileOn();
        return tile == null ? Blocks.air : tile.block();
    }

    @Override
    public Tile tileOn() {
        return Vars.world.tileWorld(this.x, this.y);
    }

    @Override
    public Floor floorOn() {
        Tile tile = this.tileOn();
        return tile == null || tile.block() != Blocks.air ? (Floor)Blocks.air : tile.floor();
    }

    @Override
    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    @Override
    public CoreBlock.CoreBuild closestEnemyCore() {
        return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
    }

    @Override
    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    public static Bullet create() {
        return Pools.obtain(Bullet.class, Bullet::new);
    }

    @Override
    public void absorb() {
        this.absorbed = true;
        this.remove();
    }

    @Override
    public void add() {
        if (this.added) {
            return;
        }
        this.index__all = Groups.all.addIndex(this);
        this.index__bullet = Groups.bullet.addIndex(this);
        this.index__draw = Groups.draw.addIndex(this);
        this.type.init(this);
        this.added = true;
        this.updateLastPosition();
    }

    @Override
    public void afterRead() {
        this.updateLastPosition();
    }

    @Override
    public void collision(Hitboxc other, float x, float y) {
        float f;
        this.type.hit(this, x, y);
        if (!this.type.pierce) {
            this.hit = true;
            this.remove();
        } else {
            this.collided.add(other.id());
        }
        if (other instanceof Healthc) {
            Healthc h = (Healthc)((Object)other);
            f = h.health();
        } else {
            f = 0.0f;
        }
        this.type.hitEntity(this, other, f);
    }

    @Override
    public void draw() {
        Draw.z(this.type.layer);
        this.type.draw(this);
        this.type.drawLight(this);
        Draw.reset();
    }

    @Override
    public void getCollisions(Cons<QuadTree> consumer) {
        Seq<Teams.TeamData> data = Vars.state.teams.present;
        for (int i = 0; i < data.size; ++i) {
            if (((Teams.TeamData[])data.items)[i].team == this.team) continue;
            consumer.get(((Teams.TeamData[])data.items)[i].tree());
        }
    }

    @Override
    public void hitbox(Rect rect) {
        rect.setCentered(this.x, this.y, this.hitSize, this.hitSize);
    }

    @Override
    public void hitboxTile(Rect rect) {
        float size = Math.min(this.hitSize * 0.66f, 7.9f);
        rect.setCentered(this.x, this.y, size, size);
    }

    @Override
    public void initVel(float angle, float amount) {
        this.vel.trns(angle, amount);
        this.rotation = angle;
    }

    @Override
    public void move(Vec2 v) {
        this.move(v.x, v.y);
    }

    @Override
    public void move(float cx, float cy) {
        EntityCollisions.SolidPred check = this.solidity();
        if (check != null) {
            Vars.collisions.move(this, cx, cy, check);
        } else {
            this.x += cx;
            this.y += cy;
        }
    }

    @Override
    public void moveRelative(float x, float y) {
        float rot = this.rotation();
        this.x += Angles.trnsx(rot, x * Time.delta, y * Time.delta);
        this.y += Angles.trnsy(rot, x * Time.delta, y * Time.delta);
    }

    @Override
    public void read(Reads read) {
        this.afterRead();
    }

    @Override
    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.all.removeIndex(this, this.index__all);
        this.index__all = -1;
        Groups.bullet.removeIndex(this, this.index__bullet);
        this.index__bullet = -1;
        Groups.draw.removeIndex(this, this.index__draw);
        this.index__draw = -1;
        if (!Groups.isClearing) {
            if (!this.hit) {
                this.type.despawned(this);
            }
            this.type.removed(this);
            this.collided.clear();
        }
        this.added = false;
        Groups.queueFree(this);
    }

    @Override
    public void reset() {
        this.absorbed = false;
        this.added = false;
        this.aimTile = null;
        this.aimX = 0.0f;
        this.aimY = 0.0f;
        this.damage = 0.0f;
        this.data = null;
        this.deltaX = 0.0f;
        this.deltaY = 0.0f;
        this.drag = 0.0f;
        this.fdata = 0.0f;
        this.hit = false;
        this.hitSize = 0.0f;
        this.id = EntityGroup.nextId();
        this.keepAlive = false;
        this.lastX = 0.0f;
        this.lastY = 0.0f;
        this.lifetime = 0.0f;
        this.mover = null;
        this.originX = 0.0f;
        this.originY = 0.0f;
        this.owner = null;
        this.rotation = 0.0f;
        this.time = 0.0f;
        this.trail = null;
        this.type = null;
        this.x = 0.0f;
        this.y = 0.0f;
    }

    @Override
    public void rotation(float angle) {
        this.rotation = angle;
        this.vel.setAngle(this.rotation);
    }

    @Override
    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    @Override
    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void tileRaycast(int x1, int y1, int x2, int y2) {
        int x = x1;
        int dx = Math.abs(x2 - x);
        int sx = x < x2 ? 1 : -1;
        int y = y1;
        int dy = Math.abs(y2 - y);
        int sy = y < y2 ? 1 : -1;
        int err = dx - dy;
        int ww = Vars.world.width();
        int wh = Vars.world.height();
        while (x >= 0 && y >= 0 && x < ww && y < wh) {
            Building build = Vars.world.build(x, y);
            if (this.type.collideFloor || this.type.collideTerrain) {
                Tile tile = Vars.world.tile(x, y);
                if (this.type.collideFloor && (tile == null || tile.floor().hasSurface() || tile.block() != Blocks.air) || this.type.collideTerrain && tile != null && tile.block() instanceof StaticWall) {
                    this.remove();
                    this.hit = true;
                    return;
                }
            }
            if (build != null && this.isAdded() && this.checkUnderBuild(build, x * 8, y * 8) && build.collide(this) && this.type.testCollision(this, build) && !build.dead() && (this.type.collidesTeam || build.team != this.team) && (!this.type.pierceBuilding || !this.hasCollided(build.id))) {
                boolean remove = false;
                float health = build.health;
                if (build.team != this.team) {
                    remove = build.collision(this);
                }
                if (remove || this.type.collidesTeam) {
                    if (Mathf.dst2(this.lastX, this.lastY, x * 8, y * 8) < Mathf.dst2(this.lastX, this.lastY, this.x, this.y)) {
                        this.x = x * 8;
                        this.y = y * 8;
                    }
                    if (!this.type.pierceBuilding) {
                        this.hit = true;
                        this.remove();
                    } else {
                        this.collided.add(build.id);
                    }
                }
                this.type.hitTile(this, build, x * 8, y * 8, health, true);
                if (this.type.pierceBuilding) {
                    return;
                }
            }
            if (x == x2 && y == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                x += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            y += sy;
        }
    }

    @Override
    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    @Override
    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    @Override
    public void turn(float x, float y) {
        float ang = this.vel.angle();
        this.vel.add(Angles.trnsx(ang, x * Time.delta, y * Time.delta), Angles.trnsy(ang, x * Time.delta, y * Time.delta)).limit(this.type.speed);
    }

    @Override
    public void update() {
        if (!Vars.net.client() || this.isLocal()) {
            float px = this.x;
            float py = this.y;
            this.move(this.vel.x * Time.delta, this.vel.y * Time.delta);
            if (Mathf.equal(px, this.x)) {
                this.vel.x = 0.0f;
            }
            if (Mathf.equal(py, this.y)) {
                this.vel.y = 0.0f;
            }
            this.vel.scl(Math.max(1.0f - this.drag * Time.delta, 0.0f));
        }
        if (this.mover != null) {
            this.mover.move(this);
        }
        this.type.update(this);
        if (this.type.collidesTiles && this.type.collides && this.type.collidesGround) {
            this.tileRaycast(World.toTile(this.lastX), World.toTile(this.lastY), this.tileX(), this.tileY());
        }
        if (this.type.removeAfterPierce && this.type.pierceCap != -1 && this.collided.size >= this.type.pierceCap) {
            this.hit = true;
            this.remove();
        }
        if (this.keepAlive) {
            this.time -= Time.delta;
            this.keepAlive = false;
        }
        this.time = Math.min(this.time + Time.delta, this.lifetime);
        if (this.time >= this.lifetime) {
            this.remove();
        }
    }

    @Override
    public void updateLastPosition() {
        this.deltaX = this.x - this.lastX;
        this.deltaY = this.y - this.lastY;
        this.lastX = this.x;
        this.lastY = this.y;
    }

    @Override
    public void velAddNet(Vec2 v) {
        this.vel.add(v);
        if (this.isRemote()) {
            this.x += v.x;
            this.y += v.y;
        }
    }

    @Override
    public void velAddNet(float vx, float vy) {
        this.vel.add(vx, vy);
        if (this.isRemote()) {
            this.x += vx;
            this.y += vy;
        }
    }

    @Override
    public void write(Writes write) {
    }
}

