/*
 * Decompiled with CFR 0.152.
 */
package mindustry.game;

import arc.math.geom.Point2;
import arc.struct.IntIntMap;
import arc.struct.LongSeq;
import arc.util.Time;
import mindustry.gen.Indicator;

public class AttackIndicators {
    private static final float duration = 900.0f;
    private LongSeq indicators = new LongSeq(false, 16);
    private IntIntMap posToIndex = new IntIntMap();

    public LongSeq list() {
        return this.indicators;
    }

    public void clear() {
        this.indicators.clear();
        this.posToIndex.clear();
    }

    public void add(int x, int y) {
        int pos = Point2.pack(x, y);
        int index = this.posToIndex.get(pos, -1);
        if (index != -1) {
            this.indicators.items[index] = Indicator.time(this.indicators.items[index], 0.0f);
        } else {
            this.indicators.add(Indicator.get(pos, 0.0f));
            this.posToIndex.put(pos, this.indicators.size - 1);
        }
    }

    public void update() {
        long[] items = this.indicators.items;
        for (int i = 0; i < this.indicators.size; ++i) {
            long l = items[i];
            items[i] = l = Indicator.time(l, Indicator.time(l) + Time.delta);
            if (!(Indicator.time(l) >= 900.0f)) continue;
            this.indicators.removeIndex(i);
            this.posToIndex.remove(Indicator.pos(l));
            if (this.indicators.size > 0) {
                this.posToIndex.put(Indicator.pos(items[i]), i);
            }
            --i;
        }
    }

    class IndicatorStruct {
        int pos;
        float time;

        IndicatorStruct() {
        }
    }
}

