/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.units;

import arc.func.Cons;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;

public class BuildPlan
implements Position,
QuadTree.QuadTreeObject {
    public int x;
    public int y;
    public int rotation;
    @Nullable
    public Block block;
    public boolean breaking;
    public Object config;
    public int originalX;
    public int originalY;
    public int originalWidth;
    public int originalHeight;
    public float progress;
    public boolean initialized;
    public boolean stuck;
    public boolean cachedValid;
    public boolean worldContext = true;
    public float animScale = 0.0f;

    public BuildPlan(int x, int y, int rotation, Block block) {
        this.x = x;
        this.y = y;
        if (block != null) {
            this.rotation = block.planRotation(rotation);
        }
        this.block = block;
        this.breaking = false;
    }

    public BuildPlan(int x, int y, int rotation, Block block, Object config) {
        this.x = x;
        this.y = y;
        if (block != null) {
            this.rotation = block.planRotation(rotation);
        }
        this.block = block;
        this.breaking = false;
        this.config = config;
    }

    public BuildPlan(int x, int y) {
        this.x = x;
        this.y = y;
        this.rotation = -1;
        this.block = Vars.world.tile(x, y).block();
        this.breaking = true;
    }

    public BuildPlan() {
    }

    public boolean placeable(Team team) {
        return Build.validPlace(this.block, team, this.x, this.y, this.rotation);
    }

    public boolean isRotation(Team team) {
        if (this.breaking) {
            return false;
        }
        Tile tile = this.tile();
        return tile != null && tile.team() == team && tile.block() == this.block && tile.build != null && tile.build.rotation != this.rotation;
    }

    public boolean samePos(BuildPlan other) {
        return this.x == other.x && this.y == other.y;
    }

    public static Object pointConfig(Block block, Object config, Cons<Point2> cons) {
        if (config instanceof Point2) {
            Point2 point = (Point2)config;
            config = point.cpy();
            cons.get((Point2)config);
        } else if (config instanceof Point2[]) {
            Point2[] points = config;
            Point2[] result = new Point2[points.length];
            int i = 0;
            for (Point2 p : points) {
                result[i] = p.cpy();
                cons.get(result[i++]);
            }
            config = result;
        } else if (block != null) {
            config = block.pointConfig(config, cons);
        }
        return config;
    }

    public void pointConfig(Cons<Point2> cons) {
        this.config = BuildPlan.pointConfig(this.block, this.config, cons);
    }

    public BuildPlan copy() {
        BuildPlan copy = new BuildPlan();
        copy.x = this.x;
        copy.y = this.y;
        copy.rotation = this.rotation;
        copy.block = this.block;
        copy.breaking = this.breaking;
        copy.config = this.config;
        copy.originalX = this.originalX;
        copy.originalY = this.originalY;
        copy.progress = this.progress;
        copy.initialized = this.initialized;
        copy.animScale = this.animScale;
        return copy;
    }

    public BuildPlan original(int x, int y, int originalWidth, int originalHeight) {
        this.originalX = x;
        this.originalY = y;
        this.originalWidth = originalWidth;
        this.originalHeight = originalHeight;
        return this;
    }

    public Rect bounds(Rect rect) {
        if (this.breaking) {
            return rect.set(-100.0f, -100.0f, 0.0f, 0.0f);
        }
        return this.block.bounds(this.x, this.y, rect);
    }

    public BuildPlan set(int x, int y, int rotation, Block block) {
        this.x = x;
        this.y = y;
        if (block != null) {
            this.rotation = block.planRotation(rotation);
        }
        this.block = block;
        this.breaking = false;
        return this;
    }

    public float drawx() {
        return (float)(this.x * 8) + (this.block == null ? 0.0f : this.block.offset);
    }

    public float drawy() {
        return (float)(this.y * 8) + (this.block == null ? 0.0f : this.block.offset);
    }

    @Nullable
    public Tile tile() {
        return Vars.world.tile(this.x, this.y);
    }

    @Nullable
    public Building build() {
        return Vars.world.build(this.x, this.y);
    }

    @Override
    public void hitbox(Rect out) {
        if (this.block != null) {
            out.setCentered((float)(this.x * 8) + this.block.offset, (float)(this.y * 8) + this.block.offset, this.block.size * 8);
        } else {
            out.setCentered(this.x * 8, this.y * 8, 8.0f);
        }
    }

    @Override
    public float getX() {
        return this.drawx();
    }

    @Override
    public float getY() {
        return this.drawy();
    }

    public String toString() {
        return "BuildPlan{x=" + this.x + ", y=" + this.y + ", rotation=" + this.rotation + ", block=" + this.block + ", breaking=" + this.breaking + ", progress=" + this.progress + ", initialized=" + this.initialized + ", config=" + this.config + '}';
    }
}

