/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.effect;

import mindustry.entities.Effect;

public class SeqEffect
extends Effect {
    public Effect[] effects = new Effect[0];

    public SeqEffect() {
        this.clip = 100.0f;
    }

    public SeqEffect(Effect ... effects) {
        this();
        this.effects = effects;
    }

    @Override
    public void init() {
        this.lifetime = 0.0f;
        for (Effect f : this.effects) {
            f.init();
            this.clip = Math.max(this.clip, f.clip);
            this.lifetime += f.lifetime;
        }
    }

    @Override
    public void render(Effect.EffectContainer e) {
        Effect.EffectContainer cont = e.inner();
        float life = e.time;
        float sum = 0.0f;
        for (int i = 0; i < this.effects.length; ++i) {
            Effect fx = this.effects[i];
            if (life <= fx.lifetime + sum) {
                cont.set(e.id + i, e.color, life - sum, fx.lifetime, e.rotation, e.x, e.y, e.data);
                fx.render(cont);
                this.clip = Math.max(this.clip, fx.clip);
                break;
            }
            sum += fx.lifetime;
        }
    }
}

