/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;

public class LaserBulletType
extends BulletType {
    public Color[] colors = new Color[]{Pal.lancerLaser.cpy().mul(1.0f, 1.0f, 1.0f, 0.4f), Pal.lancerLaser, Color.white};
    public Effect laserEffect = Fx.lancerLaserShootSmoke;
    public float length = 160.0f;
    public float width = 15.0f;
    public float lengthFalloff = 0.5f;
    public float sideLength = 29.0f;
    public float sideWidth = 0.7f;
    public float sideAngle = 90.0f;
    public float lightningSpacing = -1.0f;
    public float lightningDelay = 0.1f;
    public float lightningAngleRand;
    public boolean largeHit = false;

    public LaserBulletType(float damage) {
        this.damage = damage;
        this.speed = 0.0f;
        this.hitEffect = Fx.hitLaserBlast;
        this.hitColor = this.colors[2];
        this.despawnEffect = Fx.none;
        this.shootEffect = Fx.hitLancer;
        this.smokeEffect = Fx.none;
        this.hitSize = 4.0f;
        this.lifetime = 16.0f;
        this.impact = true;
        this.keepVelocity = false;
        this.collides = false;
        this.pierce = true;
        this.hittable = false;
        this.absorbable = false;
        this.removeAfterPierce = false;
    }

    public LaserBulletType() {
        this(1.0f);
    }

    @Override
    public float estimateDPS() {
        return super.estimateDPS() * 3.0f;
    }

    @Override
    public void init() {
        super.init();
        this.drawSize = Math.max(this.drawSize, this.length * 2.0f);
    }

    @Override
    protected float calculateRange() {
        return Math.max(this.length, this.maxRange);
    }

    @Override
    public void init(Bullet b) {
        float resultLength = Damage.collideLaser(b, this.length, this.largeHit, this.laserAbsorb, this.pierceCap);
        float rot = b.rotation();
        this.laserEffect.at(b.x, b.y, rot, Float.valueOf(resultLength * 0.75f));
        if (this.lightningSpacing > 0.0f) {
            int idx = 0;
            for (float i = 0.0f; i <= resultLength; i += this.lightningSpacing) {
                float cx = b.x + Angles.trnsx(rot, i);
                float cy = b.y + Angles.trnsy(rot, i);
                int f = idx++;
                for (int s : Mathf.signs) {
                    Time.run((float)f * this.lightningDelay, () -> {
                        if (b.isAdded() && b.type == this) {
                            Lightning.create(b, this.lightningColor, this.lightningDamage < 0.0f ? this.damage : this.lightningDamage, cx, cy, rot + (float)(90 * s) + Mathf.range(this.lightningAngleRand), this.lightningLength + Mathf.random(this.lightningLengthRand));
                        }
                    });
                }
            }
        }
    }

    @Override
    public void draw(Bullet b) {
        float realLength = b.fdata;
        float f = Mathf.curve(b.fin(), 0.0f, 0.2f);
        float baseLen = realLength * f;
        float cwidth = this.width;
        float compound = 1.0f;
        Lines.lineAngle(b.x, b.y, b.rotation(), baseLen);
        for (Color color : this.colors) {
            Draw.color(color);
            Lines.stroke((cwidth *= this.lengthFalloff) * b.fout());
            Lines.lineAngle(b.x, b.y, b.rotation(), baseLen, false);
            Tmp.v1.trns(b.rotation(), baseLen);
            Drawf.tri(b.x + Tmp.v1.x, b.y + Tmp.v1.y, Lines.getStroke(), cwidth * 2.0f + this.width / 2.0f, b.rotation());
            Fill.circle(b.x, b.y, 1.0f * cwidth * b.fout());
            for (int i : Mathf.signs) {
                Drawf.tri(b.x, b.y, this.sideWidth * b.fout() * cwidth, this.sideLength * compound, b.rotation() + this.sideAngle * (float)i);
            }
            compound *= this.lengthFalloff;
        }
        Draw.reset();
        Tmp.v1.trns(b.rotation(), baseLen * 1.1f);
        Drawf.light(b.x, b.y, b.x + Tmp.v1.x, b.y + Tmp.v1.y, this.width * 1.4f * b.fout(), this.colors[0], 0.6f);
    }

    @Override
    public void drawLight(Bullet b) {
    }
}

