/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.bullet;

import arc.Events;
import arc.audio.Sound;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ai.types.MissileAI;
import mindustry.content.Bullets;
import mindustry.content.Fx;
import mindustry.content.Liquids;
import mindustry.content.StatusEffects;
import mindustry.ctype.Content;
import mindustry.ctype.ContentType;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Fires;
import mindustry.entities.Lightning;
import mindustry.entities.Mover;
import mindustry.entities.Puddles;
import mindustry.entities.Units;
import mindustry.entities.part.DrawPart;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Call;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.gen.Velc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.type.Liquid;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.world.Tile;
import mindustry.world.blocks.ConstructBlock;
import mindustry.world.blocks.ControlBlock;

public class BulletType
extends Content
implements Cloneable {
    static final EventType.UnitDamageEvent bulletDamageEvent = new EventType.UnitDamageEvent();
    public float lifetime = 40.0f;
    public float speed = 1.0f;
    public float damage = 1.0f;
    public float hitSize = 4.0f;
    public float drawSize = 40.0f;
    public float drag = 0.0f;
    public boolean pierce;
    public boolean pierceBuilding;
    public int pierceCap = -1;
    public float pierceDamageFactor = 0.0f;
    public boolean removeAfterPierce = true;
    public boolean laserAbsorb = true;
    public float optimalLifeFract = 0.0f;
    public float layer = 100.0f;
    public Effect hitEffect = Fx.hitBulletSmall;
    public Effect despawnEffect = Fx.hitBulletSmall;
    public Effect shootEffect = Fx.shootSmall;
    public Effect chargeEffect = Fx.none;
    public Effect smokeEffect = Fx.shootSmallSmoke;
    public Sound hitSound = Sounds.none;
    public Sound despawnSound = Sounds.none;
    public float hitSoundPitch = 1.0f;
    public float hitSoundVolume = 1.0f;
    public float inaccuracy = 0.0f;
    public float ammoMultiplier = 2.0f;
    public float reloadMultiplier = 1.0f;
    public float buildingDamageMultiplier = 1.0f;
    public float recoil;
    public boolean killShooter;
    public boolean instantDisappear;
    public float splashDamage = 0.0f;
    public boolean scaledSplashDamage = false;
    public float knockback;
    public boolean impact;
    public StatusEffect status = StatusEffects.none;
    public float statusDuration = 480.0f;
    public boolean collidesTiles = true;
    public boolean collidesTeam = false;
    public boolean collidesAir = true;
    public boolean collidesGround = true;
    public boolean collides = true;
    public boolean collideFloor = false;
    public boolean collideTerrain = false;
    public boolean keepVelocity = true;
    public boolean scaleLife;
    public boolean hittable = true;
    public boolean reflectable = true;
    public boolean absorbable = true;
    public boolean backMove = true;
    public boolean ignoreSpawnAngle = false;
    public float createChance = 1.0f;
    public float maxRange = -1.0f;
    public float rangeOverride = -1.0f;
    public float rangeChange = 0.0f;
    public float range = 0.0f;
    public float healPercent = 0.0f;
    public float healAmount = 0.0f;
    public boolean makeFire = false;
    public boolean despawnHit = false;
    public boolean fragOnHit = true;
    public boolean fragOnAbsorb = true;
    public boolean pierceArmor = false;
    public boolean setDefaults = true;
    public float hitShake = 0.0f;
    public float despawnShake = 0.0f;
    @Nullable
    public BulletType fragBullet = null;
    public float fragRandomSpread = 360.0f;
    public float fragSpread = 0.0f;
    public float fragAngle = 0.0f;
    public int fragBullets = 9;
    public float fragVelocityMin = 0.2f;
    public float fragVelocityMax = 1.0f;
    public float fragLifeMin = 1.0f;
    public float fragLifeMax = 1.0f;
    @Nullable
    public BulletType intervalBullet;
    public float bulletInterval = 20.0f;
    public int intervalBullets = 1;
    public float intervalRandomSpread = 360.0f;
    public float intervalSpread = 0.0f;
    public float intervalAngle = 0.0f;
    public float intervalDelay = -1.0f;
    public Color hitColor = Color.white;
    public Color healColor = Pal.heal;
    public Effect healEffect = Fx.healBlockFull;
    public Seq<BulletType> spawnBullets = new Seq();
    @Nullable
    public UnitType spawnUnit;
    @Nullable
    public UnitType despawnUnit;
    public float despawnUnitChance = 1.0f;
    public int despawnUnitCount = 1;
    public float despawnUnitRadius = 0.1f;
    public boolean faceOutwards = false;
    public Seq<DrawPart> parts = new Seq();
    public Color trailColor = Pal.missileYellowBack;
    public float trailChance = -1.0E-4f;
    public float trailInterval = 0.0f;
    public Effect trailEffect = Fx.missileTrail;
    public float trailParam = 2.0f;
    public boolean trailRotation = false;
    public Interp trailInterp = Interp.one;
    public int trailLength = -1;
    public float trailWidth = 2.0f;
    public float trailSinMag = 0.0f;
    public float trailSinScl = 3.0f;
    public float splashDamageRadius = -1.0f;
    public boolean splashDamagePierce = false;
    public int incendAmount = 0;
    public float incendSpread = 8.0f;
    public float incendChance = 1.0f;
    public float homingPower = 0.0f;
    public float homingRange = 50.0f;
    public float homingDelay = -1.0f;
    public float suppressionRange = -1.0f;
    public float suppressionDuration = 480.0f;
    public float suppressionEffectChance = 50.0f;
    public Color lightningColor = Pal.surge;
    public int lightning;
    public int lightningLength = 5;
    public int lightningLengthRand = 0;
    public float lightningDamage = -1.0f;
    public float lightningCone = 360.0f;
    public float lightningAngle = 0.0f;
    @Nullable
    public BulletType lightningType = null;
    public float weaveScale = 1.0f;
    public float weaveMag = 0.0f;
    public boolean weaveRandom = true;
    public int puddles;
    public float puddleRange;
    public float puddleAmount = 5.0f;
    public Liquid puddleLiquid = Liquids.water;
    public boolean displayAmmoMultiplier = true;
    public float lightRadius = -1.0f;
    public float lightOpacity = 0.3f;
    public Color lightColor = Pal.powerLight;

    public BulletType(float speed, float damage) {
        this.speed = speed;
        this.damage = damage;
    }

    public BulletType() {
    }

    public BulletType copy() {
        try {
            BulletType copy = (BulletType)this.clone();
            copy.id = (short)Vars.content.getBy((ContentType)this.getContentType()).size;
            Vars.content.handleContent(copy);
            return copy;
        }
        catch (Exception e) {
            throw new RuntimeException("death to checked exceptions", e);
        }
    }

    @Override
    public void load() {
        for (DrawPart part : this.parts) {
            part.turretShading = false;
            part.load(null);
        }
    }

    public float estimateDPS() {
        if (this.spawnUnit != null) {
            return this.spawnUnit.estimateDps();
        }
        float sum = this.damage + this.splashDamage * 0.75f;
        if (this.fragBullet != null && this.fragBullet != this) {
            sum += this.fragBullet.estimateDPS() * (float)this.fragBullets / 2.0f;
        }
        return sum;
    }

    protected float calculateRange() {
        if (this.rangeOverride > 0.0f) {
            return this.rangeOverride;
        }
        if (this.spawnUnit != null) {
            return this.spawnUnit.lifetime * this.spawnUnit.speed;
        }
        return Math.max(Mathf.zero(this.drag) ? this.speed * this.lifetime : this.speed * (1.0f - Mathf.pow(1.0f - this.drag, this.lifetime)) / this.drag, this.maxRange);
    }

    public float continuousDamage() {
        return -1.0f;
    }

    public boolean heals() {
        return this.healPercent > 0.0f || this.healAmount > 0.0f;
    }

    public boolean testCollision(Bullet bullet, Building tile) {
        return !this.heals() || tile.team != bullet.team || tile.healthf() < 1.0f;
    }

    public void hitTile(Bullet b, Building build, float x, float y, float initialHealth, boolean direct) {
        if (this.makeFire && build.team != b.team) {
            Fires.create(build.tile);
        }
        if (this.heals() && build.team == b.team && !(build.block instanceof ConstructBlock)) {
            this.healEffect.at(build.x, build.y, 0.0f, this.healColor, build.block);
            build.heal(this.healPercent / 100.0f * build.maxHealth + this.healAmount);
        } else if (build.team != b.team && direct) {
            this.hit(b);
        }
        this.handlePierce(b, initialHealth, x, y);
    }

    /*
     * Unable to fully structure code
     */
    public void hitEntity(Bullet b, Hitboxc entity, float health) {
        if (!(entity instanceof Unit)) ** GOTO lbl-1000
        u = (Unit)entity;
        if (u.dead) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = wasDead = false;
        }
        if (entity instanceof Healthc) {
            h = (Healthc)entity;
            if (this.pierceArmor) {
                h.damagePierce(b.damage);
            } else {
                h.damage(b.damage);
            }
        }
        if (entity instanceof Unit) {
            unit = (Unit)entity;
            Tmp.v3.set(unit).sub(b).nor().scl(this.knockback * 80.0f);
            if (this.impact) {
                Tmp.v3.setAngle(b.rotation() + (this.knockback < 0.0f ? 180.0f : 0.0f));
            }
            unit.impulse(Tmp.v3);
            unit.apply(this.status, this.statusDuration);
            Events.fire(BulletType.bulletDamageEvent.set(unit, b));
        }
        if (!wasDead && entity instanceof Unit) {
            unit = (Unit)entity;
            if (unit.dead) {
                Events.fire(new EventType.UnitBulletDestroyEvent(unit, b));
            }
        }
        this.handlePierce(b, health, entity.x(), entity.y());
    }

    public void handlePierce(Bullet b, float initialHealth, float x, float y) {
        float sub = Mathf.zero(this.pierceDamageFactor) ? 0.0f : Math.max(initialHealth * this.pierceDamageFactor, 0.0f);
        b.damage = b.damage - (Float.isNaN(sub) ? b.damage : Math.min(b.damage, sub));
        if (this.removeAfterPierce && b.damage <= 0.0f) {
            b.hit = true;
            b.remove();
        }
    }

    public float damageMultiplier(Bullet b) {
        Entityc entityc = b.owner;
        if (entityc instanceof Unit) {
            Unit u = (Unit)entityc;
            return u.damageMultiplier() * Vars.state.rules.unitDamage(b.team);
        }
        if (b.owner instanceof Building) {
            return Vars.state.rules.blockDamage(b.team);
        }
        return 1.0f;
    }

    public void hit(Bullet b) {
        this.hit(b, b.x, b.y);
    }

    public void hit(Bullet b, float x, float y) {
        this.hitEffect.at(x, y, b.rotation(), this.hitColor);
        this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
        Effect.shake(this.hitShake, this.hitShake, b);
        if (this.fragOnHit) {
            this.createFrags(b, x, y);
        }
        this.createPuddles(b, x, y);
        this.createIncend(b, x, y);
        this.createUnits(b, x, y);
        if (this.suppressionRange > 0.0f) {
            Damage.applySuppression(b.team, b.x, b.y, this.suppressionRange, this.suppressionDuration, 0.0f, this.suppressionEffectChance, new Vec2(b.x, b.y));
        }
        this.createSplashDamage(b, x, y);
        for (int i = 0; i < this.lightning; ++i) {
            Lightning.create(b, this.lightningColor, this.lightningDamage < 0.0f ? this.damage : this.lightningDamage, b.x, b.y, b.rotation() + Mathf.range(this.lightningCone / 2.0f) + this.lightningAngle, this.lightningLength + Mathf.random(this.lightningLengthRand));
        }
    }

    public void createIncend(Bullet b, float x, float y) {
        if (this.incendChance > 0.0f && Mathf.chance(this.incendChance)) {
            Damage.createIncend(x, y, this.incendSpread, this.incendAmount);
        }
    }

    public void createPuddles(Bullet b, float x, float y) {
        if (this.puddleLiquid != null && this.puddles > 0) {
            for (int i = 0; i < this.puddles; ++i) {
                Tile tile = Vars.world.tileWorld(x + Mathf.range(this.puddleRange), y + Mathf.range(this.puddleRange));
                Puddles.deposit(tile, this.puddleLiquid, this.puddleAmount);
            }
        }
    }

    public void createSplashDamage(Bullet b, float x, float y) {
        if (this.splashDamageRadius > 0.0f && !b.absorbed) {
            Damage.damage(b.team, x, y, this.splashDamageRadius, this.splashDamage * b.damageMultiplier(), this.splashDamagePierce, this.collidesAir, this.collidesGround, this.scaledSplashDamage, b);
            if (this.status != StatusEffects.none) {
                Damage.status(b.team, x, y, this.splashDamageRadius, this.status, this.statusDuration, this.collidesAir, this.collidesGround);
            }
            if (this.heals()) {
                Vars.indexer.eachBlock(b.team, x, y, this.splashDamageRadius, Building::damaged, other -> {
                    this.healEffect.at(other.x, other.y, 0.0f, this.healColor, other.block);
                    other.heal(this.healPercent / 100.0f * other.maxHealth() + this.healAmount);
                });
            }
            if (this.makeFire) {
                Vars.indexer.eachBlock(null, x, y, this.splashDamageRadius, other -> other.team != b.team, other -> Fires.create(other.tile));
            }
        }
    }

    public void createFrags(Bullet b, float x, float y) {
        if (this.fragBullet != null && (this.fragOnAbsorb || !b.absorbed)) {
            for (int i = 0; i < this.fragBullets; ++i) {
                float len = Mathf.random(1.0f, 7.0f);
                float a = b.rotation() + Mathf.range(this.fragRandomSpread / 2.0f) + this.fragAngle + (float)(i - this.fragBullets / 2) * this.fragSpread;
                this.fragBullet.create(b, x + Angles.trnsx(a, len), y + Angles.trnsy(a, len), a, Mathf.random(this.fragVelocityMin, this.fragVelocityMax), Mathf.random(this.fragLifeMin, this.fragLifeMax));
            }
        }
    }

    public void createUnits(Bullet b, float x, float y) {
        if (this.despawnUnit != null && Mathf.chance(this.despawnUnitChance)) {
            for (int i = 0; i < this.despawnUnitCount; ++i) {
                Tmp.v1.rnd(Mathf.random(this.despawnUnitRadius));
                Unit u = this.despawnUnit.spawn(b.team, x + Tmp.v1.x, y + Tmp.v1.y);
                u.rotation = this.faceOutwards ? Tmp.v1.angle() : b.rotation();
            }
        }
    }

    public void despawned(Bullet b) {
        if (this.despawnHit) {
            this.hit(b);
        } else {
            this.createUnits(b, b.x, b.y);
        }
        if (!this.fragOnHit) {
            this.createFrags(b, b.x, b.y);
        }
        this.despawnEffect.at(b.x, b.y, b.rotation(), this.hitColor);
        this.despawnSound.at(b);
        Effect.shake(this.despawnShake, this.despawnShake, b);
    }

    public void removed(Bullet b) {
        if (this.trailLength > 0 && b.trail != null && b.trail.size() > 0) {
            Fx.trailFade.at(b.x, b.y, this.trailWidth, this.trailColor, b.trail.copy());
        }
    }

    public void draw(Bullet b) {
        this.drawTrail(b);
        this.drawParts(b);
    }

    public void drawTrail(Bullet b) {
        if (this.trailLength > 0 && b.trail != null) {
            float z = Draw.z();
            Draw.z(z - 1.0E-4f);
            b.trail.draw(this.trailColor, this.trailWidth);
            Draw.z(z);
        }
    }

    public void drawParts(Bullet b) {
        if (this.parts.size > 0) {
            DrawPart.params.set(b.fin(), 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, b.x, b.y, b.rotation());
            DrawPart.params.life = b.fin();
            for (int i = 0; i < this.parts.size; ++i) {
                this.parts.get(i).draw(DrawPart.params);
            }
        }
    }

    public void drawLight(Bullet b) {
        if (this.lightOpacity <= 0.0f || this.lightRadius <= 0.0f) {
            return;
        }
        Drawf.light(b, this.lightRadius, this.lightColor, this.lightOpacity);
    }

    public void init(Bullet b) {
        Healthc h;
        Entityc entityc;
        if (this.killShooter && (entityc = b.owner()) instanceof Healthc && !(h = (Healthc)entityc).dead()) {
            h.kill();
        }
        if (this.instantDisappear) {
            b.time = this.lifetime + 1.0f;
        }
        if (this.spawnBullets.size > 0) {
            for (BulletType bullet : this.spawnBullets) {
                bullet.create(b, b.x, b.y, b.rotation());
            }
        }
    }

    public void update(Bullet b) {
        this.updateTrail(b);
        this.updateHoming(b);
        this.updateWeaving(b);
        this.updateTrailEffects(b);
        this.updateBulletInterval(b);
    }

    public void updateBulletInterval(Bullet b) {
        if (this.intervalBullet != null && b.time >= this.intervalDelay && b.timer.get(2, this.bulletInterval)) {
            float ang = b.rotation();
            for (int i = 0; i < this.intervalBullets; ++i) {
                this.intervalBullet.create(b, b.x, b.y, ang + Mathf.range(this.intervalRandomSpread) + this.intervalAngle + ((float)i - ((float)this.intervalBullets - 1.0f) / 2.0f) * this.intervalSpread);
            }
        }
    }

    public void updateHoming(Bullet b) {
        if (this.homingPower > 1.0E-4f && b.time >= this.homingDelay) {
            float realAimY;
            float realAimX = b.aimX < 0.0f ? b.x : b.aimX;
            float f = realAimY = b.aimY < 0.0f ? b.y : b.aimY;
            Teamc target = this.heals() ? Units.closestTarget(null, realAimX, realAimY, this.homingRange, e -> e.checkTarget(this.collidesAir, this.collidesGround) && e.team != b.team && !b.hasCollided(e.id), t -> this.collidesGround && (t.team != b.team || t.damaged()) && !b.hasCollided(t.id)) : (b.aimTile != null && b.aimTile.build != null && b.aimTile.build.team != b.team && this.collidesGround && !b.hasCollided(b.aimTile.build.id) ? b.aimTile.build : Units.closestTarget(b.team, realAimX, realAimY, this.homingRange, e -> e != null && e.checkTarget(this.collidesAir, this.collidesGround) && !b.hasCollided(e.id), t -> t != null && this.collidesGround && !b.hasCollided(t.id)));
            if (target != null) {
                b.vel.setAngle(Angles.moveToward(b.rotation(), b.angleTo(target), this.homingPower * Time.delta * 50.0f));
            }
        }
    }

    public void updateWeaving(Bullet b) {
        if (this.weaveMag != 0.0f) {
            b.vel.rotateRadExact((float)Math.sin(((double)b.time + Math.PI * (double)this.weaveScale / 2.0) / (double)this.weaveScale) * this.weaveMag * (this.weaveRandom ? (float)(Mathf.randomSeed((long)b.id, 0, 1) == 1 ? -1 : 1) : 1.0f) * Time.delta * ((float)Math.PI / 180));
        }
    }

    public void updateTrailEffects(Bullet b) {
        if (this.trailChance > 0.0f && Mathf.chanceDelta(this.trailChance)) {
            this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : this.trailParam, this.trailColor);
        }
        if (this.trailInterval > 0.0f && b.timer(0, this.trailInterval)) {
            this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : this.trailParam, this.trailColor);
        }
    }

    public void updateTrail(Bullet b) {
        if (!Vars.headless && this.trailLength > 0) {
            if (b.trail == null) {
                b.trail = new Trail(this.trailLength);
            }
            b.trail.length = this.trailLength;
            b.trail.update(b.x, b.y, this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin(Time.time, this.trailSinScl, this.trailSinMag) : 0.0f)));
        }
    }

    @Override
    public void init() {
        if (this.pierceCap >= 1) {
            this.pierce = true;
        }
        if (this.setDefaults) {
            if (this.lightning > 0 && this.status == StatusEffects.none) {
                this.status = StatusEffects.shocked;
            }
            if (this.fragBullet != null || this.splashDamageRadius > 0.0f || this.lightning > 0) {
                this.despawnHit = true;
            }
        }
        if (this.fragBullet != null) {
            this.fragBullet.keepVelocity = false;
        }
        if (this.lightningType == null) {
            BulletType bulletType = this.lightningType = !this.collidesAir ? Bullets.damageLightningGround : Bullets.damageLightning;
        }
        if (this.lightRadius <= -1.0f) {
            this.lightRadius = Math.max(18.0f, this.hitSize * 5.0f);
        }
        this.drawSize = Math.max(this.drawSize, (float)this.trailLength * this.speed * 2.0f);
        this.range = this.calculateRange();
    }

    @Override
    public ContentType getContentType() {
        return ContentType.bullet;
    }

    @Nullable
    public Bullet create(Teamc owner, float x, float y, float angle) {
        return this.create(owner, owner.team(), x, y, angle);
    }

    @Nullable
    public Bullet create(Entityc owner, Team team, float x, float y, float angle) {
        return this.create(owner, team, x, y, angle, 1.0f);
    }

    @Nullable
    public Bullet create(Entityc owner, Team team, float x, float y, float angle, float velocityScl) {
        return this.create(owner, team, x, y, angle, -1.0f, velocityScl, 1.0f, null);
    }

    @Nullable
    public Bullet create(Entityc owner, Team team, float x, float y, float angle, float velocityScl, float lifetimeScl) {
        return this.create(owner, team, x, y, angle, -1.0f, velocityScl, lifetimeScl, null);
    }

    @Nullable
    public Bullet create(Entityc owner, Team team, float x, float y, float angle, float velocityScl, float lifetimeScl, Mover mover) {
        return this.create(owner, team, x, y, angle, -1.0f, velocityScl, lifetimeScl, null, mover);
    }

    @Nullable
    public Bullet create(Bullet parent, float x, float y, float angle) {
        return this.create(parent.owner, parent.team, x, y, angle);
    }

    @Nullable
    public Bullet create(Bullet parent, float x, float y, float angle, float velocityScl, float lifeScale) {
        return this.create(parent.owner, parent.team, x, y, angle, velocityScl, lifeScale);
    }

    @Nullable
    public Bullet create(Bullet parent, float x, float y, float angle, float velocityScl) {
        return this.create(parent.owner(), parent.team, x, y, angle, velocityScl);
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data) {
        return this.create(owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, null);
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover) {
        return this.create(owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, -1.0f, -1.0f);
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY) {
        return this.create(owner, owner, team, x, y, angle, damage, velocityScl, lifetimeScl, data, mover, aimX, aimY);
    }

    @Nullable
    public Bullet create(@Nullable Entityc owner, @Nullable Entityc shooter, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, @Nullable Mover mover, float aimX, float aimY) {
        if (!Mathf.chance(this.createChance)) {
            return null;
        }
        if (this.ignoreSpawnAngle) {
            angle = 0.0f;
        }
        if (this.spawnUnit != null) {
            Healthc h;
            if (!Vars.net.client()) {
                UnitController unitController;
                Unit spawned = this.spawnUnit.create(team);
                spawned.set(x, y);
                spawned.rotation = angle;
                if (this.spawnUnit.missileAccelTime <= 0.0f) {
                    spawned.vel.trns(angle, this.spawnUnit.speed);
                }
                if ((unitController = spawned.controller()) instanceof MissileAI) {
                    MissileAI ai = (MissileAI)unitController;
                    if (shooter instanceof Unit) {
                        Unit unit;
                        ai.shooter = unit = (Unit)shooter;
                    }
                    if (shooter instanceof ControlBlock) {
                        ControlBlock control = (ControlBlock)((Object)shooter);
                        ai.shooter = control.unit();
                    }
                }
                spawned.add();
            }
            if (this.killShooter && owner instanceof Healthc && !(h = (Healthc)owner).dead()) {
                h.kill();
            }
            return null;
        }
        Bullet bullet = Bullet.create();
        bullet.type = this;
        bullet.owner = owner;
        bullet.team = team;
        bullet.time = 0.0f;
        bullet.originX = x;
        bullet.originY = y;
        if (aimX != -1.0f || aimY != -1.0f) {
            bullet.aimTile = Vars.world.tileWorld(aimX, aimY);
        }
        bullet.aimX = aimX;
        bullet.aimY = aimY;
        bullet.initVel(angle, this.speed * velocityScl);
        if (this.backMove) {
            bullet.set(x - bullet.vel.x * Time.delta, y - bullet.vel.y * Time.delta);
        } else {
            bullet.set(x, y);
        }
        bullet.lifetime = this.lifetime * lifetimeScl;
        bullet.data = data;
        bullet.drag = this.drag;
        bullet.hitSize = this.hitSize;
        bullet.mover = mover;
        bullet.damage = (damage < 0.0f ? this.damage : damage) * bullet.damageMultiplier();
        if (bullet.trail != null) {
            bullet.trail.clear();
        }
        bullet.add();
        if (this.keepVelocity && owner instanceof Velc) {
            Velc v = (Velc)owner;
            bullet.vel.add(v.vel());
        }
        return bullet;
    }

    public void createNet(Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl) {
        Call.createBullet(this, team, x, y, angle, damage, velocityScl, lifetimeScl);
    }

    public static void createBullet(BulletType type, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl) {
        if (type == null) {
            return;
        }
        type.create(null, team, x, y, angle, damage, velocityScl, lifetimeScl, null);
    }
}

