/*
 * Decompiled with CFR 0.152.
 */
package mindustry.entities.abilities;

import arc.graphics.Color;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;

public class MoveEffectAbility
extends Ability {
    public float minVelocity = 0.08f;
    public float interval = 3.0f;
    public float x;
    public float y;
    public float rotation;
    public boolean rotateEffect = false;
    public float effectParam = 3.0f;
    public boolean teamColor = false;
    public boolean parentizeEffects;
    public Color color = Color.white;
    public Effect effect = Fx.missileTrail;
    protected float counter;

    public MoveEffectAbility(float x, float y, Color color, Effect effect, float interval) {
        this.x = x;
        this.y = y;
        this.color = color;
        this.effect = effect;
        this.interval = interval;
        this.display = false;
    }

    public MoveEffectAbility() {
        this.display = false;
    }

    @Override
    public void update(Unit unit) {
        if (Vars.headless) {
            return;
        }
        this.counter += Time.delta;
        if (unit.vel.len2() >= this.minVelocity * this.minVelocity && this.counter >= this.interval && !unit.inFogTo(Vars.player.team())) {
            Tmp.v1.trns(unit.rotation - 90.0f, this.x, this.y);
            this.counter %= this.interval;
            this.effect.at(Tmp.v1.x + unit.x, Tmp.v1.y + unit.y, (this.rotateEffect ? unit.rotation : this.effectParam) + this.rotation, this.teamColor ? unit.team.color : this.color, this.parentizeEffects ? unit : null);
        }
    }
}

