/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai.types;

import arc.math.Mathf;
import mindustry.Vars;
import mindustry.entities.units.AIController;
import mindustry.entities.units.WeaponMount;
import mindustry.world.Tile;
import mindustry.world.blocks.storage.CoreBlock;

public class GroundAI
extends AIController {
    @Override
    public void updateMovement() {
        CoreBlock.CoreBuild core = this.unit.closestEnemyCore();
        if (core != null && this.unit.within(core, this.unit.range() / 1.3f + (float)(core.block.size * 8) / 2.0f)) {
            this.target = core;
            for (WeaponMount mount : this.unit.mounts) {
                if (!mount.weapon.controllable || !mount.weapon.bullet.collidesGround) continue;
                mount.target = core;
            }
        }
        if (core == null || !this.unit.within(core, this.unit.type.range * 0.5f)) {
            boolean move = true;
            if (Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam) {
                Tile spawner = this.getClosestSpawner();
                if (spawner != null && this.unit.within(spawner, Vars.state.rules.dropZoneRadius + 120.0f)) {
                    move = false;
                }
                if (spawner == null && core == null) {
                    move = false;
                }
            }
            if (!(core != null || Vars.state.rules.waves && this.getClosestSpawner() != null)) {
                move = false;
            }
            if (move) {
                this.pathfind(0);
            }
        }
        if (this.unit.type.canBoost && this.unit.elevation > 0.001f && !this.unit.onSolid()) {
            this.unit.elevation = Mathf.approachDelta(this.unit.elevation, 0.0f, this.unit.type.riseSpeed);
        }
        this.faceTarget();
    }
}

