/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Core;
import arc.func.Func;
import arc.scene.style.TextureRegionDrawable;
import arc.struct.Seq;
import mindustry.ai.types.BoostAI;
import mindustry.ai.types.BuilderAI;
import mindustry.ai.types.MinerAI;
import mindustry.ai.types.RepairAI;
import mindustry.entities.units.AIController;
import mindustry.gen.Icon;
import mindustry.gen.Iconc;
import mindustry.gen.Unit;

public class UnitCommand {
    public static final Seq<UnitCommand> all = new Seq();
    public static final UnitCommand moveCommand = new UnitCommand("move", "right", u -> null){
        {
            this.drawTarget = true;
            this.resetTarget = false;
        }
    };
    public static final UnitCommand repairCommand = new UnitCommand("repair", "modeSurvival", u -> new RepairAI());
    public static final UnitCommand rebuildCommand = new UnitCommand("rebuild", "hammer", u -> new BuilderAI());
    public static final UnitCommand assistCommand = new UnitCommand("assist", "players", u -> {
        BuilderAI ai = new BuilderAI();
        ai.onlyAssist = true;
        return ai;
    });
    public static final UnitCommand mineCommand = new UnitCommand("mine", "production", u -> new MinerAI());
    public static final UnitCommand boostCommand = new UnitCommand("boost", "up", u -> new BoostAI()){
        {
            this.switchToMove = false;
            this.drawTarget = true;
            this.resetTarget = false;
        }
    };
    public final int id;
    public final String name;
    public final String icon;
    public final Func<Unit, AIController> controller;
    public boolean switchToMove = true;
    public boolean drawTarget = false;
    public boolean resetTarget = true;

    public UnitCommand(String name, String icon, Func<Unit, AIController> controller) {
        this.name = name;
        this.icon = icon;
        this.controller = controller;
        this.id = UnitCommand.all.size;
        all.add(this);
    }

    public String localized() {
        return Core.bundle.get("command." + this.name);
    }

    public TextureRegionDrawable getIcon() {
        return Icon.icons.get(this.icon, Icon.cancel);
    }

    public char getEmoji() {
        return (char)Iconc.codes.get(this.icon, 59413);
    }

    public String toString() {
        return "UnitCommand:" + this.name;
    }
}

