/*
 * Decompiled with CFR 0.152.
 */
package mindustry.ai;

import arc.Events;
import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Prov;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.QuadTree;
import arc.math.geom.Rect;
import arc.struct.EnumSet;
import arc.struct.IntSeq;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.game.Teams;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.logic.Ranged;
import mindustry.type.Item;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.meta.BlockFlag;

public class BlockIndexer {
    private static final int quadrantSize = 20;
    private static final Rect rect = new Rect();
    private static boolean returnBool = false;
    private int quadWidth;
    private int quadHeight;
    private IntSeq[][][] ores;
    private Seq<Building>[] damagedTiles = new Seq[Team.all.length];
    private ObjectIntMap<Item> allOres = new ObjectIntMap();
    private Seq<Team> activeTeams = new Seq(Team.class);
    private Seq<Building>[][] flagMap = new Seq[Team.all.length][BlockFlag.all.length];
    private boolean[] blocksPresent;
    private Seq<Building> breturnArray = new Seq(Building.class);

    public BlockIndexer() {
        this.clearFlags();
        Events.on(EventType.TilePreChangeEvent.class, event -> this.removeIndex(event.tile));
        Events.on(EventType.TileChangeEvent.class, event -> this.addIndex(event.tile));
        Events.on(EventType.WorldLoadEvent.class, event -> {
            this.damagedTiles = new Seq[Team.all.length];
            this.flagMap = new Seq[Team.all.length][BlockFlag.all.length];
            this.activeTeams = new Seq(Team.class);
            this.clearFlags();
            this.allOres.clear();
            this.ores = new IntSeq[Vars.content.items().size][][];
            this.quadWidth = Mathf.ceil((float)Vars.world.width() / 20.0f);
            this.quadHeight = Mathf.ceil((float)Vars.world.height() / 20.0f);
            this.blocksPresent = new boolean[Vars.content.blocks().size];
            for (Team team : Team.all) {
                Teams.TeamData data = Vars.state.teams.get(team);
                if (data == null) continue;
                if (data.buildingTree != null) {
                    data.buildingTree.clear();
                }
                if (data.turretTree == null) continue;
                data.turretTree.clear();
            }
            for (Tile tile : Vars.world.tiles) {
                this.process(tile);
                Item drop = tile.drop();
                if (drop == null) continue;
                int qx = tile.x / 20;
                int qy = tile.y / 20;
                if (tile.block() != Blocks.air) continue;
                if (this.ores[drop.id] == null) {
                    this.ores[drop.id] = new IntSeq[this.quadWidth][this.quadHeight];
                }
                if (this.ores[drop.id][qx][qy] == null) {
                    this.ores[drop.id][qx][qy] = new IntSeq(false, 16);
                }
                this.ores[drop.id][qx][qy].add(tile.pos());
                this.allOres.increment(drop);
            }
        });
    }

    public void removeIndex(Tile tile) {
        Team team = tile.team();
        if (tile.build != null && tile.isCenter()) {
            Building build = tile.build;
            EnumSet<BlockFlag> flags = tile.block().flags;
            Teams.TeamData data = team.data();
            if (flags.size > 0) {
                for (BlockFlag flag : (BlockFlag[])flags.array) {
                    this.getFlagged(team)[flag.ordinal()].remove(build);
                }
            }
            data.buildings.remove(build);
            ((Seq)((Object)data.buildingTypes.get(build.block, (Seq<Building>)((Object)((Prov<Seq>)() -> new Seq(false)))))).remove(build);
            data.unitCap -= tile.block().unitCapModifier;
            if (data.buildingTree != null) {
                data.buildingTree.remove(build);
            }
            if (data.turretTree != null && build.block.attacks) {
                data.turretTree.remove(build);
            }
            build.wasDamaged = false;
            if (build.damaged() && this.damagedTiles[team.id] != null) {
                this.damagedTiles[team.id].remove(build);
            }
        }
    }

    public void addIndex(Tile tile) {
        this.process(tile);
        Item drop = tile.drop();
        if (drop != null && this.ores != null) {
            int qx = tile.x / 20;
            int qy = tile.y / 20;
            if (this.ores[drop.id] == null) {
                this.ores[drop.id] = new IntSeq[this.quadWidth][this.quadHeight];
            }
            if (this.ores[drop.id][qx][qy] == null) {
                this.ores[drop.id][qx][qy] = new IntSeq(false, 16);
            }
            int pos = tile.pos();
            IntSeq seq = this.ores[drop.id][qx][qy];
            if (tile.block() == Blocks.air && !seq.contains(pos)) {
                seq.add(pos);
                this.allOres.increment(drop);
            } else {
                seq.removeValue(pos);
                this.allOres.increment(drop, -1);
            }
        }
    }

    public boolean isBlockPresent(Block block) {
        return this.blocksPresent != null && this.blocksPresent[block.id];
    }

    private void clearFlags() {
        for (int i = 0; i < this.flagMap.length; ++i) {
            for (int j = 0; j < BlockFlag.all.length; ++j) {
                this.flagMap[i][j] = new Seq();
            }
        }
    }

    private Seq<Building>[] getFlagged(Team team) {
        return this.flagMap[team.id];
    }

    public boolean hasOre(Item item) {
        return this.allOres.get(item) > 0;
    }

    public Seq<Building> getDamaged(Team team) {
        if (this.damagedTiles[team.id] == null) {
            this.damagedTiles[team.id] = new Seq<Building>(false);
            return this.damagedTiles[team.id];
        }
        Seq<Building> tiles = this.damagedTiles[team.id];
        tiles.removeAll(b -> !b.damaged());
        return tiles;
    }

    public Seq<Building> getFlagged(Team team, BlockFlag type) {
        return this.flagMap[team.id][type.ordinal()];
    }

    @Nullable
    public Building findClosestFlag(float x, float y, Team team, BlockFlag flag) {
        return Geometry.findClosest(x, y, this.getFlagged(team, flag));
    }

    public boolean eachBlock(Teamc team, float range, Boolf<Building> pred, Cons<Building> cons) {
        return this.eachBlock(team.team(), team.getX(), team.getY(), range, pred, cons);
    }

    public boolean eachBlock(@Nullable Team team, float wx, float wy, float range, Boolf<Building> pred, Cons<Building> cons) {
        if (team == null) {
            returnBool = false;
            this.allBuildings(wx, wy, range, b -> {
                if (pred.get((Building)b)) {
                    returnBool = true;
                    cons.get((Building)b);
                }
            });
            return returnBool;
        }
        this.breturnArray.clear();
        QuadTree<Building> buildings = team.data().buildingTree;
        if (buildings == null) {
            return false;
        }
        buildings.intersect(wx - range, wy - range, range * 2.0f, range * 2.0f, b -> {
            if (b.within(wx, wy, range + b.hitSize() / 2.0f) && pred.get((Building)b)) {
                this.breturnArray.add((Building)b);
            }
        });
        int size = this.breturnArray.size;
        Building[] items = (Building[])this.breturnArray.items;
        for (int i = 0; i < size; ++i) {
            cons.get(items[i]);
            items[i] = null;
        }
        this.breturnArray.size = 0;
        return size > 0;
    }

    public boolean eachBlock(Team team, Rect rect, Boolf<Building> pred, Cons<Building> cons) {
        if (team == null) {
            return false;
        }
        this.breturnArray.clear();
        QuadTree<Building> buildings = team.data().buildingTree;
        if (buildings == null) {
            return false;
        }
        buildings.intersect(rect, b -> {
            if (pred.get((Building)b)) {
                this.breturnArray.add((Building)b);
            }
        });
        int size = this.breturnArray.size;
        Building[] items = (Building[])this.breturnArray.items;
        for (int i = 0; i < size; ++i) {
            cons.get(items[i]);
            items[i] = null;
        }
        this.breturnArray.size = 0;
        return size > 0;
    }

    public Seq<Building> getEnemy(Team team, BlockFlag type) {
        this.breturnArray.clear();
        Seq<Teams.TeamData> data = Vars.state.teams.present;
        if (data.isEmpty()) {
            for (Team enemy : Team.all) {
                Seq<Building> set;
                if (enemy == team || enemy == Team.derelict && !Vars.state.rules.coreCapture || (set = this.getFlagged(enemy)[type.ordinal()]) == null) continue;
                this.breturnArray.addAll(set);
            }
        } else {
            for (int i = 0; i < data.size; ++i) {
                Seq<Building> set;
                Team enemy = ((Teams.TeamData[])data.items)[i].team;
                if (enemy == team || enemy == Team.derelict && !Vars.state.rules.coreCapture || (set = this.getFlagged(enemy)[type.ordinal()]) == null) continue;
                this.breturnArray.addAll(set);
            }
        }
        return this.breturnArray;
    }

    public void notifyHealthChanged(Building build) {
        boolean damaged = build.damaged();
        if (build.wasDamaged != damaged) {
            if (this.damagedTiles[build.team.id] == null) {
                this.damagedTiles[build.team.id] = new Seq(false);
            }
            if (damaged) {
                this.damagedTiles[build.team.id].add(build);
            } else {
                this.damagedTiles[build.team.id].remove(build);
            }
            build.wasDamaged = damaged;
        }
    }

    public void allBuildings(float x, float y, float range, Cons<Building> cons) {
        this.breturnArray.clear();
        for (int i = 0; i < this.activeTeams.size; ++i) {
            Team team = ((Team[])this.activeTeams.items)[i];
            QuadTree<Building> buildings = team.data().buildingTree;
            if (buildings == null) continue;
            buildings.intersect(x - range, y - range, range * 2.0f, range * 2.0f, this.breturnArray);
        }
        Building[] items = (Building[])this.breturnArray.items;
        int size = this.breturnArray.size;
        for (int i = 0; i < size; ++i) {
            Building b = items[i];
            if (b != null && b.within(x, y, range + b.hitSize() / 2.0f)) {
                cons.get(b);
            }
            items[i] = null;
        }
        this.breturnArray.size = 0;
    }

    public Building findEnemyTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        Building target = null;
        float targetDist = 0.0f;
        for (int i = 0; i < this.activeTeams.size; ++i) {
            Building candidate;
            Team enemy = ((Team[])this.activeTeams.items)[i];
            if (enemy == team || enemy == Team.derelict && !Vars.state.rules.coreCapture || (candidate = Vars.indexer.findTile(enemy, x, y, range, b -> pred.get((Building)b) && b.isDiscovered(team), true)) == null) continue;
            float dist = candidate.dst(x, y) - candidate.hitSize() / 2.0f;
            if (!(target == null || dist < targetDist && candidate.block.priority >= target.block.priority) && !(candidate.block.priority > target.block.priority)) continue;
            target = candidate;
            targetDist = dist;
        }
        return target;
    }

    public Building findTile(Team team, float x, float y, float range, Boolf<Building> pred) {
        return this.findTile(team, x, y, range, pred, false);
    }

    public Building findTile(Team team, float x, float y, float range, Boolf<Building> pred, boolean usePriority) {
        Building closest = null;
        float dst = 0.0f;
        QuadTree<Building> buildings = team.data().buildingTree;
        if (buildings == null) {
            return null;
        }
        this.breturnArray.clear();
        buildings.intersect(rect.setCentered(x, y, range * 2.0f), this.breturnArray);
        for (int i = 0; i < this.breturnArray.size; ++i) {
            float bdst;
            Building next = ((Building[])this.breturnArray.items)[i];
            if (!pred.get(next) || !next.block.targetable || !((bdst = next.dst(x, y) - next.hitSize() / 2.0f) < range) || closest != null && (!(bdst < dst) || usePriority && !(closest.block.priority <= next.block.priority)) && (!usePriority || !(closest.block.priority < next.block.priority))) continue;
            dst = bdst;
            closest = next;
        }
        return closest;
    }

    public Tile findClosestOre(float xp, float yp, Item item) {
        if (this.ores[item.id] != null) {
            float minDst = 0.0f;
            Tile closest = null;
            for (int qx = 0; qx < this.quadWidth; ++qx) {
                for (int qy = 0; qy < this.quadHeight; ++qy) {
                    Tile tile;
                    IntSeq arr = this.ores[item.id][qx][qy];
                    if (arr == null || arr.size <= 0 || (tile = Vars.world.tile(arr.first())).block() != Blocks.air) continue;
                    float dst = Mathf.dst2(xp, yp, tile.worldx(), tile.worldy());
                    if (closest != null && !(dst < minDst)) continue;
                    closest = tile;
                    minDst = dst;
                }
            }
            return closest;
        }
        return null;
    }

    public Tile findClosestOre(Unit unit, Item item) {
        return this.findClosestOre(unit.x, unit.y, item);
    }

    private void process(Tile tile) {
        Team team = tile.team();
        if (tile.isCenter() && tile.build != null) {
            Teams.TeamData data = team.data();
            if (tile.block().flags.size > 0 && tile.isCenter()) {
                Seq<Building>[] map = this.getFlagged(team);
                for (BlockFlag flag : (BlockFlag[])tile.block().flags.array) {
                    map[flag.ordinal()].add(tile.build);
                }
            }
            data.buildings.add(tile.build);
            ((Seq)((Object)data.buildingTypes.get(tile.block(), (Seq<Building>)((Object)((Prov<Seq>)() -> new Seq(false)))))).add(tile.build);
            data.unitCap += tile.block().unitCapModifier;
            if (!this.activeTeams.contains(team)) {
                this.activeTeams.add(team);
            }
            if (data.buildingTree == null) {
                data.buildingTree = new QuadTree(new Rect(0.0f, 0.0f, Vars.world.unitWidth(), Vars.world.unitHeight()));
            }
            data.buildingTree.insert(tile.build);
            if (tile.block().attacks && tile.build instanceof Ranged) {
                if (data.turretTree == null) {
                    data.turretTree = new TurretQuadtree(new Rect(0.0f, 0.0f, Vars.world.unitWidth(), Vars.world.unitHeight()));
                }
                data.turretTree.insert(tile.build);
            }
            this.notifyHealthChanged(tile.build);
        }
        if (this.blocksPresent != null) {
            if (!tile.block().isStatic()) {
                this.blocksPresent[tile.floorID()] = true;
                this.blocksPresent[tile.overlayID()] = true;
            }
            if (tile.blockID() < this.blocksPresent.length) {
                this.blocksPresent[tile.blockID()] = true;
            }
        }
    }

    static class TurretQuadtree
    extends QuadTree<Building> {
        public TurretQuadtree(Rect bounds) {
            super(bounds);
        }

        @Override
        public void hitbox(Building build) {
            this.tmp.setCentered(build.x, build.y, ((Ranged)((Object)build)).range() * 2.0f);
        }

        @Override
        protected QuadTree<Building> newChild(Rect rect) {
            return new TurretQuadtree(rect);
        }
    }
}

