/*
 * Decompiled with CFR 0.152.
 */
package arc.util.noise;

public class Simplex {
    static final int[][] grad3 = new int[][]{{1, 1, 0}, {-1, 1, 0}, {1, -1, 0}, {-1, -1, 0}, {1, 0, 1}, {-1, 0, 1}, {1, 0, -1}, {-1, 0, -1}, {0, 1, 1}, {0, -1, 1}, {0, 1, -1}, {0, -1, -1}};
    static final int[][] grad4 = new int[][]{{0, 1, 1, 1}, {0, 1, 1, -1}, {0, 1, -1, 1}, {0, 1, -1, -1}, {0, -1, 1, 1}, {0, -1, 1, -1}, {0, -1, -1, 1}, {0, -1, -1, -1}, {1, 0, 1, 1}, {1, 0, 1, -1}, {1, 0, -1, 1}, {1, 0, -1, -1}, {-1, 0, 1, 1}, {-1, 0, 1, -1}, {-1, 0, -1, 1}, {-1, 0, -1, -1}, {1, 1, 0, 1}, {1, 1, 0, -1}, {1, -1, 0, 1}, {1, -1, 0, -1}, {-1, 1, 0, 1}, {-1, 1, 0, -1}, {-1, -1, 0, 1}, {-1, -1, 0, -1}, {1, 1, 1, 0}, {1, 1, -1, 0}, {1, -1, 1, 0}, {1, -1, -1, 0}, {-1, 1, 1, 0}, {-1, 1, -1, 0}, {-1, -1, 1, 0}, {-1, -1, -1, 0}};
    static final int[][] simplex = new int[][]{{0, 1, 2, 3}, {0, 1, 3, 2}, {0, 0, 0, 0}, {0, 2, 3, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 2, 3, 0}, {0, 2, 1, 3}, {0, 0, 0, 0}, {0, 3, 1, 2}, {0, 3, 2, 1}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 3, 2, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {1, 2, 0, 3}, {0, 0, 0, 0}, {1, 3, 0, 2}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {2, 3, 0, 1}, {2, 3, 1, 0}, {1, 0, 2, 3}, {1, 0, 3, 2}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {2, 0, 3, 1}, {0, 0, 0, 0}, {2, 1, 3, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {2, 0, 1, 3}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 0, 1, 2}, {3, 0, 2, 1}, {0, 0, 0, 0}, {3, 1, 2, 0}, {2, 1, 0, 3}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {3, 1, 0, 2}, {0, 0, 0, 0}, {3, 2, 0, 1}, {3, 2, 1, 0}};

    private Simplex() {
    }

    public static float noise2d(int seed, double octaves, double persistence, double scale, double x, double y) {
        double total = 0.0;
        double frequency = scale;
        double amplitude = 1.0;
        double maxAmplitude = 0.0;
        int i = 0;
        while ((double)i < octaves) {
            total += (Simplex.raw2d(seed, x * frequency, y * frequency) + 1.0) / 2.0 * amplitude;
            frequency *= 2.0;
            maxAmplitude += amplitude;
            amplitude *= persistence;
            ++i;
        }
        return (float)(total / maxAmplitude);
    }

    public static float noise3d(int seed, double octaves, double persistence, double scale, double x, double y, double z) {
        double total = 0.0;
        double frequency = scale;
        double amplitude = 1.0;
        double maxAmplitude = 0.0;
        int i = 0;
        while ((double)i < octaves) {
            total += (Simplex.raw3d(seed, x * frequency, y * frequency, z * frequency) + 1.0) / 2.0 * amplitude;
            frequency *= 2.0;
            maxAmplitude += amplitude;
            amplitude *= persistence;
            ++i;
        }
        return (float)(total / maxAmplitude);
    }

    public static float noise4d(double octaves, double persistence, double scale, double x, double y, double z, double w) {
        double total = 0.0;
        double frequency = scale;
        double amplitude = 1.0;
        double maxAmplitude = 0.0;
        int i = 0;
        while ((double)i < octaves) {
            total += Simplex.raw4d(x * frequency, y * frequency, z * frequency, w * frequency) * amplitude;
            frequency *= 2.0;
            maxAmplitude += amplitude;
            amplitude *= persistence;
            ++i;
        }
        return (float)(total / maxAmplitude);
    }

    public static double raw2d(int seed, double x, double y) {
        double n2;
        double n1;
        double n0;
        int j1;
        int i1;
        double Y0;
        double y0;
        double G2;
        int j;
        double t;
        double F2 = 0.5 * (Math.sqrt(3.0) - 1.0);
        double s = (x + y) * F2;
        int i = Simplex.fastfloor(x + s);
        double X0 = (double)i - (t = (double)(i + (j = Simplex.fastfloor(y + s))) * (G2 = (3.0 - Math.sqrt(3.0)) / 6.0));
        double x0 = x - X0;
        if (x0 > (y0 = y - (Y0 = (double)j - t))) {
            i1 = 1;
            j1 = 0;
        } else {
            i1 = 0;
            j1 = 1;
        }
        double x1 = x0 - (double)i1 + G2;
        double y1 = y0 - (double)j1 + G2;
        double x2 = x0 - 1.0 + 2.0 * G2;
        double y2 = y0 - 1.0 + 2.0 * G2;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int gi0 = Simplex.perm(seed, ii + Simplex.perm(seed, jj)) % 12;
        int gi1 = Simplex.perm(seed, ii + i1 + Simplex.perm(seed, jj + j1)) % 12;
        int gi2 = Simplex.perm(seed, ii + 1 + Simplex.perm(seed, jj + 1)) % 12;
        double t0 = 0.5 - x0 * x0 - y0 * y0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * Simplex.dot(grad3[gi0], x0, y0);
        }
        double t1 = 0.5 - x1 * x1 - y1 * y1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * Simplex.dot(grad3[gi1], x1, y1);
        }
        double t2 = 0.5 - x2 * x2 - y2 * y2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * Simplex.dot(grad3[gi2], x2, y2);
        }
        return 70.0 * (n0 + n1 + n2);
    }

    public static double raw3d(int seed, double x, double y, double z) {
        double n3;
        double n2;
        double n1;
        double n0;
        int k2;
        int j2;
        int i2;
        int k1;
        int j1;
        int i1;
        double F3 = 0.3333333333333333;
        double s = (x + y + z) * F3;
        int i = Simplex.fastfloor(x + s);
        int j = Simplex.fastfloor(y + s);
        int k = Simplex.fastfloor(z + s);
        double G3 = 0.16666666666666666;
        double t = (double)(i + j + k) * G3;
        double X0 = (double)i - t;
        double Y0 = (double)j - t;
        double Z0 = (double)k - t;
        double x0 = x - X0;
        double y0 = y - Y0;
        double z0 = z - Z0;
        if (x0 >= y0) {
            if (y0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 1;
                k2 = 0;
            } else if (x0 >= z0) {
                i1 = 1;
                j1 = 0;
                k1 = 0;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            } else {
                i1 = 0;
                j1 = 0;
                k1 = 1;
                i2 = 1;
                j2 = 0;
                k2 = 1;
            }
        } else if (y0 < z0) {
            i1 = 0;
            j1 = 0;
            k1 = 1;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else if (x0 < z0) {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 0;
            j2 = 1;
            k2 = 1;
        } else {
            i1 = 0;
            j1 = 1;
            k1 = 0;
            i2 = 1;
            j2 = 1;
            k2 = 0;
        }
        double x1 = x0 - (double)i1 + G3;
        double y1 = y0 - (double)j1 + G3;
        double z1 = z0 - (double)k1 + G3;
        double x2 = x0 - (double)i2 + 2.0 * G3;
        double y2 = y0 - (double)j2 + 2.0 * G3;
        double z2 = z0 - (double)k2 + 2.0 * G3;
        double x3 = x0 - 1.0 + 3.0 * G3;
        double y3 = y0 - 1.0 + 3.0 * G3;
        double z3 = z0 - 1.0 + 3.0 * G3;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        int gi0 = Simplex.perm(seed, ii + Simplex.perm(seed, jj + Simplex.perm(seed, kk))) % 12;
        int gi1 = Simplex.perm(seed, ii + i1 + Simplex.perm(seed, jj + j1 + Simplex.perm(seed, kk + k1))) % 12;
        int gi2 = Simplex.perm(seed, ii + i2 + Simplex.perm(seed, jj + j2 + Simplex.perm(seed, kk + k2))) % 12;
        int gi3 = Simplex.perm(seed, ii + 1 + Simplex.perm(seed, jj + 1 + Simplex.perm(seed, kk + 1))) % 12;
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * Simplex.dot(grad3[gi0], x0, y0, z0);
        }
        double t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * Simplex.dot(grad3[gi1], x1, y1, z1);
        }
        double t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * Simplex.dot(grad3[gi2], x2, y2, z2);
        }
        double t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3;
        if (t3 < 0.0) {
            n3 = 0.0;
        } else {
            t3 *= t3;
            n3 = t3 * t3 * Simplex.dot(grad3[gi3], x3, y3, z3);
        }
        return 32.0 * (n0 + n1 + n2 + n3);
    }

    public static double raw4d(double x, double y, double z, double w) {
        double n4;
        double n3;
        double n2;
        double n1;
        double n0;
        double F4 = (Math.sqrt(5.0) - 1.0) / 4.0;
        double G4 = (5.0 - Math.sqrt(5.0)) / 20.0;
        double s = (x + y + z + w) * F4;
        int i = Simplex.fastfloor(x + s);
        int j = Simplex.fastfloor(y + s);
        int k = Simplex.fastfloor(z + s);
        int l = Simplex.fastfloor(w + s);
        double t = (double)(i + j + k + l) * G4;
        double X0 = (double)i - t;
        double Y0 = (double)j - t;
        double Z0 = (double)k - t;
        double W0 = (double)l - t;
        double x0 = x - X0;
        double y0 = y - Y0;
        double z0 = z - Z0;
        double w0 = w - W0;
        int c1 = x0 > y0 ? 32 : 0;
        int c2 = x0 > z0 ? 16 : 0;
        int c3 = y0 > z0 ? 8 : 0;
        int c4 = x0 > w0 ? 4 : 0;
        int c5 = y0 > w0 ? 2 : 0;
        int c6 = z0 > w0 ? 1 : 0;
        int c = c1 + c2 + c3 + c4 + c5 + c6;
        int i1 = simplex[c][0] >= 3 ? 1 : 0;
        int j1 = simplex[c][1] >= 3 ? 1 : 0;
        int k1 = simplex[c][2] >= 3 ? 1 : 0;
        int l1 = simplex[c][3] >= 3 ? 1 : 0;
        int i2 = simplex[c][0] >= 2 ? 1 : 0;
        int j2 = simplex[c][1] >= 2 ? 1 : 0;
        int k2 = simplex[c][2] >= 2 ? 1 : 0;
        int l2 = simplex[c][3] >= 2 ? 1 : 0;
        int i3 = simplex[c][0] >= 1 ? 1 : 0;
        int j3 = simplex[c][1] >= 1 ? 1 : 0;
        int k3 = simplex[c][2] >= 1 ? 1 : 0;
        int l3 = simplex[c][3] >= 1 ? 1 : 0;
        double x1 = x0 - (double)i1 + G4;
        double y1 = y0 - (double)j1 + G4;
        double z1 = z0 - (double)k1 + G4;
        double w1 = w0 - (double)l1 + G4;
        double x2 = x0 - (double)i2 + 2.0 * G4;
        double y2 = y0 - (double)j2 + 2.0 * G4;
        double z2 = z0 - (double)k2 + 2.0 * G4;
        double w2 = w0 - (double)l2 + 2.0 * G4;
        double x3 = x0 - (double)i3 + 3.0 * G4;
        double y3 = y0 - (double)j3 + 3.0 * G4;
        double z3 = z0 - (double)k3 + 3.0 * G4;
        double w3 = w0 - (double)l3 + 3.0 * G4;
        double x4 = x0 - 1.0 + 4.0 * G4;
        double y4 = y0 - 1.0 + 4.0 * G4;
        double z4 = z0 - 1.0 + 4.0 * G4;
        double w4 = w0 - 1.0 + 4.0 * G4;
        int ii = i & 0xFF;
        int jj = j & 0xFF;
        int kk = k & 0xFF;
        int ll = l & 0xFF;
        int gi0 = (ii + (jj + (kk + ll))) % 32;
        int gi1 = (ii + i1 + (jj + j1 + (kk + k1 + (ll + l1)))) % 32;
        int gi2 = (ii + i2 + (jj + j2 + (kk + k2 + (ll + l2)))) % 32;
        int gi3 = (ii + i3 + (jj + j3 + (kk + k3 + (ll + l3)))) % 32;
        int gi4 = (ii + 1 + (jj + 1 + (kk + 1 + (ll + 1)))) % 32;
        double t0 = 0.6 - x0 * x0 - y0 * y0 - z0 * z0 - w0 * w0;
        if (t0 < 0.0) {
            n0 = 0.0;
        } else {
            t0 *= t0;
            n0 = t0 * t0 * Simplex.dot(grad4[gi0], x0, y0, z0, w0);
        }
        double t1 = 0.6 - x1 * x1 - y1 * y1 - z1 * z1 - w1 * w1;
        if (t1 < 0.0) {
            n1 = 0.0;
        } else {
            t1 *= t1;
            n1 = t1 * t1 * Simplex.dot(grad4[gi1], x1, y1, z1, w1);
        }
        double t2 = 0.6 - x2 * x2 - y2 * y2 - z2 * z2 - w2 * w2;
        if (t2 < 0.0) {
            n2 = 0.0;
        } else {
            t2 *= t2;
            n2 = t2 * t2 * Simplex.dot(grad4[gi2], x2, y2, z2, w2);
        }
        double t3 = 0.6 - x3 * x3 - y3 * y3 - z3 * z3 - w3 * w3;
        if (t3 < 0.0) {
            n3 = 0.0;
        } else {
            t3 *= t3;
            n3 = t3 * t3 * Simplex.dot(grad4[gi3], x3, y3, z3, w3);
        }
        double t4 = 0.6 - x4 * x4 - y4 * y4 - z4 * z4 - w4 * w4;
        if (t4 < 0.0) {
            n4 = 0.0;
        } else {
            t4 *= t4;
            n4 = t4 * t4 * Simplex.dot(grad4[gi4], x4, y4, z4, w4);
        }
        return 27.0 * (n0 + n1 + n2 + n3 + n4);
    }

    public static double rawTiled(double x, double y, double x1, double y1, double w, double h, double scl) {
        double x2 = x1 + (w /= scl);
        double y2 = y1 + (h /= scl);
        double s = (x /= scl) / w;
        double t = (y /= scl) / h;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double nx = x1 + Math.cos(s * 2.0 * 3.1415927410125732) * dx / 6.2831854820251465;
        double ny = y1 + Math.cos(t * 2.0 * 3.1415927410125732) * dy / 6.2831854820251465;
        double nz = x1 + Math.sin(s * 2.0 * 3.1415927410125732) * dx / 6.2831854820251465;
        double nw = y1 + Math.sin(t * 2.0 * 3.1415927410125732) * dy / 6.2831854820251465;
        return Simplex.raw4d(nx, ny, nz, nw);
    }

    static int perm(int seed, int x) {
        x = (x >>> 16 ^ x) * 73244475;
        x = (x >>> 16 ^ x) * (73244475 + seed);
        x = x >>> 16 ^ x;
        return x & 0xFF;
    }

    static int fastfloor(double x) {
        return x > 0.0 ? (int)x : (int)x - 1;
    }

    static double dot(int[] g, double x, double y) {
        return (double)g[0] * x + (double)g[1] * y;
    }

    static double dot(int[] g, double x, double y, double z) {
        return (double)g[0] * x + (double)g[1] * y + (double)g[2] * z;
    }

    static double dot(int[] g, double x, double y, double z, double w) {
        return (double)g[0] * x + (double)g[1] * y + (double)g[2] * z + (double)g[3] * w;
    }
}

