/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.ui.layout;

import arc.func.Boolp;
import arc.func.Cons;
import arc.graphics.g2d.Draw;
import arc.scene.Action;
import arc.scene.event.Touchable;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.util.ArcRuntimeException;
import arc.util.Nullable;

public class Collapser
extends WidgetGroup {
    Table table;
    @Nullable
    Boolp collapsedFunc;
    private CollapseAction collapseAction = new CollapseAction();
    boolean collapsed;
    boolean autoAnimate;
    boolean actionRunning;
    float currentHeight;
    float seconds = 0.4f;

    public Collapser(Cons<Table> cons, boolean collapsed) {
        this(new Table(), collapsed);
        cons.get(this.table);
    }

    public Collapser(Table table, boolean collapsed) {
        this.table = table;
        this.collapsed = collapsed;
        this.setTransform(true);
        this.updateTouchable();
        this.addChild(table);
    }

    public Collapser setDuration(float seconds) {
        this.seconds = seconds;
        return this;
    }

    public Collapser setCollapsed(Boolp collapsed) {
        this.collapsedFunc = collapsed;
        return this;
    }

    public Collapser setCollapsed(boolean autoAnimate, Boolp collapsed) {
        this.collapsedFunc = collapsed;
        this.autoAnimate = autoAnimate;
        return this;
    }

    public void toggle() {
        this.setCollapsed(!this.isCollapsed());
    }

    public void toggle(boolean animated) {
        this.setCollapsed(!this.isCollapsed(), animated);
    }

    public void setCollapsed(boolean collapse, boolean withAnimation) {
        this.collapsed = collapse;
        this.updateTouchable();
        if (this.table == null) {
            return;
        }
        this.actionRunning = true;
        if (withAnimation) {
            this.addAction(this.collapseAction);
        } else {
            if (collapse) {
                this.currentHeight = 0.0f;
                this.collapsed = true;
            } else {
                this.currentHeight = this.table.getPrefHeight();
                this.collapsed = false;
            }
            this.actionRunning = false;
            this.invalidateHierarchy();
        }
    }

    public void setCollapsed(boolean collapse) {
        this.setCollapsed(collapse, true);
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    private void updateTouchable() {
        Touchable touchable1;
        this.touchable = touchable1 = this.collapsed ? Touchable.disabled : Touchable.enabled;
    }

    @Override
    public void draw() {
        if (this.currentHeight > 1.0f) {
            Draw.flush();
            if (this.clipBegin(this.x, this.y, this.getWidth(), this.currentHeight)) {
                super.draw();
                Draw.flush();
                this.clipEnd();
            }
        }
    }

    @Override
    public void act(float delta) {
        boolean col;
        super.act(delta);
        if (this.collapsedFunc != null && (col = this.collapsedFunc.get()) != this.collapsed) {
            this.setCollapsed(col, this.autoAnimate);
        }
    }

    @Override
    public void layout() {
        if (this.table == null) {
            return;
        }
        this.table.setBounds(0.0f, 0.0f, this.getWidth(), this.getHeight());
        if (!this.actionRunning) {
            this.currentHeight = this.collapsed ? 0.0f : this.table.getPrefHeight();
        }
    }

    @Override
    public float getPrefWidth() {
        return this.table == null ? 0.0f : this.table.getPrefWidth();
    }

    @Override
    public float getPrefHeight() {
        if (this.table == null) {
            return 0.0f;
        }
        if (!this.actionRunning) {
            if (this.collapsed) {
                return 0.0f;
            }
            return this.table.getPrefHeight();
        }
        return this.currentHeight;
    }

    public void setTable(Table table) {
        this.table = table;
        this.clearChildren();
        this.addChild(table);
    }

    @Override
    public float getMinWidth() {
        return 0.0f;
    }

    @Override
    public float getMinHeight() {
        return 0.0f;
    }

    @Override
    protected void childrenChanged() {
        super.childrenChanged();
        if (this.getChildren().size > 1) {
            throw new ArcRuntimeException("Only one actor can be added to CollapsibleWidget");
        }
    }

    private class CollapseAction
    extends Action {
        CollapseAction() {
        }

        @Override
        public boolean act(float delta) {
            if (Collapser.this.collapsed) {
                Collapser.this.currentHeight -= delta * Collapser.this.table.getPrefHeight() / Collapser.this.seconds;
                if (Collapser.this.currentHeight <= 0.0f) {
                    Collapser.this.currentHeight = 0.0f;
                    Collapser.this.actionRunning = false;
                }
            } else {
                Collapser.this.currentHeight += delta * Collapser.this.table.getPrefHeight() / Collapser.this.seconds;
                if (Collapser.this.currentHeight > Collapser.this.table.getPrefHeight()) {
                    Collapser.this.currentHeight = Collapser.this.table.getPrefHeight();
                    Collapser.this.actionRunning = false;
                }
            }
            Collapser.this.invalidateHierarchy();
            return !Collapser.this.actionRunning;
        }
    }
}

