/*
 * Decompiled with CFR 0.152.
 */
package arc.scene.ui;

import arc.Core;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Font;
import arc.graphics.g2d.FontCache;
import arc.graphics.g2d.GlyphLayout;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.Style;

public class Label
extends Element {
    protected static final Color tempColor = new Color();
    protected static final GlyphLayout prefSizeLayout = new GlyphLayout();
    protected final GlyphLayout layout = new GlyphLayout();
    protected final Vec2 prefSize = new Vec2();
    protected final StringBuilder text = new StringBuilder();
    protected LabelStyle style;
    protected FontCache cache;
    protected int labelAlign = 8;
    protected int lineAlign = 8;
    protected boolean wrap;
    protected float lastPrefHeight;
    protected boolean prefSizeInvalid = true;
    protected float fontScaleX = 1.0f;
    protected float fontScaleY = 1.0f;
    protected boolean fontScaleChanged = false;
    protected String ellipsis;

    public Label(Prov<CharSequence> sup) {
        this("", new LabelStyle(Core.scene.getStyle(LabelStyle.class)));
        this.setText(sup);
        try {
            this.setText(sup.get());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Label(CharSequence text) {
        this(text, Core.scene.getStyle(LabelStyle.class));
    }

    public Label(CharSequence text, LabelStyle style) {
        if (style == null) {
            this.text.setLength(0);
            this.text.append(text);
            return;
        }
        this.setStyle(new LabelStyle(style));
        if (text != null) {
            this.setText(text);
        }
        if (text != null && text.length() > 0) {
            this.setSize(this.getPrefWidth(), this.getPrefHeight());
        }
    }

    public LabelStyle getStyle() {
        return this.style;
    }

    public void setStyle(LabelStyle style) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        if (style.font == null) {
            throw new IllegalArgumentException("Missing LabelStyle font.");
        }
        this.style = style;
        this.cache = style.font.newFontCache();
        this.invalidateHierarchy();
    }

    public void setText(Prov<CharSequence> sup) {
        this.update(() -> this.setText((CharSequence)sup.get()));
    }

    private void setTextInternal(CharSequence newText) {
        if (newText == null) {
            newText = "";
        }
        if (this.textEquals(newText)) {
            return;
        }
        this.text.setLength(0);
        this.text.append(newText);
        this.invalidateHierarchy();
    }

    public boolean textEquals(CharSequence other) {
        int length = this.text.length();
        if (length != other.length()) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.text.charAt(i) == other.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public StringBuilder getText() {
        return this.text;
    }

    public void setText(CharSequence newText) {
        if (Core.bundle != null && newText != null && newText.length() > 0 && (newText.charAt(0) == '$' || newText.charAt(0) == '@')) {
            String out = newText.toString().substring(1);
            this.setTextInternal(Core.bundle.get(out, newText.toString()));
        } else {
            this.setTextInternal(newText);
        }
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.prefSizeInvalid = true;
    }

    private void scaleAndComputePrefSize() {
        if (this.cache == null) {
            return;
        }
        Font font = this.cache.getFont();
        float oldScaleX = font.getScaleX();
        float oldScaleY = font.getScaleY();
        if (this.fontScaleChanged) {
            font.getData().setScale(this.fontScaleX, this.fontScaleY);
        }
        this.computePrefSize();
        if (this.fontScaleChanged) {
            font.getData().setScale(oldScaleX, oldScaleY);
        }
    }

    private void computePrefSize() {
        this.prefSizeInvalid = false;
        GlyphLayout prefSizeLayout = Label.prefSizeLayout;
        if (this.wrap && this.ellipsis == null) {
            float width = this.getWidth();
            if (this.style.background != null) {
                width -= this.style.background.getLeftWidth() + this.style.background.getRightWidth();
            }
            prefSizeLayout.setText(this.cache.getFont(), this.text, Color.white, width, 8, true);
        } else {
            prefSizeLayout.setText(this.cache.getFont(), this.text, 0, this.text.length(), Color.white, this.width, this.lineAlign, this.wrap, this.ellipsis);
        }
        this.prefSize.set(prefSizeLayout.width, prefSizeLayout.height);
    }

    @Override
    public void layout() {
        float textHeight;
        float textWidth;
        float prefHeight;
        boolean wrap;
        if (this.cache == null) {
            return;
        }
        Font font = this.cache.getFont();
        float oldScaleX = font.getScaleX();
        float oldScaleY = font.getScaleY();
        if (this.fontScaleChanged) {
            font.getData().setScale(this.fontScaleX, this.fontScaleY);
        }
        boolean bl = wrap = this.wrap && this.ellipsis == null;
        if (wrap && (prefHeight = this.getPrefHeight()) != this.lastPrefHeight) {
            this.lastPrefHeight = prefHeight;
            this.invalidateHierarchy();
        }
        float width = this.getWidth();
        float height = this.getHeight();
        Drawable background = this.style.background;
        float x = 0.0f;
        float y = 0.0f;
        if (background != null) {
            x = background.getLeftWidth();
            y = background.getBottomHeight();
            width -= background.getLeftWidth() + background.getRightWidth();
            height -= background.getBottomHeight() + background.getTopHeight();
        }
        GlyphLayout layout = this.layout;
        if (wrap || this.text.indexOf("\n") != -1) {
            layout.setText(font, this.text, 0, this.text.length(), Color.white, width, this.lineAlign, wrap, this.ellipsis);
            textWidth = layout.width;
            textHeight = layout.height;
            if ((this.labelAlign & 8) == 0) {
                x = (this.labelAlign & 0x10) != 0 ? (x += width - textWidth) : (x += (width - textWidth) / 2.0f);
            }
        } else {
            textWidth = width;
            textHeight = font.getData().capHeight;
        }
        if ((this.labelAlign & 2) != 0) {
            y += this.cache.getFont().isFlipped() ? 0.0f : height - textHeight;
            y += this.style.font.getDescent();
        } else if ((this.labelAlign & 4) != 0) {
            y += this.cache.getFont().isFlipped() ? height - textHeight : 0.0f;
            y -= this.style.font.getDescent();
        } else {
            y += (height - textHeight) / 2.0f;
        }
        if (!this.cache.getFont().isFlipped()) {
            y += textHeight;
        }
        layout.setText(font, this.text, 0, this.text.length(), Color.white, textWidth, this.lineAlign, wrap, this.ellipsis);
        this.cache.setText(layout, x, y);
        if (this.fontScaleChanged) {
            font.getData().setScale(oldScaleX, oldScaleY);
        }
    }

    @Override
    public void draw() {
        this.validate();
        Color color = tempColor.set(this.color);
        color.a *= this.parentAlpha;
        if (this.style.background != null) {
            Draw.color(color.r, color.g, color.b, color.a);
            this.style.background.draw(this.x, this.y, this.width, this.height);
        }
        if (this.style.fontColor != null) {
            color.mul(this.style.fontColor);
        }
        this.cache.tint(color);
        this.cache.setPosition(this.x, this.y);
        this.cache.draw();
    }

    @Override
    public float getPrefWidth() {
        if (this.style == null) {
            return 0.0f;
        }
        if (this.wrap) {
            return 0.0f;
        }
        if (this.prefSizeInvalid) {
            this.scaleAndComputePrefSize();
        }
        float width = this.prefSize.x;
        Drawable background = this.style.background;
        if (background != null) {
            width += background.getLeftWidth() + background.getRightWidth();
        }
        return width;
    }

    @Override
    public float getPrefHeight() {
        if (this.style == null) {
            return 0.0f;
        }
        if (this.prefSizeInvalid) {
            this.scaleAndComputePrefSize();
        }
        float descentScaleCorrection = 1.0f;
        if (this.fontScaleChanged) {
            descentScaleCorrection = this.fontScaleY / this.style.font.getScaleY();
        }
        float height = this.prefSize.y - this.style.font.getDescent() * descentScaleCorrection * 2.0f;
        Drawable background = this.style.background;
        if (background != null) {
            height += background.getTopHeight() + background.getBottomHeight();
        }
        return height;
    }

    public GlyphLayout getGlyphLayout() {
        return this.layout;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
        this.invalidateHierarchy();
    }

    public int getLabelAlign() {
        return this.labelAlign;
    }

    public int getLineAlign() {
        return this.lineAlign;
    }

    public void setAlignment(int alignment) {
        this.setAlignment(alignment, alignment);
    }

    public void setAlignment(int labelAlign, int lineAlign) {
        this.labelAlign = labelAlign;
        this.lineAlign = (lineAlign & 8) != 0 ? 8 : ((lineAlign & 0x10) != 0 ? 16 : 1);
        this.invalidate();
    }

    public void setFontScale(float fontScale) {
        this.setFontScale(fontScale, fontScale);
    }

    public void setFontScale(float fontScaleX, float fontScaleY) {
        this.fontScaleChanged = true;
        this.fontScaleX = fontScaleX;
        this.fontScaleY = fontScaleY;
        this.invalidateHierarchy();
    }

    public float getFontScaleX() {
        return this.fontScaleX;
    }

    public void setFontScaleX(float fontScaleX) {
        this.setFontScale(fontScaleX, this.fontScaleY);
    }

    public float getFontScaleY() {
        return this.fontScaleY;
    }

    public void setFontScaleY(float fontScaleY) {
        this.setFontScale(this.fontScaleX, fontScaleY);
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
    }

    public void setEllipsis(boolean ellipsis) {
        this.ellipsis = ellipsis ? "..." : null;
    }

    public FontCache getFontCache() {
        return this.cache;
    }

    @Override
    public String toString() {
        return super.toString() + ": " + this.text;
    }

    public static class LabelStyle
    extends Style {
        public Font font;
        public Color fontColor;
        public Drawable background;

        public LabelStyle() {
        }

        public LabelStyle(Font font, Color fontColor) {
            this.font = font;
            this.fontColor = fontColor;
        }

        public LabelStyle(LabelStyle style) {
            this.font = style.font;
            if (style.fontColor != null) {
                this.fontColor = new Color(style.fontColor);
            }
            this.background = style.background;
        }
    }
}

