/*
 * Decompiled with CFR 0.152.
 */
package arc.math.geom;

import arc.math.Mathf;
import arc.math.geom.Circle;
import arc.math.geom.Polygon;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.struct.FloatSeq;
import arc.struct.Seq;

public final class Intersector {
    private static final Vec3 v0 = new Vec3();
    private static final Vec3 v1 = new Vec3();
    private static final Vec3 v2 = new Vec3();
    private static final FloatSeq floatArray = new FloatSeq();
    private static final FloatSeq floatArray2 = new FloatSeq();
    private static final Vec2 ip = new Vec2();
    private static final Vec2 ep1 = new Vec2();
    private static final Vec2 ep2 = new Vec2();
    private static final Vec2 s = new Vec2();
    private static final Vec2 e = new Vec2();
    static Vec3 tmp = new Vec3();
    static Vec3 tmp1 = new Vec3();
    static Vec3 tmp2 = new Vec3();
    static Vec3 tmp3 = new Vec3();
    static Vec2 v2tmp = new Vec2();

    public static boolean intersectPolygons(float[] p1, float[] p2) {
        floatArray2.clear();
        floatArray.clear();
        floatArray2.addAll(p1);
        if (p1.length == 0 || p2.length == 0) {
            return false;
        }
        for (int i = 0; i < p2.length; i += 2) {
            ep1.set(p2[i], p2[i + 1]);
            if (i < p2.length - 2) {
                ep2.set(p2[i + 2], p2[i + 3]);
            } else {
                ep2.set(p2[0], p2[1]);
            }
            if (Intersector.floatArray2.size == 0) {
                return false;
            }
            s.set(floatArray2.get(Intersector.floatArray2.size - 2), floatArray2.get(Intersector.floatArray2.size - 1));
            for (int j = 0; j < Intersector.floatArray2.size; j += 2) {
                e.set(floatArray2.get(j), floatArray2.get(j + 1));
                if (Intersector.pointLineSide(ep2, ep1, e) > 0) {
                    if (Intersector.pointLineSide(ep2, ep1, s) <= 0) {
                        Intersector.intersectLines(s, e, ep1, ep2, ip);
                        if (Intersector.floatArray.size < 2 || floatArray.get(Intersector.floatArray.size - 2) != Intersector.ip.x || floatArray.get(Intersector.floatArray.size - 1) != Intersector.ip.y) {
                            floatArray.add(Intersector.ip.x);
                            floatArray.add(Intersector.ip.y);
                        }
                    }
                    floatArray.add(Intersector.e.x);
                    floatArray.add(Intersector.e.y);
                } else if (Intersector.pointLineSide(ep2, ep1, s) > 0) {
                    Intersector.intersectLines(s, e, ep1, ep2, ip);
                    floatArray.add(Intersector.ip.x);
                    floatArray.add(Intersector.ip.y);
                }
                s.set(Intersector.e.x, Intersector.e.y);
            }
            floatArray2.clear();
            floatArray2.addAll(floatArray);
            floatArray.clear();
        }
        return Intersector.floatArray2.size != 0;
    }

    public static boolean isInTriangle(Vec3 point, Vec3 t1, Vec3 t2, Vec3 t3) {
        v0.set(t1).sub(point);
        v1.set(t2).sub(point);
        v2.set(t3).sub(point);
        float ab = v0.dot(v1);
        float ac = v0.dot(v2);
        float bc = v1.dot(v2);
        float cc = v2.dot(v2);
        if (bc * ac - cc * ab < 0.0f) {
            return false;
        }
        float bb = v1.dot(v1);
        return !(ab * bc - ac * bb < 0.0f);
    }

    public static boolean isInsideHexagon(float cx, float cy, float d, float x, float y) {
        float a;
        float dx = Math.abs(x - cx) / d;
        float dy = Math.abs(y - cy) / d;
        return dy <= (a = 0.25f * Mathf.sqrt3) && (double)(a * dx) + 0.25 * (double)dy <= 0.5 * (double)a;
    }

    public static boolean isInRegularPolygon(int sides, float cx, float cy, float radius, float rotation, float x, float y) {
        floatArray.clear();
        for (int i = 0; i < sides; ++i) {
            s.trns((float)i * 360.0f / (float)sides + rotation, radius);
            floatArray.add(cx + Intersector.s.x, cy + Intersector.s.y);
        }
        return Intersector.isInPolygon(Intersector.floatArray.items, 0, Intersector.floatArray.size, x, y);
    }

    public static boolean isInTriangle(Vec2 p, Vec2 a, Vec2 b, Vec2 c) {
        boolean side12;
        float px1;
        float py1;
        if ((c.x - a.x) * py1 - (c.y - a.y) * px1 > 0.0f == (side12 = (b.x - a.x) * (py1 = p.y - a.y) - (b.y - a.y) * (px1 = p.x - a.x) > 0.0f)) {
            return false;
        }
        return (c.x - b.x) * (p.y - b.y) - (c.y - b.y) * (p.x - b.x) > 0.0f == side12;
    }

    public static boolean isInTriangle(float px, float py, float ax, float ay, float bx, float by, float cx, float cy) {
        boolean side12;
        float px1;
        float py1;
        if ((cx - ax) * py1 - (cy - ay) * px1 > 0.0f == (side12 = (bx - ax) * (py1 = py - ay) - (by - ay) * (px1 = px - ax) > 0.0f)) {
            return false;
        }
        return (cx - bx) * (py - by) - (cy - by) * (px - bx) > 0.0f == side12;
    }

    public static int pointLineSide(Vec2 linePoint1, Vec2 linePoint2, Vec2 point) {
        return (int)Math.signum((linePoint2.x - linePoint1.x) * (point.y - linePoint1.y) - (linePoint2.y - linePoint1.y) * (point.x - linePoint1.x));
    }

    public static int pointLineSide(float linePoint1X, float linePoint1Y, float linePoint2X, float linePoint2Y, float pointX, float pointY) {
        return (int)Math.signum((linePoint2X - linePoint1X) * (pointY - linePoint1Y) - (linePoint2Y - linePoint1Y) * (pointX - linePoint1X));
    }

    public static boolean isInPolygon(Seq<Vec2> polygon, Vec2 point) {
        Vec2 lastVertice = polygon.peek();
        boolean oddNodes = false;
        for (int i = 0; i < polygon.size; ++i) {
            Vec2 vertice = polygon.get(i);
            if ((vertice.y < point.y && lastVertice.y >= point.y || lastVertice.y < point.y && vertice.y >= point.y) && vertice.x + (point.y - vertice.y) / (lastVertice.y - vertice.y) * (lastVertice.x - vertice.x) < point.x) {
                oddNodes = !oddNodes;
            }
            lastVertice = vertice;
        }
        return oddNodes;
    }

    public static boolean isInPolygon(float[] polygon, int offset, int count, float x, float y) {
        boolean oddNodes = false;
        int j = offset + count - 2;
        int n = j;
        for (int i = offset; i <= n; i += 2) {
            float xi;
            float yi = polygon[i + 1];
            float yj = polygon[j + 1];
            if ((yi < y && yj >= y || yj < y && yi >= y) && (xi = polygon[i]) + (y - yi) / (yj - yi) * (polygon[j] - xi) < x) {
                oddNodes = !oddNodes;
            }
            j = i;
        }
        return oddNodes;
    }

    public static boolean intersectPolygons(Polygon p1, Polygon p2, Polygon overlap) {
        if (p1.getVertices().length == 0 || p2.getVertices().length == 0) {
            return false;
        }
        floatArray2.clear();
        floatArray.clear();
        floatArray2.addAll(p1.getTransformedVertices());
        for (int i = 0; i < p2.getTransformedVertices().length; i += 2) {
            ep1.set(p2.getTransformedVertices()[i], p2.getTransformedVertices()[i + 1]);
            if (i < p2.getTransformedVertices().length - 2) {
                ep2.set(p2.getTransformedVertices()[i + 2], p2.getTransformedVertices()[i + 3]);
            } else {
                ep2.set(p2.getTransformedVertices()[0], p2.getTransformedVertices()[1]);
            }
            if (Intersector.floatArray2.size == 0) {
                return false;
            }
            s.set(floatArray2.get(Intersector.floatArray2.size - 2), floatArray2.get(Intersector.floatArray2.size - 1));
            for (int j = 0; j < Intersector.floatArray2.size; j += 2) {
                e.set(floatArray2.get(j), floatArray2.get(j + 1));
                if (Intersector.pointLineSide(ep2, ep1, e) > 0) {
                    if (Intersector.pointLineSide(ep2, ep1, s) <= 0) {
                        Intersector.intersectLines(s, e, ep1, ep2, ip);
                        if (Intersector.floatArray.size < 2 || floatArray.get(Intersector.floatArray.size - 2) != Intersector.ip.x || floatArray.get(Intersector.floatArray.size - 1) != Intersector.ip.y) {
                            floatArray.add(Intersector.ip.x);
                            floatArray.add(Intersector.ip.y);
                        }
                    }
                    floatArray.add(Intersector.e.x);
                    floatArray.add(Intersector.e.y);
                } else if (Intersector.pointLineSide(ep2, ep1, s) > 0) {
                    Intersector.intersectLines(s, e, ep1, ep2, ip);
                    floatArray.add(Intersector.ip.x);
                    floatArray.add(Intersector.ip.y);
                }
                s.set(Intersector.e.x, Intersector.e.y);
            }
            floatArray2.clear();
            floatArray2.addAll(floatArray);
            floatArray.clear();
        }
        if (Intersector.floatArray2.size != 0) {
            if (overlap != null) {
                if (overlap.getVertices().length == Intersector.floatArray2.size) {
                    System.arraycopy(Intersector.floatArray2.items, 0, overlap.getVertices(), 0, Intersector.floatArray2.size);
                } else {
                    overlap.setVertices(floatArray2.toArray());
                }
            }
            return true;
        }
        return false;
    }

    public static float distanceLinePoint(Vec2 start, Vec2 end, Vec2 point) {
        return Intersector.distanceLinePoint(start.x, start.y, end.x, end.y, point.x, point.y);
    }

    public static float distanceLinePoint(float startX, float startY, float endX, float endY, float pointX, float pointY) {
        float normalLength = (float)Math.sqrt((endX - startX) * (endX - startX) + (endY - startY) * (endY - startY));
        return Math.abs((pointX - startX) * (endY - startY) - (pointY - startY) * (endX - startX)) / normalLength;
    }

    public static float distanceSegmentPoint(float startX, float startY, float endX, float endY, float pointX, float pointY) {
        return Intersector.nearestSegmentPoint(startX, startY, endX, endY, pointX, pointY, v2tmp).dst(pointX, pointY);
    }

    public static float distanceSegmentPoint(Vec2 start, Vec2 end, Vec2 point) {
        return Intersector.nearestSegmentPoint(start, end, point, v2tmp).dst(point);
    }

    public static Vec2 nearestSegmentPoint(Vec2 start, Vec2 end, Vec2 point, Vec2 nearest) {
        float length2 = start.dst2(end);
        if (length2 == 0.0f) {
            return nearest.set(start);
        }
        float t = ((point.x - start.x) * (end.x - start.x) + (point.y - start.y) * (end.y - start.y)) / length2;
        if (t < 0.0f) {
            return nearest.set(start);
        }
        if (t > 1.0f) {
            return nearest.set(end);
        }
        return nearest.set(start.x + t * (end.x - start.x), start.y + t * (end.y - start.y));
    }

    public static Vec2 nearestSegmentPoint(float startX, float startY, float endX, float endY, float pointX, float pointY, Vec2 nearest) {
        float xDiff = endX - startX;
        float yDiff = endY - startY;
        float length2 = xDiff * xDiff + yDiff * yDiff;
        if (length2 == 0.0f) {
            return nearest.set(startX, startY);
        }
        float t = ((pointX - startX) * (endX - startX) + (pointY - startY) * (endY - startY)) / length2;
        if (t < 0.0f) {
            return nearest.set(startX, startY);
        }
        if (t > 1.0f) {
            return nearest.set(endX, endY);
        }
        return nearest.set(startX + t * (endX - startX), startY + t * (endY - startY));
    }

    public static boolean intersectSegmentCircle(Vec2 start, Vec2 end, Vec2 center, float squareRadius) {
        tmp.set(end.x - start.x, end.y - start.y, 0.0f);
        tmp1.set(center.x - start.x, center.y - start.y, 0.0f);
        float l = tmp.len();
        float u = tmp1.dot(tmp.nor());
        if (u <= 0.0f) {
            tmp2.set(start.x, start.y, 0.0f);
        } else if (u >= l) {
            tmp2.set(end.x, end.y, 0.0f);
        } else {
            tmp3.set(tmp.scl(u));
            tmp2.set(Intersector.tmp3.x + start.x, Intersector.tmp3.y + start.y, 0.0f);
        }
        float x = center.x - Intersector.tmp2.x;
        float y = center.y - Intersector.tmp2.y;
        return x * x + y * y <= squareRadius;
    }

    public static float intersectSegmentCircleDisplace(Vec2 start, Vec2 end, Vec2 point, float radius, Vec2 displacement) {
        float u = (point.x - start.x) * (end.x - start.x) + (point.y - start.y) * (end.y - start.y);
        float d = start.dst(end);
        if ((u /= d * d) < 0.0f || u > 1.0f) {
            return Float.POSITIVE_INFINITY;
        }
        tmp.set(end.x, end.y, 0.0f).sub(start.x, start.y, 0.0f);
        tmp2.set(start.x, start.y, 0.0f).add(tmp.scl(u));
        d = tmp2.dst(point.x, point.y, 0.0f);
        if (d < radius) {
            displacement.set(point).sub(Intersector.tmp2.x, Intersector.tmp2.y).nor();
            return d;
        }
        return Float.POSITIVE_INFINITY;
    }

    public static float intersectRayRay(Vec2 start1, Vec2 direction1, Vec2 start2, Vec2 direction2) {
        float difx = start2.x - start1.x;
        float dify = start2.y - start1.y;
        float d1xd2 = direction1.x * direction2.y - direction1.y * direction2.x;
        if (d1xd2 == 0.0f) {
            return Float.POSITIVE_INFINITY;
        }
        float d2sx = direction2.x / d1xd2;
        float d2sy = direction2.y / d1xd2;
        return difx * d2sy - dify * d2sx;
    }

    public static boolean intersectLines(Vec2 p1, Vec2 p2, Vec2 p3, Vec2 p4, Vec2 intersection) {
        float y4 = p4.y;
        float y3 = p3.y;
        float x2 = p2.x;
        float x1 = p1.x;
        float x4 = p4.x;
        float x3 = p3.x;
        float y2 = p2.y;
        float y1 = p1.y;
        float d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (d == 0.0f) {
            return false;
        }
        if (intersection != null) {
            float ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / d;
            intersection.set(x1 + (x2 - x1) * ua, y1 + (y2 - y1) * ua);
        }
        return true;
    }

    public static boolean intersectLines(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, Vec2 intersection) {
        float d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (d == 0.0f) {
            return false;
        }
        if (intersection != null) {
            float ua = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / d;
            intersection.set(x1 + (x2 - x1) * ua, y1 + (y2 - y1) * ua);
        }
        return true;
    }

    public static boolean intersectLinePolygon(Vec2 p1, Vec2 p2, Polygon polygon) {
        float[] vertices = polygon.getTransformedVertices();
        float x1 = p1.x;
        float y1 = p1.y;
        float x2 = p2.x;
        float y2 = p2.y;
        int n = vertices.length;
        float x3 = vertices[n - 2];
        float y3 = vertices[n - 1];
        for (int i = 0; i < n; i += 2) {
            float xd;
            float yd;
            float ua;
            float y4 = vertices[i + 1];
            float x4 = vertices[i];
            float d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
            if (d != 0.0f && (ua = ((x4 - x3) * (yd = y1 - y3) - (y4 - y3) * (xd = x1 - x3)) / d) >= 0.0f && ua <= 1.0f) {
                return true;
            }
            x3 = x4;
            y3 = y4;
        }
        return false;
    }

    public static boolean intersectRectangles(Rect rect1, Rect rect2, Rect intersection) {
        if (rect1.overlaps(rect2)) {
            intersection.x = Math.max(rect1.x, rect2.x);
            intersection.width = Math.min(rect1.x + rect1.width, rect2.x + rect2.width) - intersection.x;
            intersection.y = Math.max(rect1.y, rect2.y);
            intersection.height = Math.min(rect1.y + rect1.height, rect2.y + rect2.height) - intersection.y;
            return true;
        }
        return false;
    }

    public static boolean intersectSegmentRectangle(float startX, float startY, float endX, float endY, Rect rect) {
        float rectangleEndX = rect.x + rect.width;
        float rectangleEndY = rect.y + rect.height;
        if (Intersector.intersectSegments(startX, startY, endX, endY, rect.x, rect.y, rect.x, rectangleEndY, null)) {
            return true;
        }
        if (Intersector.intersectSegments(startX, startY, endX, endY, rect.x, rect.y, rectangleEndX, rect.y, null)) {
            return true;
        }
        if (Intersector.intersectSegments(startX, startY, endX, endY, rectangleEndX, rect.y, rectangleEndX, rectangleEndY, null)) {
            return true;
        }
        if (Intersector.intersectSegments(startX, startY, endX, endY, rect.x, rectangleEndY, rectangleEndX, rectangleEndY, null)) {
            return true;
        }
        return rect.contains(startX, startY);
    }

    public static boolean intersectSegmentRectangle(Vec2 start, Vec2 end, Rect rect) {
        return Intersector.intersectSegmentRectangle(start.x, start.y, end.x, end.y, rect);
    }

    public static boolean intersectSegmentPolygon(Vec2 p1, Vec2 p2, Polygon polygon) {
        float[] vertices = polygon.getTransformedVertices();
        float x1 = p1.x;
        float y1 = p1.y;
        float x2 = p2.x;
        float y2 = p2.y;
        int n = vertices.length;
        float x3 = vertices[n - 2];
        float y3 = vertices[n - 1];
        for (int i = 0; i < n; i += 2) {
            float ub;
            float xd;
            float yd;
            float ua;
            float y4 = vertices[i + 1];
            float x4 = vertices[i];
            float d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
            if (d != 0.0f && (ua = ((x4 - x3) * (yd = y1 - y3) - (y4 - y3) * (xd = x1 - x3)) / d) >= 0.0f && ua <= 1.0f && (ub = ((x2 - x1) * yd - (y2 - y1) * xd) / d) >= 0.0f && ub <= 1.0f) {
                return true;
            }
            x3 = x4;
            y3 = y4;
        }
        return false;
    }

    public static boolean intersectSegments(Vec2 p1, Vec2 p2, Vec2 p3, Vec2 p4, Vec2 intersection) {
        float y4 = p4.y;
        float y3 = p3.y;
        float x2 = p2.x;
        float x1 = p1.x;
        float x4 = p4.x;
        float x3 = p3.x;
        float y2 = p2.y;
        float y1 = p1.y;
        float d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (d == 0.0f) {
            return false;
        }
        float yd = y1 - y3;
        float xd = x1 - x3;
        float ua = ((x4 - x3) * yd - (y4 - y3) * xd) / d;
        if (ua < 0.0f || ua > 1.0f) {
            return false;
        }
        float ub = ((x2 - x1) * yd - (y2 - y1) * xd) / d;
        if (ub < 0.0f || ub > 1.0f) {
            return false;
        }
        if (intersection != null) {
            intersection.set(x1 + (x2 - x1) * ua, y1 + (y2 - y1) * ua);
        }
        return true;
    }

    public static boolean intersectSegments(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4, Vec2 intersection) {
        float d = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
        if (d == 0.0f) {
            return false;
        }
        float yd = y1 - y3;
        float xd = x1 - x3;
        float ua = ((x4 - x3) * yd - (y4 - y3) * xd) / d;
        if (ua < 0.0f || ua > 1.0f) {
            return false;
        }
        float ub = ((x2 - x1) * yd - (y2 - y1) * xd) / d;
        if (ub < 0.0f || ub > 1.0f) {
            return false;
        }
        if (intersection != null) {
            intersection.set(x1 + (x2 - x1) * ua, y1 + (y2 - y1) * ua);
        }
        return true;
    }

    static float det(float a, float b, float c, float d) {
        return a * d - b * c;
    }

    static double detd(double a, double b, double c, double d) {
        return a * d - b * c;
    }

    public static boolean overlapsRect(float x1, float y1, float w1, float h1, float x2, float y2, float w2, float h2) {
        return x1 < x2 + w2 && x1 + w1 > x2 && y1 < y2 + h2 && y1 + h1 > y2;
    }

    public static boolean overlaps(Circle c1, Circle c2) {
        return c1.overlaps(c2);
    }

    public static boolean overlaps(Rect r1, Rect r2) {
        return r1.overlaps(r2);
    }

    public static boolean overlaps(Circle c, Rect r) {
        float closestX = c.x;
        float closestY = c.y;
        if (c.x < r.x) {
            closestX = r.x;
        } else if (c.x > r.x + r.width) {
            closestX = r.x + r.width;
        }
        if (c.y < r.y) {
            closestY = r.y;
        } else if (c.y > r.y + r.height) {
            closestY = r.y + r.height;
        }
        closestX -= c.x;
        closestX *= closestX;
        closestY -= c.y;
        closestY *= closestY;
        return closestX + closestY < c.radius * c.radius;
    }

    public static boolean overlapConvexPolygons(Polygon p1, Polygon p2) {
        return Intersector.overlapConvexPolygons(p1, p2, null);
    }

    public static boolean overlapConvexPolygons(Polygon p1, Polygon p2, MinimumTranslationVector mtv) {
        return Intersector.overlapConvexPolygons(p1.getTransformedVertices(), p2.getTransformedVertices(), mtv);
    }

    public static boolean overlapConvexPolygons(float[] verts1, float[] verts2, MinimumTranslationVector mtv) {
        return Intersector.overlapConvexPolygons(verts1, 0, verts1.length, verts2, 0, verts2.length, mtv);
    }

    public static boolean overlapConvexPolygons(float[] verts1, int offset1, int count1, float[] verts2, int offset2, int count2, MinimumTranslationVector mtv) {
        float maxs;
        float mins;
        float o;
        float p;
        float max2;
        float min2;
        int numInNormalDir;
        float p2;
        float max1;
        float min1;
        float length;
        float axisY;
        float axisX;
        float y2;
        float x2;
        float y1;
        float x1;
        int i;
        float overlap = Float.MAX_VALUE;
        float smallestAxisX = 0.0f;
        float smallestAxisY = 0.0f;
        int end1 = offset1 + count1;
        int end2 = offset2 + count2;
        for (i = offset1; i < end1; i += 2) {
            x1 = verts1[i];
            y1 = verts1[i + 1];
            x2 = verts1[(i + 2) % count1];
            y2 = verts1[(i + 3) % count1];
            axisX = y1 - y2;
            axisY = -(x1 - x2);
            length = (float)Math.sqrt(axisX * axisX + axisY * axisY);
            max1 = min1 = (axisX /= length) * verts1[0] + (axisY /= length) * verts1[1];
            for (int j = offset1; j < end1; j += 2) {
                p2 = axisX * verts1[j] + axisY * verts1[j + 1];
                if (p2 < min1) {
                    min1 = p2;
                    continue;
                }
                if (!(p2 > max1)) continue;
                max1 = p2;
            }
            numInNormalDir = 0;
            max2 = min2 = axisX * verts2[0] + axisY * verts2[1];
            for (int j = offset2; j < end2; j += 2) {
                numInNormalDir -= Intersector.pointLineSide(x1, y1, x2, y2, verts2[j], verts2[j + 1]);
                p = axisX * verts2[j] + axisY * verts2[j + 1];
                if (p < min2) {
                    min2 = p;
                    continue;
                }
                if (!(p > max2)) continue;
                max2 = p;
            }
            if (!(min1 <= min2 && max1 >= min2 || min2 <= min1 && max2 >= min1)) {
                return false;
            }
            o = Math.min(max1, max2) - Math.max(min1, min2);
            if (min1 < min2 && max1 > max2 || min2 < min1 && max2 > max1) {
                mins = Math.abs(min1 - min2);
                o = mins < (maxs = Math.abs(max1 - max2)) ? (o += mins) : (o += maxs);
            }
            if (!(o < overlap)) continue;
            overlap = o;
            smallestAxisX = numInNormalDir >= 0 ? axisX : -axisX;
            smallestAxisY = numInNormalDir >= 0 ? axisY : -axisY;
        }
        for (i = offset2; i < end2; i += 2) {
            x1 = verts2[i];
            y1 = verts2[i + 1];
            x2 = verts2[(i + 2) % count2];
            y2 = verts2[(i + 3) % count2];
            axisX = y1 - y2;
            axisY = -(x1 - x2);
            length = (float)Math.sqrt(axisX * axisX + axisY * axisY);
            numInNormalDir = 0;
            max1 = min1 = (axisX /= length) * verts1[0] + (axisY /= length) * verts1[1];
            for (int j = offset1; j < end1; j += 2) {
                p2 = axisX * verts1[j] + axisY * verts1[j + 1];
                numInNormalDir -= Intersector.pointLineSide(x1, y1, x2, y2, verts1[j], verts1[j + 1]);
                if (p2 < min1) {
                    min1 = p2;
                    continue;
                }
                if (!(p2 > max1)) continue;
                max1 = p2;
            }
            max2 = min2 = axisX * verts2[0] + axisY * verts2[1];
            for (int j = offset2; j < end2; j += 2) {
                p = axisX * verts2[j] + axisY * verts2[j + 1];
                if (p < min2) {
                    min2 = p;
                    continue;
                }
                if (!(p > max2)) continue;
                max2 = p;
            }
            if (!(min1 <= min2 && max1 >= min2 || min2 <= min1 && max2 >= min1)) {
                return false;
            }
            o = Math.min(max1, max2) - Math.max(min1, min2);
            if (min1 < min2 && max1 > max2 || min2 < min1 && max2 > max1) {
                mins = Math.abs(min1 - min2);
                o = mins < (maxs = Math.abs(max1 - max2)) ? (o += mins) : (o += maxs);
            }
            if (!(o < overlap)) continue;
            overlap = o;
            smallestAxisX = numInNormalDir < 0 ? axisX : -axisX;
            smallestAxisY = numInNormalDir < 0 ? axisY : -axisY;
        }
        if (mtv != null) {
            mtv.normal.set(smallestAxisX, smallestAxisY);
            mtv.depth = overlap;
        }
        return true;
    }

    public static class MinimumTranslationVector {
        public Vec2 normal = new Vec2();
        public float depth = 0.0f;
    }
}

