/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.Core;
import arc.graphics.Gl;
import arc.graphics.Mesh;
import arc.graphics.VertexAttribute;
import arc.graphics.gl.Shader;
import arc.graphics.gl.VertexData;
import arc.struct.IntSeq;
import arc.util.Buffers;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class VertexBufferObjectWithVAO
implements VertexData {
    static final IntBuffer tmpHandle = Buffers.newIntBuffer(1);
    final Mesh mesh;
    final FloatBuffer buffer;
    final ByteBuffer byteBuffer;
    final boolean isStatic;
    final int usage;
    int bufferHandle;
    boolean isDirty = false;
    boolean isBound = false;
    int vaoHandle = -1;
    IntSeq cachedLocations = new IntSeq();

    public VertexBufferObjectWithVAO(boolean isStatic, int numVertices, Mesh mesh) {
        this.isStatic = isStatic;
        this.mesh = mesh;
        this.byteBuffer = Buffers.newUnsafeByteBuffer(this.mesh.vertexSize * numVertices);
        this.buffer = this.byteBuffer.asFloatBuffer();
        this.buffer.flip();
        this.byteBuffer.flip();
        this.bufferHandle = Gl.genBuffer();
        this.usage = isStatic ? 35044 : 35040;
        this.createVAO();
    }

    @Override
    public int size() {
        return this.buffer.limit() * 4 / this.mesh.vertexSize;
    }

    @Override
    public int max() {
        return this.byteBuffer.capacity() / this.mesh.vertexSize;
    }

    @Override
    public FloatBuffer buffer() {
        this.isDirty = true;
        return this.buffer;
    }

    private void upload() {
        Gl.bufferData(34962, this.byteBuffer.limit(), this.byteBuffer, this.usage);
    }

    private void bufferChanged() {
        if (this.isBound) {
            this.upload();
            this.isDirty = false;
        }
    }

    @Override
    public void set(float[] vertices, int offset, int count) {
        this.isDirty = true;
        Buffers.copy(vertices, this.byteBuffer, count, offset);
        this.buffer.position(0);
        this.buffer.limit(count);
        this.bufferChanged();
    }

    @Override
    public void update(int targetOffset, float[] vertices, int sourceOffset, int count) {
        this.isDirty = true;
        int pos = this.byteBuffer.position();
        this.byteBuffer.position(targetOffset * 4);
        Buffers.copy(vertices, sourceOffset, count, this.byteBuffer);
        this.byteBuffer.position(pos);
        this.buffer.position(0);
        this.bufferChanged();
    }

    @Override
    public void bind(Shader shader) {
        Core.gl30.glBindVertexArray(this.vaoHandle);
        this.bindAttributes(shader);
        this.bindData();
        this.isBound = true;
    }

    private void bindAttributes(Shader shader) {
        boolean stillValid;
        boolean bl = stillValid = this.cachedLocations.size != 0;
        if (stillValid) {
            for (int i = 0; stillValid && i < this.mesh.attributes.length; ++i) {
                VertexAttribute attribute = this.mesh.attributes[i];
                int location = shader.getAttributeLocation(attribute.alias);
                stillValid = location == this.cachedLocations.get(i);
            }
        }
        if (!stillValid) {
            Gl.bindBuffer(34962, this.bufferHandle);
            this.unbindAttributes(shader);
            this.cachedLocations.clear();
            int offset = 0;
            for (int i = 0; i < this.mesh.attributes.length; ++i) {
                VertexAttribute attribute = this.mesh.attributes[i];
                this.cachedLocations.add(shader.getAttributeLocation(attribute.alias));
                int aoffset = offset;
                offset += attribute.size;
                int location = this.cachedLocations.get(i);
                if (location < 0) continue;
                Gl.enableVertexAttribArray(location);
                Gl.vertexAttribPointer(location, attribute.components, attribute.type, attribute.normalized, this.mesh.vertexSize, aoffset);
            }
        }
    }

    private void unbindAttributes(Shader shader) {
        if (this.cachedLocations.size == 0) {
            return;
        }
        for (int i = 0; i < this.mesh.attributes.length; ++i) {
            int location = this.cachedLocations.get(i);
            if (location < 0) continue;
            Gl.disableVertexAttribArray(location);
        }
    }

    private void bindData() {
        if (this.isDirty) {
            Core.gl.glBindBuffer(34962, this.bufferHandle);
            this.byteBuffer.limit(this.buffer.limit() * 4);
            this.upload();
            this.isDirty = false;
        }
    }

    @Override
    public void unbind(Shader shader) {
        Core.gl30.glBindVertexArray(0);
        this.isBound = false;
    }

    @Override
    public void dispose() {
        Core.gl.glBindBuffer(34962, 0);
        Core.gl.glDeleteBuffer(this.bufferHandle);
        this.bufferHandle = 0;
        Buffers.disposeUnsafeByteBuffer(this.byteBuffer);
        this.deleteVAO();
    }

    private void createVAO() {
        tmpHandle.clear();
        Core.gl30.glGenVertexArrays(1, tmpHandle);
        this.vaoHandle = tmpHandle.get();
    }

    private void deleteVAO() {
        if (this.vaoHandle != -1) {
            tmpHandle.clear();
            tmpHandle.put(this.vaoHandle);
            tmpHandle.flip();
            Core.gl30.glDeleteVertexArrays(1, tmpHandle);
            this.vaoHandle = -1;
        }
    }
}

