/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.math.Mat;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.struct.ObjectIntMap;
import arc.util.ArcRuntimeException;
import arc.util.Buffers;
import arc.util.Disposable;
import arc.util.Log;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class Shader
implements Disposable {
    public static final String positionAttribute = "a_position";
    public static final String normalAttribute = "a_normal";
    public static final String colorAttribute = "a_color";
    public static final String mixColorAttribute = "a_mix_color";
    public static final String texcoordAttribute = "a_texCoord";
    public static boolean pedantic = false;
    public static String prependVertexCode = "";
    public static String prependFragmentCode = "";
    private final ObjectIntMap<String> uniforms = new ObjectIntMap();
    private final ObjectIntMap<String> uniformTypes = new ObjectIntMap();
    private final ObjectIntMap<String> uniformSizes = new ObjectIntMap();
    private final ObjectIntMap<String> attributes = new ObjectIntMap();
    private final ObjectIntMap<String> attributeTypes = new ObjectIntMap();
    private final ObjectIntMap<String> attributeSizes = new ObjectIntMap();
    private final String vertexShaderSource;
    private final String fragmentShaderSource;
    IntBuffer params = Buffers.newIntBuffer(1);
    IntBuffer type = Buffers.newIntBuffer(1);
    private String log = "";
    private boolean isCompiled;
    private String[] uniformNames;
    private String[] attributeNames;
    private int program;
    private int vertexShaderHandle;
    private int fragmentShaderHandle;
    private boolean disposed;
    private static final float[] val = new float[16];

    public Shader(String vertexShader, String fragmentShader) {
        if (vertexShader == null) {
            throw new IllegalArgumentException("vertex shader must not be null");
        }
        if (fragmentShader == null) {
            throw new IllegalArgumentException("fragment shader must not be null");
        }
        vertexShader = this.preprocess(vertexShader, false);
        fragmentShader = this.preprocess(fragmentShader, true);
        if (prependVertexCode != null && prependVertexCode.length() > 0) {
            vertexShader = prependVertexCode + vertexShader;
        }
        if (prependFragmentCode != null && prependFragmentCode.length() > 0) {
            fragmentShader = prependFragmentCode + fragmentShader;
        }
        this.vertexShaderSource = vertexShader;
        this.fragmentShaderSource = fragmentShader;
        this.compileShaders(vertexShader, fragmentShader);
        if (!this.isCompiled()) {
            throw new IllegalArgumentException("Failed to compile shader: " + this.log);
        }
        this.fetchAttributes();
        this.fetchUniforms();
    }

    public Shader(Fi vertexShader, Fi fragmentShader) {
        this(vertexShader.readString(), fragmentShader.readString());
        if (!this.log.isEmpty()) {
            Log.warn("Shader " + vertexShader + " | " + fragmentShader + ":\n" + this.log, new Object[0]);
        }
    }

    public void apply() {
    }

    protected String preprocess(String source, boolean fragment) {
        if (source.contains("#ifdef GL_ES")) {
            throw new ArcRuntimeException("Shader contains GL_ES specific code; this should be handled by the preprocessor. Code: \n```\n" + source + "\n```");
        }
        if (source.contains("#version")) {
            throw new ArcRuntimeException("Shader contains explicit version requirement; this should be handled by the preprocessor. Code: \n```\n" + source + "\n```");
        }
        source = fragment ? "#ifdef GL_ES\nprecision " + (source.contains("#define HIGHP") && !source.contains("//#define HIGHP") ? "highp" : "mediump") + " float;\nprecision mediump int;\n#else\n#define lowp  \n#define mediump \n#define highp \n#endif\n" + source : "#ifndef GL_ES\n#define lowp  \n#define mediump \n#define highp \n#endif\n" + source;
        if (Core.gl30 != null) {
            String version = source.contains("#version ") ? "" : (Core.app.isDesktop() ? (Core.graphics.getGLVersion().atLeast(3, 2) ? "150" : "130") : "300 es");
            return "#version " + version + "\n" + (fragment ? "out lowp vec4 fragColor;\n" : "") + source.replace("varying", fragment ? "in" : "out").replace("attribute", fragment ? "???" : "in").replace("texture2D(", "texture(").replace("textureCube(", "texture(").replace("gl_FragColor", "fragColor");
        }
        return source;
    }

    private void compileShaders(String vertexShader, String fragmentShader) {
        this.vertexShaderHandle = this.loadShader(35633, vertexShader);
        this.fragmentShaderHandle = this.loadShader(35632, fragmentShader);
        if (this.vertexShaderHandle == -1 || this.fragmentShaderHandle == -1) {
            this.isCompiled = false;
            return;
        }
        this.program = this.linkProgram(this.createProgram());
        if (this.program == -1) {
            this.isCompiled = false;
            return;
        }
        this.isCompiled = true;
    }

    private int loadShader(int type, String source) {
        int compiled;
        IntBuffer intbuf = Buffers.newIntBuffer(1);
        int shader = Gl.createShader(type);
        if (shader == 0) {
            return -1;
        }
        Gl.shaderSource(shader, source);
        Gl.compileShader(shader);
        Gl.getShaderiv(shader, 35713, intbuf);
        String infoLog = Gl.getShaderInfoLog(shader);
        if (!infoLog.isEmpty()) {
            this.log = this.log + (type == 35633 ? "Vertex shader\n" : "Fragment shader:\n");
            this.log = this.log + infoLog;
        }
        if ((compiled = intbuf.get(0)) == 0) {
            return -1;
        }
        return shader;
    }

    protected int createProgram() {
        int program = Gl.createProgram();
        return program != 0 ? program : -1;
    }

    private int linkProgram(int program) {
        if (program == -1) {
            return -1;
        }
        Gl.attachShader(program, this.vertexShaderHandle);
        Gl.attachShader(program, this.fragmentShaderHandle);
        Gl.linkProgram(program);
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intbuf = tmp.asIntBuffer();
        Gl.getProgramiv(program, 35714, intbuf);
        int linked = intbuf.get(0);
        if (linked == 0) {
            this.log = Gl.getProgramInfoLog(program);
            return -1;
        }
        return program;
    }

    public String getLog() {
        if (this.isCompiled) {
            this.log = Gl.getProgramInfoLog(this.program);
            return this.log;
        }
        return this.log;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    private int fetchAttributeLocation(String name) {
        int location = this.attributes.get(name, -2);
        if (location == -2) {
            location = Gl.getAttribLocation(this.program, name);
            this.attributes.put(name, location);
        }
        return location;
    }

    private int fetchUniformLocation(String name) {
        return this.fetchUniformLocation(name, pedantic);
    }

    public int fetchUniformLocation(String name, boolean pedantic) {
        int location = this.uniforms.get(name, -2);
        if (location == -2) {
            location = Gl.getUniformLocation(this.program, name);
            if (location == -1 && pedantic) {
                throw new IllegalArgumentException("no uniform with name '" + name + "' in shader");
            }
            this.uniforms.put(name, location);
        }
        return location;
    }

    public void setUniformi(String name, int value) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform1i(location, value);
    }

    public void setUniformi(int location, int value) {
        Gl.uniform1i(location, value);
    }

    public void setUniformi(String name, int value1, int value2) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform2i(location, value1, value2);
    }

    public void setUniformi(int location, int value1, int value2) {
        Gl.uniform2i(location, value1, value2);
    }

    public void setUniformi(String name, int value1, int value2, int value3) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform3i(location, value1, value2, value3);
    }

    public void setUniformi(int location, int value1, int value2, int value3) {
        Gl.uniform3i(location, value1, value2, value3);
    }

    public void setUniformi(String name, int value1, int value2, int value3, int value4) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform4i(location, value1, value2, value3, value4);
    }

    public void setUniformi(int location, int value1, int value2, int value3, int value4) {
        Gl.uniform4i(location, value1, value2, value3, value4);
    }

    public void setUniformf(String name, float value) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform1f(location, value);
    }

    public void setUniformf(int location, float value) {
        Gl.uniform1f(location, value);
    }

    public void setUniformf(String name, float value1, float value2) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform2f(location, value1, value2);
    }

    public void setUniformf(int location, float value1, float value2) {
        Gl.uniform2f(location, value1, value2);
    }

    public void setUniformf(String name, float value1, float value2, float value3) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform3f(location, value1, value2, value3);
    }

    public void setUniformf(int location, float value1, float value2, float value3) {
        Gl.uniform3f(location, value1, value2, value3);
    }

    public void setUniformf(String name, float value1, float value2, float value3, float value4) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform4f(location, value1, value2, value3, value4);
    }

    public void setUniformf(int location, float value1, float value2, float value3, float value4) {
        Gl.uniform4f(location, value1, value2, value3, value4);
    }

    public void setUniform1fv(String name, float[] values, int offset, int length) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform1fv(location, length, values, offset);
    }

    public void setUniform1fv(int location, float[] values, int offset, int length) {
        Gl.uniform1fv(location, length, values, offset);
    }

    public void setUniform2fv(String name, float[] values, int offset, int length) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform2fv(location, length / 2, values, offset);
    }

    public void setUniform2fv(int location, float[] values, int offset, int length) {
        Gl.uniform2fv(location, length / 2, values, offset);
    }

    public void setUniform3fv(String name, float[] values, int offset, int length) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform3fv(location, length / 3, values, offset);
    }

    public void setUniform3fv(int location, float[] values, int offset, int length) {
        Gl.uniform3fv(location, length / 3, values, offset);
    }

    public void setUniform4fv(String name, float[] values, int offset, int length) {
        int location = this.fetchUniformLocation(name);
        Gl.uniform4fv(location, length / 4, values, offset);
    }

    public void setUniform4fv(int location, float[] values, int offset, int length) {
        Gl.uniform4fv(location, length / 4, values, offset);
    }

    public void setUniformMatrix(String name, Mat matrix) {
        this.setUniformMatrix(name, matrix, false);
    }

    public void setUniformMatrix(String name, Mat matrix, boolean transpose) {
        this.setUniformMatrix(this.fetchUniformLocation(name), matrix, transpose);
    }

    public void setUniformMatrix(int location, Mat matrix) {
        this.setUniformMatrix(location, matrix, false);
    }

    public void setUniformMatrix(int location, Mat matrix, boolean transpose) {
        Gl.uniformMatrix3fv(location, 1, transpose, matrix.val, 0);
    }

    public void setUniformMatrix4(String name, float[] val) {
        Gl.uniformMatrix4fv(this.fetchUniformLocation(name), 1, false, val, 0);
    }

    public void setUniformMatrix4(String name, Mat mat) {
        Gl.uniformMatrix4fv(this.fetchUniformLocation(name), 1, false, Shader.copyTransform(mat), 0);
    }

    public void setUniformMatrix4(String name, Mat mat, float near, float far) {
        Gl.uniformMatrix4fv(this.fetchUniformLocation(name), 1, false, Shader.copyTransform(mat, near, far), 0);
    }

    public void setUniformMatrix3fv(String name, FloatBuffer buffer, int count, boolean transpose) {
        buffer.position(0);
        int location = this.fetchUniformLocation(name);
        Gl.uniformMatrix3fv(location, count, transpose, buffer);
    }

    public void setUniformMatrix4fv(String name, FloatBuffer buffer, int count, boolean transpose) {
        buffer.position(0);
        int location = this.fetchUniformLocation(name);
        Gl.uniformMatrix4fv(location, count, transpose, buffer);
    }

    public void setUniformMatrix4fv(int location, float[] values, int offset, int length) {
        Gl.uniformMatrix4fv(location, length / 16, false, values, offset);
    }

    public void setUniformMatrix4fv(String name, float[] values, int offset, int length) {
        this.setUniformMatrix4fv(this.fetchUniformLocation(name), values, offset, length);
    }

    public void setUniformf(String name, Vec2 values) {
        this.setUniformf(name, values.x, values.y);
    }

    public void setUniformf(int location, Vec2 values) {
        this.setUniformf(location, values.x, values.y);
    }

    public void setUniformf(String name, Vec3 values) {
        this.setUniformf(name, values.x, values.y, values.z);
    }

    public void setUniformf(int location, Vec3 values) {
        this.setUniformf(location, values.x, values.y, values.z);
    }

    public void setUniformf(String name, Color values) {
        this.setUniformf(name, values.r, values.g, values.b, values.a);
    }

    public void setUniformf(int location, Color values) {
        this.setUniformf(location, values.r, values.g, values.b, values.a);
    }

    public void bind() {
        Gl.useProgram(this.program);
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        Gl.useProgram(0);
        Gl.deleteShader(this.vertexShaderHandle);
        Gl.deleteShader(this.fragmentShaderHandle);
        Gl.deleteProgram(this.program);
        this.disposed = true;
    }

    @Override
    public boolean isDisposed() {
        return this.disposed;
    }

    public void disableVertexAttribute(String name) {
        int location = this.fetchAttributeLocation(name);
        if (location == -1) {
            return;
        }
        Gl.disableVertexAttribArray(location);
    }

    private void fetchUniforms() {
        this.params.clear();
        Gl.getProgramiv(this.program, 35718, this.params);
        int numUniforms = this.params.get(0);
        this.uniformNames = new String[numUniforms];
        for (int i = 0; i < numUniforms; ++i) {
            this.params.clear();
            this.params.put(0, 1);
            this.type.clear();
            String name = Gl.getActiveUniform(this.program, i, this.params, this.type);
            int location = Gl.getUniformLocation(this.program, name);
            this.uniforms.put(name, location);
            this.uniformTypes.put(name, this.type.get(0));
            this.uniformSizes.put(name, this.params.get(0));
            this.uniformNames[i] = name;
        }
    }

    private void fetchAttributes() {
        this.params.clear();
        Gl.getProgramiv(this.program, 35721, this.params);
        int numAttributes = this.params.get(0);
        this.attributeNames = new String[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            this.params.clear();
            this.params.put(0, 1);
            this.type.clear();
            String name = Gl.getActiveAttrib(this.program, i, this.params, this.type);
            int location = Gl.getAttribLocation(this.program, name);
            this.attributes.put(name, location);
            this.attributeTypes.put(name, this.type.get(0));
            this.attributeSizes.put(name, this.params.get(0));
            this.attributeNames[i] = name;
        }
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public int getAttributeType(String name) {
        return this.attributeTypes.get(name, 0);
    }

    public int getAttributeLocation(String name) {
        return this.attributes.get(name, -1);
    }

    public int getAttributeSize(String name) {
        return this.attributeSizes.get(name, 0);
    }

    public boolean hasUniform(String name) {
        return this.uniforms.containsKey(name);
    }

    public int getUniformType(String name) {
        return this.uniformTypes.get(name, 0);
    }

    public int getUniformLocation(String name) {
        return this.uniforms.get(name, -1);
    }

    public int getUniformSize(String name) {
        return this.uniformSizes.get(name, 0);
    }

    public String[] getAttributes() {
        return this.attributeNames;
    }

    public String[] getUniforms() {
        return this.uniformNames;
    }

    public String getVertexShaderSource() {
        return this.vertexShaderSource;
    }

    public String getFragmentShaderSource() {
        return this.fragmentShaderSource;
    }

    public static float[] copyTransform(Mat matrix) {
        Shader.val[4] = matrix.val[3];
        Shader.val[1] = matrix.val[1];
        Shader.val[0] = matrix.val[0];
        Shader.val[5] = matrix.val[4];
        Shader.val[10] = matrix.val[8];
        Shader.val[12] = matrix.val[6];
        Shader.val[13] = matrix.val[7];
        Shader.val[15] = 1.0f;
        return val;
    }

    public static float[] copyTransform(Mat matrix, float near, float far) {
        Shader.val[4] = matrix.val[3];
        Shader.val[1] = matrix.val[1];
        Shader.val[0] = matrix.val[0];
        Shader.val[5] = matrix.val[4];
        Shader.val[10] = matrix.val[8];
        Shader.val[12] = matrix.val[6];
        Shader.val[13] = matrix.val[7];
        Shader.val[15] = 1.0f;
        float z_orth = -2.0f / (far - near);
        float tz = -(far + near) / (far - near);
        Shader.val[10] = z_orth;
        Shader.val[14] = tz;
        return val;
    }
}

