/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.graphics.Cubemap;
import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.gl.GLFrameBuffer;
import arc.graphics.gl.GLOnlyTextureData;
import arc.util.ArcRuntimeException;

public class FrameBufferCubemap
extends GLFrameBuffer<Cubemap> {
    private static final Cubemap.CubemapSide[] cubemapSides = Cubemap.CubemapSide.values();
    private int currentSide;

    FrameBufferCubemap() {
    }

    protected FrameBufferCubemap(GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Cubemap>> bufferBuilder) {
        super(bufferBuilder);
    }

    public FrameBufferCubemap(Pixmap.Format format, int width, int height, boolean hasDepth) {
        this(format, width, height, hasDepth, false);
    }

    public FrameBufferCubemap(Pixmap.Format format, int width, int height, boolean hasDepth, boolean hasStencil) {
        GLFrameBuffer.FrameBufferCubemapBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferCubemapBuilder(width, height);
        frameBufferBuilder.addBasicColorTextureAttachment(format);
        if (hasDepth) {
            frameBufferBuilder.addBasicDepthRenderBuffer();
        }
        if (hasStencil) {
            frameBufferBuilder.addBasicStencilRenderBuffer();
        }
        this.bufferBuilder = frameBufferBuilder;
        this.build();
    }

    @Override
    protected Cubemap createTexture(GLFrameBuffer.FrameBufferTextureAttachmentSpec attachmentSpec) {
        GLOnlyTextureData data = new GLOnlyTextureData(this.bufferBuilder.width, this.bufferBuilder.height, 0, attachmentSpec.internalFormat, attachmentSpec.format, attachmentSpec.type);
        Cubemap result = new Cubemap(data, data, data, data, data, data);
        result.setFilter(Texture.TextureFilter.linear, Texture.TextureFilter.linear);
        result.setWrap(Texture.TextureWrap.clampToEdge, Texture.TextureWrap.clampToEdge);
        return result;
    }

    @Override
    protected void disposeColorTexture(Cubemap colorTexture) {
        colorTexture.dispose();
    }

    @Override
    protected void attachFrameBufferColorTexture(Cubemap texture) {
        Cubemap.CubemapSide[] sides;
        int glHandle = texture.getTextureObjectHandle();
        for (Cubemap.CubemapSide side : sides = Cubemap.CubemapSide.values()) {
            Gl.framebufferTexture2D(36160, 36064, side.glEnum, glHandle, 0);
        }
    }

    @Override
    public void bind() {
        this.currentSide = -1;
        super.bind();
    }

    public boolean nextSide() {
        if (this.currentSide > 5) {
            throw new ArcRuntimeException("No remaining sides.");
        }
        if (this.currentSide == 5) {
            return false;
        }
        ++this.currentSide;
        this.bindSide(this.getSide());
        return true;
    }

    protected void bindSide(Cubemap.CubemapSide side) {
        Gl.framebufferTexture2D(36160, 36064, side.glEnum, ((Cubemap)this.getTexture()).getTextureObjectHandle(), 0);
    }

    public Cubemap.CubemapSide getSide() {
        return this.currentSide < 0 ? null : cubemapSides[this.currentSide];
    }
}

