/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.gl;

import arc.graphics.Gl;
import arc.graphics.Pixmap;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.GLFrameBuffer;
import arc.graphics.gl.GLOnlyTextureData;
import arc.graphics.gl.Shader;

public class FrameBuffer
extends GLFrameBuffer<Texture> {
    private Pixmap.Format format;

    protected FrameBuffer(GLFrameBuffer.GLFrameBufferBuilder<? extends GLFrameBuffer<Texture>> bufferBuilder) {
        super(bufferBuilder);
    }

    public FrameBuffer() {
        this(2, 2);
    }

    public FrameBuffer(int width, int height) {
        this(Pixmap.Format.rgba8888, width, height, false, false);
    }

    public FrameBuffer(Pixmap.Format format, int width, int height) {
        this(format, width, height, false, false);
    }

    public FrameBuffer(Pixmap.Format format, int width, int height, boolean hasDepth) {
        this(format, width, height, hasDepth, false);
    }

    public FrameBuffer(int width, int height, boolean hasDepth) {
        this(Pixmap.Format.rgba8888, width, height, hasDepth, false);
    }

    public FrameBuffer(Pixmap.Format format, int width, int height, boolean hasDepth, boolean hasStencil) {
        this.create(format, width, height, hasDepth, hasStencil);
    }

    protected void create(Pixmap.Format format, int width, int height, boolean hasDepth, boolean hasStencil) {
        width = Math.max(width, 2);
        height = Math.max(height, 2);
        this.format = format;
        GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(width, height);
        frameBufferBuilder.addBasicColorTextureAttachment(format);
        if (hasDepth) {
            frameBufferBuilder.addBasicDepthRenderBuffer();
        }
        if (hasStencil) {
            frameBufferBuilder.addBasicStencilRenderBuffer();
        }
        this.bufferBuilder = frameBufferBuilder;
        this.build();
    }

    public void blit(Shader shader) {
        Draw.blit(this, shader);
    }

    public boolean resizeCheck(int width, int height) {
        int lastWidth = this.getWidth();
        int lastHeight = this.getHeight();
        this.resize(width, height);
        return lastWidth != this.getWidth() || lastHeight != this.getHeight();
    }

    public void resize(int width, int height) {
        width = Math.max(width, 2);
        height = Math.max(height, 2);
        if (width == this.getWidth() && height == this.getHeight()) {
            return;
        }
        Texture.TextureFilter min = ((Texture)this.getTexture()).getMinFilter();
        Texture.TextureFilter mag = ((Texture)this.getTexture()).getMagFilter();
        boolean hasDepth = this.depthbufferHandle != 0;
        boolean hasStencil = this.stencilbufferHandle != 0;
        this.dispose();
        GLFrameBuffer.FrameBufferBuilder frameBufferBuilder = new GLFrameBuffer.FrameBufferBuilder(width, height);
        frameBufferBuilder.addBasicColorTextureAttachment(this.format);
        if (hasDepth) {
            frameBufferBuilder.addBasicDepthRenderBuffer();
        }
        if (hasStencil) {
            frameBufferBuilder.addBasicStencilRenderBuffer();
        }
        this.bufferBuilder = frameBufferBuilder;
        this.textureAttachments.clear();
        this.framebufferHandle = 0;
        this.depthbufferHandle = 0;
        this.stencilbufferHandle = 0;
        this.depthStencilPackedBufferHandle = 0;
        this.isMRT = false;
        this.hasDepthStencilPackedBuffer = false;
        this.build();
        ((Texture)this.getTexture()).setFilter(min, mag);
    }

    public static void unbind() {
        GLFrameBuffer.unbind();
    }

    @Override
    protected Texture createTexture(GLFrameBuffer.FrameBufferTextureAttachmentSpec attachmentSpec) {
        GLOnlyTextureData data = new GLOnlyTextureData(this.bufferBuilder.width, this.bufferBuilder.height, 0, attachmentSpec.internalFormat, attachmentSpec.format, attachmentSpec.type);
        Texture result = new Texture(data);
        result.setFilter(Texture.TextureFilter.linear, Texture.TextureFilter.linear);
        result.setWrap(Texture.TextureWrap.clampToEdge, Texture.TextureWrap.clampToEdge);
        return result;
    }

    @Override
    protected void disposeColorTexture(Texture colorTexture) {
        colorTexture.dispose();
    }

    @Override
    protected void attachFrameBufferColorTexture(Texture texture) {
        Gl.framebufferTexture2D(36160, 36064, 3553, texture.getTextureObjectHandle(), 0);
    }
}

