/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.graphics.Blending;
import arc.graphics.Texture;
import arc.graphics.g2d.DrawRequest;
import arc.graphics.g2d.ForkJoinHolder;
import arc.graphics.g2d.SpriteBatch;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.math.geom.Point2;
import arc.struct.IntIntMap;
import arc.util.Structs;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RecursiveAction;

public class SortedSpriteBatch
extends SpriteBatch {
    static ForkJoinHolder commonPool;
    boolean multithreaded = Core.app.getVersion() >= 21 && !Core.app.isIOS() || Core.app.isDesktop();
    int[] contiguous = new int[2048];
    int[] contiguousCopy = new int[2048];
    DrawRequest[] copy = new DrawRequest[0];
    int[] locs = new int[this.contiguous.length];
    protected DrawRequest[] requests = new DrawRequest[10000];
    protected boolean sort;
    protected boolean flushing;
    protected float[] requestZ = new float[10000];
    protected int numRequests = 0;

    public SortedSpriteBatch() {
        for (int i = 0; i < this.requests.length; ++i) {
            this.requests[i] = new DrawRequest();
        }
        if (this.multithreaded) {
            try {
                commonPool = new ForkJoinHolder();
            }
            catch (Throwable t) {
                this.multithreaded = false;
            }
        }
    }

    @Override
    protected void setSort(boolean sort) {
        if (this.sort != sort) {
            this.flush();
        }
        this.sort = sort;
    }

    @Override
    protected void setShader(Shader shader, boolean apply) {
        if (!this.flushing && this.sort) {
            throw new IllegalArgumentException("Shaders cannot be set while sorting is enabled. Set shaders inside Draw.run(...).");
        }
        super.setShader(shader, apply);
    }

    @Override
    protected void setBlending(Blending blending) {
        this.blending = blending;
    }

    @Override
    protected void draw(Texture texture, float[] spriteVertices, int offset, int count) {
        if (this.sort && !this.flushing) {
            if (this.numRequests + count - offset >= this.requests.length) {
                this.expandRequests();
            }
            float[] requestZ = this.requestZ;
            DrawRequest[] requests = this.requests;
            for (int i = offset; i < count; i += 24) {
                DrawRequest req = requests[this.numRequests];
                requestZ[this.numRequests] = req.z = this.z;
                System.arraycopy(spriteVertices, i, req.vertices, 0, req.vertices.length);
                req.texture = texture;
                req.blending = this.blending;
                req.run = null;
                ++this.numRequests;
            }
        } else {
            super.draw(texture, spriteVertices, offset, count);
        }
    }

    @Override
    protected void draw(TextureRegion region, float x, float y, float originX, float originY, float width, float height, float rotation) {
        if (this.sort && !this.flushing) {
            if (this.numRequests >= this.requests.length) {
                this.expandRequests();
            }
            DrawRequest req = this.requests[this.numRequests];
            req.x = x;
            req.y = y;
            this.requestZ[this.numRequests] = req.z = this.z;
            req.originX = originX;
            req.originY = originY;
            req.width = width;
            req.height = height;
            req.color = this.colorPacked;
            req.rotation = rotation;
            req.region.set(region);
            req.mixColor = this.mixColorPacked;
            req.blending = this.blending;
            req.texture = null;
            req.run = null;
            ++this.numRequests;
        } else {
            super.draw(region, x, y, originX, originY, width, height, rotation);
        }
    }

    @Override
    protected void draw(Runnable request) {
        if (this.sort && !this.flushing) {
            if (this.numRequests >= this.requests.length) {
                this.expandRequests();
            }
            DrawRequest req = this.requests[this.numRequests];
            req.run = request;
            req.blending = this.blending;
            req.mixColor = this.mixColorPacked;
            req.color = this.colorPacked;
            this.requestZ[this.numRequests] = req.z = this.z;
            req.texture = null;
            ++this.numRequests;
        } else {
            super.draw(request);
        }
    }

    protected void expandRequests() {
        DrawRequest[] requests = this.requests;
        DrawRequest[] newRequests = new DrawRequest[requests.length * 7 / 4];
        System.arraycopy(requests, 0, newRequests, 0, Math.min(newRequests.length, requests.length));
        for (int i = requests.length; i < newRequests.length; ++i) {
            newRequests[i] = new DrawRequest();
        }
        this.requests = newRequests;
        this.requestZ = Arrays.copyOf(this.requestZ, newRequests.length);
    }

    @Override
    protected void flush() {
        this.flushRequests();
        super.flush();
    }

    protected void flushRequests() {
        if (!this.flushing && this.numRequests > 0) {
            this.flushing = true;
            this.sortRequests();
            float preColor = this.colorPacked;
            float preMixColor = this.mixColorPacked;
            Blending preBlending = this.blending;
            DrawRequest[] r = this.requests;
            int num = this.numRequests;
            for (int j = 0; j < num; ++j) {
                DrawRequest req = r[j];
                this.colorPacked = req.color;
                this.mixColorPacked = req.mixColor;
                super.setBlending(req.blending);
                if (req.run != null) {
                    req.run.run();
                    continue;
                }
                if (req.texture != null) {
                    super.draw(req.texture, req.vertices, 0, req.vertices.length);
                    continue;
                }
                super.draw(req.region, req.x, req.y, req.originX, req.originY, req.width, req.height, req.rotation);
            }
            this.colorPacked = preColor;
            this.mixColorPacked = preMixColor;
            this.color.abgr8888(this.colorPacked);
            this.mixColor.abgr8888(this.mixColorPacked);
            this.blending = preBlending;
            this.numRequests = 0;
            this.flushing = false;
        }
    }

    protected void sortRequests() {
        if (this.multithreaded) {
            this.sortRequestsThreaded();
        } else {
            this.sortRequestsStandard();
        }
    }

    protected void sortRequestsThreaded() {
        int numRequests = this.numRequests;
        if (this.copy.length < numRequests) {
            this.copy = new DrawRequest[numRequests + (numRequests >> 3)];
        }
        DrawRequest[] items = this.requests;
        DrawRequest[] itemCopy = this.copy;
        float[] itemZ = this.requestZ;
        Future initTask = SortedSpriteBatch.commonPool.pool.submit(() -> System.arraycopy(items, 0, itemCopy, 0, numRequests));
        int[] contiguous = this.contiguous;
        int ci = 0;
        int cl = contiguous.length;
        float z = itemZ[0];
        int startI = 0;
        for (int i = 1; i < numRequests; ++i) {
            if (itemZ[i] == z) continue;
            contiguous[ci] = Float.floatToRawIntBits(z + 16.0f);
            contiguous[ci + 1] = startI;
            contiguous[ci + 2] = i - startI;
            if ((ci += 3) + 3 > cl) {
                contiguous = Arrays.copyOf(contiguous, cl <<= 1);
            }
            startI = i;
            z = itemZ[startI];
        }
        contiguous[ci] = Float.floatToRawIntBits(z + 16.0f);
        contiguous[ci + 1] = startI;
        contiguous[ci + 2] = numRequests - startI;
        this.contiguous = contiguous;
        int L = ci / 3 + 1;
        if (this.contiguousCopy.length < contiguous.length) {
            this.contiguousCopy = new int[contiguous.length];
        }
        int[] sorted = CountingSort.countingSortMapMT(contiguous, this.contiguousCopy, L);
        if (this.locs.length < L + 1) {
            this.locs = new int[L + L / 10];
        }
        int[] locs = this.locs;
        for (int i = 0; i < L; ++i) {
            locs[i + 1] = locs[i] + sorted[i * 3 + 2];
        }
        try {
            initTask.get();
        }
        catch (Exception ignored) {
            System.arraycopy(items, 0, itemCopy, 0, numRequests);
        }
        PopulateTask.tasks = sorted;
        PopulateTask.src = itemCopy;
        PopulateTask.dest = items;
        PopulateTask.locs = locs;
        SortedSpriteBatch.commonPool.pool.invoke(new PopulateTask(0, L));
    }

    protected void sortRequestsStandard() {
        int numRequests = this.numRequests;
        if (this.copy.length < numRequests) {
            this.copy = new DrawRequest[numRequests + (numRequests >> 3)];
        }
        DrawRequest[] items = this.copy;
        float[] itemZ = this.requestZ;
        System.arraycopy(this.requests, 0, items, 0, numRequests);
        int[] contiguous = this.contiguous;
        int ci = 0;
        int cl = contiguous.length;
        float z = itemZ[0];
        int startI = 0;
        for (int i = 1; i < numRequests; ++i) {
            if (itemZ[i] == z) continue;
            contiguous[ci] = Float.floatToRawIntBits(z + 16.0f);
            contiguous[ci + 1] = startI;
            contiguous[ci + 2] = i - startI;
            if ((ci += 3) + 3 > cl) {
                contiguous = Arrays.copyOf(contiguous, cl <<= 1);
            }
            startI = i;
            z = itemZ[startI];
        }
        contiguous[ci] = Float.floatToRawIntBits(z + 16.0f);
        contiguous[ci + 1] = startI;
        contiguous[ci + 2] = numRequests - startI;
        this.contiguous = contiguous;
        int L = ci / 3 + 1;
        if (this.contiguousCopy.length < contiguous.length) {
            this.contiguousCopy = new int[contiguous.length];
        }
        int[] sorted = CountingSort.countingSortMap(contiguous, this.contiguousCopy, L);
        int ptr = 0;
        DrawRequest[] dest = this.requests;
        for (int i = 0; i < L * 3; i += 3) {
            int pos = sorted[i + 1];
            int length = sorted[i + 2];
            if (length < 10) {
                int end = pos + length;
                int sj = pos;
                int dj = ptr;
                while (sj < end) {
                    dest[dj] = items[sj];
                    ++sj;
                    ++dj;
                }
            } else {
                System.arraycopy(items, pos, dest, ptr, Math.min(length, dest.length - ptr));
            }
            ptr += length;
        }
    }

    static class CountingSort {
        private static final int processors;
        static int[] locs;
        static final int[][] locses;
        static final IntIntMap[] countses;
        private static Point2[] entries;
        private static int[] entries3;
        private static int[] entries3a;
        private static Integer[] entriesBacking;
        private static final CountingSortTask[] tasks;
        private static final CountingSortTask2[] task2s;
        private static final Future<?>[] futures;

        CountingSort() {
        }

        static int[] countingSortMapMT(int[] arr, int[] swap, int end) {
            int i2;
            IntIntMap[] countses = CountingSort.countses;
            int[][] locs = locses;
            int threads = Math.min(processors, (end + 4095) / 4096);
            int thread_size = end / threads + 1;
            CountingSortTask[] tasks = CountingSort.tasks;
            CountingSortTask2[] task2s = CountingSort.task2s;
            Future<?>[] futures = CountingSort.futures;
            CountingSortTask2.src = arr;
            CountingSortTask.arr = arr;
            CountingSortTask2.dest = swap;
            int s = 0;
            int thread = 0;
            while (thread < threads) {
                CountingSortTask task = tasks[thread];
                int stop = Math.min(s + thread_size, end);
                task.set(s, stop, thread);
                task2s[thread].set(s, stop, thread);
                futures[thread] = SortedSpriteBatch.commonPool.pool.submit(task);
                ++thread;
                s += thread_size;
            }
            int unique = 0;
            for (int i3 = 0; i3 < threads; ++i3) {
                try {
                    futures[i3].get();
                }
                catch (InterruptedException | ExecutionException e) {
                    SortedSpriteBatch.commonPool.pool.execute(tasks[i3]);
                }
                unique += countses[i3].size;
            }
            int L = unique;
            if (entriesBacking.length < L) {
                entriesBacking = new Integer[L * 3 / 2];
                entries3 = new int[L * 3 * 3 / 2];
                entries3a = new int[L * 3 * 3 / 2];
            }
            int[] entries = entries3;
            int[] entries3a = CountingSort.entries3a;
            Integer[] entriesBacking = CountingSort.entriesBacking;
            int j = 0;
            for (i2 = 0; i2 < threads; ++i2) {
                if (countses[i2].size == 0) continue;
                IntIntMap.Entries countEntries = countses[i2].entries();
                IntIntMap.Entry entry = countEntries.next();
                entries[j] = entry.key;
                entries[j + 1] = entry.value;
                entries[j + 2] = i2;
                j += 3;
                while (countEntries.hasNext) {
                    countEntries.next();
                    entries[j] = entry.key;
                    entries[j + 1] = entry.value;
                    entries[j + 2] = i2;
                    j += 3;
                }
            }
            for (i2 = 0; i2 < L; ++i2) {
                entriesBacking[i2] = i2;
            }
            Arrays.sort(entriesBacking, 0, L, Structs.comparingInt(i -> entries[i * 3]));
            for (i2 = 0; i2 < L; ++i2) {
                int from = entriesBacking[i2] * 3;
                int to = i2 * 3;
                entries3a[to] = entries[from];
                entries3a[to + 1] = entries[from + 1];
                entries3a[to + 2] = entries[from + 2];
            }
            int pos = 0;
            for (i2 = 0; i2 < L * 3; i2 += 3) {
                int[] nArray = locs[entries3a[i2 + 2]];
                int n = entries3a[i2 + 1];
                int n2 = nArray[n] + pos;
                nArray[n] = n2;
                pos = n2;
            }
            for (int thread2 = 0; thread2 < threads; ++thread2) {
                futures[thread2] = SortedSpriteBatch.commonPool.pool.submit(task2s[thread2]);
            }
            for (i2 = 0; i2 < threads; ++i2) {
                try {
                    futures[i2].get();
                    continue;
                }
                catch (InterruptedException | ExecutionException e) {
                    SortedSpriteBatch.commonPool.pool.execute(task2s[i2]);
                }
            }
            return swap;
        }

        static int[] countingSortMap(int[] arr, int[] swap, int end) {
            int i;
            int[] locs = CountingSort.locs;
            IntIntMap counts = countses[0];
            counts.clear();
            int unique = 0;
            int end3 = end * 3;
            for (int i2 = 0; i2 < end3; i2 += 3) {
                int loc;
                arr[i2] = loc = counts.getOrPut(arr[i2], unique);
                if (loc == unique) {
                    if (unique >= locs.length) {
                        locs = Arrays.copyOf(locs, unique * 3 / 2);
                    }
                    locs[unique++] = 1;
                    continue;
                }
                int n = loc;
                locs[n] = locs[n] + 1;
            }
            CountingSort.locs = locs;
            if (entries.length < unique) {
                int prevLength = entries.length;
                Point2[] entries = CountingSort.entries = Arrays.copyOf(CountingSort.entries, unique * 3 / 2);
                for (int i3 = prevLength; i3 < entries.length; ++i3) {
                    entries[i3] = new Point2();
                }
            }
            Point2[] entries = CountingSort.entries;
            IntIntMap.Entries countEntries = counts.entries();
            IntIntMap.Entry entry = countEntries.next();
            entries[0].set(entry.key, entry.value);
            int j = 1;
            while (countEntries.hasNext) {
                countEntries.next();
                entries[j++].set(entry.key, entry.value);
            }
            Arrays.sort(entries, 0, unique, Structs.comparingInt(p -> p.x));
            int prev = entries[0].y;
            for (i = 1; i < unique; ++i) {
                int next = entries[i].y;
                locs[next] = locs[next] + locs[prev];
                prev = next;
            }
            i = end - 1;
            int i3 = i * 3;
            while (i >= 0) {
                int n = arr[i3];
                int n2 = locs[n] - 1;
                locs[n] = n2;
                int destPos = n2 * 3;
                swap[destPos] = arr[i3];
                swap[destPos + 1] = arr[i3 + 1];
                swap[destPos + 2] = arr[i3 + 2];
                --i;
                i3 -= 3;
            }
            return swap;
        }

        static {
            int i;
            processors = Runtime.getRuntime().availableProcessors() * 8;
            locs = new int[100];
            locses = new int[processors][100];
            countses = new IntIntMap[processors];
            entries = new Point2[100];
            entries3 = new int[300];
            entries3a = new int[300];
            entriesBacking = new Integer[100];
            tasks = new CountingSortTask[processors];
            task2s = new CountingSortTask2[processors];
            futures = new Future[processors];
            for (i = 0; i < countses.length; ++i) {
                CountingSort.countses[i] = new IntIntMap();
            }
            for (i = 0; i < entries.length; ++i) {
                CountingSort.entries[i] = new Point2();
            }
            for (i = 0; i < processors; ++i) {
                CountingSort.tasks[i] = new CountingSortTask();
                CountingSort.task2s[i] = new CountingSortTask2();
            }
        }

        static class CountingSortTask
        implements Runnable {
            static int[] arr;
            int start;
            int end;
            int id;

            CountingSortTask() {
            }

            public void set(int start, int end, int id) {
                this.start = start;
                this.end = end;
                this.id = id;
            }

            @Override
            public void run() {
                int id = this.id;
                int start = this.start;
                int end = this.end;
                int[] locs = locses[id];
                int[] arr = CountingSortTask.arr;
                IntIntMap counts = countses[id];
                counts.clear();
                int unique = 0;
                for (int i = start; i < end; ++i) {
                    int loc;
                    arr[i * 3] = loc = counts.getOrPut(arr[i * 3], unique);
                    if (loc == unique) {
                        if (unique >= locs.length) {
                            locs = Arrays.copyOf(locs, unique * 3 / 2);
                        }
                        locs[unique++] = 1;
                        continue;
                    }
                    int n = loc;
                    locs[n] = locs[n] + 1;
                }
                CountingSort.locses[id] = locs;
            }
        }

        static class CountingSortTask2
        implements Runnable {
            static int[] src;
            static int[] dest;
            int start;
            int end;
            int id;

            CountingSortTask2() {
            }

            public void set(int start, int end, int id) {
                this.start = start;
                this.end = end;
                this.id = id;
            }

            @Override
            public void run() {
                int start = this.start;
                int end = this.end;
                int[] locs = locses[this.id];
                int[] src = CountingSortTask2.src;
                int[] dest = CountingSortTask2.dest;
                int i = end - 1;
                int i3 = i * 3;
                while (i >= start) {
                    int n = src[i3];
                    int n2 = locs[n] - 1;
                    locs[n] = n2;
                    int destPos = n2 * 3;
                    dest[destPos] = src[i3];
                    dest[destPos + 1] = src[i3 + 1];
                    dest[destPos + 2] = src[i3 + 2];
                    --i;
                    i3 -= 3;
                }
            }
        }
    }

    static class PopulateTask
    extends RecursiveAction {
        int from;
        int to;
        static int[] tasks;
        static DrawRequest[] src;
        static DrawRequest[] dest;
        static int[] locs;

        PopulateTask(int from, int to) {
            this.from = from;
            this.to = to;
        }

        @Override
        protected void compute() {
            int[] locs = PopulateTask.locs;
            if (this.to - this.from > 1 && locs[this.to] - locs[this.from] > 2048) {
                int half = locs[this.to] + locs[this.from] >> 1;
                int mid = Arrays.binarySearch(locs, this.from, this.to, half);
                if (mid < 0) {
                    mid = -mid - 1;
                }
                if (mid != this.from && mid != this.to) {
                    PopulateTask.invokeAll(new PopulateTask(this.from, mid), new PopulateTask(mid, this.to));
                    return;
                }
            }
            DrawRequest[] src = PopulateTask.src;
            DrawRequest[] dest = PopulateTask.dest;
            int[] tasks = PopulateTask.tasks;
            for (int i = this.from; i < this.to; ++i) {
                int point = i * 3;
                int pos = tasks[point + 1];
                int length = tasks[point + 2];
                if (length < 10) {
                    int end = pos + length;
                    int sj = pos;
                    int dj = locs[i];
                    while (sj < end) {
                        dest[dj] = src[sj];
                        ++sj;
                        ++dj;
                    }
                    continue;
                }
                System.arraycopy(src, pos, dest, locs[i], Math.min(length, dest.length - locs[i]));
            }
        }
    }
}

