/*
 * Decompiled with CFR 0.152.
 */
package arc.graphics.g2d;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;

public class Lines {
    public static boolean useLegacyLine = false;
    private static float stroke = 1.0f;
    private static Vec2 vector = new Vec2();
    private static Vec2 u = new Vec2();
    private static Vec2 v = new Vec2();
    private static FloatSeq floats = new FloatSeq(20);
    private static FloatSeq floatBuilder = new FloatSeq(20);
    private static boolean building;
    private static float circlePrecision;
    private static final Vec2 AB;
    private static final Vec2 BC;
    private static final Vec2 A;
    private static final Vec2 B;
    private static final Vec2 C;
    private static final Vec2 E;
    private static final Vec2 D;
    private static final Vec2 vec1;
    private static final Vec2 D0;
    private static final Vec2 E0;
    private static final Vec2 q1;
    private static final Vec2 q2;
    private static final Vec2 q3;
    private static final Vec2 q4;

    public static void setCirclePrecision(float amount) {
        circlePrecision = amount;
    }

    public static int circleVertices(float rad) {
        return 11 + (int)(rad * circlePrecision);
    }

    public static void lineAngle(float x, float y, float angle, float length, boolean cap) {
        vector.trns(angle, length);
        Lines.line(x, y, x + Lines.vector.x, y + Lines.vector.y, cap);
    }

    public static void lineAngle(float x, float y, float angle, float length) {
        vector.trns(angle, length);
        Lines.line(x, y, x + Lines.vector.x, y + Lines.vector.y);
    }

    public static void lineAngle(float x, float y, float angle, float length, float offset) {
        vector.trns(angle, 1.0f);
        Lines.line(x + Lines.vector.x * offset, y + Lines.vector.y * offset, x + Lines.vector.x * (length + offset), y + Lines.vector.y * (length + offset));
    }

    public static void lineAngleCenter(float x, float y, float angle, float length, boolean cap) {
        vector.trns(angle, length);
        Lines.line(x - Lines.vector.x / 2.0f, y - Lines.vector.y / 2.0f, x + Lines.vector.x / 2.0f, y + Lines.vector.y / 2.0f, cap);
    }

    public static void lineAngleCenter(float x, float y, float angle, float length) {
        vector.trns(angle, length);
        Lines.line(x - Lines.vector.x / 2.0f, y - Lines.vector.y / 2.0f, x + Lines.vector.x / 2.0f, y + Lines.vector.y / 2.0f);
    }

    public static void line(float x, float y, float x2, float y2) {
        Lines.line(x, y, x2, y2, true);
    }

    public static void line(float x, float y, float x2, float y2, boolean cap) {
        Lines.line(Core.atlas.white(), x, y, x2, y2, cap);
    }

    public static void line(TextureRegion region, float x, float y, float x2, float y2, boolean cap) {
        if (useLegacyLine) {
            float length = Mathf.dst(x, y, x2, y2) + (!cap ? 0.0f : stroke);
            float angle = Mathf.atan2(x2 - x, y2 - y) * 57.295776f;
            if (cap) {
                Draw.rect(region, x - stroke / 2.0f + length / 2.0f, y, length, stroke, stroke / 2.0f, stroke / 2.0f, angle);
            } else {
                Draw.rect(region, x + length / 2.0f, y, length, stroke, 0.0f, stroke / 2.0f, angle);
            }
        } else {
            float hstroke = stroke / 2.0f;
            float len = Mathf.len(x2 - x, y2 - y);
            float diffx = (x2 - x) / len * hstroke;
            float diffy = (y2 - y) / len * hstroke;
            if (cap) {
                Fill.quad(region, x - diffx - diffy, y - diffy + diffx, x - diffx + diffy, y - diffy - diffx, x2 + diffx + diffy, y2 + diffy - diffx, x2 + diffx - diffy, y2 + diffy + diffx);
            } else {
                Fill.quad(region, x - diffy, y + diffx, x + diffy, y - diffx, x2 + diffy, y2 - diffx, x2 - diffy, y2 + diffx);
            }
        }
    }

    public static void linePoint(Position p) {
        Lines.linePoint(p.getX(), p.getY());
    }

    public static void linePoint(float x, float y) {
        if (!building) {
            throw new IllegalStateException("Not building");
        }
        floatBuilder.add(x, y);
    }

    public static void beginLine() {
        if (building) {
            throw new IllegalStateException("Already building");
        }
        floatBuilder.clear();
        building = true;
    }

    public static void endLine() {
        Lines.endLine(false);
    }

    public static void endLine(boolean wrap) {
        if (!building) {
            throw new IllegalStateException("Not building");
        }
        Lines.polyline(floatBuilder, wrap);
        building = false;
    }

    public static void polyline(FloatSeq points, boolean wrap) {
        Lines.polyline(points.items, points.size, wrap);
    }

    public static void polyline(float[] points, int length, boolean wrap) {
        if (length < 4) {
            return;
        }
        float halfWidth = 0.5f * stroke;
        for (int i = 2; i < length - 2; i += 2) {
            A.set(points[i - 2], points[i - 1]);
            B.set(points[i], points[i + 1]);
            C.set(points[i + 2], points[i + 3]);
            Lines.preparePointyJoin(A, B, C, D, E, halfWidth);
            float x3 = Lines.D.x;
            float y3 = Lines.D.y;
            float x4 = Lines.E.x;
            float y4 = Lines.E.y;
            q3.set(D);
            q4.set(E);
            if (i == 2) {
                if (!wrap) {
                    Lines.prepareFlatEndpoint(points[2], points[3], points[0], points[1], D, E, halfWidth);
                    q1.set(E);
                    q2.set(D);
                } else {
                    vec1.set(points[length - 2], points[length - 1]);
                    Lines.preparePointyJoin(vec1, A, B, D0, E0, halfWidth);
                    q1.set(E0);
                    q2.set(D0);
                }
            }
            Lines.pushQuad();
            q1.set(x4, y4);
            q2.set(x3, y3);
        }
        if (!wrap) {
            Lines.prepareFlatEndpoint(B, C, D, E, halfWidth);
            q3.set(E);
            q4.set(D);
            Lines.pushQuad();
        } else {
            A.set(points[0], points[1]);
            Lines.preparePointyJoin(B, C, A, D, E, halfWidth);
            q3.set(D);
            q4.set(E);
            Lines.pushQuad();
            q1.set(D);
            q2.set(E);
            q3.set(E0);
            q4.set(D0);
            Lines.pushQuad();
        }
    }

    private static void pushQuad() {
        Fill.quad(Lines.q1.x, Lines.q1.y, Lines.q2.x, Lines.q2.y, Lines.q3.x, Lines.q3.y, Lines.q4.x, Lines.q4.y);
    }

    private static void prepareFlatEndpoint(Vec2 pathPoint, Vec2 endPoint, Vec2 D, Vec2 E, float halfLineWidth) {
        Lines.prepareFlatEndpoint(pathPoint.x, pathPoint.y, endPoint.x, endPoint.y, D, E, halfLineWidth);
    }

    private static void prepareFlatEndpoint(float pathPointX, float pathPointY, float endPointX, float endPointY, Vec2 D, Vec2 E, float halfLineWidth) {
        v.set(endPointX, endPointY).sub(pathPointX, pathPointY).setLength(halfLineWidth);
        D.set(Lines.v.y, -Lines.v.x).add(endPointX, endPointY);
        E.set(-Lines.v.y, Lines.v.x).add(endPointX, endPointY);
    }

    private static void preparePointyJoin(Vec2 A, Vec2 B, Vec2 C, Vec2 D, Vec2 E, float halfLineWidth) {
        AB.set(B).sub(A);
        BC.set(C).sub(B);
        float angle = Lines.angleRad(AB, BC);
        if (Mathf.equal(angle, 0.0f) || Mathf.equal(angle, (float)Math.PI * 2)) {
            Lines.prepareStraightJoin(B, D, E, halfLineWidth);
            return;
        }
        float len = (float)((double)halfLineWidth / Math.sin(angle));
        boolean bendsLeft = angle < 0.0f;
        AB.setLength(len);
        BC.setLength(len);
        Vec2 insidePoint = bendsLeft ? D : E;
        Vec2 outsidePoint = bendsLeft ? E : D;
        insidePoint.set(B).sub(AB).add(BC);
        outsidePoint.set(B).add(AB).sub(BC);
    }

    private static float angleRad(Vec2 v, Vec2 reference) {
        return (float)Math.atan2(reference.x * v.y - reference.y * v.x, v.x * reference.x + v.y * reference.y);
    }

    private static void prepareStraightJoin(Vec2 B, Vec2 D, Vec2 E, float halfLineWidth) {
        AB.setLength(halfLineWidth);
        D.set(-Lines.AB.y, Lines.AB.x).add(B);
        E.set(Lines.AB.y, -Lines.AB.x).add(B);
    }

    public static void dashLine(float x1, float y1, float x2, float y2, int divisions) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        for (int i = 0; i < divisions; i += 2) {
            Lines.line(x1 + (float)i / (float)divisions * dx, y1 + (float)i / (float)divisions * dy, x1 + ((float)i + 1.0f) / (float)divisions * dx, y1 + ((float)i + 1.0f) / (float)divisions * dy);
        }
    }

    public static void circle(float x, float y, float rad) {
        Lines.poly(x, y, Lines.circleVertices(rad), rad);
    }

    public static void ellipse(float x, float y, float rad, float width, float height, float rot) {
        float sides = Lines.circleVertices(rad);
        float space = 360.0f / sides;
        int i = 0;
        while ((float)i < sides) {
            float a = space * (float)i;
            u.trns(rot, rad * width * Mathf.cosDeg(a), rad * height * Mathf.sinDeg(a));
            v.trns(rot, rad * width * Mathf.cosDeg(a + space), rad * height * Mathf.sinDeg(a + space));
            Lines.line(x + Lines.u.x, y + Lines.u.y, x + Lines.v.x, y + Lines.v.y);
            ++i;
        }
    }

    public static void dashCircle(float x, float y, float radius) {
        float scaleFactor = 0.6f;
        int sides = 10 + (int)(radius * scaleFactor);
        if (sides % 2 == 1) {
            ++sides;
        }
        vector.set(0.0f, 0.0f);
        for (int i = 0; i < sides; i += 2) {
            vector.set(radius, 0.0f).rotate(360.0f / (float)sides * (float)i + 90.0f);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.set(radius, 0.0f).rotate(360.0f / (float)sides * (float)(i + 1) + 90.0f);
            Lines.line(x1 + x, y1 + y, Lines.vector.x + x, Lines.vector.y + y);
        }
    }

    public static void spikes(float x, float y, float radius, float length, int spikes, float rot) {
        vector.set(0.0f, 1.0f);
        float step = 360.0f / (float)spikes;
        for (int i = 0; i < spikes; ++i) {
            vector.trns((float)i * step + rot, radius);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.setLength(radius + length);
            Lines.line(x + x1, y + y1, x + Lines.vector.x, y + Lines.vector.y);
        }
    }

    public static void spikes(float x, float y, float rad, float length, int spikes) {
        Lines.spikes(x, y, rad, length, spikes, 0.0f);
    }

    public static void quad(float x1, float y1, float x2, float y2, float x3, float y3, float x4, float y4) {
        floatBuilder.clear();
        floatBuilder.add(x1, y1, x2, y2);
        floatBuilder.add(x3, y3, x4, y4);
        Lines.polyline(floatBuilder, true);
    }

    public static void poly(float x, float y, int sides, float radius, float angle) {
        float space = 360.0f / (float)sides;
        float hstep = stroke / 2.0f / Mathf.cosDeg(space / 2.0f);
        float r1 = radius - hstep;
        float r2 = radius + hstep;
        for (int i = 0; i < sides; ++i) {
            float a = space * (float)i + angle;
            float cos = Mathf.cosDeg(a);
            float sin = Mathf.sinDeg(a);
            float cos2 = Mathf.cosDeg(a + space);
            float sin2 = Mathf.sinDeg(a + space);
            Fill.quad(x + r1 * cos, y + r1 * sin, x + r1 * cos2, y + r1 * sin2, x + r2 * cos2, y + r2 * sin2, x + r2 * cos, y + r2 * sin);
        }
    }

    public static void poly(float x, float y, int sides, float radius) {
        Lines.poly(x, y, sides, radius, 0.0f);
    }

    public static void poly(Vec2[] vertices, float offsetx, float offsety, float scl) {
        for (int i = 0; i < vertices.length; ++i) {
            Vec2 current = vertices[i];
            Vec2 next = i == vertices.length - 1 ? vertices[0] : vertices[i + 1];
            Lines.line(current.x * scl + offsetx, current.y * scl + offsety, next.x * scl + offsetx, next.y * scl + offsety);
        }
    }

    public static void curve(float x1, float y1, float cx1, float cy1, float cx2, float cy2, float x2, float y2, int segments) {
        float subdiv_step = 1.0f / (float)segments;
        float subdiv_step2 = subdiv_step * subdiv_step;
        float subdiv_step3 = subdiv_step * subdiv_step * subdiv_step;
        float pre1 = 3.0f * subdiv_step;
        float pre2 = 3.0f * subdiv_step2;
        float pre4 = 6.0f * subdiv_step2;
        float pre5 = 6.0f * subdiv_step3;
        float tmp1x = x1 - cx1 * 2.0f + cx2;
        float tmp1y = y1 - cy1 * 2.0f + cy2;
        float tmp2x = (cx1 - cx2) * 3.0f - x1 + x2;
        float tmp2y = (cy1 - cy2) * 3.0f - y1 + y2;
        float fx = x1;
        float fy = y1;
        float dfx = (cx1 - x1) * pre1 + tmp1x * pre2 + tmp2x * subdiv_step3;
        float dfy = (cy1 - y1) * pre1 + tmp1y * pre2 + tmp2y * subdiv_step3;
        float ddfx = tmp1x * pre4 + tmp2x * pre5;
        float ddfy = tmp1y * pre4 + tmp2y * pre5;
        float dddfx = tmp2x * pre5;
        float dddfy = tmp2y * pre5;
        Lines.beginLine();
        while (segments-- > 0) {
            Lines.linePoint(fx, fy);
            fx += dfx;
            fy += dfy;
            dfx += ddfx;
            dfy += ddfy;
            ddfx += dddfx;
            ddfy += dddfy;
        }
        Lines.linePoint(x2, y2);
        Lines.endLine();
    }

    public static void arc(float x, float y, float radius, float fraction) {
        Lines.arc(x, y, radius, fraction, 0.0f);
    }

    public static void arc(float x, float y, float radius, float fraction, float rotation) {
        Lines.arc(x, y, radius, fraction, rotation, 50);
    }

    public static void arc(float x, float y, float radius, float fraction, float rotation, int sides) {
        int max = Mathf.ceil((float)sides * fraction);
        floats.clear();
        for (int i = 0; i <= max; ++i) {
            vector.trns((float)i / (float)max * fraction * 360.0f + rotation, radius);
            float x1 = Lines.vector.x;
            float y1 = Lines.vector.y;
            vector.trns((float)(i + 1) / (float)max * fraction * 360.0f + rotation, radius);
            floats.add(x1 + x, y1 + y);
        }
        Lines.polyline(floats, false);
    }

    public static void square(float x, float y, float rad) {
        Lines.rect(x - rad, y - rad, rad * 2.0f, rad * 2.0f);
    }

    public static void square(float x, float y, float rad, float rot) {
        Lines.poly(x, y, 4, rad, rot - 45.0f);
    }

    public static void rect(float x, float y, float width, float height, float xspace, float yspace) {
        Fill.crect(x -= xspace, y -= yspace, width += xspace * 2.0f, stroke);
        Fill.crect(x, y + (height += yspace * 2.0f), width, -stroke);
        Fill.crect(x + width, y, -stroke, height);
        Fill.crect(x, y, stroke, height);
    }

    public static void rect(float x, float y, float width, float height) {
        Lines.rect(x, y, width, height, 0);
    }

    public static void rect(Rect rect) {
        Lines.rect(rect.x, rect.y, rect.width, rect.height, 0);
    }

    public static void rect(float x, float y, float width, float height, int space) {
        Lines.rect(x, y, width, height, space, space);
    }

    public static void stroke(float thick) {
        stroke = thick;
    }

    public static void stroke(float thick, Color color) {
        stroke = thick;
        Draw.color(color);
    }

    public static float getStroke() {
        return stroke;
    }

    static {
        circlePrecision = 0.4f;
        AB = new Vec2();
        BC = new Vec2();
        A = new Vec2();
        B = new Vec2();
        C = new Vec2();
        E = new Vec2();
        D = new Vec2();
        vec1 = new Vec2();
        D0 = new Vec2();
        E0 = new Vec2();
        q1 = new Vec2();
        q2 = new Vec2();
        q3 = new Vec2();
        q4 = new Vec2();
    }
}

