/*
 * Decompiled with CFR 0.152.
 */
package arc.fx;

import arc.Core;
import arc.files.Fi;
import arc.graphics.Texture;
import arc.graphics.g2d.Draw;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.util.Disposable;
import arc.util.Time;

public abstract class FxFilter
implements Disposable {
    protected static final int u_texture0 = 0;
    protected static final int u_texture1 = 1;
    protected static final int u_texture2 = 2;
    protected static final int u_texture3 = 3;
    protected final Shader shader;
    protected Texture inputTexture = null;
    protected FrameBuffer outputBuffer = null;
    protected boolean disabled = false;
    protected boolean autobind = false;
    public float time = 0.0f;

    public FxFilter() {
        this(null);
    }

    public FxFilter(String vert, String frag) {
        this(FxFilter.compileShader(Core.files.classpath("vfxshaders/" + vert + ".vert"), Core.files.classpath("vfxshaders/" + frag + ".frag")));
    }

    public FxFilter(Shader shader) {
        this.shader = shader;
    }

    public static Shader compileShader(Fi vertexFile, Fi fragmentFile) {
        return FxFilter.compileShader(vertexFile, fragmentFile, "");
    }

    public static Shader compileShader(Fi vertexFile, Fi fragmentFile, String defines) {
        return new Shader(defines + "\n" + vertexFile.readString(), defines + "\n" + fragmentFile.readString());
    }

    public FxFilter setInput(Texture input) {
        this.inputTexture = input;
        return this;
    }

    public FxFilter setInput(FrameBuffer input) {
        return this.setInput((Texture)input.getTexture());
    }

    public FxFilter setOutput(FrameBuffer output) {
        this.outputBuffer = output;
        return this;
    }

    @Override
    public void dispose() {
        this.shader.dispose();
    }

    public void resize(int width, int height) {
    }

    public void rebind() {
        if (this.shader == null) {
            return;
        }
        this.shader.bind();
        this.setParams();
    }

    protected void setParams() {
        if (this.shader != null) {
            this.shader.setUniformi("u_texture0", 0);
        }
    }

    public void render() {
        boolean manualBufferBind;
        boolean bl = manualBufferBind = this.outputBuffer != null && !this.outputBuffer.isBound();
        if (manualBufferBind) {
            this.outputBuffer.begin();
        }
        this.onBeforeRender();
        this.shader.bind();
        if (this.autobind) {
            this.setParams();
        }
        Draw.blit(this.shader);
        if (manualBufferBind) {
            this.outputBuffer.end();
        }
    }

    protected void onBeforeRender() {
        this.inputTexture.bind(0);
    }

    public void render(FrameBuffer src, FrameBuffer dst) {
        this.setInput(src).setOutput(dst).render();
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean enabled) {
        this.disabled = enabled;
    }

    public void update() {
        this.time = Time.time;
    }
}

